﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="keyWordEdit.aspx.cs" Inherits="webXabara_shop_keyWordEdit" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
    <title>修改关键词</title>
    <script src="/js/jquery.min.js" type="text/javascript"></script>
    <script src="/js/all.js" type="text/javascript"></script>
    <link href="../InClude/StyleSheet.css" rel="stylesheet" type="text/css" />   
    <style type="text/css">
        <!--
        body {
            margin-left: 0px;
            margin-top: 15px;
            margin-right: 10px;
            margin-bottom: 10px;
        }
        -->
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <div class="divWidth">
            <div class="titleBg">修改关键词</div>
        </div>
        <div class="height10px">
        </div>
        <div class="divWidth">
            <table width="100%" class="tableLine">
                <tr>
                    <td class="tdTitle">
                        <strong>分类名称</strong>
                    </td>
                    <td class="tdContent">
                        <asp:DropDownList ID="classID" runat="server" CssClass="inputText"
                            ToolTip="请选择分类">
                        </asp:DropDownList>
                        &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server"
                            ControlToValidate="classID" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">品牌中文名</td>
                    <td class="tdContent">
                        <asp:TextBox ID="wordName" runat="server" CssClass="inputText" Width="300px"></asp:TextBox>
                        &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator6" runat="server"
                            ControlToValidate="wordName" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">品牌英文名</td>
                    <td class="tdContent">
                        <asp:TextBox ID="wordEN" runat="server" CssClass="inputText" Width="300px"></asp:TextBox>
                        <asp:RequiredFieldValidator ID="RequiredFieldValidator7" runat="server"
                            ControlToValidate="wordEN" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    &nbsp; 品牌域名名称，中间无空格</td>
                </tr>
                <tr>
                    <td class="tdTitle">搜索关键词
                    </td>
                    <td class="tdContent">
                        <asp:TextBox ID="keyword" runat="server" CssClass="inputText" Width="300px"></asp:TextBox>
                        &nbsp;<asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server"
                            ControlToValidate="keyword" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    &nbsp;中间不要留空格</td>
                </tr>
                <tr>
                    <td class="tdTitle">是否品牌</td>
                    <td class="tdContent">
                        <asp:RadioButtonList ID="isPP" runat="server"
                            RepeatDirection="Horizontal" RepeatLayout="Flow" DataTextFormatString="PP" AutoPostBack="True" OnSelectedIndexChanged="isPP_SelectedIndexChanged">
                            <asp:ListItem Value="0">是</asp:ListItem>
                            <asp:ListItem Value="1">否</asp:ListItem>
                            <asp:ListItem Value="2">标签</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">关联品牌</td>
                    <td class="tdContent">
                        <asp:DropDownList ID="ppID" runat="server" CssClass="inputText"
                            ToolTip="请选择关联品牌">
                            <asp:ListItem Value="0">== 非品牌类关联 ==</asp:ListItem>
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">搜索范围</td>
                    <td class="tdContent">
                        <asp:RadioButtonList ID="isTmall" runat="server"
                            RepeatDirection="Horizontal" RepeatLayout="Flow">
                            <asp:ListItem Value="true">天猫</asp:ListItem>
                            <asp:ListItem Value="false">全站</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">排序</td>
                    <td class="tdContent">
                        <asp:RadioButtonList ID="sort" runat="server"
                            RepeatDirection="Horizontal" RepeatLayout="Flow">
                            <asp:ListItem Value="total_sales">销量</asp:ListItem>
                            <asp:ListItem Value="tk_total_sales">累计推广量</asp:ListItem>
                            <asp:ListItem Value="tk_total_commi">总支出佣金</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">状态</td>
                    <td class="tdContent">
                        <asp:RadioButtonList ID="isBad" runat="server"
                            RepeatDirection="Horizontal" RepeatLayout="Flow">
                            <asp:ListItem Value="0">启用</asp:ListItem>
                            <asp:ListItem Value="1">禁用</asp:ListItem>
                        </asp:RadioButtonList>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">搜索价格范围</td>
                    <td class="tdContent">从 
                    <asp:TextBox ID="startPrice" runat="server" CssClass="inputTextIME"
                        Width="80px" Style="text-align: center;"></asp:TextBox>
                        &nbsp;元<asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server"
                            ControlToValidate="startPrice" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                        至 
                    <asp:TextBox ID="endPrice" runat="server" CssClass="inputTextIME"
                        Width="80px" Style="text-align: center;"></asp:TextBox>
                        元<asp:RequiredFieldValidator ID="RequiredFieldValidator5" runat="server"
                            ControlToValidate="endPrice" ErrorMessage="*" ForeColor="#FF3300"></asp:RequiredFieldValidator>
                    </td>
                </tr>
                <tr>
                    <td class="tdTitle">白名单</td>
                    <td class="tdContent">
                        <asp:TextBox ID="vipUser" runat="server" CssClass="inputTextIME" Width="500px"></asp:TextBox>
                        &nbsp; 当白名单设置ID后，黑名单无效</td>
                </tr>
                <tr>
                    <td class="tdTitle">黑名单</td>
                    <td class="tdContent">
                        <asp:TextBox ID="blackUser" runat="server" CssClass="inputText" Width="800px" Height="370px" TextMode="MultiLine"></asp:TextBox>
                        &nbsp; 请通过 <a href="keyWordEdit.aspx?id=<%=editID %>" class="red">品牌</a> 修改，标签类无法修改白名单或黑名单<br />
                        </td>
                </tr>
                <tr>
                    <td class="tdTitle">黑名名单操作</td>
                    <td class="tdContent">
                        通过 <a href="Default.aspx" target="_blank">管理商品</a> 功能，找出店名即可，然后粘贴到窗口内，多个店名用半角逗号间隔。</td>
                </tr>
                <tr>
                    <td class="tdTitle">&nbsp;
                    </td>
                    <td class="tdContent">
                        <asp:Button ID="keywords" runat="server" Text="确定修改" CssClass="inputBottom"
                            OnClick="keywords_Click" />
                    </td>
                </tr>
            </table>
        </div>
    </form>
</body>
</html>