﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="shop.aspx.cs" Inherits="webXabara_shop_shop" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>管理关键词信息</title>
    <script src="/js/jquery.min.js" type="text/javascript"></script>
    <script src="/js/all.js" type="text/javascript"></script>
    <link href="../InClude/StyleSheet.css" rel="stylesheet" type="text/css" />
    <style type="text/css">
        body {
            margin-left: 0px;
            margin-top: 15px;
            margin-right: 10px;
            margin-bottom: 10px;
        }
    </style>
</head>
<body>
    <form id="form1" runat="server">
        <div class="divWidth">
            <div class="titleBg">
                管理商品
                <asp:DropDownList
                    ID="classID" runat="server" CssClass="inputText" AutoPostBack="True"
                    OnSelectedIndexChanged="classID_SelectedIndexChanged">
                    <asp:ListItem Value="0">== 所有店铺 ==</asp:ListItem>
                </asp:DropDownList>
                &nbsp;
                品牌名称<asp:TextBox ID="keyWord" runat="server" CssClass="inputText" Width="200px"></asp:TextBox>
                &nbsp;&nbsp;<asp:Button ID="ButtonSearch" runat="server" CssClass="inputBottom" Text="搜索" OnClick="ButtonSearch_Click" />
                &nbsp;
            </div>
            <div class="height10px">
            </div>
            <div runat="server" id="listNews">
                <asp:Repeater ID="RepeaterList" runat="server">
                    <HeaderTemplate>
                        <table width="100%" class="tableLine">
                            <tr>
                                <td class="trTitleBG">分类</td>
                                <td class="trTitleBG"><a href="shop.aspx?sort=en&cid=<%=_cid%>">品牌</a>&nbsp;&nbsp;<a href="shop.aspx?sort=bak&cid=<%=_cid%>">广告备份</a></td>
                                <td class="trTitleBG" style="width: 40%;">SEO</td>
                                <td class="trTitleBG"><a href="shop.aspx?sort=date&cid=<%=_cid%>">时间</a></td>
                                <td class="trTitleBG"><a href="shop.aspx?sort=list&cid=<%=_cid%>">排序</a></td>
                                <td class="trTitleBG">操作</td>
                            </tr>
                    </HeaderTemplate>
                    <ItemTemplate>
                        <tr>
                            <td><%# getTreeName(Eval("treeID").ToString().Trim())%></td>
                            <td>
                                <%# pic(Eval("logo").ToString().Trim()) %>&nbsp;<a href="/<%# Eval("id").ToString().Trim()%>.htm" target="_blank"><%# Eval("wordName").ToString().Trim()+"("+Eval("wordEN").ToString().Trim()+")"%></a>&nbsp;<%# Eval("isSHOP").ToString().Trim().Equals("1")?"<span style=\"color:red;\">[店铺]</span>":""%>&nbsp;&nbsp;<%# pic(Eval("listpic").ToString().Trim()) %>&nbsp;&nbsp;<%# picBak(Eval("listpicBack").ToString().Trim()) %></td>
                            <td>
                                <%# Eval("seo").ToString().Trim()%>
                            </td>
                            <td style="text-align: center;">
                                <%# Convert.ToDateTime(Eval("startDate")).ToString("yy-MM-dd") + "<br />" + Convert.ToDateTime(Eval("endDate")).ToString("yy-MM-dd")%>
                            </td>
                            <td style="text-align: center;">
                                <%# Eval("listID").ToString().Trim()%>
                            </td>
                            <td style="text-align: center;">
                                <a href="del.aspx?id=<%# Eval("id").ToString().Trim()%>&page=<%=_page %>" style="font-weight: bold;" onclick="return confirm('确定删除吗？');">删除</a>&nbsp;&nbsp;<a href="add.aspx?id=<%# Eval("id").ToString().Trim()%>&page=<%=_page %>" style="font-weight: bold;">修改</a>
                            </td>
                        </tr>
                    </ItemTemplate>
                    <AlternatingItemTemplate>
                        <tr>
                            <td style="background-color: #E9F8FC;"><%# getTreeName(Eval("treeID").ToString().Trim())%></td>
                            <td style="background-color: #E9F8FC;">
                                <%# pic(Eval("logo").ToString().Trim()) %>&nbsp;<a href="/<%# Eval("id").ToString().Trim()%>.htm" target="_blank"><%# Eval("wordName").ToString().Trim()+"("+Eval("wordEN").ToString().Trim()+")"%></a>&nbsp;<%# Eval("isSHOP").ToString().Trim().Equals("1")?"<span style=\"color:red;\">[店铺]</span>":""%>&nbsp;&nbsp;<%# pic(Eval("listpic").ToString().Trim()) %>&nbsp;&nbsp;<%# picBak(Eval("listpicBack").ToString().Trim()) %></td>
                            <td style="background-color: #E9F8FC;">
                                <%# Eval("seo").ToString().Trim()%>
                            </td>
                            <td style="text-align: center; background-color: #E9F8FC;">
                                <%# Convert.ToDateTime(Eval("startDate")).ToString("yy-MM-dd") + "<br />" + Convert.ToDateTime(Eval("endDate")).ToString("yy-MM-dd")%>
                            </td>
                            <td style="text-align: center; background-color: #E9F8FC;">
                                <%# Eval("listID").ToString().Trim()%>
                            </td>
                            <td style="text-align: center; background-color: #E9F8FC;">
                                <a href="del.aspx?id=<%# Eval("id").ToString().Trim()%>&page=<%=_page %>" style="font-weight: bold;" onclick="return confirm('确定删除吗？');">删除</a>&nbsp;&nbsp;<a href="add.aspx?id=<%# Eval("id").ToString().Trim()%>&page=<%=_page %>" style="font-weight: bold;">修改</a>
                            </td>
                        </tr>
                    </AlternatingItemTemplate>
                    <FooterTemplate>
                        </table>
                    </FooterTemplate>
                </asp:Repeater>
            </div>
            <div class="height5px">
            </div>
            <div id="errDiv" runat="server" class="tableAdminLine">
                <div style="height: 150px;">
                </div>
                <div style="text-align: center;">
                    <asp:Label ID="errInfo" runat="server" ForeColor="#FF3300"></asp:Label>
                </div>
                <div style="height: 150px;">
                </div>
            </div>
            <div class="height10px">
            </div>
            <div>
                <a name="foot" id="foot"></a>
                <asp:Literal ID="lblCurrentPage" runat="server"></asp:Literal>
            </div>
        </div>
    </form>
</body>
</html>