﻿using System;
using System.Web;
using System.Web.UI;
using System.Data;
using Top.Api;
using xabaraCOM;
using Top.Api.Request;
using Top.Api.Response;
using System.Collections.Generic;
public partial class webXabara_shop_taobao : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string adminID = "ipUser";
        ipAddress ip = new ipAddress();
        if (xml.read("xabara.config", "ip", 60).IndexOf(ip.address()) < 0)
        {
            admin a = new admin();
            a.check("");

            adminID = a.uid;
        }

        if (!IsPostBack)
        {
            sqlServer s = new sqlServer();
            DataTable dt;
            string[] strValue = new string[30];

            string appkey = xml.read("xabara.config", "appkey", 60);
            if (string.IsNullOrWhiteSpace(appkey as string))
            {
                Response.Redirect("../frame/interfaceSet.aspx", true);
            }
            string appsecret = xml.read("xabara.config", "appSecret", 60);
            string url = xml.read("xabara.config", "taobaoKeUrl", 60);

            Response.Write("根据分类自动同步店铺宝贝开始，如出现死机或出错，重新点击 <a href=\"taobao.aspx?rnd=" + xabara.rnd("abc123", 6) + "\">自动更新</a> 即可；<br />");

            string strSql = "select top 1 id,treeID,ppID,keywords,wordEN,wordName,blackUser,vipUser,sort,isTmall,startPrice,endPrice from keywordID where isBad=0 and updateDate<'" + DateTime.Now.AddHours(-24).ToString() + "' order by newid()";    //每24个小时更新数据
            //Response.Write(strSql);
            //Response.End();
            dt = s.getDataTable(strSql);
            if (dt.Rows.Count > 0)
            {
                string _wordEN= dt.Rows[0]["wordEN"].ToString().Trim().ToLower();
                string _wordName= dt.Rows[0]["wordName"].ToString().Trim().ToLower();

                //黑名单
                string _blackUser = dt.Rows[0]["blackUser"].ToString().Trim();
                //白名单
                string _vipUser = dt.Rows[0]["vipUser"].ToString().Trim();

                string keywordID = dt.Rows[0]["id"].ToString().Trim();
                this.js(keywordID);  //定时刷新
                long _keywordID = xabara.isNum(dt.Rows[0]["ppID"].ToString().Trim());
                string classID = dt.Rows[0]["treeID"].ToString().Trim();
                string keyword = dt.Rows[0]["keywords"].ToString().Trim();
                Response.Write("<br />" + keyword + "　正在同步，请等待下一个关键词更新...<br /><br />");

                ITopClient topClient = new DefaultTopClient(url, appkey, appsecret);
                TbkItemGetRequest req = new TbkItemGetRequest();
                req.Fields = "num_iid,title,pict_url,small_images,reserve_price,zk_final_price,user_type,provcity,item_url,seller_id,volume,nick";
                req.Q = keyword;
                req.Sort = dt.Rows[0]["sort"].ToString().Trim();
                req.IsTmall = Convert.ToBoolean(dt.Rows[0]["isTmall"].ToString().Trim());
                req.StartPrice = xabara.isNum(dt.Rows[0]["startPrice"].ToString().Trim());
                req.EndPrice = xabara.isNum(dt.Rows[0]["endPrice"].ToString().Trim());
                req.PageNo = 1L;
                req.PageSize = 20L;
                TbkItemGetResponse response = topClient.Execute(req);

                long shopNums = response.Results.Count;

                Response.Write("本次共获取了宝贝数：" + shopNums.ToString() + "<br /><br />");

                if (shopNums > 0)
                {
                    string strDim = "@classID,@isGood,@isBad,@num_iid,@title,@pic_url,@small_images,@reserve_price,@zk_final_price,@user_type,@provcity,@item_url,@seller_id,@volume,@nick,@updateDate,@postID,@postDate,@postIP,@keywordID";
                    for (int i = 0; i < shopNums; i++)
                    {
                        string _title = CHAR.NoHtm(response.Results[i].Title);
                        long num_iid = xabara.isNum(response.Results[i].NumIid.ToString());
                        if (num_iid > 0)
                        {
                            strValue[0] = classID;
                            long volume = response.Results[i].Volume;
                            if (volume > 199)    //直接推荐商品
                            {
                                strValue[1] = "1";
                            }
                            else
                            {
                                strValue[1] = "0";
                            }
                            strValue[2] = "0";
                            strValue[3] = num_iid.ToString();
                            strValue[4] = _title;
                            strValue[5] = response.Results[i].PictUrl;
                            List<string> list = new List<string>(response.Results[i].SmallImages);
                            string imgs = string.Empty;
                            for (int img = 0; img < list.Count; img++)
                            {
                                imgs += list[img].ToString() + "|";
                            }
                            if (imgs.Length > 1)
                            {
                                imgs = imgs.Substring(0, imgs.Length - 1);
                            }
                            strValue[6] = imgs;
                            strValue[7] = response.Results[i].ReservePrice;
                            strValue[8] = response.Results[i].ZkFinalPrice;
                            strValue[9] = response.Results[i].UserType.ToString();
                            strValue[10] = response.Results[i].Provcity;
                            strValue[11] = response.Results[i].ItemUrl;
                            strValue[12] = response.Results[i].SellerId.ToString();
                            strValue[13] = volume.ToString();
                            string _nick = response.Results[i].Nick;
                            if(string.IsNullOrWhiteSpace(_nick))
                            {
                                _nick = "混合专卖店";
                            }
                            strValue[14] = _nick;
                            strValue[15] = DateTime.Now.AddDays(-7).ToString("yyyy-MM-dd HH:mm:ss");//首次强制由taobaoke更新完整资料
                            strValue[16] = adminID;
                            strValue[17] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                            strValue[18] = new ipAddress().address();
                            strValue[19] = keywordID;
                            if (_keywordID > 0)    //非品牌类关键词合并
                            {
                                strValue[19] = _keywordID.ToString();
                            }

                            DataTable dtIf = s.getDataTable("select postDate from taobaoKe where num_iid=" + num_iid.ToString());  //防止重复插入
                            if (dtIf.Rows.Count > 0)
                            {
                                strValue[15] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                                strValue[17] = Convert.ToDateTime(dtIf.Rows[0]["postDate"].ToString()).ToString("yyyy-MM-dd HH:mm:ss");

                                if (string.IsNullOrWhiteSpace(_vipUser as string))
                                {
                                    if (_blackUser.IndexOf(response.Results[i].Nick.Trim()) > -1) //黑名单判断
                                    {
                                        Response.Write("黑名单：" + response.Results[i].Nick.Trim() + "&nbsp;&nbsp;" + response.Results[i].Title + "<br />");
                                        Response.Flush();
                                    }
                                    else
                                    {
                                        s.update("taobaoKe", strDim, strValue, "num_iid=" + num_iid.ToString());
                                    }
                                }
                                else
                                {
                                    if (_vipUser.IndexOf(response.Results[i].Nick.Trim()) > -1) //白名单判断
                                    {
                                        s.update("taobaoKe", strDim, strValue, "num_iid=" + num_iid.ToString());
                                    }
                                }
                            }
                            else
                            {
                                if (volume > 0)//0推广不插入
                                {
                                    _title = _title.ToLower();

                                    if (string.IsNullOrWhiteSpace(_vipUser as string))
                                    {
                                        if (_blackUser.IndexOf(response.Results[i].Nick.Trim()) > -1) //黑名单判断
                                        {
                                            Response.Write("黑名单：" + response.Results[i].Nick.Trim() + "&nbsp;&nbsp;" + response.Results[i].Title + "<br />");
                                            Response.Flush();
                                        }
                                        else
                                        {
                                            if ((_title.IndexOf(_wordEN) > -1 && _title.IndexOf("二手") < 0) || (_title.IndexOf(_wordName) > -1 && _title.IndexOf("二手") < 0))
                                            {
                                                s.add("taobaoKe", strDim, strValue);
                                            }
                                        }
                                    }
                                    else
                                    {
                                        if (_vipUser.IndexOf(response.Results[i].Nick.Trim()) > -1) //白名单判断
                                        {
                                            s.add("taobaoKe", strDim, strValue);
                                        }
                                    }
                                }
                            }

                            dtIf.Dispose();
                        }
                    }
                }
                else
                {
                    Response.Write("同步有异常：<br />");
                    Response.Write(response.Body.ToString());
                    s.log("taobaoke", "admin", "无效关键词:" + keyword);
                }

                //更新关键词同步时间
                strValue[0] = DateTime.Now.ToString();
                s.update("keywordID", "@updateDate", strValue, "id=" + keywordID);
            }
            else
            {
                //自动清除黑名单功能 关联商品无法读取nick导致垃圾
                strSql = "SELECT STUFF( (SELECT ',' + cast(num_iid AS varchar(20)) FROM (select taobaoke.num_iid,taobaoke.classID,keywordID.wordName,keywordID.wordEN,taobaoke.title,taobaoke.nick,keywordID.blackUser from taobaoke left join keywordID on taobaoke.keywordID=keywordID.id where charindex(RTRIM(taobaoke.nick), RTRIM(keywordID.blackUser)) >0 and keywordID.blackUser <>'' and seller_id>0) as temp FOR xml path('')),1,1,'') as ids";
                dt = s.getDataTable(strSql);
                if (dt.Rows.Count > 0)
                {
                    string _ids = dt.Rows[0]["ids"].ToString().Trim();
                    if (!string.IsNullOrWhiteSpace(_ids))
                    {
                        string[] del = dt.Rows[0]["ids"].ToString().Trim().Split(new char[] { ',' });
                        string orStr = string.Empty;
                        for (int d = 0; d <= del.GetUpperBound(0); d++)
                        {
                            orStr += " num_iid=" + del[d] + " or";
                        }
                        orStr = orStr.Substring(0, orStr.Length - 3);

                        strSql = "delete FROM taobaoke WHERE " + orStr;
                        s.exe(strSql);

                        Response.Write("<br /><br />同步清理无效IIDs淘宝客已完成！");
                    }
                }
                dt.Dispose();

                //转向淘客批量更新
                Response.Redirect("taobaoke.aspx", true);
            }
            //宝贝同步结束
            dt.Dispose();
        }
    }

    /// <summary>
    /// js方式输出
    /// </summary>
    /// <param name="str">js代码</param>
    /// <returns></returns>
    private void js(string id)
    {
        string str = "<script type=\"text/javascript\">window.setTimeout(\"window.location.href='taobaoIID.aspx?id=" + id + "'\",30000)</script>";

        ClientScriptManager cs = ((Page)HttpContext.Current.CurrentHandler).ClientScript;
        cs.RegisterClientScriptBlock(this.GetType(), "ClientScriptBlock", str);
    }
}