﻿using System;
using System.Collections.Generic;
using System.Data;
using Top.Api;
using Top.Api.Request;
using Top.Api.Response;
using xabaraCOM;
using System.Web.UI;
using System.Web;
public partial class webXabara_shop_taobaoIID : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string adminID = "ipUser";
        ipAddress ip = new ipAddress();
        if (xml.read("xabara.config", "ip", 60).IndexOf(ip.address()) < 0)
        {
            admin a = new admin();
            a.check("");

            adminID = a.uid;
        }

        if (!IsPostBack)
        {
            string appkey = xml.read("xabara.config", "appkey", 60);
            if (string.IsNullOrWhiteSpace(appkey as string))
            {
                Response.Redirect("../frame/interfaceSet.aspx", true);
            }
            string appsecret = xml.read("xabara.config", "appSecret", 60);
            string url = xml.read("xabara.config", "taobaoKeUrl", 60);

            string[] strValue = new string[30];
            sqlServer s = new sqlServer();

            string strSql = "SELECT TOP 1 keywordID.wordEN,keywordID.wordName,keywordID.startPrice,keywordID.endPrice,taobaoke.classID,taobaoke.keywordID,taobaoke.num_iid from taobaoke left join keywordID on taobaoke.keywordID=keywordID.id  where taobaoke.IIDUpdate < '" + DateTime.Now.AddHours(-36).ToString() + "' and taobaoke.volume>49 order by NEWID()";
            DataTable dt = s.getDataTable(strSql);
            if (dt.Rows.Count > 0)
            {
                string num_iid = dt.Rows[0]["num_iid"].ToString().Trim();
                string keywordID = dt.Rows[0]["keywordID"].ToString().Trim();
                this.js(keywordID);  //定时刷新
                string _classID = dt.Rows[0]["classID"].ToString().Trim();
                string _wordEN = dt.Rows[0]["wordEN"].ToString().Trim();
                string _wordName = dt.Rows[0]["wordName"].ToString().Trim();

                Response.Write("根据宝贝更新关联商品，如出现死机或出错，重新点击 <a href=\"taobaoIID.aspx?id=" + keywordID + "\">自动更新</a> 即可；<br /><br />");

                ITopClient client = new DefaultTopClient(url, appkey, appsecret);
                TbkItemRecommendGetRequest req = new TbkItemRecommendGetRequest();
                req.Fields = "num_iid,title,pict_url,small_images,reserve_price,zk_final_price,user_type,provcity,item_url";
                req.NumIid = xabara.isNum(num_iid);
                req.Count = 40L;
                req.Platform = 1L;
                TbkItemRecommendGetResponse response = client.Execute(req);
                long shopNums = response.Results.Count;

                Response.Write("本次共获取了 " + _wordName + " 宝贝关联数：" + shopNums.ToString() + "<br /><br />");

                if (shopNums > 0)
                {
                    for (int i = 0; i < shopNums; i++)
                    {
                        //同品牌新商品添加操作
                        string _title = CHAR.NoHtm(response.Results[i].Title);
                        if ((_title.ToLower().IndexOf(_wordName.ToLower()) > -1 && _title.ToLower().IndexOf("二手") < 0) || (_title.ToLower().IndexOf(_wordEN.ToLower()) > -1 && _title.ToLower().IndexOf("二手") < 0))
                        {
                            string _numIID = response.Results[i].NumIid.ToString();

                            DataTable dtIf = s.getDataTable("select num_iid from taobaoKe where num_iid=" + _numIID);  //防止重复插入
                            if (dtIf.Rows.Count > 0)
                            {
                                //无需更新操作
                            }
                            else
                            {
                                string strDim = "@classID,@isGood,@isBad,@num_iid,@title,@pic_url,@small_images,@reserve_price,@zk_final_price,@user_type,@provcity,@item_url,@seller_id,@volume,@nick,@updateDate,@postID,@postDate,@postIP,@keywordID,@IIDUpdate";
                                strValue[0] = _classID;
                                strValue[1] = "0";
                                strValue[2] = "0";
                                strValue[3] = _numIID;
                                strValue[4] = _title;
                                strValue[5] = response.Results[i].PictUrl;
                                List<string> list = new List<string>(response.Results[i].SmallImages);
                                string imgs = string.Empty;
                                for (int img = 0; img < list.Count; img++)
                                {
                                    imgs += list[img].ToString() + "|";
                                }
                                if (imgs.Length > 1)
                                {
                                    imgs = imgs.Substring(0, imgs.Length - 1);
                                }
                                strValue[6] = imgs;
                                strValue[7] = response.Results[i].ReservePrice;
                                strValue[8] = response.Results[i].ZkFinalPrice;
                                strValue[9] = response.Results[i].UserType.ToString();
                                strValue[10] = response.Results[i].Provcity;
                                strValue[11] = response.Results[i].ItemUrl;
                                strValue[12] = "0";
                                strValue[13] = "1";
                                strValue[14] = _wordName + "专卖店";
                                strValue[15] = DateTime.Now.AddDays(-7).ToString("yyyy-MM-dd HH:mm:ss");//由taobaoke后强更新完整数据
                                strValue[16] = num_iid;
                                strValue[17] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                                strValue[18] = new ipAddress().address();
                                strValue[19] = keywordID.ToString();
                                strValue[20] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                                //插入新记录
                                s.add("taobaoKe", strDim, strValue);
                            }
                            dtIf.Dispose();
                        }
                    }
                }
                else
                {
                    Response.Write("同步有异常：<br />");
                    Response.Write(response.Body.ToString());
                }

                //更新关键词同步时间
                strValue[0] = DateTime.Now.ToString();
                s.update("taobaoke", "@IIDUpdate", strValue, " keywordID=" + keywordID + " and classID=" + _classID);
            }
            else
            {
                //Response.Write(strSql);
                Response.Redirect("taobao.aspx", true);
            }
            dt.Dispose();
        }
    }

    /// <summary>
    /// js方式输出
    /// </summary>
    /// <param name="str">js代码</param>
    /// <returns></returns>
    private void js(string id)
    {
        string str = "<script type=\"text/javascript\">window.setTimeout(\"window.location.href='taobao.aspx?id=" + id + "'\",15000)</script>";

        ClientScriptManager cs = ((Page)HttpContext.Current.CurrentHandler).ClientScript;
        cs.RegisterClientScriptBlock(this.GetType(), "ClientScriptBlock", str);
    }
}