﻿using System;
using System.Web;
using System.Web.UI;
using System.Data;
using Top.Api;
using xabaraCOM;
using Top.Api.Request;
using Top.Api.Response;
using System.Collections.Generic;

public partial class webXabara_shop_taobaoke : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string adminID = "ipUser";
        ipAddress ip = new ipAddress();
        if (xml.read("xabara.config", "ip", 60).IndexOf(ip.address()) < 0)
        {
            admin a = new admin();
            a.check("");

            adminID = a.uid;
        }

        this.js();  //定时刷新

        if (!IsPostBack)
        {
            sqlServer s = new sqlServer();
            DataTable dt;
            string strSql;
            string[] strValue = new string[30];

            string appkey = xml.read("xabara.config", "appkey", 60);
            if (string.IsNullOrWhiteSpace(appkey as string))
            {
                Response.Redirect("../frame/interfaceSet", true);
            }
            string appsecret = xml.read("xabara.config", "appSecret", 60);
            string url = xml.read("xabara.config", "taobaoKeUrl", 60);

            ITopClient client = new DefaultTopClient(url, appkey, appsecret);

            Response.Write("根据老淘客数据更新操作，如出现死机或出错，重新点击 <a href=\"taobaoke.aspx?rnd=" + xabara.rnd("abc123", 6) + "\">自动更新</a> 即可；<br />");

            string ids = s.sqlVerifyString(Request.QueryString["ids"]);
            bool singleRef = false;
            if (string.IsNullOrWhiteSpace(ids as string))   //手动添加IID判断使用
            {
                strSql = "SELECT STUFF( (SELECT top 40 ',' + cast(num_iid AS varchar(20)) FROM taobaoke WHERE isBad=0 and updateDate<'" + DateTime.Now.AddHours(-48).ToString("yyyy-MM-dd") + "' order by volume desc FOR xml path('')),1,1,'') as ids";    //每次40个更新请求

                dt = s.getDataTable(strSql);
                if (dt.Rows.Count > 0)
                {
                    ids = dt.Rows[0]["ids"].ToString().Trim();
                }
                dt.Dispose();
            }
            else
            {
                singleRef = true;
            }

            if (!string.IsNullOrWhiteSpace(ids as string))
            {
                Response.Write("<br />正在更新：<br />" + ids.Replace(",", "<br />"));

                TbkItemInfoGetRequest req = new TbkItemInfoGetRequest();
                //req.Fields = "num_iid,title,pict_url,small_images,reserve_price,zk_final_price,user_type,provcity,item_url";
                req.NumIids = ids;
                TbkItemInfoGetResponse response = client.Execute(req);

                long shopNums = response.Results.Count;
                string idsReplace = ids + ",";  //删除末成功使用

                if (shopNums > 0)
                {
                    string strDim = "@title,@pic_url,@small_images,@reserve_price,@zk_final_price,@user_type,@provcity,@item_url,@updateDate,@cat_name,@cat_leaf_name,@seller_id,@volume,@isGood,@nick";
                    for (int i = 0; i < shopNums; i++)
                    {
                        long num_iid = xabara.isNum(response.Results[i].NumIid.ToString());
                        if (num_iid > 0)
                        {
                            strValue[0] = CHAR.NoHtm(response.Results[i].Title);
                            strValue[1] = response.Results[i].PictUrl;
                            List<string> list = new List<string>(response.Results[i].SmallImages);
                            string imgs = string.Empty;
                            for (int img = 0; img < list.Count; img++)
                            {
                                imgs += list[img].ToString() + "|";
                            }
                            if (imgs.Length > 1)
                            {
                                imgs = imgs.Substring(0, imgs.Length - 1);
                            }
                            strValue[2] = imgs;
                            strValue[3] = response.Results[i].ReservePrice;
                            strValue[4] = response.Results[i].ZkFinalPrice;
                            strValue[5] = response.Results[i].UserType.ToString();
                            strValue[6] = response.Results[i].Provcity;
                            strValue[7] = response.Results[i].ItemUrl;
                            strValue[8] = DateTime.Now.ToString("yyyy-MM-dd HH:mm:ss");
                            strValue[9] = response.Results[i].CatName;
                            strValue[10] = response.Results[i].CatLeafName;
                            strValue[11] = response.Results[i].SellerId.ToString();
                            long volume = response.Results[i].Volume;
                            strValue[12] = volume.ToString();
                            if (volume > 199)    //直接推荐商品
                            {
                                strValue[13] = "1";
                            }
                            else
                            {
                                strValue[13] = "0";
                            }
                            string _nick = response.Results[i].Nick;
                            if(string.IsNullOrWhiteSpace(_nick))
                            {
                                _nick = "混合集市";
                            }
                            strValue[14] = _nick;

                            string updateStr = s.update("taobaoKe", strDim, strValue, "num_iid=" + num_iid.ToString());

                            if(updateStr== "更新成功")
                            {
                                idsReplace = idsReplace.Replace(num_iid.ToString() + ",", "");
                            }
                        }
                    }

                    //随时清理无效num_iid
                    if (idsReplace.Length > 5)
                    {
                        string[] del = idsReplace.Substring(0, idsReplace.Length - 1).Split(new char[] { ',' });
                        string orStr = string.Empty;
                        for (int d = 0; d <= del.GetUpperBound(0); d++)
                        {
                            orStr += " num_iid=" + del[d] + " or";
                        }
                        orStr = orStr.Substring(0, orStr.Length - 3) + " )";
                        strSql = "delete FROM taobaoke WHERE updateDate<'" + DateTime.Now.ToString("yyyy-MM-dd") + "' and (" + orStr;
                        Response.Write("<br /><br />同步清理无效IID，请稍等...");
                        s.exe(strSql);
                    }
                }
                else
                {
                    if (response.SubErrCode == "50001")//全部是无效推广
                    {
                        //随时清理无效num_iid
                        string[] del = ids.Split(new char[] { ',' });
                        string orStr = string.Empty;
                        for (int d = 0; d <= del.GetUpperBound(0); d++)
                        {
                            orStr += " num_iid=" + del[d] + " or";
                        }
                        orStr = orStr.Substring(0, orStr.Length - 3) + " )";
                        strSql = "delete FROM taobaoke WHERE updateDate<'" + DateTime.Now.ToString("yyyy-MM-dd") + "' and (" + orStr;
                        Response.Write("<br /><br />同步清理无效IID，请稍等...");
                        s.exe(strSql);
                    }
                    else
                    {
                        Response.Write("同步有异常：<br />");
                        Response.Write(response.Body.ToString());
                    }
                }

                if (singleRef)  //手工添加数据判断
                {
                    Response.Redirect("?ppID=" + xabara.isNum(Request.QueryString["pid"])+"&cid="+ xabara.isNum(Request.QueryString["cid"]));
                    Response.End();
                }
            }
            else
            {
                //自动清除黑名单功能 关联商品无法读取nick导致垃圾
                strSql = "SELECT STUFF( (SELECT ',' + cast(num_iid AS varchar(20)) FROM (select taobaoke.num_iid,taobaoke.classID,keywordID.wordName,keywordID.wordEN,taobaoke.title,taobaoke.nick,keywordID.blackUser from taobaoke left join keywordID on taobaoke.keywordID=keywordID.id where charindex(RTRIM(taobaoke.nick), RTRIM(keywordID.blackUser)) >0 and keywordID.blackUser <>'' and seller_id>0) as temp FOR xml path('')),1,1,'') as ids";
                dt = s.getDataTable(strSql);
                if (dt.Rows.Count > 0)
                {
                    string _ids = dt.Rows[0]["ids"].ToString().Trim();
                    if (!string.IsNullOrWhiteSpace(_ids))
                    {
                        string[] del = dt.Rows[0]["ids"].ToString().Trim().Split(new char[] { ',' });
                        string orStr = string.Empty;
                        for (int d = 0; d <= del.GetUpperBound(0); d++)
                        {
                            orStr += " num_iid=" + del[d] + " or";
                        }
                        orStr = orStr.Substring(0, orStr.Length - 3);

                        strSql = "delete FROM taobaoke WHERE " + orStr;
                        s.exe(strSql);

                        Response.Write("<br /><br />同步清理无效IIDs淘宝客已完成！");
                    }
                }
                dt.Dispose();


                //转向优惠券更新
                Response.Redirect("coupon.aspx", true);
            }
            //宝贝同步结束
        }
    }

    /// <summary>
    /// js方式输出
    /// </summary>
    /// <param name="str">js代码</param>
    /// <returns></returns>
    private void js()
    {
        string str = "<script type=\"text/javascript\">window.setTimeout(\"window.location.href='taobaoke.aspx?tmp=" + DateTime.Now.ToString("yyyyMMddHHmmss")  +  xabara.rnd("123", 3) + "'\",20000)</script>";

        ClientScriptManager cs = ((Page)HttpContext.Current.CurrentHandler).ClientScript;
        cs.RegisterClientScriptBlock(this.GetType(), "ClientScriptBlock", str);
    }
}