﻿<%@ page language="C#" autoeventwireup="true" inherits="phone_OrderMeal, 25175_ALL" %>

<%@ Register Src="~/phone/MyHeader.ascx" TagPrefix="uc1" TagName="MyHeader" %>
<%@ Register Src="~/phone/MyFooter.ascx" TagPrefix="uc1" TagName="MyFooter" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>江门市新会梁启超纪念中学食堂报餐系统</title>
    <link href="/control/plugin/bootstrap3/css/bootstrap.min.css" rel="stylesheet" />
    <link href="/phone/css/style.css?v=201721" rel="stylesheet" />
    <link href="/control/plugin/bootstrap-datepicker/css/datepicker3.css" rel="stylesheet" />

    <script src="/control/js/jquery.js"></script>
    <script src="/control/plugin/bootstrap3/js/bootstrap.min.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/bootstrap-datepicker.js"></script>
    <script src="/control/plugin/bootstrap-datepicker/js/locales/bootstrap-datepicker.zh-CN.js"></script>
    <style>
        .l {
            font-weight: initial;
        }
    </style>
</head>
<body>
    <uc1:MyHeader runat="server" ID="MyHeader" />
    <div class=" container-fluid ">
        <div class="row">
            <div class="col-xs-12 cont">
                <div class="panel panel-default">
                    <form runat="server" id="form1">
                        <asp:HiddenField ID="hfCurrentTab" runat="server" Value="1" />
                        <!-- Nav tabs -->
                        <ul class="nav nav-tabs">
                            <li id="tab1" role="presentation"><a  href="#panel_1" onclick="customOrder()" role="tab" data-toggle="tab">连续预定</a></li>
                            <li id="tab2" role="presentation"><a href="#panel_2" onclick="currentOrder()"  role="tab" data-toggle="tab">今日预定</a></li>
                            <li id="tab3" role="presentation"><a href="#panel_3"  onclick="singleOrder()" role="tab" data-toggle="tab">单日预定</a></li>
                        </ul>

                     <script type="text/javascript">
                
                            var currentDay = '<%=DateTime.Now.ToString("yyyy-MM-dd")%>';
                   
                           $("#tab" + $("#hfCurrentTab").val()).addClass("active");

                            function singleOrder() {
                                $("#hfCurrentTab").val(3);
                            }
                            function currentOrder() {
                                $("#hfCurrentTab").val(2);
                            }
                            function customOrder() {
                                $("#hfCurrentTab").val(1);
                            }

                         //active
                        </script>

                        <div class="panel-body">
                            <div class="tab-content">
                                <div role="tabpanel" class="tab-pane " id="panel_1">
                                        <div class="form-group" id="startDiv">
                                            <label>
                                                订餐起始日期：<span id="rfvtxtStart" style="color:Red; display:none">必填</span>
                                            </label>
                                            <div id="start" class="input-group date">
                                                <asp:TextBox ID="txtStart" runat="server" class="form-control"></asp:TextBox>
                                                <div class="input-group-addon">
                                                    <span class="glyphicon glyphicon-th"></span>
                                                </div>
                                            </div> 
                                            <script type="text/javascript">
                                                function DatePicker(beginSelector, endSelector) {

                                                    var startDate = new Date();
                                                    var endDate = new Date();
                                                    endDate.setMonth(endDate.getMonth() + 6);
                                                    // 仅选择日期  
                                                    $(beginSelector).datepicker({
                                                        language: "zh-CN",
                                                        autoclose: true,
                                                        format: "yyyy-mm-dd",
                                                        todayBtn: "linked",
                                                        startDate: startDate,
                                                        todayHighlight: true
                                                    }).on('changeDate', function (ev) {
                                                        if (ev.date) {
                                                            $(endSelector).datepicker('setStartDate', new Date(ev.date.valueOf()))
                                                        } else {
                                                            $(endSelector).datepicker('setStartDate', null);
                                                        }
                                                    })

                                                    $(endSelector).datepicker({
                                                        language: "zh-CN",
                                                        autoclose: true,
                                                        format: "yyyy-mm-dd",
                                                        todayBtn: "linked",
                                                        endDate: endDate,
                                                        todayHighlight: true
                                                    }).on('changeDate', function (ev) {
                                                        if (ev.date) {
                                                            $(beginSelector).datepicker('setEndDate', new Date(ev.date.valueOf()))
                                                        } else {
                                                            $(beginSelector).datepicker('setEndDate', new Date());
                                                        }
                                                    })
                                                }

                                                $(function () {
                                                    DatePicker("#start", "#end");
                                                });
                                            </script>
                                        </div>
                                    
                                        <div class="form-group" id="endDiv">
                                            <label>
                                                订餐截至日期：<span id="rfvtxtEnd" style="color:Red; display:none">必填</span>
                                            </label>
                                            <div id="end" class=" input-group  date">
                                                <asp:TextBox ID="txtEnd" runat="server" class="form-control "></asp:TextBox>
                                                <div class="input-group-addon">
                                                    <span class="glyphicon glyphicon-th"></span>
                                                </div>
                                            </div>
                                            <p class=" help-block">注：订餐只能预定六个月之内</p>

                                        </div>
                                        
                                        <div class="form-group" id="ltdc">
                                            <label>
                                                周六与周日是否订餐：
                                            </label>

                                            <div class="list-group">
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cbxql" runat="server" />
                                                    星期六
                                                </label>
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cbxqt" runat="server" />
                                                    星期天
                                                </label>
                                            </div>

                                            <p class="help-block">注：如果星期六或星期天需要订餐，请勾选</p>
                                        </div>

                                        <div class="form-group">
                                            <label>
                                                订餐类型：
                                        <span id="rfvdclx" style="color: red; display: none;">请选择订餐类型</span>
                                            </label>
                                            <div class="list-group">
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cbzc" runat="server" />
                                                    早餐
                                                </label>
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cbzwc" runat="server" />
                                                    午餐
                                                </label>
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cbwc" runat="server" />
                                                    晚餐
                                                </label>
                                            </div>
                                            <p class="help-block">注：早餐需前一天下午4时前，午餐早上9点前，晚餐下午4点前订</p>
                                        </div>

                                        <asp:Button ID="btnSubmit"
                                            CssClass="btn btn-primary btn-block"
                                            runat="server" Text="提交订餐" OnClientClick="return beSubmit()"
                                            OnClick="btnSubmit_Click" />

                                        <script type="text/javascript">
                                            function beSubmit()
                                            {
                                                var start = $.trim($("#txtStart").val());
                                                var end = $.trim($("#txtEnd").val());

                                                if (start == "") {
                                                    $("#rfvtxtStart").show();
                                                    return false;
                                                }
                                                if (end == "") {
                                                    $("#rfvtxtEnd").show();
                                                    return false;
                                                }

                                                if (!$("#cbwsj").get(0).checked &&
                                                !$("#cbsj").get(0).checked &&
                                                !$("#cbcdx").get(0).checked) {
                                                    $("#rfvdclx").show();
                                                    return false;
                                                }
                                                return true;
                                            }
                                        </script>
                                </div>
                              
                                <div role="tabpanel" class="tab-pane" id="panel_2">
                             
                                        <div class="form-group">
                                            <label>
                                                订餐类型：<span id="rfvdclx_cd" style="color: red; display: none;">请选择订餐类型</span>
                                            </label>
                                            <div class="list-group">
                                                <label class="list-group-item l disabled" >
                                                    <asp:CheckBox ID="cb_jrzc" runat="server" Enabled="false" />
                                                    早餐
                                                </label>
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cb_jrzwc" runat="server" />
                                                    午餐
                                                </label>
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cb_jrwc" runat="server" />
                                                    晚餐
                                                </label>
                                            </div>
                                            <p class="help-block">注：早餐需前一天下午4时前，午餐早上9点前，晚餐下午4点前订</p>
                                        </div>
                                    
                                        <asp:Button ID="btnCurrentOrder"
                                            CssClass="btn btn-primary btn-block"
                                            runat="server" Text="提交订餐" OnClientClick="return btnCurrentOrderSubmit()"
                                            OnClick="btnCurrentOrder_Click" />

                                        <script type="text/javascript">
                                            function btnCurrentOrderSubmit()
                                            {
                                                if (
                                                !$("#cb_jrzwc").get(0).checked &&
                                                !$("#cb_jrwc").get(0).checked) {
                                                    $("#rfvdclx_cd").show();
                                                    return false;
                                                }
                                                return true;
                                            }
                                        </script>
                                   
                                </div>

                                <div role="tabpanel" class="tab-pane" id="panel_3">
                                        <div class="form-group">
                                            <label>
                                                订餐日期：
                                                <span id="rfvtxtSingleStart" style="color:Red; display:none">必填</span>
                                            </label>
                                            <div id="SingleStart" class="input-group date">
                                                <asp:TextBox ID="txtSingleStart" runat="server" class="form-control"></asp:TextBox>
                                                <div class="input-group-addon">
                                                    <span class="glyphicon glyphicon-th"></span>
                                                </div>
                                            </div>
                                            <script type="text/javascript">
                                                $(function () {
                                                    $("#SingleStart").datepicker({
                                                        language: "zh-CN",
                                                        autoclose: true,
                                                        format: "yyyy-mm-dd",
                                                        todayBtn: "linked",
                                                        todayHighlight: true
                                                    })
                                                });
                                            </script>
                                        </div>

                                        <div class="form-group">
                                            <label>
                                                订餐类型：
                                        <span id="rfvdclx_single" style="color: red; display: none;">请选择订餐类型</span>
                                            </label>
                                            <div class="list-group">
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cb_single_zc" runat="server" />
                                                    早餐
                                                </label>
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cb_single_zwc" runat="server" />
                                                    午餐
                                                </label>
                                                <label class="list-group-item l">
                                                    <asp:CheckBox ID="cb_single_wc" runat="server" />
                                                    晚餐
                                                </label>
                                            </div>
                                            <p class="help-block">注：早餐需前一天下午4时前，午餐早上9点前，晚餐下午4点前订</p>
                                        </div>

                                        <asp:Button ID="btnSingleSubmit"
                                            CssClass="btn btn-primary btn-block"
                                            runat="server" Text="提交订餐" OnClientClick="return befSingleSubmit()"
                                            OnClick="btnSingleSubmit_Click" />

                                        <script type="text/javascript">
                                            function befSingleSubmit() {
                                              
                                                var singleStart = $.trim($("#txtSingleStart").val());
                                      
                                                if (singleStart == "") {
                                                    $("#rfvtxtSingleStart").show();
                                                    return false;
                                                }
                
                                                if (!$("#cb_single_zc").get(0).checked &&
                                                !$("#cb_single_zwc").get(0).checked &&
                                                !$("#cb_single_wc").get(0).checked) {
                                                    $("#rfvdclx_single").show();
                                                    return false;
                                                }
                                                return true;
                                            }
                                        </script>
                                    
                                </div>
                            </div>
                        </div>
                        <script type="text/javascript">
                           $("#panel_" + $("#hfCurrentTab").val()).addClass("active");
                        </script>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <uc1:MyFooter runat="server" ID="MyFooter" />
</body>
</html>
