﻿using System;
using System.Collections.Generic;
using System.Text;

namespace JumboTCMS.Utils
{
    /// <summary>
    /// 汉字转换拼音
    /// </summary>
    public static class ChineseSpell
    {

        private static readonly string[] _charIndex = new string[] { 
            "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "", "", "", "", "", "", 
            "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", 
            "17", "18", "19", "20", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", 
            "13", "14", "15", "16", "17", "18", "19", "20", "1", "2", "3", "4", "5", "6", "7", "8", 
            "9", "10", "", "", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "", "", 
            "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "", ""
         };
        private static readonly int[,] _spellCodeIndex = new int[,] { 
        { 
            0x162, 0x117, 0x14b, 0, 190, 0x27, 0x11c, 0x43, 0xf9, 0xa7, 0x161, 0x13, 0x85, 0x5c, 0x81, 0x98, 
            0x1f, 0x181, 0x69, 0x83, 0x54, 0x15c, 0x15c, 0x149, 0x85, 0, 0x178, 0x74, 0x11b, 0x15d, 0x158, 0x57, 
            0x85, 0, 0, 0, 0x11c, 0xca, 0, 0, 0, 0, 0, 0, 0x156, 0x159, 0, 0x114, 
            0xc7, 0xf3, 0, 0, 0x34, 0, 0x177, 0x66, 0x58, 0xb0, 170, 0x15c, 0x88, 180, 0x177, 0, 
            0x162, 0x126, 0x12b, 0x5e, 0x158, 0x170, 0x158, 0x37, 0x15b, 0x14d, 0x83, 0x15b, 0x161, 0x171, 0xa6, 0x4a, 
            0x145, 0x5c, 0, 0x149, 6, 0x13, 0, 0x132, 0, 0x14c, 0x174, 0x72, 0x6b, 20, 0x21, 370, 
            0x117, 0x102, 0x4f, 0xbf, 0xf3, 0x148, 220, 0x53, 0x2b, 0x144, 0x3e, 0x178, 0xe5, 0x162, 0x40, 0x49, 
            0x149, 0x15c, 0x150, 0x5c, 2, 0x15d, 0xe8, 0x11a, 0x54, 0x131, 0x185, 0x165, 0x86, 0x14c, 0x157, 0x150, 
            0x16b, 0x14c, 0xd9, 0xd0, 0x14f, 340, 0x179, 0x185, 13, 0xe8, 0x15c, 0x126, 0x15c, 0x176, 0x6b, 0xb5, 
            0x17a, 0x15, 250, 14, 0x173, 0x2f, 0x15a, 0x171, 14, 0x14c, 250, 0x11c, 10, 0x79, 110, 0x14d, 
            0x5b, 0x4e, 0xc2, 0x13, 0x71, 0x7b, 0x66, 0xfb, 0x2f, 0x151, 0x11a, 320, 0x6a, 0x9d, 0x15c, 0x65, 
            0x15d, 0xbd, 340, 3, 0xaf, 0x4d, 0xb2, 0x1d, 0x25, 0x157, 0x179, 0x107, 0x7d, 0x126, 0x38
         }, { 
            0x12e, 0xd6, 130, 0x84, 0x139, 0x175, 0x189, 0x27, 0x194, 0x86, 0x11e, 0x139, 0x11a, 320, 20, 0xc9, 
            0x14e, 0x13e, 0x162, 330, 340, 0x65, 0x94, 0x149, 0x15c, 0x54, 0xa7, 0x7a, 350, 0x14c, 270, 0xe5, 
            330, 190, 0x14b, 0x153, 0x3e, 0x86, 0x177, 0x9d, 0x126, 0x7b, 0x14e, 0x7d, 0x10, 0x135, 0x51, 0x158, 
            11, 0x162, 0x150, 0x74, 0x176, 0x177, 0x13, 0x85, 220, 0x185, 0xa7, 0x143, 0xa9, 0x2b, 0x183, 0, 
            0x5b, 310, 0x11e, 0xbb, 0x130, 0x17f, 0x151, 0xed, 0xf1, 0x58, 0xa7, 0x12b, 0xf5, 80, 0x177, 0x183, 
            0xb2, 0x127, 0xab, 0x7a, 0x44, 0x182, 12, 0x149, 0x86, 200, 0x17, 0x7d, 0x15b, 0x114, 0xf5, 350, 
            0x24, 0xf3, 0x108, 0x178, 0x2d, 0x145, 0x162, 0x13, 0x135, 0x159, 0x53, 0x131, 0x148, 0x4b, 0x22, 0x11b, 
            140, 0x3e, 0x1d, 11, 0x16f, 120, 220, 0x171, 0x184, 0x159, 0x161, 340, 0x16f, 0x2f, 0x54, 0x54, 
            0x177, 190, 0x5c, 0x15c, 0x14f, 0x157, 0x126, 0x47, 0x170, 0x175, 0x13b, 11, 360, 0xf5, 0x145, 0x128, 
            0x177, 0x129, 0x14b, 0x163, 0x105, 0xd9, 0x165, 0x7e, 180, 0x3f, 0x131, 0x6d, 0x81, 330, 0x116, 0xf3, 
            0xfc, 0x23, 40, 270, 11, 0x14e, 0x160, 220, 0x130, 0x12d, 0x15a, 0x4e, 0x13, 0x14d, 0x167, 0x61, 
            270, 0xa2, 0x160, 0x16a, 0x183, 0xe7, 0x127, 0x17d, 0x162, 0x170, 0x185, 0x117, 0x2b, 0x83, 0x6b
         }, { 
            370, 0xf7, 0x15d, 0x3e, 0x14f, 0xae, 11, 0xea, 130, 0xa6, 0xaf, 0xb6, 0xf3, 0x14c, 0x130, 350, 
            0x44, 0x188, 0x116, 0x7f, 0x84, 0x13e, 0x188, 240, 160, 0x20, 0x65, 0xf1, 0x134, 0x17d, 0x145, 0x5c, 
            20, 0x79, 0x2d, 0x138, 0x116, 220, 0x52, 0x14c, 0x162, 0x4b, 170, 20, 0x61, 0x14c, 0x14c, 0xc1, 
            0x15b, 130, 0xf2, 0x7f, 0x53, 0x179, 2, 0x10d, 0x15c, 0x89, 0xd8, 0x130, 0x15c, 0x3a, 150, 0, 
            0x7d, 40, 0x80, 0x114, 0x167, 0x18, 0x12, 3, 0x12f, 0x3b, 30, 0x9e, 0x15c, 130, 0xf3, 0xbc, 
            0x149, 0xd6, 0xf8, 0xd0, 0x20, 0xa9, 0x194, 0x98, 10, 0x162, 0x10, 360, 0x177, 0x126, 0x161, 0x6d, 
            0xf7, 0xf6, 0xa4, 0x134, 0x145, 0xad, 40, 0x1f, 0x14d, 0x137, 0x14f, 0xa4, 0xb3, 360, 0xdd, 0x131, 
            0x159, 0xb3, 0xca, 360, 0x152, 0x109, 0x109, 0x13c, 0x20, 0xd0, 0xd0, 130, 0x159, 0x11c, 0, 0, 
            0, 0, 0x11a, 0x45, 0, 0, 120, 0x149, 0x109, 0xa7, 0x162, 0x6b, 310, 0, 0x5c, 0x15c, 
            0xb8, 0xfe, 0x159, 0xb8, 0x16f, 0x84, 0x62, 0x84, 0xb8, 0x179, 0x60, 340, 0x161, 140, 0x15c, 0xbd, 
            0x11c, 0xbc, 0x86, 0x93, 0xc1, 0x54, 0x14f, 0xbd, 0x12f, 0x59, 0x74, 0xe2, 0x54, 0xc1, 0xf2, 0x7d, 
            0x128, 0xba, 0x13c, 0x61, 0x83, 0xf7, 0x44, 0x58, 0x15d, 2, 0xa4, 0x19, 0xc2, 0x180, 0x34
         }, { 
            0x126, 0x4a, 130, 170, 330, 70, 0x4f, 0x4f, 0x86, 40, 0x176, 0x53, 0xc6, 0x177, 0x53, 0x53, 
            0x8b, 0x58, 0xed, 150, 0x6b, 0x102, 0x2b, 0x5c, 0xf3, 0x35, 0x5c, 0x39, 0x143, 0x88, 0xa4, 0x54, 
            250, 0x40, 0xc1, 0xab, 0x178, 0x11, 0x81, 0x81, 0x116, 0x1f, 0x5e, 0x2b, 0x99, 0x4a, 0x4d, 0x81, 
            0x2f, 0x83, 0x45, 0xb3, 0x16b, 0x163, 0x36, 0, 0x114, 0x2b, 0x36, 0xa4, 0x51, 0x1f, 0xf1, 0, 
            0x2b, 0x182, 0x59, 240, 0x4a, 0xf7, 0x181, 0x7d, 0x5c, 0x159, 0x7b, 0x4a, 0x177, 0x149, 0x62, 0x11b, 
            0x7d, 0x16f, 0x8b, 0xf4, 0x2a, 0x1f, 0x17d, 0xaf, 0xa4, 0xe7, 0x116, 0x93, 0x62, 0x75, 0x16f, 0x181, 
            0xa6, 0x86, 0xac, 0x66, 0x80, 0x66, 0x7d, 0x7d, 0x13a, 0x5c, 0x7d, 0x7d, 0x177, 0x1f, 390, 0xc4, 
            0xa4, 0x17a, 0x158, 0x83, 0x91, 0x14f, 0x177, 0x15c, 0x17a, 0xc4, 160, 0x87, 0x93, 0x15a, 0x141, 0x14e, 
            0xc5, 0x98, 0x81, 0xa9, 0, 0x83, 90, 0xc1, 0x25, 0x9f, 0x160, 0, 0x87, 0xf7, 0xaf, 0x15, 
            0x9d, 0x8b, 190, 0x44, 340, 0x149, 0x15c, 0x157, 0x15a, 0x11b, 0xa8, 0xaf, 0xea, 0x11c, 0x5c, 0xf4, 
            0x80, 0xfb, 0x14d, 0x15c, 0x156, 0x4f, 0x87, 0x13a, 0x86, 0x39, 0xb5, 0x157, 0x157, 0x194, 0xa4, 0x22, 
            0x14d, 0xfb, 0x165, 0x85, 10, 0, 14, 0x57, 0x57, 0x15c, 0xe7, 0x86, 220, 0x5b, 0x4b
         }, { 
            0x5f, 0x37, 0x85, 0x5f, 0xcb, 0x85, 0x15c, 0x7e, 0x8d, 0x74, 250, 0x4f, 0xf5, 0x169, 0x98, 0x74, 
            0x162, 0x66, 0x79, 0x39, 0x99, 0xa6, 0xa6, 0x12a, 70, 0x85, 250, 330, 0x8f, 0x159, 250, 0x157, 
            0xd1, 0x185, 0x11c, 330, 0x143, 0x143, 0x14f, 0x116, 0x5c, 0x120, 0x98, 330, 0x14f, 0xfe, 0x15a, 0xf8, 
            280, 0x25, 340, 330, 0x99, 0x5c, 0x4b, 330, 270, 0x159, 0x174, 0x6b, 0x158, 0x3e, 0x170, 0, 
            0xe3, 0, 0xf5, 0x158, 0x177, 0xb7, 0x135, 0x119, 0x139, 0x187, 0x51, 0x16b, 0x163, 0xa4, 0x3f, 0xf6, 
            5, 0x66, 0x159, 0xa4, 0x20, 0xf3, 0xa4, 0x159, 0x159, 0x163, 0x72, 190, 0x106, 250, 0, 0xa2, 
            70, 0x17d, 0x11a, 0x11a, 0x11a, 0x15c, 0x38, 0x11d, 0x88, 6, 0x10b, 0x11c, 0x181, 0x14b, 0x14e, 0x5c, 
            0x165, 0x109, 0x30, 0x62, 0xf9, 0x25, 0, 0x72, 0xc0, 0xb7, 0x155, 0x182, 0x4a, 0x15b, 0xdf, 0x7b, 
            0x15c, 0x27, 0xf6, 0x14f, 0xef, 0x75, 0x72, 0x162, 0xdd, 0x156, 0x107, 0xdf, 90, 0x89, 0x194, 0x5b, 
            0x146, 0xf1, 0x149, 0x80, 0x165, 0x25, 0x11b, 0x13f, 0x146, 0x4b, 0x11c, 0x87, 230, 0x146, 0xc5, 0xfe, 
            0x3e, 0x11c, 0x179, 0x138, 330, 0x15c, 0xf1, 0xed, 0x182, 340, 0x15c, 0x14e, 0x158, 250, 0x14c, 320, 
            0xef, 0x11, 0x54, 0x15a, 0x7b, 0x12f, 0x37, 0x141, 0x189, 0x15, 0x12e, 0x14c, 0x7b, 0xf1, 0x4d
         }, { 
            0x4b, 0x177, 0x17a, 0x157, 0x14e, 0x95, 0x11c, 0x137, 0x18d, 0x155, 0x142, 160, 0x13a, 0x152, 0x161, 0xbd, 
            0xd1, 0x151, 0, 0x6d, 0x165, 0xad, 0xef, 0xb7, 0x185, 110, 0x14c, 160, 0xee, 0xa7, 6, 0xc0, 
            0x194, 0x12b, 0x54, 0x6b, 0x164, 0x161, 0x61, 0x61, 11, 0x6b, 0x15c, 0xf3, 0x13c, 0x159, 0x143, 0xa4, 
            0xf9, 0x22, 0x16a, 0x158, 0x45, 0xf1, 0x3e, 0xf6, 0, 0x72, 0, 0, 0xa7, 0x9f, 0x114, 0, 
            0, 0x148, 0x15d, 0xf1, 0x141, 0xf4, 3, 0x16b, 0xd1, 0x162, 310, 0x9d, 330, 2, 400, 0x181, 
            0x170, 0x166, 0x14e, 0x14d, 0x180, 0x149, 0x146, 0x135, 0x61, 0xf1, 0xf1, 0x39, 0x15b, 0x182, 0x13c, 0x34, 
            110, 0x158, 0xf1, 0x174, 0xa7, 0x14c, 350, 0x62, 0x16b, 0x68, 0xb3, 0, 0x3e, 0xfb, 320, 0, 
            0x131, 3, 0x39, 0x162, 0x174, 0x179, 30, 0x142, 0, 360, 220, 190, 0x74, 0x165, 0x77, 0x163, 
            0x5c, 0x178, 0x145, 0x114, 340, 120, 0x16f, 0x159, 0xa7, 0x162, 0x10f, 0x8b, 0x7f, 0x159, 0x116, 230, 
            300, 0x15f, 0x145, 350, 0, 11, 0, 0x16a, 0x7b, 0x135, 220, 0x14e, 0xf4, 0x111, 0x160, 0x72, 
            0x14f, 180, 0x1d, 0x6a, 0x107, 0x141, 0x5c, 0xe3, 0x149, 0x14c, 0x182, 0xaf, 0x141, 0, 0x12d, 0, 
            0x10d, 0, 0xc7, 0xf4, 14, 5, 0xa6, 0x187, 0x17a, 0xc4, 0x130, 0x80, 0x26, 0x80, 0x8b
         }, { 
            0x130, 0x11a, 2, 0x14e, 0xae, 0x14e, 0x74, 0x79, 0x68, 340, 0x14c, 0x16b, 0x20, 0xee, 60, 180, 
            0x74, 0x56, 0x131, 0x15b, 0x10d, 0x80, 0x14e, 0x75, 0xb5, 0xfe, 0x14e, 0x14e, 0x5c, 0x99, 0x14e, 0x6d, 
            0x18c, 0x7f, 340, 320, 0x130, 0x157, 0x149, 0x188, 0x4f, 0x8b, 0x79, 0x18, 0x2b, 0x166, 0x39, 0x162, 
            0x13f, 330, 0xf1, 0x6d, 0xa6, 340, 0x79, 0x15d, 0x157, 220, 0x126, 0x159, 350, 0x37, 0x171, 0, 
            0x181, 0xd8, 0x164, 0x14f, 0x7f, 0x163, 2, 0x160, 0x145, 0x162, 230, 0x3b, 0x150, 0x49, 0x3a, 0x150, 
            0xe8, 0x15d, 0x187, 0xd6, 0x3e, 0x9e, 0x12e, 0x148, 0x14b, 0x15b, 0x4a, 0x153, 0x179, 0x170, 130, 0x20, 
            0x157, 0xb9, 0x177, 0xaf, 0x79, 0xe4, 0x161, 220, 0x15d, 0x15f, 0xba, 0x72, 0x174, 0xa4, 0xac, 0x6a, 
            0xca, 0xc4, 0x159, 0xa4, 0xaf, 0xad, 0xc4, 0x39, 0x23, 0xec, 0xe8, 0x14d, 0xb9, 330, 0x4a, 0x94, 
            0x159, 0x1f, 350, 0, 0x9c, 0x12e, 0x14e, 0x2e, 0x77, 0x7b, 0x17d, 0x174, 0x14e, 0x16f, 0xa4, 0x1f, 
            30, 0xa4, 0x15c, 0xb3, 360, 0x129, 0, 0x16d, 0x7d, 0x166, 0x17a, 0x9e, 0xd4, 0, 0, 0x79, 
            0x15d, 0xd5, 0x13d, 0x8d, 0x163, 0x84, 0xe9, 0x165, 0x30, 0x79, 0x4b, 0x68, 0x13a, 0x13c, 0x68, 0xfd, 
            260, 0x68, 0x12f, 0x68, 0x15d, 0x7a, 0x6b, 0xb2, 0x68, 0x2c, 0x145, 0x163, 0xfb, 0x94, 240
         }, { 
            0x163, 0x163, 0x158, 0x13d, 0x13c, 0x13c, 0x13d, 0xb1, 0x79, 0x15c, 0xb0, 0xb0, 0x158, 0x13c, 0x139, 240, 
            0xaf, 150, 0x158, 0x180, 0x129, 0x129, 0x181, 0x3a, 0xf2, 0x14b, 0x116, 0xd4, 0xc4, 0x7c, 0x177, 0x157, 
            0x15c, 0xf6, 0xba, 0x105, 0x13f, 0x52, 14, 0x151, 0x9e, 0x83, 0x5c, 0x3e, 0x151, 0xe2, 0x131, 250, 
            0x181, 0x62, 0x12f, 0x84, 0x15a, 0, 0xaf, 0xf9, 0x60, 0x156, 6, 0xab, 0x17a, 0x54, 0x74, 0, 
            0x177, 5, 0, 0xe4, 0xc1, 0x5c, 110, 0x194, 0x2f, 0x25, 0x15d, 0x73, 0x48, 0x173, 0x54, 0x65, 
            220, 0x4a, 0x66, 0x1d, 0x15a, 0x14f, 0x11d, 0x13, 0x72, 0x37, 0x8a, 0x3a, 0x6c, 3, 0x151, 0x14c, 
            9, 0xef, 11, 0x15c, 0x15d, 0x6b, 340, 0x17f, 0xf6, 0x53, 80, 0xfc, 0x160, 0x89, 0x14b, 0x3e, 
            0x9f, 0x87, 0xf6, 0x174, 0xa9, 0x75, 0x15, 0x84, 0x15b, 0x3e, 0x158, 0xfb, 0x12b, 0x176, 0x143, 0x86, 
            0xb2, 0x176, 0x92, 0x117, 0x44, 0x130, 0x17, 0x13b, 13, 0x14c, 0x4a, 0x15c, 0x177, 0x180, 0xf1, 0x86, 
            0xd0, 0x8f, 0x9a, 0xd0, 0x7d, 0x59, 0x162, 0x158, 0x61, 0xa3, 80, 0x158, 0x9a, 3, 0x11a, 0xcb, 
            0x13c, 0x24, 0x77, 14, 0xa6, 0x148, 0x17d, 10, 0x162, 0x149, 0x81, 0x108, 0x15b, 0x5e, 0x183, 0x162, 
            120, 0x4b, 220, 0x54, 0x5c, 0xba, 0x117, 320, 0x15d, 0x53, 0x178, 0x81, 130, 0x71, 0x59
         }, { 
            0x2d, 0x14c, 0xed, 0xa2, 0x151, 120, 0x47, 0x143, 0x155, 330, 0x5c, 150, 350, 0x160, 0x8b, 0x129, 
            0x11c, 0xbd, 0x147, 0x24, 0x13c, 0xfc, 0x178, 0xa4, 0xe7, 9, 0x169, 0x48, 0x175, 0x149, 0x176, 0x157, 
            0x175, 2, 0x5f, 0x159, 140, 0x146, 0x14f, 0xac, 0x6a, 0x9f, 0x117, 0xe7, 13, 0x23, 0xaf, 0xaf, 
            0xdf, 0xf3, 0xba, 0xc4, 0x17d, 290, 0xae, 0x10, 0x1b, 0x177, 370, 140, 0x3f, 0x23, 0x181, 0, 
            0x5c, 0x68, 0xf4, 0xf6, 0x3e, 0x34, 0x159, 0x12e, 0x16e, 0xf3, 0x145, 0x17f, 0x7f, 0x116, 0x116, 0x51, 
            240, 0x13e, 0x13d, 0x4f, 0xfc, 0x49, 0x188, 0x3e, 0x11b, 0x79, 0x4a, 0x130, 0x3d, 0x149, 0x52, 120, 
            0x130, 0x37, 0x15b, 0x17a, 0x7d, 0x162, 0xf4, 0x7f, 0x90, 0x15c, 0xe8, 0x3f, 0x7e, 0x15b, 0x156, 0x130, 
            0x9e, 0x86, 0x76, 0x3a, 0xff, 0xf3, 0x157, 0x14c, 330, 2, 0x158, 0x3b, 0x108, 130, 0x194, 0x98, 
            0xaf, 0x159, 0x130, 0x145, 0x79, 0xad, 0xad, 0x109, 0xa4, 170, 0x1f, 0x157, 0x159, 0xa2, 6, 0x143, 
            270, 0x17e, 0x15c, 0xb5, 0x17a, 0x17e, 0x74, 0x9a, 0x74, 340, 0x9a, 0x11d, 0xb7, 0x49, 0x11d, 0x15c, 
            350, 0x7e, 0xe3, 0x170, 15, 0x12b, 0xfd, 0xab, 0x36, 0x155, 0x14f, 0xcb, 0x14b, 0x163, 0x143, 0x177, 
            0xf7, 0, 0x60, 0xf1, 0xbc, 0xbc, 0x23, 0x16b, 0x88, 90, 0x132, 0x12f, 0x159, 14, 0
         }, { 
            0x165, 0x14f, 6, 0x4c, 0x135, 0xe4, 0x87, 0x14f, 0x3f, 0x15a, 0x77, 0x8b, 0x16f, 12, 120, 0x51, 
            0x40, 0x157, 0x91, 5, 0x147, 0x12f, 0x149, 5, 0x7e, 0xa6, 0x4a, 0x165, 0x7e, 0x11c, 0x52, 0x7b, 
            14, 0xb0, 0x4a, 0x139, 0xf3, 0x85, 0xda, 0x1d, 0x14c, 0x4f, 0x5c, 0x72, 0x39, 0x161, 0x83, 0x81, 
            0x146, 0x178, 0xe0, 0x91, 0x178, 0x165, 0xe8, 0x25, 0x164, 0x17e, 0x159, 0xc9, 0x150, 0x52, 0x53, 0, 
            0x163, 70, 20, 0x181, 0x173, 0xd0, 0x163, 0x13b, 0x155, 0x177, 0x4b, 0xc4, 14, 0x11a, 0x4b, 110, 
            340, 0x4e, 0x176, 0xc1, 8, 0x54, 0xab, 0x182, 0xfe, 0x14c, 0x15a, 0xb6, 0x182, 0x86, 0x102, 0x44, 
            0x5c, 0x57, 0x14d, 0x7b, 0x87, 0x60, 0x7d, 0x7d, 0xd1, 0x177, 0x175, 0x14c, 0x71, 0x65, 0x157, 0x95, 
            0x159, 0xc2, 0xa9, 0xe5, 0x158, 0x161, 0x159, 0x14c, 0x135, 0x141, 0xfb, 0x127, 0x72, 0x14c, 280, 0x11b, 
            0x14f, 0xb7, 0x54, 0x149, 0x8f, 0x9d, 50, 0x139, 0x151, 0xc9, 0x162, 0xee, 0x12b, 0x177, 0x6b, 0x17e, 
            0xed, 0x13e, 0x14c, 0x162, 0x159, 0x149, 330, 0x159, 0x162, 0x126, 0xa4, 0x86, 0x17f, 0xf1, 0x14c, 0x181, 
            0x44, 0xaf, 0x4b, 0x4b, 0x194, 190, 0x30, 0xef, 0x86, 0x17, 0xab, 0x14e, 0x11e, 0xf1, 0x79, 0x54, 
            0x148, 0x148, 0x130, 0x51, 0x51, 310, 0xd0, 0xfb, 0x83, 0x83, 0xf3, 0x3f, 0x151, 0x74, 0x143
         }, { 
            0x9d, 0x15d, 0x179, 0xcb, 0x54, 0xb2, 0, 0x9a, 0x15d, 0x158, 0x86, 0xa4, 0x3f, 0x14c, 0x75, 0x75, 
            0x15a, 220, 0xc9, 0x10b, 0x7c, 0x162, 0x162, 0x145, 0x135, 0x106, 0xba, 0x39, 0x108, 0xf7, 0x79, 0x148, 
            0xf3, 0x2d, 0xbf, 0x54, 0x81, 0x47, 0x15c, 0x178, 120, 190, 0x159, 350, 0x155, 0x81, 0x145, 0x176, 
            0xf9, 0x177, 0x14f, 320, 0xa6, 0xb8, 0xfe, 0x126, 0xe9, 0x145, 0x141, 50, 0x74, 0xf5, 10, 0, 
            340, 0x162, 0x66, 0x184, 220, 0x163, 0x105, 0x107, 0xac, 0xba, 0xe2, 0x165, 180, 0x99, 0x11a, 0x175, 
            0x163, 0x12d, 0x105, 0xc2, 350, 0x129, 0xd3, 0x132, 0xe3, 0x9f, 0xcb, 10, 0xe8, 0x15c, 0x162, 0x155, 
            0x163, 0x15c, 0x8d, 0x160, 0xd0, 0x187, 130, 0x17d, 0x16b, 0xc9, 160, 0x174, 0x74, 0x74, 5, 0x108, 
            180, 0xeb, 0x61, 0x149, 0x7f, 320, 0x171, 0xbf, 0x14c, 0x14c, 0xc4, 0xa8, 0xa6, 0x75, 0x66, 0x3d, 
            0x177, 340, 0x15c, 0x75, 330, 0x99, 220, 0x159, 0x1f, 0x80, 0xba, 0x54, 0x4f, 0x159, 0x15c, 0x6f, 
            0x80, 0x54, 0x11c, 0x12b, 0xf4, 0xa6, 0x155, 0x150, 0xd3, 0x44, 0x15c, 0x18, 2, 210, 0xd6, 180, 
            0x137, 0x27, 130, 0x2f, 0x162, 0xec, 0x105, 0x107, 0xd0, 0x159, 0x12f, 350, 0xf3, 0x164, 190, 14, 
            0x11a, 0x151, 0xd0, 70, 0xac, 0x163, 0x9e, 0x159, 0xab, 0x80, 0xff, 0x9e, 0x14c, 350, 290
         }, { 
            0x14f, 0xfb, 0xbd, 0xa4, 0xb0, 0x159, 0x17a, 0x9e, 0x88, 0x182, 0x150, 0x126, 0x12f, 0x161, 0x17d, 0x157, 
            0xc0, 0x30, 0x143, 0x158, 0x15c, 0x182, 0xa4, 0x156, 20, 200, 0xd4, 350, 0xb0, 0x105, 0xf8, 0x13c, 
            0x106, 220, 0x15c, 0x83, 0x180, 0x17a, 0x72, 0x11c, 0x15c, 0x137, 330, 0x24, 0xfd, 0x5f, 0x14e, 0x16f, 
            0x11c, 0x11a, 120, 0xbd, 0x93, 0x17, 360, 0x163, 0xf9, 110, 0x175, 0x7d, 0xd6, 0x13, 0x77, 0, 
            0xf6, 0x11c, 0xd6, 130, 0xd6, 0x177, 0x162, 10, 0x97, 0xd6, 0x194, 0xf6, 0x74, 0x177, 0xd6, 0x11a, 
            0x145, 0x14f, 0x97, 0x79, 0x89, 0x15c, 0x15c, 10, 0xf6, 0xad, 10, 0x53, 0x194, 0x48, 0xee, 0x17d, 
            0xee, 0, 0x15a, 0x17d, 0x157, 0x17a, 0x48, 0x3b, 0x81, 0xbd, 0xbd, 0x11e, 0x117, 0xc4, 0xa8, 0x14c, 
            0x14c, 0x9a, 0x161, 0xd3, 0xe3, 0x144, 0x144, 0x144, 220, 0x4a, 0x99, 0x178, 0x58, 0x61, 380, 0x58, 
            0x58, 330, 14, 0x81, 310, 0x40, 0x11c, 0x175, 0x14f, 0xd0, 330, 0, 0xb6, 0xae, 0xed, 0x14f, 
            0x51, 0x14f, 0x194, 0x1c, 0x14f, 0x86, 0x88, 0xa8, 0x88, 0x17a, 0x14f, 0xee, 0x141, 0x14c, 0xa4, 0x159, 
            0x3b, 0x79, 0xad, 0x102, 0x149, 0x6b, 0x11a, 40, 0, 0x164, 8, 220, 4, 0x149, 0x81, 0x5c, 
            0x52, 0x143, 0xf3, 0xf1, 0x81, 0x189, 0x189, 0x15a, 0x86, 0x59, 0x156, 0xee, 0xa4, 0x137, 0x185
         }, { 
            0x54, 320, 0xe8, 5, 0x98, 250, 0xee, 0x137, 0xab, 0x25, 0xed, 0, 9, 0x13a, 0x156, 15, 
            110, 0x8f, 0xb3, 0x4b, 0xd4, 0x41, 0xaf, 0x4c, 0x4d, 0x57, 0xfb, 0x15c, 0xc6, 0x11c, 3, 0x145, 
            0x77, 0xbd, 0xa4, 0x5c, 0x13a, 0x145, 0x161, 0x61, 0xa9, 220, 0x80, 0x4b, 0x15b, 0x15, 0xfd, 0x53, 
            0xcb, 0xa4, 0x161, 0x14c, 0x105, 0x3b, 0x11a, 0x24, 0x13c, 0x5e, 90, 0x14b, 0x15d, 0x162, 0xca, 0, 
            140, 0x159, 0xfc, 0x26, 0x12e, 170, 0x75, 0x86, 0x9d, 0xc1, 0x9a, 0x9a, 0x185, 0x61, 0x158, 0x59, 
            0xb2, 0xb2, 0xab, 0x4a, 0x176, 0x15d, 0x44, 0x6b, 0x176, 0x145, 0xe8, 0x81, 0x185, 0x94, 0x44, 0x15d, 
            0x182, 0x16b, 120, 0x162, 0x15a, 0x53, 0xf9, 0x15a, 0x135, 0x15c, 0x177, 0x11c, 0x4b, 0x17a, 0x171, 0x194, 
            0x159, 0xba, 0x6b, 0x5c, 0x77, 0x139, 0x149, 0x162, 0x183, 0x9e, 0x8f, 0x159, 0x159, 0x145, 0x183, 0x1d, 
            0x12d, 0x8f, 0xf6, 0x135, 0x13c, 0x48, 330, 0x147, 0x19, 0x131, 350, 0x81, 0x8b, 0xac, 0x149, 0x7f, 
            13, 0x3f, 0xf3, 0x160, 0xd4, 0x36, 0x11c, 0x10b, 0x127, 0x183, 0x7e, 0xa8, 0x8d, 0x1f, 0x41, 0x18f, 
            0x42, 0x13c, 0xae, 0x171, 0x171, 5, 0x1a, 250, 0xf4, 0x187, 0x187, 0x3b, 0x3b, 330, 0x162, 0xe8, 
            0xad, 0x14d, 0x176, 20, 0xf6, 0x80, 0x159, 160, 0x171, 0xa8, 0xa8, 0xf6, 0x4a, 0x188, 0x7f
         }, { 
            0x88, 220, 0x80, 220, 0x88, 0x171, 0x15c, 0x156, 0xcb, 0x15b, 0x15b, 0x15c, 0xd4, 0x159, 0x5c, 0x14f, 
            0x8f, 330, 0x3e, 5, 0x187, 0x145, 0x105, 0x3b, 0xab, 0x81, 0x162, 0x164, 0x15d, 0x107, 0x81, 0xa9, 
            330, 0xad, 0xad, 350, 330, 0x86, 0x1f, 350, 0x145, 0x159, 0xcb, 0xfb, 0x21, 0x33, 0xb0, 0x3f, 
            0x3f, 0xd4, 0x159, 0x159, 0x159, 0xcb, 0x159, 150, 120, 0x151, 0x21, 0xa9, 0, 240, 240, 0, 
            0xf9, 0x177, 0x173, 0x15c, 130, 300, 0xfb, 0, 0xee, 0x166, 0x42, 0xd4, 0x52, 0xe0, 0x177, 0x74, 
            0x39, 0x38, 0x141, 0x54, 0xc4, 0x15c, 0x15c, 0xed, 0xf2, 0x87, 0x107, 0x120, 0x123, 0x7f, 0x175, 0x11c, 
            0xfd, 0x38, 0x66, 0xed, 370, 270, 0x143, 0x38, 0x114, 0xf1, 70, 0x73, 0x176, 340, 0x145, 0x15c, 
            9, 0xed, 0x41, 0x5f, 0xe2, 0x132, 0xbd, 0x7c, 0x134, 0x79, 0x178, 0x11a, 0x10, 0x68, 0x16b, 0xc6, 
            9, 0x83, 0x1f, 0x177, 0x149, 14, 14, 370, 0xbd, 0x7f, 0x1f, 0x52, 0xbc, 9, 0x3b, 0xc0, 
            40, 0x81, 0x14c, 0x9e, 0x7d, 0x13, 0x58, 0x5c, 0x139, 0x16b, 0x65, 0xb9, 0xf6, 0x13f, 0x158, 0x150, 
            0x81, 0x17e, 0x158, 0x2f, 0x13a, 0x15c, 0x177, 0x137, 0x177, 0x14e, 0x13c, 0x66, 0x94, 0xbc, 0x161, 0x15, 
            0x13, 0x24, 0x9d, 0x5c, 0x127, 0x11e, 0xf7, 0x162, 0xbf, 0x128, 0x16b, 0x14d, 0x51, 0x85, 0x4b
         }, { 
            0x145, 0xac, 0x14b, 0x128, 0x177, 0x15, 0xf7, 0x85, 0x85, 0xae, 0x15d, 330, 0xaf, 0x15c, 40, 0x13c, 
            0x126, 0x150, 0xbf, 0x20, 0x149, 0x51, 0x98, 0, 150, 14, 0x111, 170, 0xa8, 0x194, 0x5c, 350, 
            0x14c, 0x139, 0x160, 0xa4, 0x139, 0x159, 0x3e, 0xee, 0x79, 200, 0x79, 0x52, 250, 0x159, 0x169, 0x15c, 
            0x4d, 270, 0x4d, 0x11c, 0x40, 0x74, 0x149, 0x13e, 0x7e, 6, 0x11a, 370, 0x132, 0x54, 0x3e, 0, 
            0x21, 0x175, 0x15c, 0xfb, 280, 0x163, 0x83, 0x40, 370, 0x7e, 0xf4, 0xe7, 14, 0x119, 0x130, 0x7d, 
            0x5b, 0x4e, 14, 0x93, 0x7d, 0x11, 0x14e, 0x130, 0x68, 0xf4, 0x72, 0xd0, 0x68, 0x143, 0x88, 0x5c, 
            0xaf, 0x79, 0x79, 0x15c, 0x15c, 0x15c, 0x164, 0x164, 0x146, 0x159, 0x162, 0x25, 0x40, 0x160, 0xea, 0x25, 
            0x181, 0x15c, 0x5c, 0x178, 0x144, 0x3e, 0xab, 0x54, 0x144, 330, 0x144, 0x176, 0x177, 0x83, 0x30, 0x177, 
            0x30, 0, 0x5c, 0x177, 0x183, 0x179, 0x9d, 0x14f, 0x81, 0x7d, 0x135, 0x14b, 0xe9, 0x54, 0x145, 0xe3, 
            330, 0x176, 0xea, 0x135, 60, 0x177, 0x11, 0x178, 0x22, 220, 0x79, 0xba, 0xad, 0x14d, 10, 250, 
            0xa1, 0x102, 0x139, 0x57, 0x102, 0x6b, 0x15c, 0x12f, 330, 0x4f, 350, 0x146, 0x146, 0x149, 0x5c, 330, 
            0x81, 0x143, 0x30, 0x162, 0x11c, 0x34, 0x12f, 0x180, 0xf6, 0x7a, 0x152, 0x144, 0x14c, 0x8d, 0x86
         }, { 
            0x15c, 10, 0xc1, 0xe5, 0x93, 8, 0xd7, 0x171, 0x74, 0x185, 0x161, 0x3e, 0x13e, 0x161, 0x54, 330, 
            14, 0x161, 0x155, 0x30, 0x13, 120, 0x156, 0xe8, 0x11e, 330, 0x130, 0x160, 0xc4, 0, 0x11c, 330, 
            160, 0x71, 0x98, 0xc5, 0x177, 0x14f, 220, 0x41, 0x6d, 0x145, 340, 0x14e, 0x126, 0x95, 0xf9, 0x79, 
            0x25, 0x15c, 0x152, 0x63, 170, 0x25, 0x117, 0x17d, 0x164, 0xe7, 60, 0x79, 0x14e, 0xb7, 0x160, 0, 
            0x163, 0xe8, 0x164, 0x162, 0x162, 0x8f, 0x174, 170, 0x80, 0xf5, 0x135, 0x15, 0xf3, 330, 0xbb, 0x15c, 
            0x71, 0x24, 0x149, 0xa4, 0xa7, 0x30, 0x15c, 0xa4, 0xcb, 0x4b, 0x149, 0x30, 60, 0x20, 0xbb, 0xa4, 
            100, 100, 0xf1, 0x92, 310, 0xb2, 330, 140, 0x67, 0xd0, 0x49, 0x68, 0x171, 0x163, 130, 0x5c, 
            170, 0x162, 110, 0xfb, 0x130, 0x135, 0xd4, 0x2e, 0xbb, 0x150, 0x149, 0x12d, 0x183, 0x7d, 0x160, 60, 
            0xcb, 0x165, 0x138, 0x2d, 0xf8, 0x1b, 15, 0x7a, 0x183, 0x135, 11, 0x155, 0x145, 0x5b, 0x145, 14, 
            0x155, 0x77, 190, 0x160, 0xf1, 0x131, 0x15d, 0x150, 0xb8, 0xf2, 0x8f, 2, 0xf5, 0x159, 0x108, 0x183, 
            0x126, 350, 0xfc, 0x72, 0x165, 0x129, 0xf1, 220, 0x127, 120, 0x5c, 0x61, 0x86, 0x2b, 0xd0, 0x14f, 
            0x8b, 0x176, 0x160, 0x1a, 0x157, 0x11a, 20, 330, 0x14f, 0x7a, 0x160, 0x15a, 0xa4, 0x110, 0x132
         }, 
        { 
            0x15d, 340, 0x12f, 0x165, 0xc2, 0x5f, 0x30, 0xea, 0xc6, 0x68, 0x25, 0x18, 0x18, 0x18, 0x34, 0xc1, 
            370, 0x13a, 5, 290, 100, 0xfc, 0x16a, 0x85, 0xa6, 0xdf, 0x127, 0xf6, 0x15d, 0x194, 0x117, 0x13d, 
            0xb6, 0x14c, 0x119, 0xf7, 0x3e, 0x177, 0x194, 0x87, 0xf1, 0xf1, 0x162, 0xed, 0xa8, 0x127, 0x161, 0x26, 
            0x177, 0x13a, 0x24, 0xf1, 250, 0xe7, 11, 0xf8, 0x80, 0x25, 0xa6, 0xed, 0x99, 0x79, 0x176, 0, 
            0x15d, 0x15d, 330, 330, 0x39, 0x130, 0x4a, 0x13f, 0x129, 0x88, 0x1b, 0x14e, 0x4f, 0x52, 160, 160, 
            0x14c, 0xc1, 0xa8, 0x149, 0x18, 0x88, 50, 0x14c, 0x130, 0x11b, 0xe8, 0x15c, 0x14c, 0xd8, 0x39, 0x130, 
            0x83, 0x127, 0x80, 0x145, 0x155, 0xf6, 0xf6, 0x86, 0x110, 0x90, 350, 0x15c, 170, 0x111, 0x89, 0x76, 
            2, 0x15b, 0x9b, 0x14b, 0x25, 0x162, 0x15d, 0x38, 0xbc, 0xd0, 0xbc, 0x48, 0xf1, 0xc4, 0x14c, 0xbb, 
            0x27, 0x177, 0xdd, 40, 0x15a, 20, 0x177, 0x98, 0x98, 0x161, 0x54, 0xac, 0xc0, 0x24, 0x79, 0x1f, 
            0x9e, 0x76, 0x155, 0xff, 0x1f, 0x5c, 0x86, 0x77, 0x119, 0xa6, 0xc9, 0xc4, 0x131, 0x88, 0x17e, 0x17e, 
            0x164, 0x5b, 0x7d, 0x44, 0x41, 0x17, 0x7c, 0x177, 0x99, 0x171, 0xf4, 0x5b, 0x7d, 0x162, 0x161, 330, 
            0x171, 330, 330, 250, 0x74, 0x74, 0x4b, 0x15c, 0x135, 0xb8, 0x3f, 0x117, 0x15c, 0x15c, 0x159
         }, { 
            0xf9, 0xa4, 0x4f, 0x107, 0x167, 370, 0x164, 0x162, 0x149, 0x6b, 0x11a, 0x16f, 0x15c, 0xf1, 0x149, 0, 
            0x102, 330, 0xf6, 0x7c, 0x162, 5, 0x174, 0x177, 0x177, 0, 0x159, 0x144, 15, 0x86, 0x146, 0x74, 
            0x164, 0xf6, 0x11a, 0x176, 0x165, 0x143, 0x109, 0xef, 0xef, 6, 0xd7, 0x16b, 0x165, 0x13, 0x177, 0xc9, 
            240, 220, 0x175, 0x16f, 0x15a, 0xf2, 0xd0, 0x15b, 0x25, 0xe8, 0x7c, 0xba, 250, 40, 0x158, 0, 
            0x171, 0xe4, 0xc7, 0xf3, 320, 7, 0x177, 0x86, 0x9b, 0xf2, 0xf3, 0x70, 0xd5, 0x5f, 0x188, 0x15c, 
            0x14f, 0x111, 0x79, 7, 0x177, 0x9b, 0x4a, 0x4a, 0xd8, 0x175, 110, 0x80, 0x44, 0x107, 0xa9, 0x16f, 
            0xaf, 0x119, 0x88, 0xa9, 0x86, 0x158, 0x14c, 0x162, 0x159, 20, 0x5e, 0x135, 0x24, 0x12d, 0xf3, 0xba, 
            0xd8, 0x86, 0xe7, 0x7d, 0x159, 0x12b, 0x14f, 0x16f, 0x53, 0x94, 0xf9, 0x7b, 0x13c, 0xef, 0x16b, 0x128, 
            0x162, 0x181, 0x143, 0x177, 0x188, 380, 0x170, 0xaf, 0x128, 0x159, 9, 0x145, 0x143, 0xf6, 0x119, 0xc1, 
            0xbb, 0x54, 0x3b, 0x148, 0xfb, 0x164, 0x183, 310, 0x13c, 12, 0x148, 0x189, 0x14b, 0xf1, 0x24, 0x110, 
            0xb2, 0xf7, 0x59, 0x3e, 0x7a, 0xf1, 0x11e, 0x143, 0xab, 0x158, 0x176, 0xa7, 0x62, 0x15c, 340, 0x159, 
            0x176, 0x17, 0x13, 0x135, 0x184, 0x90, 0x11d, 0x81, 0xc2, 0x5e, 0xbc, 0x110, 0xe7, 0xdd, 0x7d
         }, { 
            0x176, 0x161, 0xf3, 0x159, 0xc9, 0x155, 0xe8, 0x145, 0x10d, 0xd4, 0x11c, 0x183, 0x175, 0x157, 0x160, 15, 
            0x15a, 0x77, 0x159, 390, 340, 0xf2, 0x5c, 0x135, 0x9c, 0x9c, 0x23, 0x85, 0x13c, 0x7a, 0x5d, 0x44, 
            0x14e, 0x14f, 0xf3, 0x16f, 11, 220, 0x145, 0, 0x149, 0x183, 0x5d, 0x60, 0xf6, 0x105, 0xfc, 0x184, 
            300, 300, 0x105, 0xe7, 0x8f, 220, 0x3b, 0x177, 0xdd, 0x14f, 0xf9, 0x14c, 130, 0xc0, 0x15c, 0, 
            0x48, 0x116, 0x12e, 0x16f, 0xee, 0xa4, 0x132, 0x94, 0x177, 0x141, 0x14b, 0x146, 0xf4, 310, 0x175, 0x4b, 
            0xdd, 0xfb, 0x16f, 0x149, 0x174, 0x8d, 0x105, 0x115, 300, 0x12d, 0xa8, 0x26, 0x2b, 0x68, 0xe7, 0x177, 
            0xf1, 0x128, 0xa6, 0x24, 0x25, 100, 0xaf, 0xae, 0x183, 330, 0x74, 0x17b, 0xf4, 0x131, 0x75, 0x177, 
            0xf4, 0x66, 350, 0x7f, 0x177, 0xd4, 0xb6, 0x1f, 0xdf, 40, 0x129, 0x17d, 0x80, 0x116, 0xf3, 0xea, 
            0x7e, 220, 0x60, 0xf3, 0x5c, 0xeb, 160, 0x49, 0x14c, 0x10b, 0x66, 0x16d, 0x15c, 0x157, 0x24, 0x14e, 
            0x72, 0x65, 0x12e, 0xd1, 170, 0x176, 0x145, 0x8e, 0x5c, 0x1a, 0x150, 0x130, 0x4e, 0x22, 0x88, 0x14e, 
            12, 0xc4, 0x181, 0x145, 240, 0xf6, 0x49, 0x75, 0x80, 0x12e, 220, 0x17b, 0xa6, 0x160, 0xca, 0xaf, 
            0x181, 0x170, 240, 0x2e, 330, 0x3a, 0x111, 0xf7, 0x81, 150, 0x116, 0x14f, 0x16f, 5, 0x86
         }, { 
            0x15b, 0x4b, 0xbc, 0xbd, 0x5c, 0x12f, 0x3b, 0x9e, 0x86, 0x15b, 0x107, 0x15b, 0x15b, 0xd0, 0x148, 0x81, 
            0x12, 0xd6, 0x5b, 0x177, 0x177, 0x131, 0xc4, 0x7d, 0x14f, 0xa9, 0x130, 7, 0x128, 0xaf, 0x164, 0x100, 
            0x177, 0x15a, 0xa2, 0x10c, 0x11e, 0x33, 0xd1, 0x14c, 0xe5, 0xa4, 0x9d, 0x77, 350, 0xb3, 0xad, 0xf3, 
            0xf3, 0xf3, 0x9e, 0x14c, 350, 0xba, 0x116, 350, 0x33, 0x14f, 0x174, 0xb3, 0xba, 0xc4, 0x25, 0, 
            390, 0xb0, 0x130, 0x115, 0x3f, 0x141, 0x131, 0x80, 0x9e, 0xb3, 0x66, 0x66, 0xf1, 0x157, 0x8e, 0x15c, 
            0x6b, 8, 0xee, 0x3f, 0x93, 0xc1, 0x149, 110, 0x1b, 0x11d, 0x68, 340, 0x80, 0x23, 0x175, 0x4a, 
            0x162, 7, 340, 0x4a, 0xd4, 0x3f, 0xfc, 0x15c, 0x8f, 0x159, 0xf1, 0x13b, 0x14e, 0x4a, 0x15a, 0x14b, 
            0xc1, 0x17a, 2, 0x3e, 0x175, 0x11e, 0xa8, 250, 0x152, 0x15c, 0x80, 0x116, 0x80, 0x181, 0x15c, 0xa6, 
            14, 0x12f, 0x14e, 0x14e, 0x156, 0xf1, 0xf1, 0x88, 0x170, 0, 8, 0x162, 0x9e, 0x145, 0x11b, 0x7c, 
            0x7c, 0x162, 0x80, 0x13b, 0x45, 0x177, 0xf4, 250, 0x171, 0x181, 0x181, 0x181, 0xf6, 170, 0x181, 40, 
            0x47, 0x17a, 0x81, 0x6c, 0xe5, 0x161, 0, 0xf1, 0xe8, 0xac, 0x54, 80, 0x83, 0x173, 0x15c, 280, 
            0x7d, 0, 0x177, 0x4f, 0xea, 0x4f, 0x171, 150, 0x12b, 0x162, 0x5c, 0x5c, 0x7b, 0x14f, 0x137
         }, { 
            350, 0x3e, 340, 0x1f, 0x15a, 0x11c, 0xc1, 0xc1, 0x180, 0x2d, 0x149, 11, 8, 0x81, 0x11b, 0x74, 
            80, 0x84, 0x155, 0x52, 0xf6, 0x74, 0x159, 0x16b, 80, 0x11a, 0x86, 0x15a, 80, 0x155, 0xee, 0x175, 
            0xab, 0x6d, 0xc4, 15, 340, 0x7a, 0x183, 0x14b, 0x51, 0x15c, 0x146, 0x44, 2, 0x13, 4, 0xad, 
            0x98, 0x137, 0x11c, 120, 0x155, 0x99, 340, 0x80, 130, 0x177, 0x13a, 0x72, 0x57, 0x14d, 0x6b, 0, 
            0x89, 0x14c, 0x9a, 0x179, 330, 0x11b, 0x174, 0x174, 0x6b, 0x6d, 0x143, 310, 0x181, 0x187, 0x179, 0x116, 
            0xd0, 330, 0xf1, 0x176, 0x15c, 0x159, 0x143, 170, 0x20, 0x144, 0x14e, 0x51, 0x155, 0x15c, 0x165, 0x79, 
            340, 0xc1, 0x15b, 350, 0x11e, 0x145, 0xf7, 0xb8, 0xc9, 0x9e, 0x15a, 0x2d, 220, 0x12d, 240, 0x80, 
            0x8b, 0x6d, 0x147, 0x20, 0xf1, 0x6d, 0x159, 0xa4, 0x5c, 0xbb, 360, 0x14f, 0x6d, 0xc4, 0x30, 0xd0, 
            370, 0x79, 0x6b, 0x155, 0x2a, 0xa8, 0x130, 0x83, 0xeb, 170, 330, 0x15c, 0x81, 120, 0x38, 0x15b, 
            0x15b, 0xa4, 0x130, 0x13a, 0x14e, 0x51, 0x11a, 0x173, 0x6d, 0x15c, 0x14d, 0x151, 0x116, 0x80, 10, 0x83, 
            0x159, 2, 0x15b, 0x107, 0xbc, 0xa4, 0x23, 0x98, 0x41, 0, 220, 0x7b, 0x194, 0x105, 0xad, 0xb3, 
            0xb0, 0x115, 0x131, 0x159, 0x17a, 0, 0x15c, 0x74, 0x11e, 0x1a, 0x11b, 0x16e, 0xf3, 340, 0x9b
         }, { 
            0x15d, 0xf5, 0x52, 0xe8, 0x52, 0xab, 0x94, 0, 0x195, 0x137, 0x9f, 0x187, 0xc2, 0x144, 0x13f, 0xf1, 
            350, 0x183, 0x144, 0x13a, 0x9f, 160, 0xad, 0, 0x11e, 0, 0x102, 6, 0x4a, 0x137, 0xa4, 0xf9, 
            0x85, 14, 0x175, 0x2f, 0x107, 0xf3, 0x162, 0x149, 0x157, 0x4f, 0x182, 0x102, 0x174, 0x4a, 0xb7, 0x25, 
            0x15c, 0x5b, 0x5f, 0x177, 0x7e, 0x116, 0x143, 0x85, 0xb7, 0x177, 0x163, 0x51, 0x44, 0x14c, 0x2d, 0, 
            0x11e, 0x75, 0x150, 0xd7, 0x27, 0x127, 0x164, 130, 0x5c, 0xb8, 0xe8, 4, 0x52, 0x15c, 0x54, 0xc9, 
            0x74, 0x15b, 0x17a, 0x150, 220, 0x4b, 0x173, 0x165, 0x187, 0x11b, 0x4a, 0xaf, 0x127, 0xc9, 0x175, 0x12f, 
            330, 0x63, 0x54, 0xc4, 0x15c, 0x15b, 0x15b, 0x11c, 0xd4, 14, 0x15c, 0xd0, 0x9c, 110, 0xe2, 0x4f, 
            0x178, 0x38, 0x2f, 350, 0x54, 0x11e, 280, 0x127, 0x11a, 0xfe, 0x160, 0x177, 0x185, 0x39, 0x61, 240, 
            5, 0x54, 0x54, 0x189, 0x11, 0x16f, 0x126, 0x17a, 0xe5, 0x11c, 0x63, 0x1d, 220, 0x85, 0xac, 0xba, 
            0xa4, 0x105, 0x16a, 0, 0x160, 0x157, 0xf1, 0x175, 0x15c, 0x14d, 0x175, 0xa4, 0x111, 140, 0x13, 0x102, 
            7, 0x102, 0x13, 0x182, 0x27, 0x15c, 0x2f, 0x188, 0x187, 0x4d, 0x4d, 0x162, 0x4e, 0x5f, 0x171, 0xa4, 
            0x15d, 0x177, 0x11c, 0x54, 0x107, 0x15c, 0x94, 0xf8, 0x10f, 0x156, 0x4a, 0x2c, 0x162, 360, 0
         }, { 
            350, 0x81, 0xac, 0x171, 0x157, 0x10c, 0x175, 11, 350, 0x9b, 0x83, 0xee, 12, 0x109, 330, 0x9f, 
            0xac, 0x53, 0xf1, 0x146, 0x89, 0x6b, 0x15d, 0xf9, 0x161, 0xad, 0xe7, 0x17e, 0x3e, 0x156, 0x13c, 0x16a, 
            0x161, 14, 0x3e, 0x6b, 0x177, 0x102, 11, 0x14c, 0x77, 0x143, 0xdd, 0x7c, 0x137, 0x5c, 0x14e, 0x194, 
            0x97, 0x18f, 0x52, 0x127, 0x126, 0x45, 0xf6, 350, 0x86, 0x9a, 0x181, 0x1f, 0x145, 0x83, 0xa4, 0, 
            0x13, 0x14b, 0, 0x132, 0x177, 0x9d, 0xa6, 0x181, 0xa4, 0xf1, 0x13, 0xb2, 0x127, 0xf3, 0xf1, 0x17, 
            0x1f, 0x174, 0x51, 0xe5, 0xef, 0x7a, 0x24, 0x16a, 0xa9, 0x162, 0x162, 0x61, 0x67, 0x44, 0x59, 0x144, 
            0x36, 0x4f, 0x24, 0x171, 0xf1, 0x163, 0x159, 0x162, 0xfb, 0x15c, 0x11a, 330, 0x181, 0x129, 0x9d, 0x184, 
            0x184, 0x52, 0x23, 0xf7, 0xd4, 0x143, 0xaf, 0x6d, 0xf5, 0x179, 0x86, 0x86, 0x24, 0x189, 0xf4, 0x158, 
            0xe8, 0x181, 0x182, 0x12, 0xe7, 0x42, 40, 0x20, 0xbb, 0x75, 0x7d, 0x66, 330, 0x3b, 0x66, 0x3f, 
            0x177, 0xfb, 0, 0x54, 0x5e, 0xe7, 0x116, 0x15c, 0x11a, 0x4a, 0x54, 0x145, 0x145, 0x7c, 0x183, 0x7d, 
            0x15c, 330, 0x159, 0x159, 0x171, 0x162, 110, 0x148, 0xe9, 14, 220, 0x95, 340, 0x10b, 0x15a, 0x9c, 
            0x159, 12, 0x79, 0x99, 0x81, 0x99, 0x126, 0x53, 320, 0x177, 0xc6, 0xb8, 0x94, 0x74, 0x139
         }, { 
            0x162, 0x161, 0x127, 0x163, 0x15a, 0x175, 0xe9, 0x15b, 0xf2, 0x15b, 0x124, 0x162, 0x145, 0xba, 0x135, 0x5c, 
            0x81, 0x106, 120, 0xa1, 0xfb, 0x14d, 0x11c, 0x130, 0x165, 0x11a, 40, 0xe8, 0x7c, 0x15c, 0x175, 0x54, 
            0xdd, 0xbd, 0x61, 130, 0x12e, 220, 0x14f, 0x163, 0x182, 0xc2, 0x129, 0x7c, 220, 0x81, 120, 0x6b, 
            0xf3, 180, 0x163, 0x105, 0x11c, 0x177, 0x146, 0x139, 0x105, 0x131, 0x170, 0x126, 0x11b, 0x8f, 330, 0, 
            0x61, 0xf1, 0x8e, 300, 0xe2, 0x132, 0x5b, 0x2d, 0x175, 400, 0x5c, 0x81, 0xf4, 0x14c, 0xba, 340, 
            0x59, 0x181, 320, 0x7f, 0x15a, 0x3f, 0x7c, 0x177, 0x3b, 0xad, 0x10f, 330, 0x5c, 0xa6, 0x79, 0x160, 
            0xf3, 0x68, 0x57, 0x57, 0x13d, 0x75, 0x11a, 0x187, 0xe7, 0x161, 0x7e, 0x74, 0x77, 0x66, 0x15c, 0x15c, 
            90, 0x8d, 0x66, 0x66, 0x143, 0x177, 0x17e, 0x165, 0x9f, 0x23, 0x183, 0xa4, 0x153, 0xf7, 290, 0x13a, 
            100, 0x16b, 0x129, 0xa2, 0xaf, 0xa7, 0xbd, 0x194, 0x80, 0x129, 0x8f, 0x10, 0xaf, 0xa8, 0x174, 0x16f, 
            0x11e, 0xb6, 0xd3, 0x15a, 0x137, 0xe7, 0x17a, 0x114, 0xfb, 0x7d, 0x30, 0x5c, 0x159, 0x156, 0x177, 0x157, 
            0x177, 0x187, 0x30, 240, 0x11e, 0x75, 0x99, 0x175, 0x116, 330, 0x2d, 0x3f, 0x51, 0xc4, 0x149, 0x100, 
            170, 0xac, 0x7f, 0x14c, 0x10a, 0x4f, 0x171, 160, 0x165, 0x124, 0x13e, 0x24, 0x131, 0xbc, 0x14e
         }, { 
            0x88, 0x150, 0x79, 0x5c, 0xdd, 320, 0xd6, 0x109, 0x13a, 0x16e, 0x52, 0xf8, 0x159, 0x71, 0xf6, 0x61, 
            0xac, 160, 90, 330, 0x11b, 0x182, 270, 0x5c, 0x45, 0x83, 0x7d, 40, 0x37, 0x11e, 0x7e, 170, 
            0xcb, 0x15d, 0x79, 0x116, 0x187, 0x155, 0x24, 0x58, 0x86, 0x187, 0x15c, 240, 0x53, 0x79, 0x3a, 0x5c, 
            0x12b, 0xed, 0x24, 40, 0x17b, 0x79, 0x5c, 0x81, 0x7c, 0x170, 0x7d, 0xf4, 0x3b, 0x15c, 0x10, 0, 
            0x127, 0x119, 0xa4, 0x15d, 0x132, 0x12f, 190, 0xf1, 0x13d, 0x13, 0x7b, 0x5c, 0xf3, 0xd0, 0xd6, 0x15c, 
            90, 140, 0x15d, 0x108, 0xf7, 0x159, 0xf1, 0xbd, 0x173, 0x66, 0x2d, 0x5c, 0x99, 0xee, 0x3d, 40, 
            0x5b, 190, 0x161, 0x177, 120, 0xf3, 0xa2, 0xa9, 0x10c, 0xaf, 0xa4, 0x33, 0x194, 0xc0, 0x79, 0xdf, 
            0x194, 0x177, 90, 70, 0x163, 0x164, 0x51, 0x181, 0x128, 0xa6, 0x7e, 40, 0xf7, 0x17a, 0x194, 0x159, 
            0xa4, 0x17a, 0xf6, 0x81, 0x4b, 0x129, 0x76, 0xd4, 0x162, 0xad, 0x9d, 0x80, 0x14c, 0, 0x86, 0x153, 
            0xab, 350, 0x116, 0x15d, 0x161, 350, 0x14d, 0xd8, 20, 0x171, 0xa6, 0x86, 290, 0x119, 0x187, 0x30, 
            0xfb, 250, 0x19, 0, 0x162, 0xb3, 0xa4, 390, 0xb0, 0x131, 0x88, 0x159, 0x9e, 0x9e, 0x17a, 0xb3, 
            0xa4, 6, 0xca, 0x162, 0xab, 0x65, 0x15c, 0x14c, 340, 0x21, 330, 0xf1, 0x8f, 0x15d, 0x88
         }, { 
            330, 340, 0x14b, 0x99, 0x9f, 0x150, 0x128, 0x14f, 340, 0x29, 0x15d, 0xf3, 0x150, 0xf3, 0x2a, 0x62, 
            0x15d, 0x162, 0x14e, 0x15b, 0x15a, 0x130, 0xfd, 0xdf, 0x74, 0x14e, 0x77, 340, 230, 0x15c, 0x14e, 340, 
            0, 0xa6, 40, 0x15c, 0x4b, 0x162, 0x2e, 0x77, 0x15, 0x15, 0x86, 0xf3, 0x177, 0x111, 0x25, 0x111, 
            0x178, 0x12d, 0x12b, 0xa4, 0x16b, 0x162, 0xa4, 0x99, 0x4b, 0x174, 0x146, 0xc4, 220, 0x11b, 340, 0, 
            0x88, 0xf2, 0xf9, 0x129, 0xf7, 0x15c, 0x15b, 0x15b, 0x18, 0xbb, 0x41, 0x175, 0x165, 0x146, 0x27, 0x135, 
            130, 0x117, 0x15d, 0x40, 0x85, 0x99, 0x33, 0x39, 70, 0x7e, 0xa6, 0x12, 70, 0x7d, 0x7d, 0x17a, 
            0x11b, 0x15c, 0x14f, 0xfc, 0x7f, 220, 0x157, 0x79, 0xfc, 0xf1, 250, 0x79, 0x47, 0x15c, 0x14e, 100, 
            0xba, 2, 0x81, 0xe8, 0x1f, 0, 0, 0xe8, 0xa9, 0x7c, 0x10d, 0xc6, 320, 0x157, 0x4d, 0x105, 
            0x14c, 0x86, 0xf9, 0xdd, 0, 0xe5, 0x86, 0x4a, 14, 270, 0xb8, 0x12b, 0x11e, 320, 0x8f, 0x12e, 
            270, 0x11e, 0xc6, 0xb8, 0x13a, 0x105, 0x171, 0x110, 0x171, 0xbc, 0xaf, 0x41, 0x88, 0xf1, 0x15a, 0xcd, 
            0x12, 0x11a, 330, 330, 0xf7, 0x158, 0x44, 0x15a, 0x165, 0x176, 0x13, 0x3a, 0x123, 0xa1, 0xd0, 0x4f, 
            0xf9, 0xe0, 0x16b, 190, 0x40, 0x181, 0x2a, 0x143, 0x4f, 0x38, 320, 0xb7, 0x161, 0xec, 0xf3
         }, { 
            0x162, 0x162, 0x13c, 0x85, 0x177, 0x177, 0xf3, 0x83, 0x83, 0x13f, 0x89, 0x72, 0xfb, 15, 0x6b, 0x178, 
            0xe3, 0x156, 120, 0x161, 340, 340, 0x165, 0x159, 0x39, 0x161, 0x74, 0x7b, 0x195, 0xc4, 0x149, 0x26, 
            0xe3, 14, 0x177, 0xe2, 0x182, 0x166, 0xac, 0x16b, 0x53, 0xba, 0x166, 320, 0x175, 0x175, 0x15c, 0x4e, 
            310, 0x126, 0x98, 350, 0x86, 0x15c, 0x7c, 0x178, 0x79, 12, 0x16b, 0x17a, 0x161, 0x61, 0x74, 0, 
            0xed, 0x182, 0x177, 0x129, 0x24, 0x126, 0x86, 0x156, 0x11b, 0x156, 0x54, 0x5c, 100, 0x39, 0x15d, 0x179, 
            0x15b, 0x79, 0x167, 0x24, 0x145, 0x73, 0x7d, 0x126, 0x4d, 0x151, 0x54, 0x182, 0x177, 0x15d, 0x149, 0x8e, 
            0, 0x159, 0x135, 0xc5, 0xa2, 0x15c, 0xbd, 0xfb, 0xee, 0x14e, 0x15c, 0x129, 0x98, 0xf5, 0x86, 0xed, 
            0x152, 0x177, 120, 0xc2, 0x149, 250, 0x15c, 0x83, 0x11c, 0, 0x1f, 130, 0xa9, 0xf9, 0x145, 0x6b, 
            0xb7, 0x161, 20, 0x45, 0x72, 0x15c, 0x176, 0x9e, 0x6b, 0xa4, 0x5e, 0xa6, 0x2d, 0x72, 0x15c, 0x13a, 
            160, 0x14b, 0x26, 0x84, 0x12b, 0x24, 0xe5, 0x14c, 0x11a, 0x9a, 0xed, 0x6b, 0xf7, 0x102, 0x13c, 0x14e, 
            0x139, 0x4b, 0x165, 0xa4, 0x123, 0x126, 0xa2, 0x123, 70, 0x165, 0x71, 0x151, 0x132, 0x2e, 370, 0xca, 
            0x163, 320, 0x44, 0x148, 0x86, 0x119, 0xa7, 0x7a, 0x12e, 0xf5, 60, 0x87, 0x74, 0x68, 0x159
         }, { 
            0x179, 0xe7, 0x6d, 0x20, 0xf3, 80, 0x25, 0xaf, 0x86, 0xa4, 0x174, 0xed, 310, 0x162, 0xd0, 0xaf, 
            0xbd, 0x83, 0xab, 0xb2, 250, 0x162, 0x11a, 0x74, 0x74, 0x163, 0x9d, 0xf7, 0xf3, 0x177, 0x15d, 0xee, 
            12, 0x163, 0x146, 0x10b, 0x51, 0x163, 0x8f, 0xf1, 0x119, 0x111, 0xf1, 0xe8, 330, 0x163, 0x106, 0x77, 
            0x7d, 0xda, 0x149, 0x139, 0x53, 0x148, 0x135, 0x145, 0x108, 0x1b, 110, 0x159, 0x72, 0xbd, 0xb8, 0, 
            350, 0x159, 0xf7, 0x11b, 0xba, 0x167, 0x7a, 200, 0x66, 0x25, 0x4b, 0xa6, 0xf1, 0xf1, 0xba, 310, 
            0x31, 0x145, 0x18, 0xc1, 0xee, 340, 0x5c, 0x7d, 0x53, 0x15c, 0x15d, 0x11c, 0x14f, 0x176, 0x130, 0x162, 
            14, 0xc1, 0x11c, 0x13c, 0x11b, 0x160, 0x86, 0x13a, 0x13d, 0xf9, 0xf9, 0x15a, 0xad, 0x7b, 0x163, 0xc9, 
            0xe2, 0x161, 0xfb, 0x17e, 0xa7, 0x1f, 0x159, 0x180, 110, 0x182, 0xbb, 350, 0x9c, 0x53, 0xae, 0x145, 
            0x14b, 350, 0xee, 130, 0x159, 0x12d, 0x163, 0x14c, 220, 0xbc, 0x181, 0x24, 0x12f, 0x12e, 0x141, 0x93, 
            0x110, 0x16f, 0x11c, 0xb2, 180, 0x145, 0x167, 0x149, 0x146, 0xf4, 0x16b, 0x11c, 2, 0x165, 0x15d, 0x129, 
            0x12d, 0x11c, 2, 0xe2, 340, 0x147, 0x19, 0xc0, 0x5b, 0x156, 120, 0x14f, 0x3e, 0x177, 350, 0x81, 
            0x5b, 0x12b, 0x80, 0x79, 0x15d, 0x16b, 290, 0x2d, 0x14e, 0x162, 0x153, 0x74, 14, 0x10, 0x177
         }, { 
            0x7e, 0x93, 0x11a, 0x117, 0xbd, 5, 0xaf, 340, 0x161, 0x1f, 0x4f, 0x160, 0x67, 0xbb, 0xf7, 0x162, 
            0x5c, 0x158, 0x21, 330, 0x5c, 0xaf, 0xad, 130, 0x68, 0x127, 0x177, 0x57, 0xf4, 0x80, 0x30, 0x2d, 
            0x17d, 0xdf, 0x134, 0x15b, 330, 0xbd, 0x131, 0x131, 0x130, 0xa6, 0x141, 0x12f, 0x58, 0xe7, 0x182, 0x8d, 
            0xe7, 370, 0x17e, 340, 0x9b, 0xf3, 0x159, 290, 0x14e, 0x34, 0x135, 0x7e, 0x183, 350, 0x72, 0, 
            0x150, 0x11e, 0x77, 0x183, 0x9a, 340, 0x177, 0xeb, 0x11e, 0x7f, 0xee, 0x15a, 0x79, 0x81, 0x149, 0xe0, 
            0x5c, 0x145, 0x14e, 0xf3, 0x158, 330, 300, 0x49, 0xc1, 0x10a, 0x129, 0x175, 0x183, 0x15c, 0x177, 0x143, 
            0x130, 0x15d, 0x14f, 0x15b, 0x16f, 270, 0x6f, 14, 0x1f, 0x11e, 240, 170, 0x145, 0x111, 0x111, 0x24, 
            0x84, 0x75, 0xcb, 160, 0x35, 0x72, 0x6b, 0x165, 0xac, 0x72, 0x54, 0x6d, 110, 0x14c, 0x7d, 0x116, 
            330, 0x162, 0xaf, 0xd6, 0x162, 170, 0x11b, 0x3a, 0x77, 0x16b, 0x14f, 0x162, 0x11c, 0x156, 0xab, 0x143, 
            0x182, 0x160, 150, 0x18, 0xa6, 0x3f, 0x15b, 0x155, 0x175, 0xb6, 0x39, 0x15c, 0x12b, 0xe8, 0x86, 0x12e, 
            0xf6, 0x181, 0xd8, 0x148, 0xf6, 230, 0x111, 0x114, 0x145, 40, 0x12e, 0x127, 0x139, 0x111, 0x17a, 0xa6, 
            0xd0, 330, 0x11e, 0xbd, 0xd6, 350, 350, 0xbc, 130, 0xf1, 0xf1, 0x187, 0x148, 0x132, 0x15d
         }, { 
            0x15d, 0x48, 0x2f, 0x7b, 0xf7, 0x9e, 0x157, 0x8f, 0x145, 0x12, 0x61, 0xf3, 350, 0x12, 0x9b, 0x51, 
            0x19, 0xb9, 360, 0x145, 0xee, 360, 0xaf, 0xa4, 0x161, 0x15a, 0xaf, 0x126, 0x177, 350, 70, 0x144, 
            0x79, 0x14f, 0xe2, 0x11a, 0x10, 0x1f, 0xc4, 0xac, 0x7d, 0x111, 0x24, 0x61, 0x12, 0x7b, 0x14c, 0xaf, 
            0xf6, 0x105, 0xa4, 0x83, 0x14e, 350, 0x12b, 0x145, 0x142, 0x156, 0x17a, 290, 0x9d, 0x48, 0x4f, 0, 
            0x74, 0x9d, 0x11e, 0xab, 350, 0xd0, 0x5c, 0xa6, 0x188, 350, 170, 0x15c, 0x7d, 0x1f, 0x38, 0xff, 
            0x7d, 0x9e, 0x4f, 290, 0x163, 0x181, 0x53, 0x119, 0xa2, 0x9e, 0x30, 250, 0x160, 0xf3, 0x4e, 0x88, 
            0x159, 350, 0x14c, 360, 0xb0, 0x159, 0xa4, 0xbd, 0x116, 0x130, 0x3a, 0x80, 0x1f, 350, 0x6d, 0x17a, 
            0x9e, 0x9e, 0xca, 0x143, 0xb0, 0x157, 0x14c, 0x159, 0x58, 0x159, 0x162, 0x65, 0x14e, 0x14e, 0x79, 0x72, 
            0x17d, 0x16f, 0x14f, 0x25, 0x167, 0xf1, 0x178, 0x52, 0xd7, 0x146, 240, 0x15c, 0xe8, 0x8b, 0xe2, 0x159, 
            0xe3, 0xc6, 0xa8, 0x65, 0x150, 0x65, 0x65, 15, 0x37, 0x14b, 0x176, 0x17a, 0x8f, 0x173, 0x54, 6, 
            0x14f, 0x14f, 0xab, 0x181, 0xe4, 0x12f, 0x15a, 0x13a, 0x116, 0x145, 120, 0x179, 220, 340, 0x71, 0xfb, 
            0x77, 0x153, 0x153, 0x14c, 0x15d, 0x158, 0x179, 220, 0x11c, 0x145, 0x13a, 0x156, 0x167, 0x8b, 0x14b
         }, { 
            0x155, 0x176, 0xee, 0x79, 0x65, 0x22, 0x79, 0x23, 0, 0xa9, 0x54, 0x84, 0x14f, 240, 0x139, 0x181, 
            0x139, 0x6a, 0x9f, 0x159, 340, 0x25, 0x105, 0x74, 330, 0x11e, 0x7b, 0x157, 0x94, 0x164, 0x14e, 330, 
            0x17e, 250, 0x3e, 0x14f, 0xf1, 0, 0x194, 0x159, 0x86, 170, 0x9a, 0x7a, 0x13f, 330, 0x34, 0x149, 
            0x72, 0x86, 0x54, 0x148, 0x30, 0x53, 0xed, 0xf8, 0x10b, 0x15c, 0xf8, 0x150, 0x15c, 0x7f, 0x162, 0, 
            0x59, 0xe8, 350, 0x144, 0x11b, 0x62, 280, 0, 0, 0x5e, 0x145, 0x23, 110, 0x99, 0x178, 0x14b, 
            0x165, 0x53, 0xa6, 0x151, 0x80, 14, 350, 0x17a, 0x145, 0x13d, 0x116, 330, 0x155, 0xda, 0x1f, 0x159, 
            0x84, 0x84, 0xba, 0x145, 0x16f, 130, 0xf8, 0x106, 0x77, 0x4f, 0xf9, 0x12b, 0x15a, 0xa9, 0x81, 0x16a, 
            0x62, 0x165, 0xc9, 0x11c, 0xa7, 0x60, 0x131, 0x21, 0x165, 20, 0x15b, 0x14f, 330, 0x149, 0x165, 110, 
            0x14e, 0x15c, 0x165, 200, 0x116, 0xf8, 220, 0xbd, 0xf3, 350, 0x149, 0x5f, 0x159, 0xf4, 14, 0x10, 
            0x183, 0xaf, 0x7d, 0xae, 0xe7, 0x12b, 0x15c, 0x13a, 0x88, 0x183, 0x74, 0x15c, 0x177, 0x145, 0xac, 0xfe, 
            0xdf, 0x101, 0x84, 0x9a, 0x33, 0x16e, 0x7d, 330, 330, 0x15c, 0x14e, 0x25, 120, 0x39, 0x15b, 0x157, 
            0x159, 0x157, 0x14e, 0x89, 0x3d, 0x13f, 0x11a, 0x7f, 0x52, 330, 0x162, 170, 0x13a, 280, 0x52
         }, { 
            0x157, 0x9e, 0xba, 0x131, 0x15c, 0x84, 0xbb, 0x83, 0, 350, 0x15c, 0x156, 0x9e, 0x12f, 0x18, 330, 
            0xfc, 0x183, 0xf3, 0x79, 0x17a, 0xab, 0x162, 0x15c, 0x14f, 0x173, 0x79, 0x37, 0, 0x13, 0x108, 0x14e, 
            0x157, 130, 0x27, 0x132, 220, 110, 0x9e, 0x10, 0x105, 0xa9, 0xc4, 0x10b, 0x194, 0xa9, 5, 0x157, 
            0x98, 0x164, 0xa8, 0xa4, 0xaf, 0x88, 0xa8, 0x159, 330, 0x14f, 0xad, 0x15b, 0x18, 0xff, 0x164, 0, 
            0x9e, 0x30, 0x13a, 100, 0x86, 0x22, 0xbd, 0x131, 0x9e, 0x17a, 0x9e, 0xab, 0x162, 0x173, 0x176, 0xe4, 
            0x24, 0x145, 0x6b, 0x88, 0x15b, 0x185, 0xbd, 0x2b, 0x8f, 0x169, 0x41, 0xf4, 0x160, 0xf4, 0xe2, 0x21, 
            0x7d, 0x2b, 0x162, 0x16f, 190, 0xe2, 20, 0x2b, 0x161, 70, 0x24, 0xd7, 0xa1, 320, 0x102, 0xb7, 
            80, 0x59, 0x159, 0x169, 11, 0x126, 0x161, 0x5b, 0xc6, 0x170, 0xfb, 0xfb, 0x182, 0xb7, 0x91, 0xf3, 
            0xa4, 0xef, 0x59, 0x177, 12, 0xfb, 0x2d, 0x7c, 0x53, 0x8f, 0x86, 40, 330, 11, 0xb3, 0x81, 
            180, 270, 0x145, 0xb8, 0x49, 0x13a, 0x7f, 330, 0xa4, 70, 0xa9, 0xe1, 0xea, 20, 330, 0x27, 
            0x145, 0x100, 0x27, 6, 0x5c, 30, 0x181, 110, 0x8d, 0xe5, 0x73, 0x158, 0x15d, 0x77, 0x17e, 0x98, 
            0x178, 0xc6, 0xe8, 0x86, 0x15c, 0x151, 0x15c, 0xab, 0xe8, 0xd0, 220, 0x161, 0x156, 0x39, 20
         }, 
        { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0x94, 0x14c, 0x155, 0xc4, 0x173, 0x81, 0x157, 0x116, 0x12e, 0x13a, 160, 0x181, 330, 0x14b, 11, 0x177, 
            0x159, 0x114, 0x6b, 0x83, 0xe1, 0x51, 0x14e, 0xe8, 0xf1, 0x10, 0x15d, 0x9d, 0x7d, 0xf4, 0x9a, 0x159, 
            0x183, 0x177, 0x176, 0x158, 0xa9, 0, 0x183, 0, 0x53, 0x148, 0x163, 0x116, 0x13d, 0x158, 0x14f, 0x7c, 
            0xe9, 0x161, 220, 300, 0xee, 0xc2, 0x128, 180, 0x163, 0x38, 0x162, 0x11c, 0x6d, 0xf4, 0x15c, 0, 
            0x175, 0x19, 0x6d, 0xb6, 0x7e, 0xc6, 0x1f, 5, 90, 0x34, 0x52, 14, 14, 120, 240, 170, 
            0x162, 0x17e, 220, 330, 0x14e, 0x11d, 0, 0x80, 0x5b, 0x155, 70, 0x79, 150, 0x14c, 0x14c, 0xd6, 
            15, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0x7b, 0x107, 0xbc, 0xa9, 0x161, 0x83, 0x11d, 0xaf, 0x12e, 0x14c, 0xbd, 0xff, 0xcb, 0xb3, 0x14c, 0xf1, 
            0x88, 220, 0x182, 0xaf, 0x129, 0xf9, 0x56, 0xa1, 6, 0x72, 0x3e, 0x2a, 0x58, 0x162, 0xf1, 0x162, 
            0x20, 0x72, 0x149, 0x54, 0x81, 0x158, 0xbb, 9, 0x164, 0x88, 0x165, 0x88, 0x15d, 0x39, 0xec, 0xf4, 
            0x15c, 0x58, 0xed, 0x54, 0x155, 0x31, 0x60, 0x7c, 280, 0x2f, 0xfe, 0x11b, 0x11a, 0x15c, 0x185, 0, 
            0xac, 14, 0x175, 130, 0x80, 0x7d, 0xa4, 0x65, 0x14c, 0x179, 0x159, 0x153, 0x15a, 340, 0x129, 0xf6, 
            0x15d, 0x157, 10, 0x14d, 0x14b, 0x66, 0x26, 340, 0xe5, 160, 0x3a, 350, 0x146, 0x4b, 0x139, 0x135, 
            0x149, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0x149, 0x24, 0x89, 0xba, 11, 0x139, 0x14c, 40, 0x6b, 0x155, 0x159, 0x155, 0x153, 0x54, 330, 0xab, 
            0xa4, 130, 0x12d, 0x53, 0x143, 0x3f, 0xec, 0x171, 0x111, 0xc1, 0x162, 0x9d, 0xc1, 0x144, 0x162, 310, 
            40, 0xe5, 0x24, 0x4b, 0x20, 13, 0xaf, 0xfb, 0x40, 0xe5, 0xf4, 0x181, 0xf6, 0x4e, 130, 70, 
            0x81, 0x7a, 0x162, 0xba, 0x2d, 0x155, 0x135, 0x151, 0x38, 0x106, 0xc1, 0x7d, 0x145, 0x108, 0x77, 0, 
            0x14f, 0x2a, 0x7d, 0x17d, 0x15a, 0xa6, 0xfb, 0x47, 0x158, 120, 0xac, 0x11c, 0x105, 0x12d, 220, 0x146, 
            0x149, 0x175, 130, 350, 180, 0x132, 0xac, 0xa4, 0x9f, 310, 0xf4, 0x36, 0x88, 0x173, 0x12, 0x13c, 
            0x20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0x9a, 0x17d, 0x30, 0x15c, 0xf1, 0x83, 0x16a, 0xf9, 5, 0xa6, 0xbb, 0x15d, 0x75, 0x145, 0x149, 0x3d, 
            0x153, 0x16e, 0x157, 250, 0x3a, 170, 0xa8, 0xf8, 0x129, 0x66, 0x83, 0x4f, 130, 0xac, 0x5c, 0x79, 
            0x83, 2, 0x16a, 0x3a, 0x80, 0x67, 0x130, 150, 0x77, 0x111, 0x12b, 310, 40, 0x162, 130, 0xaf, 
            0xe9, 0x11e, 0x187, 0x9e, 330, 0x182, 0x155, 0x108, 0x148, 0x57, 0xa2, 70, 0xa4, 0x177, 0x106, 0, 
            0xa4, 360, 0x155, 0x135, 0x66, 0x12b, 0x9c, 0xad, 0xaf, 0xa4, 0x9e, 350, 330, 0x14d, 0x145, 100, 
            0x3b, 360, 0x15b, 20, 0xe4, 0x177, 0xa4, 0, 0x14d, 0, 8, 230, 80, 0x39, 0, 0, 
            0x141, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0x74, 0x15c, 0, 0x87, 0x20, 0x25, 0, 0x3a, 0xbc, 0x17f, 0xed, 15, 0x179, 0, 0x2f, 350, 
            0xf1, 0x14c, 0xae, 0x3e, 0xdf, 0x17d, 170, 0x149, 0x39, 0x147, 350, 0x159, 310, 0x6b, 0x20, 0xf7, 
            0x11a, 0x1f, 0x1f, 0x109, 0x129, 0x11a, 0xaf, 0x53, 0x16f, 0x54, 0xed, 0x42, 0x180, 0xbc, 14, 0xac, 
            300, 0xac, 0xc6, 0x165, 0x54, 0x5e, 0x81, 0x54, 310, 0xc6, 0, 0x7e, 0x141, 0x54, 0xc9, 0, 
            0xc6, 0xc6, 0x5c, 310, 0x57, 14, 0x37, 0x177, 0xb1, 0xe2, 0x15c, 0x75, 0x162, 0x162, 0xc6, 0x89, 
            0x15c, 0xac, 0x41, 0x75, 0x3a, 0x17f, 0x7e, 0x24, 0x20, 0x13f, 0xa2, 0x1d, 0xac, 0x41, 170, 0x7e, 
            0x27, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0xe8, 0x41, 0x41, 0xf5, 0x39, 0x11e, 0x177, 200, 14, 0x59, 0x179, 0x14b, 340, 0x23, 0x156, 0xf1, 
            0x158, 0x34, 14, 0x183, 0x156, 0x177, 0x4e, 0x177, 0x51, 0x86, 0x116, 0xd4, 0x134, 0x13a, 0x81, 0x162, 
            0x79, 0x130, 0x25, 0xba, 0x83, 0x14e, 0x13c, 0xb7, 0x14e, 0x12a, 240, 0x4a, 0x11d, 0x15c, 0xe7, 370, 
            100, 180, 170, 0x5c, 310, 0x15b, 0x25, 0xe8, 0xc1, 0x48, 0x8f, 0x158, 50, 0x11a, 0x178, 0, 
            0x177, 0x162, 0x53, 0x15a, 0x23, 0x13c, 0x68, 0x146, 0x77, 0x94, 0x15d, 0x88, 330, 100, 0x15c, 0x2b, 
            0xa2, 0, 0x3f, 370, 0x11a, 50, 0x15c, 0x183, 0x128, 0x111, 0x40, 0xae, 0x194, 0xf6, 0x54, 0x125, 
            0x7f, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0xac, 160, 0x14c, 0x51, 0x130, 0x15d, 110, 0x14c, 100, 0x145, 0xd8, 0x162, 0x145, 0x160, 0xa2, 0xa4, 
            0x11e, 0x39, 170, 170, 0x11, 0x5c, 0x25, 0x15a, 0x81, 0x176, 0xb9, 0xa4, 0x7b, 0x9d, 0x5c, 0x155, 
            350, 0x15d, 0x160, 0x130, 0x3f, 0xb3, 0xb0, 0xb0, 20, 0, 6, 0x4e, 0x4e, 0xf5, 0x5c, 0x16a, 
            0xb8, 0xe0, 0x2f, 0xab, 0xc4, 0x5c, 0xe7, 90, 0x4b, 0x6b, 14, 0x27, 0xf3, 2, 0x14e, 0, 
            0x6d, 120, 0x6d, 0x16b, 0x34, 0x6d, 0x14e, 0x15b, 0x6d, 0x80, 2, 0x151, 120, 0xb3, 0xea, 110, 
            0x80, 0x58, 0xe4, 0xf9, 0xfc, 0x16f, 0x61, 0x89, 0x89, 0x179, 0x16f, 0, 0x173, 70, 0xf1, 350, 
            11, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 
            3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 5, 5, 5, 5, 
            5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 
            6, 6, 0xe0, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 7, 7, 8, 
            8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 
            9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 10, 10, 10, 10, 10
         }, 
        { 
            0x173, 110, 110, 20, 0x143, 0x162, 0x4f, 0x54, 0xf9, 0x3b, 0xaf, 0x171, 0xa4, 130, 340, 140, 
            0x155, 3, 0x194, 340, 0x179, 0x3a, 3, 0x61, 0xa4, 0x58, 0x144, 0xf1, 0x163, 0x14c, 0x150, 330, 
            0x53, 0xc1, 0xc2, 0x11c, 0x165, 0xe2, 80, 0xba, 0x14c, 0x11c, 350, 0x176, 220, 0x11a, 0x7b, 0x37, 
            0x175, 0x98, 340, 0x11a, 0xba, 0xc4, 0x17a, 0x175, 0x11c, 0x41, 0xd0, 0x182, 0x21, 80, 0xe2, 0, 
            0xad, 0x13a, 0x177, 0x3e, 0xcc, 0xc2, 0x157, 0x175, 0x15a, 0xc4, 0x178, 0xc4, 0xba, 0x14e, 0x6b, 0x77, 
            0x24, 380, 0x87, 0x4b, 0xb6, 0x14c, 330, 0x9a, 0x116, 310, 0xb2, 0x143, 0xa3, 0x11c, 0xf8, 0xa9, 
            0x176, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 11, 11, 11, 
            11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 12, 12, 12, 12, 
            13, 13, 13, 13, 13, 13, 14, 14, 14, 14, 14, 14, 14, 14, 14, 14, 
            14, 14, 14, 14, 14, 14, 14, 14, 14, 0xe8, 14, 14, 14, 14, 15, 15, 
            15, 15, 15, 15, 15, 15, 15, 15, 15, 15, 0x10, 0x10, 0x10, 0x10, 0x11, 0x11, 
            0x11, 0x11, 0x12, 0x12, 0x12, 0x12, 0x12, 0x12, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13, 0x13
         }, { 
            0xa4, 0x9d, 0x187, 0x87, 0xe8, 0x7a, 0xaf, 0x16b, 0x179, 0x162, 0x7a, 180, 0x14b, 0x151, 0x79, 0x67, 
            0x167, 0x2d, 0x7d, 0xba, 0x73, 0x155, 310, 340, 0x4e, 0x148, 0x66, 0xbd, 0x147, 0x93, 0x3a, 310, 
            0xf8, 0xc4, 0x52, 0x16b, 370, 0x15c, 0x45, 0x93, 0xc4, 0x124, 0x30, 0x194, 0x25, 0xbb, 0x66, 0x77, 
            0x124, 330, 240, 0x11a, 0xa8, 0x22, 0x14c, 0x15b, 0x156, 0x149, 0x145, 0x7d, 0x15b, 2, 0x79, 0, 
            0x7d, 0x173, 0xba, 0x27, 0x110, 0xd6, 0x157, 220, 0x164, 0xbc, 190, 0xec, 190, 0xa2, 0x98, 0x155, 
            190, 0x7b, 0xaf, 0xbc, 0xad, 0xfb, 0xb6, 330, 0x131, 140, 0x17a, 0xf6, 0x162, 0x125, 0x181, 0x88, 
            0x11a, 0x13, 0x13, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 20, 
            20, 20, 20, 20, 20, 20, 0x15, 20, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 0x15, 
            0x15, 0x16, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x17, 0x18, 0x18, 0x18, 
            0x18, 0x18, 0x18, 0x18, 0x19, 0x19, 0x19, 0x19, 0x19, 0x1a, 0x1a, 0x1a, 0x1a, 0x1a, 0x1b, 0x1b, 
            0x1b, 0x1b, 0x1b, 0x1c, 0x1c, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 0x1d, 
            30, 30, 30, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x1f, 0x20, 0x20
         }, { 
            0x73, 350, 0x179, 0x80, 0x16e, 0x164, 6, 0x42, 0xf1, 0x182, 0x149, 0x174, 0xf2, 0xf4, 0x39, 0x88, 
            0xa4, 0x54, 0x146, 0x4b, 0x8d, 0x177, 0x81, 0xec, 0x4b, 0x174, 0x12b, 0x141, 130, 0xc4, 0x185, 0x162, 
            0xb3, 320, 0x4b, 0xc6, 0x17a, 0xd9, 0xed, 0xab, 240, 0xa1, 0x4b, 0xee, 0x160, 0x98, 0x91, 0xfb, 
            0x17a, 0x98, 0x4b, 0xf2, 0xaf, 0x145, 2, 0x15d, 0x159, 0xed, 160, 0x72, 0xf7, 0x145, 0x7f, 0, 
            0, 0xf7, 0xfc, 0x1f, 0x9f, 0x72, 0x162, 0x14e, 0x14b, 0xb7, 0xb3, 0x160, 0x22, 0x22, 0x159, 0x114, 
            0x9a, 0x61, 0, 0x75, 0xaf, 0x23, 0xdb, 0x127, 0x181, 0x91, 0x159, 0x17f, 0x92, 0x24, 0xf1, 0x183, 
            0xf7, 0x20, 0x20, 0x20, 370, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x21, 0x21, 0x21, 0x21, 
            0x21, 0x21, 0x21, 0x21, 0x21, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x23, 0x23, 0x23, 0x23, 0x23, 
            0x23, 0x23, 0x23, 0x23, 0x23, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 0x24, 
            0x24, 0x24, 0x24, 0x24, 0x25, 0x25, 0x25, 0x11c, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 0x25, 
            0x25, 0x25, 0x25, 0x25, 0x26, 0x26, 0x26, 0x26, 0x26, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 0x27, 
            0x27, 0x27, 0x27, 0x27, 0x27, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40
         }, { 
            170, 0x89, 0xe2, 0xc1, 0x171, 110, 330, 0xa3, 0x15d, 0x149, 0xf1, 0xb2, 0xcb, 0x108, 0x159, 0x42, 
            320, 350, 0x8f, 0x145, 0x125, 0x175, 0x47, 0x14b, 0x3a, 0x135, 0xcb, 310, 0xf1, 0x49, 0x53, 0xfc, 
            0xfc, 180, 0x5f, 0x14f, 0x4b, 0xac, 0x135, 0x131, 0x8f, 0xe8, 0x145, 310, 0x158, 0xf1, 0xa6, 0x145, 
            0x165, 0x17f, 0x9c, 0, 220, 0x17d, 0x1f, 0xf1, 0x7f, 0xe7, 0xac, 0xaf, 140, 0x2b, 0x23, 0, 
            0x15d, 0xa2, 0xea, 0xf1, 0x17a, 0x34, 0x183, 0x2e, 0xb2, 0x5c, 0x116, 160, 0x16e, 0x7d, 330, 0x42, 
            0x3f, 0xe2, 0x166, 0x7f, 0x3e, 0xa4, 0x7d, 330, 370, 0x7f, 0x14c, 0x162, 0x17f, 0x7f, 0x8f, 0x16b, 
            0xa2, 40, 40, 40, 40, 40, 40, 0x29, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2a, 0x2b, 
            0x2b, 0x17e, 0x2b, 0x2b, 0x2b, 0x2c, 0x2c, 0x2c, 0x2c, 0x2c, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 0x2d, 
            0x2d, 0x2e, 0x21, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x2f, 0x30, 
            0x30, 0x30, 0x30, 0x30, 0x30, 0x31, 50, 50, 50, 50, 0x33, 0x33, 0x33, 0x34, 0x34, 0x34, 
            0x34, 0x34, 0x34, 0x34, 0x34, 0x35, 0x35, 0x35, 0x36, 0x36, 0x36, 0x36, 0x36, 0x36, 0x37, 0x37, 
            0x37, 0x37, 0x37, 0x37, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38, 0x38
         }, { 
            0x81, 40, 0x15b, 0xfc, 0x3a, 0x15c, 0xe8, 0xe8, 0x162, 0xec, 0xf1, 0x15c, 0x8f, 0x7d, 0x162, 0x108, 
            0xe4, 0x2f, 20, 0x15a, 180, 0x150, 0x98, 0xa2, 0xa2, 0x177, 0xa4, 0xb3, 0x4f, 0xfc, 0xe4, 350, 
            0xa4, 0xad, 0xad, 0xc4, 290, 100, 0x9e, 0x16, 0x159, 0x103, 0x164, 0x12e, 180, 0x14f, 220, 0x177, 
            80, 0x48, 0x178, 0, 0x15c, 0x11c, 0x161, 0x177, 0x137, 0x54, 0xbd, 0x12a, 0xba, 30, 0x194, 0, 
            0x162, 0x149, 0x17a, 0x66, 0x14b, 0x177, 90, 90, 0x123, 130, 0x11a, 0x57, 0x9a, 0x3e, 0x132, 0x61, 
            100, 0x187, 0xab, 0xaf, 0x3b, 0x177, 14, 40, 0x79, 0x161, 0x15d, 0x182, 0x7b, 0x175, 0x163, 0x149, 
            0x14c, 0x38, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 0x39, 
            0x39, 0x3a, 0x3a, 0x3a, 0x3a, 0x3a, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 0x3b, 
            0x3b, 0x3b, 60, 60, 60, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3d, 0x3e, 0x3e, 0x3e, 0x3e, 
            0x3e, 0x3e, 0x3e, 0x3e, 0x170, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3e, 0x3f, 
            0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x3f, 0x40, 
            0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x40, 0x137, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41, 0x41
         }, { 
            0x15a, 0x177, 0x15c, 0xba, 0x126, 0x3e, 11, 0x175, 0x160, 0x5c, 90, 0x131, 0x126, 180, 0x12e, 0x54, 
            0x155, 0xf1, 0x162, 0xf1, 0x126, 0x130, 0x39, 0x66, 0x12b, 0xa4, 0xd8, 0x14c, 0x3b, 0xa4, 0x164, 0x177, 
            360, 0xa2, 0x106, 0x14f, 0x13c, 0x102, 0x182, 0xc7, 0x177, 0x14c, 0xd1, 0xf9, 0x52, 0xb8, 0x165, 0x177, 
            0x83, 0x177, 0x162, 0x94, 8, 0xe8, 0xd0, 0xa4, 0x161, 0xe8, 20, 0xab, 0xd1, 0x189, 0x177, 0, 
            0x86, 0x7b, 0x13a, 0x177, 0x9b, 110, 0x15d, 0x182, 0x177, 0x102, 70, 0x17a, 0xd8, 240, 90, 0x16b, 
            320, 0x9a, 0x58, 0x83, 0x135, 0x13c, 0x158, 0xb2, 0xaf, 0x61, 0x189, 0x180, 9, 0xf1, 0x177, 0x9a, 
            0xa3, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x43, 0x44, 0x44, 0x44, 0x44, 0x44, 
            0x44, 0x44, 0x44, 0x44, 0x44, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 0x45, 70, 70, 70, 
            70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 0x47, 0x47, 0x47, 0x47, 0x47, 
            0x47, 0x48, 0x48, 0x48, 0x48, 0x49, 0x49, 0x49, 0x49, 0x49, 0x13f, 0x49, 0x49, 0x49, 0x4a, 0x4a, 
            0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4a, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 
            0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4b, 0x4c, 0x4d, 0x4d, 0x4d, 0x4d, 0x4d, 0x4d, 0x4d
         }, { 
            0xe7, 170, 0x187, 0x162, 0x129, 0, 0x15c, 330, 15, 0x5c, 0x54, 0xe8, 0xdd, 0x81, 0x178, 0x183, 
            340, 0x24, 0x3b, 0x14c, 0x182, 0x162, 340, 0x177, 0x8e, 0x61, 0x105, 0x12b, 0x105, 0x5c, 0x8d, 0x116, 
            0xbd, 0x177, 0x5c, 0xaf, 0x129, 0x5c, 350, 0x146, 0xf9, 0, 0x15c, 120, 0xf5, 0x5c, 0x14e, 240, 
            0x80, 0x181, 0x178, 0x187, 0x194, 0x12b, 0xd8, 0x111, 0x79, 0xff, 0xdd, 0x162, 0xec, 0x182, 0x13e, 0, 
            0x146, 0x24, 0x7b, 0x98, 0x194, 0xe4, 0x111, 0x181, 0xa4, 360, 0x158, 0x162, 0x11a, 0x83, 220, 160, 
            220, 10, 0x13, 0x141, 0x17a, 0xe4, 0x40, 0x149, 0x141, 0x2b, 220, 0x14e, 0x24, 0x93, 0x39, 0x181, 
            340, 0x4d, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4e, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 
            0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 0x4f, 80, 80, 80, 80, 80, 
            80, 80, 80, 80, 80, 80, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 0x51, 
            0x51, 0x51, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 0x52, 
            0x52, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 0x53, 
            0, 0x55, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54
         }, { 
            0x129, 100, 0x181, 0x148, 0x141, 0x15b, 0xf8, 220, 220, 0x137, 0x21, 310, 0x40, 0xae, 0xa8, 330, 
            0x149, 0x99, 0x2b, 0x173, 0x97, 0x97, 0x24, 0x34, 0xa8, 0x16a, 0x33, 0x7f, 0xf8, 70, 0x16a, 0xad, 
            0xf5, 40, 0x11c, 0x54, 0xf3, 40, 0x72, 0xf1, 0x6d, 0x11b, 0x52, 0xbf, 250, 0x17a, 0xab, 0xcf, 
            0x13, 7, 0x126, 0x72, 0x175, 0x40, 0x15c, 0x11e, 0x83, 250, 0xed, 0xa4, 0x17d, 0x1c, 0x3d, 0, 
            0x35, 0x142, 0x83, 140, 0x83, 0xa1, 0xe7, 0x25, 0xb7, 0x17a, 0x143, 0x80, 0x12a, 0xf6, 0x158, 0x17f, 
            0x163, 0x6c, 130, 0xe8, 0x15c, 0x44, 0x116, 0x14b, 0x17a, 0xc7, 0x61, 0xf5, 0xc1, 10, 0x116, 0xe5, 
            0xab, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 240, 0x54, 0x54, 0x54, 
            0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 0x54, 
            0x54, 0x56, 0x56, 0x57, 0x57, 0x57, 0x57, 0x57, 0x57, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 0x58, 
            0x58, 0x58, 0x58, 0x58, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 0x59, 90, 90, 90, 
            90, 90, 90, 90, 90, 90, 90, 0x5b, 0x5b, 0x5b, 0x5b, 0x5b, 0x5b, 0x5b, 0x5b, 0x5b, 
            0x5b, 0x5b, 0x69, 0x5b, 0x5b, 0x5b, 0x5b, 0x5b, 0, 0x5d, 0x5d, 0x5e, 0x5e, 0x5e, 0x5e
         }, { 
            0xd9, 0x54, 0x4f, 0x58, 0x4f, 0x11c, 0xb8, 0x14e, 0xf8, 0xc1, 0xb3, 0x66, 250, 0x25, 0x15d, 220, 
            14, 0x9b, 0x80, 0x165, 0x107, 0x5c, 0x6c, 0x178, 0x9d, 0x3a, 0x1b, 0x54, 0x13c, 0xa4, 0x9f, 0x86, 
            100, 0x14c, 0x6b, 0x160, 0x14b, 0x177, 0x24, 0x12a, 0x17a, 0x189, 0x139, 0x7c, 90, 0x58, 0x98, 0x165, 
            0xde, 0x14e, 240, 0x9d, 0x184, 0xe1, 0xe8, 0x5b, 0x12f, 0x63, 0x162, 0x7d, 0x173, 0x74, 0x176, 0, 
            0x16f, 0x179, 0xaf, 170, 0xfd, 0x54, 0x16f, 0x61, 0xf3, 0x89, 0x17f, 0x1b, 0x185, 20, 0x155, 15, 
            300, 0x14c, 0xed, 0x151, 0x74, 0x15c, 0x164, 0x2d, 0x194, 0x149, 0x44, 0x14e, 0x5c, 0x81, 0x151, 0xba, 
            0x4f, 0x5e, 0x5e, 0x5e, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 0x5f, 
            0x5f, 0x5f, 0x5f, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x60, 0x61, 0x61, 0x61, 0x61, 
            0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x61, 0x62, 0x62, 
            0x62, 0x62, 0x62, 0x62, 0x63, 0x63, 0x63, 100, 100, 100, 100, 100, 100, 100, 100, 100, 
            100, 100, 0x65, 0x65, 0x65, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 
            0x66, 0x66, 0x66, 0x66, 0x66, 0x67, 0x67, 0x67, 0x68, 0x68, 0x68, 0x68, 0x68, 0x68, 0x69
         }, { 
            0x47, 0x53, 0x17a, 0x72, 0xf5, 0xf9, 0xbf, 0xf3, 0x61, 0x11c, 0x165, 110, 0x131, 0x164, 0x27, 0x10b, 
            0x176, 0xd4, 0xf3, 0x14e, 0xad, 0xe7, 70, 0x181, 40, 0x11c, 0x17a, 0xf4, 0xad, 0x7d, 0x15, 0x79, 
            14, 0x17a, 0x30, 0x159, 360, 390, 0xe8, 0xea, 0x162, 0x17d, 0x170, 0x115, 0x68, 0x15c, 0x74, 0x1f, 
            0x93, 0xed, 0x16a, 0x5c, 0x194, 0x5c, 0xd1, 0x12d, 0x33, 0x40, 0x12d, 0xa1, 0xa7, 0x14e, 20, 0, 
            0xbd, 0x126, 0x131, 0xa8, 0x39, 0x54, 0x7d, 0xc1, 0x99, 0x38, 0x80, 0x17d, 160, 0x14e, 0xaf, 0x11c, 
            360, 0xf1, 0xe1, 0xf1, 0xe8, 0x58, 0x86, 0xaf, 0xaf, 0x159, 0x3a, 0x10d, 0x17b, 0x60, 0xf3, 0xa6, 
            0x11c, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6a, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 
            0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 0x6b, 12, 0x6c, 0x6c, 0x6d, 0x6d, 
            0x6d, 0x6d, 0x6d, 0x6d, 0x6d, 0x6d, 0x6d, 110, 110, 110, 110, 110, 110, 110, 110, 110, 
            110, 0xc4, 110, 110, 110, 110, 110, 110, 110, 0x6f, 0x6f, 0x70, 0x70, 0x70, 0x70, 0x71, 
            0x71, 0x71, 0x71, 0x71, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x72, 0x73, 0x73, 0x73, 
            0x73, 0x73, 0x73, 0x73, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74
         }, { 
            0x9e, 0x99, 0x162, 0x164, 0x6d, 0x175, 0x12f, 0x135, 0xd4, 0x132, 0x15c, 0xf1, 0x134, 0x17d, 0x179, 0xe2, 
            0x128, 0x179, 0xf3, 0x181, 0x134, 0xaf, 0xaf, 0x7d, 320, 350, 0x162, 0x9d, 0xad, 0xf5, 0xa6, 0x9e, 
            0xf3, 0x164, 0x178, 250, 0xa6, 15, 0x47, 390, 0xa4, 0x11c, 0xb3, 350, 0x164, 0x181, 0x162, 0x4f, 
            0x11a, 0x174, 0x11a, 0x195, 110, 0xd0, 0x35, 370, 0xf3, 0x170, 0xe8, 8, 0x149, 0x114, 0x8d, 0, 
            0x106, 14, 0x12b, 0x15d, 0x174, 0xbd, 0x12f, 0x74, 0x58, 0x86, 0xc4, 0x179, 0xa4, 0x129, 0x72, 0x13a, 
            0x111, 170, 0x17e, 7, 160, 0x4d, 250, 110, 0x14c, 0x54, 0xa4, 0x164, 0xaf, 0x86, 0xf1, 7, 
            370, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x74, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 0x75, 
            0x75, 0x76, 0x76, 0x76, 0x76, 0x76, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 
            0x77, 0x77, 0x77, 0x77, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 120, 
            120, 120, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 
            0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x79, 0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7a, 0x7b, 0x7b, 0x7b, 
            0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x7b, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c
         }, { 
            0x75, 0x75, 270, 0x131, 15, 190, 0x183, 0x7d, 0xa4, 0x14f, 0x54, 0xdd, 11, 0x61, 0x153, 0x7c, 
            0x17e, 0x131, 270, 0x52, 0x7e, 0xc4, 270, 270, 0xdd, 330, 0xa7, 150, 20, 0x77, 0x11e, 0x5c, 
            0x14c, 0x13d, 0xd4, 0xa4, 0x189, 0x3e, 0xd4, 0x137, 0x9e, 0x126, 0x85, 0x5f, 0x176, 0x85, 0x161, 0x5c, 
            0x1d, 0x179, 0x157, 0x164, 0x7e, 0x162, 0x81, 0x143, 0x102, 0x146, 0xf9, 0xc7, 0x182, 0x13b, 0xd7, 0, 
            0x55, 0x81, 0x11e, 0x180, 0xe8, 0x175, 0x114, 0x72, 0x177, 0x5c, 0x52, 0x165, 0x102, 0x39, 130, 80, 
            0x185, 0x85, 0x16f, 6, 0x54, 0x177, 0xf1, 0x179, 0x72, 0x16f, 330, 0x54, 0x15c, 0x11a, 20, 0x17a, 
            250, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 
            0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 
            0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x5c, 0x7c, 0x7c, 
            0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7c, 0x7d, 
            0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 
            0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 140, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d
         }, { 
            0xab, 0x17a, 280, 0x58, 0x15a, 0x54, 320, 0x175, 0x38, 40, 0x11c, 0x178, 0x155, 0x185, 0x84, 8, 
            250, 0xc4, 0x11e, 0x187, 0x98, 0x83, 0x102, 0x6c, 0x15c, 0x81, 0x17a, 0x27, 0x95, 0xc4, 0x88, 0x98, 
            0x74, 0x2f, 0x77, 0x5e, 0x132, 0x14f, 0x94, 0x14e, 0xfb, 0x57, 0xb3, 0x157, 0xe7, 0x14c, 0x54, 0x14b, 
            0x13a, 0x105, 0x137, 0x15d, 0xa2, 0x14f, 0x87, 0x6a, 0x41, 0x13a, 0x126, 0x7e, 0x14d, 0x79, 0x88, 0, 
            0x7d, 0x155, 0x177, 0x146, 0x175, 0x194, 0x24, 0xf9, 0x11e, 9, 0x13a, 0x14e, 0x143, 0x14c, 0x5e, 0x153, 
            0x135, 0x153, 0x14f, 0x72, 330, 0x54, 0x139, 0x12b, 0x48, 0x9a, 0x54, 0x83, 0x74, 0x177, 0x159, 0x84, 
            0x53, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7d, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 
            0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x7e, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 
            0x80, 0x80, 0x80, 0x80, 220, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 
            0x80, 0x80, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x86, 0x81, 0x81, 0x81, 0x81, 
            0x81, 0x81, 0x81, 0x81, 0x81, 0x5c, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 0x81, 130, 130, 130, 
            130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130, 130
         }, { 
            0x5c, 340, 0x102, 0x183, 0x11a, 0x4a, 0xa9, 0x194, 0xa7, 0x132, 0xfb, 280, 0xf1, 0x180, 0xf1, 0x143, 
            0x176, 0x14c, 0x11d, 0x15c, 0x132, 0x143, 0x59, 0x144, 13, 0x17f, 0x17, 0x68, 0x185, 0xb2, 0xac, 0x15c, 
            0x171, 14, 0x2e, 0xab, 190, 0xf1, 0xf5, 310, 0x183, 0x7a, 0x184, 330, 0x182, 0x151, 0xa7, 130, 
            0x51, 0x109, 0xc1, 0x162, 0x183, 0x4f, 0x194, 340, 350, 0x117, 0xf1, 340, 0x14d, 0x7d, 0x8f, 0, 
            0x14c, 0x108, 190, 0xf1, 0x47, 0x178, 0x3e, 0xc1, 0xbf, 0x163, 0x15b, 10, 0x126, 0xf9, 15, 0x77, 
            0x5e, 0x183, 190, 0x145, 0x54, 0x145, 340, 0x60, 0xbf, 0x14f, 0xa6, 0x183, 0xe9, 0x165, 0x15d, 0x135, 
            0x62, 130, 130, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 
            0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x83, 0x84, 0x84, 0x85, 0x85, 
            0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x85, 0x86, 
            0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 
            0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x86, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x87, 0x88, 
            0x88, 0x88, 0x88, 0x88, 0x88, 0x80, 0x88, 0x88, 0x88, 0x89, 0x89, 0x89, 0x89, 0x89, 0x89
         }, { 
            0x177, 0x165, 0x24, 0x1f, 0x38, 0x14b, 0x163, 0x183, 340, 350, 0x145, 0x5e, 0, 350, 130, 0x15c, 
            0x17f, 0xd0, 9, 0x74, 0xe2, 0x179, 0x7d, 0x12d, 0xfb, 290, 0x165, 0x14b, 0x12b, 330, 0x105, 0x132, 
            0x54, 0x165, 0x175, 90, 0x107, 0x74, 0x16e, 0x134, 0x155, 0x129, 0x175, 0x183, 0x132, 120, 0x17, 14, 
            0x53, 50, 0xa4, 0x12d, 0x15d, 330, 0x183, 0xa2, 0x17d, 0xf3, 0xb6, 0x177, 0x194, 0xc6, 0xea, 0, 
            0xa6, 0x155, 0x183, 0x5c, 0x14e, 0x12b, 0x194, 13, 0x15c, 0x16a, 0xc6, 0xf4, 0x7a, 0x14c, 0x5c, 0x114, 
            0x153, 0xfe, 0x155, 0x12b, 0x7f, 0x16e, 0x189, 0x177, 0x116, 270, 170, 0x162, 0x4f, 0x100, 0x2e, 0x188, 
            0x7d, 0x89, 0x89, 0x89, 0x89, 0x89, 0x8a, 0x8a, 0x8a, 0x5b, 0x8b, 0x8b, 0x8b, 0x8b, 0x8b, 140, 
            140, 140, 140, 140, 140, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8d, 0x8e, 0x8e, 0x8e, 0x8e, 
            0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x8f, 0x90, 
            0x90, 0x90, 0x90, 0x91, 0x91, 0x92, 0x92, 0x92, 0x92, 0x93, 0x93, 0x93, 0x93, 0x94, 0x94, 0x94, 
            0x94, 0x94, 0x94, 0x94, 0x95, 0x95, 0x95, 0x95, 0x95, 150, 150, 150, 150, 0x97, 0x97, 0x98, 
            0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x98, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99, 0x99
         }, { 
            0x100, 0x1f, 0x109, 0x153, 0x79, 0x75, 390, 330, 0xf4, 0x165, 0x37, 350, 0x79, 330, 0x111, 0x7d, 
            0x7e, 0x77, 0x16a, 0x30, 0x14f, 0x181, 14, 0x130, 0x15c, 0xd8, 0x12b, 0x15c, 0x115, 340, 0x5c, 0x12, 
            0xf3, 0x9e, 240, 0x157, 0xf1, 0xe7, 220, 0xc4, 0xa2, 0x14f, 390, 0x98, 0x161, 340, 0xa2, 0x14c, 
            0x1f, 0x80, 0xaf, 0x1f, 350, 0x116, 0x14d, 0x14c, 0x187, 390, 0xb3, 330, 0x9e, 0xa2, 0xa6, 0, 
            0x72, 0x102, 0x17a, 0x175, 0x41, 330, 350, 0x132, 0x165, 0x14c, 0x12b, 0x14f, 0x55, 0x55, 0xf1, 20, 
            0xed, 0x14d, 0x173, 0x59, 350, 100, 0x188, 0x130, 0x19, 0xf1, 0x147, 350, 0xa2, 0x130, 0xaf, 0x126, 
            0x59, 0x99, 0x99, 0x99, 0x9a, 0x9a, 0x9a, 0x9a, 0x9b, 0x9b, 0x9b, 0x9b, 0x9c, 0x9c, 0x9c, 0x9c, 
            0x9c, 0x9c, 0x9c, 0x9d, 0x9d, 0x9d, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 
            0x9e, 0x9e, 0x9e, 0x9e, 0x9e, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 0x9f, 160, 160, 160, 160, 
            160, 160, 160, 160, 160, 0xa1, 0xa1, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 0xa2, 
            0xa2, 0xa2, 0xa3, 0xa3, 0xa3, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 
            0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4
         }, 
        { 
            0, 0x11a, 0x61, 0x17a, 0x86, 0xbc, 0xc1, 0x62, 0x135, 0x87, 0x54, 0x11a, 0x63, 0x181, 0x162, 3, 
            0x4e, 0x126, 180, 0xac, 0xe8, 0x4e, 0x21, 0x145, 14, 0x5c, 0x26, 0xac, 0x87, 0xbd, 0x173, 0xb3, 
            0xe8, 0x5c, 0x5c, 0xb0, 0xbd, 0x37, 0x15a, 0x161, 0x161, 0x52, 6, 0x15a, 0x61, 0x161, 0x169, 0xba, 
            0x15c, 0x17a, 0x15c, 0x105, 0xfd, 0xf4, 0x77, 0x15c, 0x15c, 0x15a, 0xf4, 0x14c, 0x162, 0x9f, 0x163, 0, 
            0x4f, 0x116, 0x52, 0x116, 0xa6, 400, 0xf4, 0x72, 0x26, 0x52, 0x72, 0x25, 0x34, 0x54, 0x14b, 230, 
            0x9c, 0xee, 0xaf, 0x177, 0x162, 330, 0x14f, 330, 0x8f, 0x79, 0x79, 0x14e, 0x114, 0x72, 0x7e, 0x179, 
            0x114, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa4, 0xa7, 0xa6, 0xa6, 0xa6, 0xa6, 0xa6, 0xa6, 
            0xa6, 0xa6, 0xa6, 0xa6, 0xa6, 0xa6, 0xa6, 0xa6, 0xa7, 0xa7, 0xa7, 0xa7, 0xa7, 0xa7, 0xa7, 0xa7, 
            0xa7, 0xa7, 0xa7, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa8, 0xa1, 0xa8, 0xa8, 0xa8, 0xa8, 
            0xa9, 0xa9, 0xa9, 0xa9, 0xa9, 170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 170, 
            170, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xab, 0xac, 
            0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xac, 0xad, 0xad, 0xad, 0xad, 0xad
         }, { 
            0x25, 0x155, 0x25, 0x183, 0x143, 0x79, 0x73, 110, 0xea, 0xa6, 250, 5, 170, 230, 0x7f, 5, 
            0x79, 0x155, 0x3b, 0, 0x60, 0x60, 0x60, 0x41, 0x108, 200, 0x17d, 0x139, 0xe8, 0x15c, 250, 0x7c, 
            0x86, 40, 0xb2, 0x81, 0x16f, 0xae, 0x5c, 160, 0x7b, 0x161, 0x76, 0x15c, 0xf6, 0x165, 0x39, 0x72, 
            0x177, 0, 0x175, 0x22, 0x176, 0x161, 0x181, 0x137, 0x195, 0x158, 0x174, 0, 0x6d, 0x11b, 0xa9, 0, 
            0x83, 14, 0x3e, 0x68, 0x146, 340, 0xed, 0x30, 0x42, 0, 0x139, 0x86, 0x30, 0x99, 0xa6, 0xa6, 
            0x147, 0x99, 0xa6, 0xa6, 0x30, 0x11b, 0x127, 0x139, 0x99, 0x174, 0x177, 0x39, 0xd6, 0xf5, 0xd0, 0x139, 
            0x139, 0xad, 0xad, 0xad, 0xad, 0xae, 0xae, 0xae, 0xae, 0xae, 0xae, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 
            0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0xaf, 0x194, 
            0x194, 0x194, 0x194, 0x194, 0x194, 0x194, 0x194, 0x194, 0x194, 0x194, 0x194, 0x194, 0x194, 0xb0, 0xb0, 0xb0, 
            0xb0, 0xb0, 0xb0, 0xb1, 0xb1, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb2, 0xb3, 0xb3, 0xb3, 0xb3, 
            0xb3, 0xb3, 0xb3, 0xb3, 0xb3, 0xb3, 0xb3, 0xb3, 180, 180, 180, 180, 180, 180, 180, 180, 
            180, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb5, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6, 0xb6
         }, { 
            0xad, 0x173, 0x126, 0x129, 0x173, 0x15c, 0xf9, 0x90, 0x1a, 0xf1, 0x3e, 0x77, 0x25, 0x102, 0x107, 0x163, 
            0x1d, 0xf6, 0x52, 0xe5, 0xe3, 0x161, 0xfe, 0x146, 0xf1, 0xe8, 330, 330, 0x90, 0x41, 0x51, 6, 
            20, 340, 310, 0x182, 0x94, 0x177, 0xd0, 0xed, 0x182, 0x179, 0x14c, 0xc6, 250, 0x8f, 0x25, 0x15a, 
            0xe3, 0x177, 0x152, 0x4d, 0x71, 0x182, 0x99, 0x176, 0x137, 0x34, 0xba, 0x14f, 0x14f, 0xb5, 0x14f, 0, 
            0xd5, 0x146, 0x146, 0x153, 0x91, 0x161, 0x71, 0xe4, 0x116, 0x139, 0xba, 0x2d, 0x11a, 250, 0x133, 0x187, 
            0x5c, 0x161, 0x150, 320, 0x24, 0x13e, 0x45, 0xcb, 0xe8, 0x61, 0xa4, 370, 0x12b, 0x81, 0xa7, 0x123, 
            0x10, 0xb6, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb7, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 0xb8, 
            0xb8, 0xb8, 0xb8, 0xb8, 0xb9, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 0xba, 
            0xba, 0xba, 0xba, 0xba, 0xba, 0xbb, 0xbb, 0xbb, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 0xbc, 
            0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 0xbd, 190, 190, 
            190, 190, 190, 190, 190, 190, 190, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xbf, 0xc0, 
            0xc0, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc1, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc2, 0xc3, 0xc4
         }, { 
            0xb2, 0xe9, 0xa2, 0xfb, 0x73, 0x39, 0xcd, 200, 0x102, 0x11a, 0x17f, 0x86, 0x44, 0xe8, 0x7b, 0x148, 
            0xba, 0x108, 0x17d, 0x25, 0xb3, 0xdf, 0x3e, 3, 0xcb, 0x121, 0x165, 0x178, 0x106, 0x13c, 0x145, 0x88, 
            0x7c, 0x47, 14, 0x20, 0x159, 0x141, 0x11d, 0x131, 0x129, 0x17f, 0x15c, 0xa8, 0x5c, 0xe8, 0x14f, 0x194, 
            0xdf, 0x20, 0xaf, 0x7b, 0xe3, 0x29, 0x7e, 0xaf, 0x17d, 0xaf, 0x80, 350, 0x194, 0x156, 0x18f, 0, 
            0x13a, 0xd0, 0xa8, 0x34, 0x99, 0x14e, 0x13f, 0xe2, 0x177, 0x80, 0x149, 0x34, 0, 0x14d, 0, 0x52, 
            0x17b, 0x39, 150, 0xd8, 0x88, 40, 0x87, 0x9c, 0xa6, 0x13f, 0xf1, 0x34, 0x12, 0x157, 0x107, 0x164, 
            0x169, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 0xc4, 
            0xc4, 0xc5, 0xc5, 0xc5, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 0xc6, 
            0xc6, 0xc6, 0xc6, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7, 0xc7, 200, 200, 200, 200, 200, 0xc9, 
            0xc9, 0xc9, 0xca, 0xcb, 0xcb, 0xcb, 0xcb, 0xcb, 0xcc, 0xcd, 0xcd, 0xce, 0xcf, 0xd0, 0xd0, 0xd0, 
            0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd0, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 0xd1, 210, 
            210, 0xd3, 0xd3, 0xd4, 0xd4, 0xd4, 0xd4, 0xd4, 0xd4, 0xd4, 0xd5, 0xd6, 0xd6, 0xd6, 0xd6
         }, { 
            0x14c, 0x10, 0x151, 0x9a, 0xa9, 0x159, 0xaf, 0x7b, 0x166, 0xb3, 250, 0x169, 0xb0, 0xd0, 360, 0x14c, 
            0x148, 0x84, 170, 0x84, 0x80, 0x5c, 0x6d, 0x153, 190, 0xd4, 0x5b, 0x7d, 0x177, 0x177, 0x153, 0x12f, 
            0x14c, 0x1d, 330, 0x162, 0x151, 0x86, 0x85, 0x150, 0x119, 0x85, 310, 0x11c, 0x130, 240, 240, 100, 
            0xf1, 310, 0x14b, 0x3b, 0x4f, 0xe0, 0x12f, 0x4f, 0x4f, 0xaf, 0xab, 0x14b, 0xf8, 0xe3, 0x95, 0, 
            0x54, 0x16a, 0x53, 0xa4, 0x162, 0x9f, 0, 20, 0xf3, 0, 120, 0x183, 15, 0xc6, 0x41, 0x45, 
            9, 0x1d, 0x15c, 0x19, 0xae, 0x38, 0x156, 220, 0x3d, 0x3a, 0xf4, 0xaf, 0x15c, 0x5c, 0x7d, 0x148, 
            0xf1, 0xd6, 0xd6, 0xd7, 0xd7, 0xd7, 0xd7, 0xd8, 0xd8, 0xd8, 0xd8, 0xd9, 0xd9, 0xd9, 0x195, 0xda, 
            0xdb, 0xdb, 0xdd, 0xdd, 0xdd, 0xdd, 0xde, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xdf, 0xe0, 0xe0, 
            0xe0, 0xe0, 0xe0, 0xe0, 0xe1, 0xe1, 0xe1, 0xe1, 0xe1, 0xe1, 0xe2, 0xe2, 0xe2, 0xe2, 0xe2, 0xe2, 
            0xe2, 0xe2, 0xe3, 0xe3, 0xe3, 0xe3, 0xe3, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe4, 0xe5, 0xe5, 
            0xe5, 0xe5, 0xe5, 0xe5, 0xe5, 0xe5, 0xe5, 230, 230, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 
            0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe7, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8
         }, { 
            0xaf, 0xaf, 0x1f, 290, 0x7d, 0xed, 0x159, 0x159, 0x1a, 0xa1, 0x139, 0x137, 0x80, 0xe7, 0x15c, 0x1d, 
            190, 0x58, 0x162, 0x14b, 0x182, 0x79, 0x12b, 0x177, 0x13f, 0x145, 0xf1, 0x146, 0x102, 0x54, 0x17a, 0x75, 
            0x88, 0x5c, 5, 0x184, 0xb8, 0x103, 0x6c, 0x15d, 0x161, 0x15c, 0xf5, 0xe8, 0x135, 0x3e, 0xa4, 0x160, 
            11, 0x15c, 0x17a, 0xd0, 0xe0, 0x13, 0x153, 220, 0x14c, 0x72, 0x189, 0x44, 0x41, 0xd4, 0x74, 0, 
            0xba, 0x11b, 0x62, 0xbd, 0x145, 0x54, 0x182, 0x177, 0x5c, 0x30, 0, 0x156, 0xb3, 0xa4, 0x105, 0x177, 
            0x23, 0x162, 0x153, 0x182, 0xa9, 0x149, 0x5c, 0x66, 0x2f, 0x60, 0x65, 0xd3, 0x162, 0x182, 0xe5, 0xc6, 
            0x178, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8, 0xe8, 0xe9, 0xe9, 0xe9, 0xe9, 0xea, 0xea, 
            0xea, 0xea, 0xeb, 0xeb, 0xec, 0xec, 0xec, 0xec, 0xec, 0xed, 0xed, 0xed, 0xed, 0xed, 0xed, 0xed, 
            0xed, 0xed, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xee, 0xef, 240, 240, 240, 240, 240, 
            240, 240, 240, 240, 240, 240, 240, 240, 240, 10, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 
            0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 
            0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf1, 0xf2
         }, { 
            0xf3, 0x17a, 0x77, 0x54, 0x57, 0x12e, 0x2a, 0x83, 0x4d, 3, 0x7f, 0x25, 0xed, 0xf3, 160, 0x11e, 
            0x17e, 0x37, 0x1b, 0x162, 70, 0x145, 0xa4, 0x45, 0x54, 0x102, 0x15d, 240, 0x165, 0x12b, 0x24, 0xd8, 
            0x149, 0x11, 330, 0x5e, 0x17a, 0xc4, 0x17e, 0x189, 320, 0xf9, 0x12d, 0x23, 0xe7, 330, 0x151, 350, 
            0x22, 0x89, 0x159, 0x36, 0x6b, 0x36, 0x7c, 0x144, 0x161, 0x106, 0x14e, 0x14c, 0x146, 0x81, 0xc9, 0, 
            0xc6, 0x13c, 0, 0xb7, 0x2f, 0x3e, 250, 0x44, 0x184, 0x9c, 0xaf, 0x145, 0x102, 0x9a, 240, 0x182, 
            90, 0x68, 0xb2, 0x27, 0x2c, 0x171, 0xbb, 0xa4, 10, 0xf6, 0x87, 0xf6, 0x3e, 0x114, 130, 0x173, 
            0x177, 0xf2, 0xf2, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 
            0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf3, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 0xf4, 
            0xf4, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 0x7f, 
            0xf5, 0xf5, 0xf5, 0xf5, 0xf5, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 0xf6, 
            0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf7, 0xf8, 0xf8, 0xf9, 
            0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 0xf9, 250, 250, 250, 250, 250, 250, 250, 250
         }, { 
            0x5e, 0x95, 0xf6, 0x159, 0x144, 13, 0x179, 0x7d, 170, 0x130, 310, 0x3b, 0x74, 110, 0x2d, 0x20, 
            0x77, 0x54, 0x9d, 0x114, 0x159, 0x15c, 0x137, 0xf1, 0x143, 0x1b, 0x175, 0x16b, 0x85, 14, 0x15c, 0xbc, 
            0, 0xe4, 0x42, 0xf9, 0x8f, 0x14d, 0x143, 0x162, 0x162, 0x54, 0xa6, 0x155, 0xc9, 0x1b, 0x148, 0x2d, 
            0x14e, 0xe9, 0xc6, 3, 350, 0x9b, 0x9b, 0x7e, 190, 0x189, 0x189, 0x185, 0x106, 330, 0x15b, 0, 
            0x159, 250, 0x7d, 0x54, 0x194, 0x7d, 230, 0x72, 0x72, 0x73, 0x159, 0x13c, 0x182, 0xf7, 0xbd, 120, 
            0x11a, 0x57, 0x179, 0xf3, 0x145, 20, 0x145, 0x5c, 0x47, 220, 0x12d, 0xfb, 0x175, 0x157, 0x11c, 0x9e, 
            0x183, 250, 250, 250, 250, 250, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 0xfb, 
            0xfb, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfc, 0xfd, 0xfd, 0xfe, 0xfe, 0xfe, 0xfe, 0xff, 
            0xff, 0xff, 0xff, 0xff, 0x100, 0x100, 0x100, 0x101, 0x101, 0x102, 0x102, 0x102, 0x102, 0x102, 0x102, 0x102, 
            0x102, 0x102, 0x102, 0x103, 0x103, 260, 0x105, 0x105, 0x105, 0x105, 0x105, 0x105, 0x105, 0x105, 0x105, 0x105, 
            0x106, 0x106, 0x106, 0x107, 0x107, 0x107, 0x107, 0x107, 0x107, 0x107, 0x107, 0x107, 0x107, 0x108, 0x108, 0x109, 
            0x109, 0x109, 0x10a, 0x10a, 0x10b, 0x10b, 0x10c, 0x10c, 0x10c, 0x10d, 0x10d, 0x10d, 0x10d, 270, 270
         }, { 
            220, 0x163, 0xba, 0x165, 0x11e, 0x17d, 100, 0xfe, 0x156, 0, 0x145, 0x161, 0x128, 0x15d, 0x11c, 0x2d, 
            0x11c, 0x165, 0x175, 0x107, 0xa4, 0xfc, 0x163, 0xa4, 0x86, 330, 40, 340, 0x13c, 0xac, 0x148, 0x3f, 
            0xf3, 0x185, 0xee, 0x36, 0x163, 40, 0x162, 0xe2, 240, 0xc7, 330, 0x52, 0x165, 0x10b, 0x19, 0xbd, 
            300, 0xc2, 0x128, 0xac, 330, 0x61, 0x9f, 0x5b, 0x36, 0x131, 0xb3, 0x155, 0x181, 0x66, 0x183, 0, 
            0x67, 0x189, 0x137, 0x1b, 0xe5, 0, 0x11a, 0x9f, 0xab, 0x137, 0x153, 0xb8, 0x13a, 0x17a, 3, 0xa6, 
            0x183, 0xed, 340, 130, 0x13d, 0x81, 0x145, 0x13e, 0x1a, 0x162, 0x15c, 0x182, 14, 0xaf, 0x15, 370, 
            0xa2, 270, 270, 0x10f, 0x10f, 0x10f, 0x110, 0x110, 0x110, 0x110, 0x111, 0x111, 0x111, 0x112, 0x113, 0x114, 
            0x114, 0x114, 0x1d, 0x114, 0x114, 0x114, 0x114, 0x114, 0x115, 0x115, 0x116, 0x116, 0x116, 0x116, 0x116, 0x116, 
            0x116, 0x116, 0x116, 0x116, 0x116, 0x116, 0x116, 0x116, 0x116, 0x116, 0x117, 0x117, 0x117, 0x117, 0x117, 0x117, 
            0x117, 0x117, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 280, 0x119, 0x119, 0x119, 
            0x119, 0x119, 0x119, 0x119, 0x119, 0x119, 0x119, 0x119, 0x119, 0x11a, 0x11a, 0x11a, 0x11a, 0x11a, 0x11a, 0x11a, 
            0x11a, 0x11a, 0x11a, 0x11a, 0x11a, 0x11a, 0x11a, 0x11a, 0x11a, 0x11b, 0x11b, 0x11b, 0x11b, 0x11b, 0x11b
         }, { 
            0xf4, 0xb6, 0x159, 0xab, 330, 0xea, 0x67, 0x6b, 0x3e, 0xaf, 0x119, 0x117, 0x3e, 0x157, 20, 0x3e, 
            0x16f, 0x11a, 0x155, 0x74, 5, 0xbd, 0x194, 0x178, 0xee, 0x7e, 0xbd, 0x30, 0xd3, 0x79, 0x89, 0x15d, 
            0x116, 0x15d, 0x68, 0x23, 0x74, 0x114, 0x93, 0xf3, 180, 0x169, 0x16b, 0xa4, 0x145, 0x5c, 0x157, 0x11b, 
            0xbc, 0xdf, 0x1f, 0x3f, 0x109, 0xa2, 0x162, 0x7f, 0x17a, 0x95, 0x7d, 0xb5, 0x165, 10, 0x161, 0, 
            0xaf, 220, 0x4b, 0x135, 0x51, 0x88, 0x51, 0x107, 0x52, 0x99, 0x124, 0x158, 340, 0x54, 0x131, 0x149, 
            0x44, 0x126, 0x14e, 330, 0x10c, 0x165, 280, 0x7d, 300, 0xab, 0x162, 0x14b, 0x126, 0xd8, 0x155, 0x165, 
            0x162, 0x11b, 0x11b, 0x11b, 0x11b, 0x11b, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 
            0x11c, 0x11c, 0x11a, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 
            0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 
            0x11c, 0x11c, 0x11c, 0x11c, 0x11c, 0x11d, 0x11d, 0x11d, 0x11d, 0x11d, 0x11d, 0x11d, 0x11d, 0x11d, 0x11d, 0x11e, 
            0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 
            0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e, 0x11e
         }, { 
            0x14e, 0x6d, 2, 0x79, 0x79, 0x5c, 0x182, 0x14d, 0x143, 0xc0, 0xa3, 0x7e, 0x18, 0x11a, 0x111, 0xa6, 
            0x8f, 0x163, 0x37, 0x177, 0x131, 0x171, 300, 0x159, 0x4f, 0x42, 0x14f, 0x61, 0x17a, 0x7d, 0x8e, 0x10c, 
            0x157, 220, 7, 0x48, 0xec, 0x163, 0xd6, 0x179, 0x148, 0xea, 0xf1, 0x16a, 0x23, 0x175, 0x4d, 0xd0, 
            350, 0x30, 0x14e, 0xf1, 0x4e, 0x7d, 0x162, 0x99, 15, 0x181, 0xbd, 0x9e, 130, 0xf8, 0xf5, 0, 
            0, 0x14c, 0x129, 0x194, 0x15c, 340, 0x14f, 0x15c, 0x9c, 0xa2, 0x80, 0x3e, 0x177, 11, 220, 0xc4, 
            0x77, 0xe4, 0x128, 0x130, 0x13e, 0xf8, 0x7f, 0x145, 0xac, 0x79, 0xdf, 0x8e, 0x165, 10, 0xa4, 0x17a, 
            0x17a, 0x11e, 0x11f, 0x11f, 0x120, 0x120, 0x120, 0x120, 0x121, 0x121, 290, 290, 290, 0x123, 0x123, 0x123, 
            0x123, 0x124, 0x124, 0x124, 0x124, 0x125, 0x125, 0x125, 0x125, 0x126, 0x126, 0x126, 0x126, 0x126, 0x126, 0x126, 
            0x126, 0x126, 0x126, 0x126, 0x126, 0x126, 0x11c, 0x126, 0x126, 0x127, 0x127, 0x127, 0x127, 0x127, 0x127, 0x127, 
            0x127, 0x128, 0x128, 0x128, 0x128, 0x129, 0x129, 0x129, 0x129, 0x129, 0x129, 0x129, 0x129, 0x129, 0x153, 0x129, 
            0x129, 0x12a, 0x12a, 0x12a, 0x12b, 0x12b, 0x12b, 0x12b, 0x12b, 0x12b, 0x12b, 0x12b, 0x12b, 0x12b, 0x12b, 300, 
            300, 300, 0x12d, 0x12d, 0x12d, 0x12d, 0x12d, 0x12d, 0x12d, 0x12d, 0x12e, 0x12e, 0x12e, 0x12e, 0x12e
         }, { 
            2, 170, 0x155, 0xf6, 0x9d, 0x16b, 0x149, 0x109, 0x109, 0xf6, 0xaf, 0x129, 0x13e, 0xb7, 0x165, 0xed, 
            0x162, 0x157, 0x5c, 0x84, 0x155, 0xf9, 0x129, 0x84, 0x53, 20, 0x14d, 0x15c, 0x14c, 0x162, 0x86, 0x14c, 
            0x14c, 0x15d, 0xf4, 350, 0xad, 0x13b, 0x75, 0x164, 0xab, 220, 0xba, 0x9e, 0x99, 0x9e, 0x5c, 0x131, 
            0xb6, 0xa2, 0xa2, 0x79, 0x127, 0x177, 0x145, 0x99, 0x76, 0xa4, 0x5c, 0xa2, 0x76, 0xb3, 0x5c, 0, 
            0x99, 0xaf, 0x7d, 0, 0x134, 0xa2, 0xfb, 0x14e, 0x15c, 0xb0, 0xbb, 0x11, 0x177, 0x14e, 0x86, 0x74, 
            340, 0x36, 0x54, 340, 0xaf, 0x74, 0x6d, 0x80, 0x86, 10, 0x159, 0x171, 0x171, 0x99, 0x12, 330, 
            0x11e, 0x12e, 0x12e, 0x12e, 0x12e, 0x12f, 0x12f, 0x12f, 0x12f, 0x12f, 0x12f, 0x12f, 0x12f, 0x12f, 0x130, 0x130, 
            0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 0x130, 
            0x131, 0x131, 0x131, 0x131, 0x131, 0x131, 0x131, 0x131, 0x131, 0x131, 0x131, 0x131, 0x131, 0x132, 0x132, 0x132, 
            0x132, 0x132, 0x132, 0x132, 0x132, 0x132, 0x132, 0x132, 0x133, 0x134, 0x134, 0x134, 0x134, 0x135, 0x135, 0x135, 
            0x135, 0x135, 0x135, 0x135, 0x135, 0x135, 0x135, 0x135, 0x135, 0x135, 0x135, 0x135, 310, 310, 310, 310, 
            310, 310, 310, 310, 0x137, 0x137, 0x137, 0x137, 0x137, 0x138, 0x138, 0x138, 0x139, 0x139, 0x139
         }, { 
            0x40, 0xf9, 0x42, 0, 0x88, 0x174, 0x15b, 0x162, 0x6b, 0x182, 0x14d, 80, 0x4b, 6, 0x25, 0xf3, 
            0x146, 0x164, 0x164, 0x89, 0xf1, 0x13a, 0x177, 0x163, 0xfc, 0x161, 0xf6, 0xf1, 0x178, 0xc6, 0x144, 0x52, 
            0x52, 0x6c, 0x54, 0xfe, 0xe4, 0xd0, 0x133, 0xed, 0x3e, 0x86, 0xa4, 0x54, 0x16f, 340, 0xe8, 0xe8, 
            0x14c, 0x40, 0x11, 0x13, 0x171, 0x138, 0x61, 350, 0xb3, 0x2f, 0x79, 0xb7, 0x54, 0xa9, 0x15c, 0, 
            0x14c, 0xa4, 0x15c, 0xed, 0xf5, 0x119, 0x15c, 0x144, 0xc4, 0xf5, 0x66, 0xf8, 160, 0x151, 0x81, 0xf9, 
            0x7c, 0x164, 0x22, 11, 0x6b, 0x155, 0x175, 240, 0x14c, 0xa7, 14, 0x163, 0x161, 0x81, 0x39, 0x3f, 
            0x79, 0x139, 0x139, 0x139, 0x139, 0x139, 0x139, 0x139, 0x13a, 0x13a, 0x13a, 0x13a, 0x13a, 0x13a, 0x13a, 0x13a, 
            0x13a, 0x13a, 0x13a, 0x13a, 0x13a, 0x13b, 0x13b, 0x13b, 0x13b, 0x13c, 0x13c, 0x13c, 0x13c, 0x13c, 0x13c, 0x13c, 
            0x13c, 0x13c, 0x13c, 0x13c, 0x13d, 0x13d, 0x13e, 0x13e, 0x13e, 0x13e, 0x13e, 0x13e, 0x13f, 0x13f, 0x13f, 320, 
            320, 320, 320, 320, 320, 320, 320, 320, 320, 320, 0x141, 0x141, 0x141, 0x141, 0x141, 0x141, 
            0x141, 0x142, 0x142, 0x143, 0x143, 0x143, 0x143, 0x143, 0x143, 0x143, 0x143, 0x143, 0x143, 0x143, 0x143, 0x143, 
            0x143, 0x143, 0x143, 0x143, 0x144, 0x144, 0x144, 0x144, 0x144, 0x144, 0x144, 0x144, 0x144, 0x144, 0x145
         }, { 
            0x127, 0x86, 0xf1, 0x162, 0x89, 330, 0xb2, 0xa4, 0x41, 0x132, 0x9a, 0x6b, 0x6b, 9, 0x51, 0x145, 
            0x13f, 0x165, 0x12d, 0xf3, 0x145, 0xd0, 0x145, 0xa7, 0x44, 0x4b, 8, 0x181, 0x144, 0x18, 0xbd, 0, 
            0x9c, 0x81, 0x139, 0xb8, 340, 190, 0x81, 0x11c, 0x155, 0x159, 0x106, 0x145, 0x54, 0x163, 0xba, 0x145, 
            0x108, 0x14f, 0x14b, 350, 0x11c, 0x178, 0x131, 0x17a, 0x183, 0x135, 0x163, 0xbc, 0x9c, 70, 0xf9, 0, 
            330, 0x148, 0x165, 0x162, 350, 0x7e, 8, 0x126, 0x2f, 330, 0x147, 0xa6, 0xe2, 0x105, 0x5c, 0x149, 
            0x153, 0x6b, 0x15c, 0xe8, 0x75, 0x15c, 70, 0xcf, 0x14b, 0x74, 0x79, 180, 0x15c, 0x146, 350, 0x134, 
            0x178, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 
            0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 0x145, 
            0x145, 0x146, 0x146, 0x146, 0x146, 0x146, 0x146, 0x146, 0x146, 0x146, 0x146, 0x147, 0x147, 0x147, 0x148, 0x148, 
            0x148, 0x148, 0x148, 0x148, 0x148, 0x148, 0x148, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 
            0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 0x149, 
            0x149, 0x149, 0x149, 0x149, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330
         }, { 
            0x19, 0, 0xf1, 0x137, 0x117, 0x3e, 0xaf, 0x145, 0x177, 0x23, 250, 0xe8, 0x162, 0x7d, 0xae, 0xf6, 
            0x15d, 0x7e, 0x146, 0x14e, 0xb6, 0x174, 0x174, 180, 0x162, 0xac, 0x30, 0xa4, 0xb6, 0x14e, 0x20, 0xc4, 
            0x187, 0x126, 0xf9, 0x133, 0x177, 0xe7, 0x7f, 250, 0x11, 0xa8, 0x66, 330, 0xf1, 0x17d, 0x51, 0xa8, 
            0x88, 0x88, 0x15d, 0x135, 0x80, 0x100, 0x14e, 0x149, 0x178, 0x157, 0x126, 40, 0x24, 0x3a, 0xa4, 0, 
            320, 0x15c, 0x83, 0x37, 0xf1, 0x5c, 0x14d, 0x119, 0xf6, 350, 30, 0xa4, 0x16c, 0x155, 0x17a, 0x16b, 
            0x14f, 0xb7, 0x14f, 0xf1, 0x105, 0x7d, 0x6d, 0x181, 0x81, 0x12, 110, 0x4f, 0xa2, 0x81, 0x9c, 0xc1, 
            0xa4, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 330, 
            330, 330, 330, 0x14c, 330, 330, 330, 330, 330, 0x14b, 0x14b, 0x14b, 0x14b, 0x14b, 0x14b, 0x14b, 
            0x14b, 0x14b, 0x14b, 0x114, 0x14b, 0x14b, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 
            0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 0x14c, 
            0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 0x14d, 
            0x14d, 0x14d, 0x14d, 0x14d, 0x14e, 0x14e, 0x14e, 0x156, 0x14e, 0x14e, 0x14e, 0x14e, 0x14e, 0x14e, 0x14e
         }, { 
            0xf9, 0xd4, 0xaf, 70, 0x14e, 0x17a, 0xad, 0xa4, 0xad, 0xe3, 0x15b, 0xe8, 0x117, 0x15b, 350, 0x11e, 
            330, 0x18, 250, 0xfb, 0x18, 0xb6, 0x81, 0x17a, 0x181, 120, 0x195, 0xe5, 0x178, 0xb5, 0x4d, 0x8f, 
            0xc0, 330, 140, 0x163, 250, 0xab, 0x155, 0x11e, 0x13a, 0x14d, 0x162, 0x74, 0x145, 0x3b, 0x26, 0x145, 
            0x3b, 0x180, 0x58, 0x162, 0x15c, 0x54, 230, 0x81, 0x178, 0x39, 0x15c, 0x178, 0x81, 0x177, 0x14f, 0, 
            0xfe, 0x177, 0x89, 30, 0x15c, 0xfe, 320, 0xab, 0xe4, 220, 0x189, 14, 280, 0x86, 0x95, 0x156, 
            0x175, 0x15c, 0xe0, 0x54, 0x3e, 0x54, 0x67, 0x177, 0x177, 0xfe, 0x15c, 320, 0xc7, 0x60, 0x155, 0x174, 
            250, 0x14e, 0x14e, 0x14e, 0x14e, 0x14e, 0x14e, 0x14e, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x7c, 0x14f, 
            0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x14f, 0x150, 0x150, 0x150, 
            0x150, 0x150, 0x150, 0x150, 0x150, 0x150, 0x150, 0x151, 0x151, 0x151, 0x151, 0x151, 0x151, 0x151, 0x151, 0x151, 
            0x6c, 0x151, 0x151, 0x151, 0x151, 0x151, 0x152, 0x152, 0x152, 0x152, 0x152, 0x152, 0x152, 0x153, 0x153, 0x153, 
            0x153, 0x153, 0x153, 0x153, 0x153, 0x153, 340, 340, 340, 340, 340, 340, 340, 340, 340, 340, 
            340, 340, 340, 40, 340, 340, 340, 340, 340, 0x155, 0x155, 0x155, 0x155, 0x155, 0x155
         }, 
        { 
            0x162, 0xd0, 20, 0, 0xdd, 0xf1, 0x94, 0x102, 0x7e, 0x188, 0xc4, 0x81, 0x4d, 0x107, 0x17a, 0x66, 
            0x15d, 0x8a, 0x151, 0, 0x9a, 0xd3, 0x11e, 0x14f, 0x9a, 0xa4, 0x87, 0x11a, 0x81, 0x175, 0xac, 0x5c, 
            0x15c, 0x15, 0x17e, 0x123, 0xfd, 0xa4, 0x153, 0x130, 0x9a, 0x132, 0x163, 0xab, 0x25, 0x20, 0x3b, 0xa7, 
            0xe5, 0x51, 0x163, 0x159, 70, 0x177, 0x15c, 0xf1, 0x68, 0x90, 0xf1, 0x135, 0x135, 0x54, 0x178, 0, 
            0x14f, 0x41, 0x9a, 0x13d, 0x161, 0x161, 0x163, 0x54, 0x162, 0x13d, 0x159, 0x15c, 0xe4, 0x39, 0x165, 0x12e, 
            0x60, 0x76, 0x105, 0x163, 200, 0x84, 0x12d, 0xe2, 0x10f, 0xd3, 350, 0x81, 0x76, 0x94, 0xa6, 0xa4, 
            0x11c, 0x155, 0x155, 0x155, 0x155, 0x156, 0x156, 0x156, 0x156, 0x156, 0x156, 0x157, 0x157, 0x157, 0x157, 0x157, 
            0x157, 0x157, 0x157, 0x157, 0x157, 0x157, 0x157, 0x157, 0x157, 0x158, 0x158, 0x158, 0x158, 0x158, 0x158, 0x158, 
            0x158, 0x158, 0x158, 0x158, 0x158, 0x158, 0x158, 0x158, 0x158, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 
            0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 
            0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x159, 0x15a, 0x15a, 0x15a, 0x15a, 0x15a, 0x15a, 
            0x15a, 0x15a, 0x15a, 0x15a, 0x15a, 0x15a, 0x15a, 0x15a, 0x15a, 0x15a, 0x15a, 220, 220, 220, 220
         }, { 
            0x194, 0x15c, 0x41, 0x14f, 0x14c, 0x145, 0x10, 0x1a, 0x5c, 0x116, 0xef, 14, 240, 0x7d, 0x17d, 0x7d, 
            0x36, 0x5c, 0x39, 0x166, 0x4f, 0x51, 0x14d, 0x157, 0x11, 0x100, 0xb6, 0x9e, 5, 0x16b, 0x79, 0x1a, 
            0x12b, 0xd8, 0x39, 0xa6, 0x3a, 0x11e, 0x171, 14, 0x9e, 240, 0x177, 0, 0x11e, 0x141, 0x11c, 11, 
            0x14f, 20, 0x23, 0x9d, 0xad, 330, 0x14c, 0x9e, 0x174, 0x38, 0x86, 360, 0x11c, 0x7d, 0x15c, 0, 
            0x9e, 0x158, 330, 0x53, 0x54, 0, 6, 110, 0x5c, 0x5c, 0x14c, 100, 15, 0x159, 340, 0x88, 
            0xe9, 0xb8, 0xbd, 0xbd, 0xeb, 0x11c, 0x126, 0x5c, 0x175, 0x88, 0xbd, 0x137, 0xa6, 220, 0x177, 0x89, 
            330, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 220, 0x15b, 0x15b, 0x15b, 0x15b, 
            0x15b, 0x15b, 0x15b, 0x15b, 0x15b, 0x15b, 0x15b, 0x15b, 0x15b, 0x15b, 0x15b, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 
            0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 
            0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 
            0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 0x15c, 
            0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d, 0x15d
         }, { 
            0x116, 0x145, 330, 310, 0x162, 0x9e, 0x4b, 70, 0xf6, 0xe3, 0x5c, 0xc2, 350, 0x60, 250, 0x171, 
            130, 100, 0x3d, 0x7d, 0xb3, 250, 0x7d, 0x145, 0x88, 250, 0xb3, 0x9e, 0x11a, 0x5c, 100, 0x159, 
            310, 0xf9, 130, 50, 0x177, 0x21, 0x5c, 0x39, 0x177, 0x14f, 0xfb, 0x5b, 0x11c, 0x66, 0x14f, 0x7a, 
            0xf9, 0x151, 0xd0, 0xf1, 0xaf, 0x16f, 14, 0x151, 0x117, 0x5f, 0x177, 0x156, 40, 330, 0x15c, 0, 
            0xaf, 0x88, 330, 0x159, 330, 0x159, 0x42, 0x54, 0xf9, 0xf9, 0x80, 0x5c, 0x4f, 0x157, 0x40, 0x72, 
            30, 0x132, 340, 0x81, 0x15c, 0x102, 0x157, 0x15d, 0x116, 0xf1, 320, 0x5c, 0x157, 0x15d, 0x4b, 0x52, 
            0x158, 0x15d, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 350, 
            350, 350, 350, 350, 0x15f, 0x160, 0x160, 0x160, 0x160, 0x160, 0x160, 0x160, 0x160, 0x160, 0x160, 0x160, 
            0x160, 0x160, 0x160, 0x160, 0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 
            0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 0x161, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 
            0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 
            0x162, 0x162, 0x162, 0x162, 0x162, 340, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162
         }, { 
            220, 0x127, 0x11a, 0x15d, 0x15d, 0x88, 0x14e, 0xcc, 0x23, 0x161, 0x177, 0x152, 80, 0x150, 0xbf, 0x119, 
            0x159, 0x10c, 0x180, 340, 0x15c, 0x15c, 0x129, 0x25, 110, 0x11a, 110, 340, 0x175, 0x17a, 0x176, 0x60, 
            0x182, 0x171, 0x61, 0x54, 0x7d, 0x41, 0xab, 0x135, 0x15a, 0xd9, 0xe2, 0x179, 0x58, 0x15c, 0x86, 220, 
            0x16f, 0x15c, 0x15c, 250, 0x173, 0xed, 14, 0x152, 250, 20, 0x37, 0x185, 0x132, 0x17a, 0x2f, 0, 
            0x174, 0x160, 340, 0x157, 0x15c, 120, 110, 0x11c, 0xf5, 0x14e, 0x11c, 0x70, 70, 0x73, 0x66, 0xfb, 
            0x79, 0x81, 0x75, 0x57, 0x15a, 0x145, 0x11a, 0x179, 0x13a, 0xbd, 0xc2, 0xb3, 0x79, 0x159, 0x152, 0x62, 
            0x4d, 0x162, 0x162, 0x162, 0x162, 0x162, 0x162, 0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 
            0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 0x163, 0x164, 0x164, 0x164, 0x164, 220, 
            0x164, 0x164, 0x164, 0x164, 0x164, 0x165, 0x165, 0x165, 0x165, 0x165, 0x165, 0x165, 0x165, 0x165, 0x165, 0x165, 
            0x165, 0x166, 0x166, 0x166, 0x167, 0x167, 0x167, 0x167, 0x167, 0x167, 0x167, 360, 360, 360, 360, 0x169, 
            0x169, 0x169, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 0x16a, 
            0x16b, 0x16b, 0x16b, 0x16b, 0x16c, 0x16d, 0x16e, 0x16e, 0x1c, 0x16e, 0x16f, 0x16f, 0x16f, 0x16f, 0x16f
         }, { 
            0x13, 0x137, 0x15c, 0xa2, 0x17a, 0x98, 250, 0x149, 0x5c, 0x177, 0x102, 50, 0x9f, 0x4b, 0x98, 0x15c, 
            0x139, 0x39, 11, 0x1f, 0x161, 0x91, 0x7f, 0xf6, 0x11f, 3, 0x162, 0x14e, 0x24, 0x81, 0x14c, 0x149, 
            0x149, 90, 0x127, 0x15, 0x79, 0x83, 0x164, 0x175, 0x164, 70, 0x75, 0x20, 0x123, 0x81, 0x8f, 250, 
            0x30, 0x14e, 0x12b, 0x144, 0x14c, 0x51, 0x9d, 0x12e, 0x15c, 0xd0, 0x15d, 0x179, 0xe8, 0x181, 0x1f, 0, 
            0x23, 0x180, 0x5c, 0xf1, 0x130, 0x17f, 0x145, 0x86, 0xf7, 0x44, 0x176, 0x189, 0x184, 0xf3, 0x181, 0xa7, 
            0x7d, 0x5c, 0x14b, 0xb2, 0x11a, 0x10, 0x75, 0xe9, 0x162, 0x14f, 340, 0xe9, 0x11c, 0x155, 0x11c, 0x7a, 
            0x75, 0x16f, 0x16f, 0x16f, 0x116, 0x16f, 0x166, 0x16f, 0x16f, 0x16f, 0x170, 0x170, 0x170, 0x170, 0x170, 0x170, 
            0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 0x171, 
            0x171, 370, 370, 370, 370, 370, 370, 370, 370, 370, 370, 370, 370, 370, 370, 370, 
            0x173, 0x173, 0x173, 0x173, 0x173, 0x173, 0x173, 0x173, 0x173, 0x173, 0x174, 0x174, 0x174, 0x174, 0x174, 0x174, 
            0x174, 0x174, 0x174, 0x174, 0x175, 0x175, 0x175, 0x175, 0x175, 0x175, 0x175, 0x175, 0x175, 0x175, 0x175, 0x175, 
            0x175, 0x175, 0x175, 0x175, 0x176, 0x176, 0x176, 0x176, 0x176, 0x176, 0x176, 0x176, 0x176, 0x176, 0x176
         }, { 
            0x4b, 0x178, 0x135, 0x14f, 0x54, 240, 0x139, 0x9e, 0xf1, 0x162, 0x182, 0x17d, 330, 0x79, 0x15d, 0x13b, 
            0x14c, 0xc9, 0x23, 0x53, 0x17a, 0x15a, 0x159, 120, 0x155, 0x5b, 0xdd, 340, 0xc5, 0x15b, 0x145, 0x151, 
            0x134, 0x179, 0x116, 0xee, 0x13e, 120, 0x7b, 0x5b, 350, 0xbd, 0x14e, 0xbd, 0x14b, 0xf4, 0x175, 0x156, 
            0x135, 0x129, 9, 0x25, 0x171, 0x15c, 0x7e, 0x163, 0x14f, 0x14e, 0x132, 220, 220, 0x177, 0x162, 0, 
            0xea, 0x30, 0xa4, 0xc4, 0xc4, 0x117, 0x174, 0xc3, 0x7d, 0x16b, 0x185, 0xa6, 0x194, 0x16a, 340, 0x67, 
            330, 0x181, 5, 5, 130, 0x174, 0x15c, 0x14e, 0x7e, 0xb6, 0x173, 0x14c, 0x141, 0x39, 340, 0x16e, 
            0x111, 0x175, 0x176, 0x176, 0x176, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 
            0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 
            0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 0x177, 
            0x178, 0x178, 0x178, 0x178, 0x178, 0x178, 0x178, 0x178, 0x178, 0x178, 0x178, 0x179, 0x179, 0x179, 0x179, 0x179, 
            0x179, 0x179, 0x179, 0x179, 0x179, 0x179, 0x179, 0x179, 0x179, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 
            0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a, 0x17a
         }, { 
            330, 0x16f, 0x48, 0x176, 0x14e, 0x9e, 0x4b, 350, 0x88, 0x5c, 0x188, 0x7f, 20, 0x79, 0x17d, 0x149, 
            0x16d, 0x16f, 0x177, 0x7f, 0x130, 0x16d, 240, 0x11b, 0x155, 0x16a, 0x130, 0x3a, 0x12b, 0x14c, 0x5c, 0x80, 
            0x171, 400, 0x15c, 2, 0x171, 0x79, 0x14f, 0x15c, 0x15c, 0x116, 0xff, 400, 0xf3, 0x48, 0x12e, 0x74, 
            0x179, 0x6d, 0x15c, 350, 140, 0x162, 0x7d, 0x79, 70, 0x174, 0x155, 360, 0xa2, 0x11a, 0x145, 0, 
            0x1f, 0xa4, 0x15c, 15, 0x174, 0x159, 0x4b, 0x27, 0x145, 0x27, 220, 0x1f, 0xff, 0x15d, 0x9e, 0x23, 
            0x14f, 0xd4, 0x77, 360, 0x15c, 0x3a, 0x171, 0x159, 70, 320, 0x102, 0x152, 0x152, 14, 0x179, 0x11a, 
            340, 0x17a, 0x17a, 0x17a, 0x17a, 0x17b, 0x173, 380, 0x17d, 0x17d, 0x17d, 0x17d, 390, 0x17d, 0x17e, 0x17e, 
            0x17e, 0x17e, 0x17e, 0x17e, 0x17e, 0x17f, 0x17f, 0x17f, 0x17f, 0x17f, 0x17f, 0x180, 0x180, 0x181, 0x181, 0x181, 
            0x181, 0x181, 0x181, 0x181, 0x181, 0x174, 0x181, 0x181, 0x182, 0x182, 0x182, 0x182, 0x182, 0x182, 0x182, 0x182, 
            0x167, 0x182, 0x182, 0x182, 0x182, 0x182, 0x182, 0x183, 0x183, 0x183, 0x183, 0x183, 0x183, 0x183, 0x184, 0x184, 
            0x184, 0x184, 0x185, 0x185, 0x185, 0x185, 0x185, 0x185, 0x185, 0x185, 390, 390, 0x187, 0x187, 0x187, 0x187, 
            0x188, 0x188, 0x189, 0x189, 0x189, 0x16f, 0x189, 0x189, 0x189, 0x189, 0, 0, 0, 0, 0
         }, { 
            0xf3, 0x72, 0x14b, 0x5c, 0x72, 0x6b, 0xad, 330, 330, 0xa8, 0x6b, 70, 0xad, 0xf1, 0xa4, 0x3d, 
            15, 0x11e, 0x14c, 0x53, 0x177, 0x177, 0x159, 0x159, 40, 0x79, 0x13f, 0x15c, 0x15c, 0x159, 6, 0x73, 
            0x4b, 40, 0x159, 0x9a, 0x57, 0x86, 240, 330, 0x77, 0x17a, 0x7c, 0x52, 330, 0x7b, 0x146, 0x77, 
            0x3e, 0x183, 0x52, 0x15c, 3, 0xe8, 0xc7, 0xe8, 0x60, 0xc7, 0x161, 0xc4, 0x126, 0x77, 0xb8, 0, 
            0xc4, 3, 0x162, 0xd0, 14, 0x162, 0x7c, 0x13d, 0xb8, 330, 0x15c, 0x162, 40, 0x130, 0x77, 0x88, 
            11, 0x175, 0x165, 0x54, 0x17, 0x5f, 0x133, 0x15c, 0x6c, 0x143, 0xec, 0x7b, 0x4f, 0x130, 0x143, 0x170, 
            0x177, 40, 0x5c, 0x149, 0x57, 0xd1, 0x10c, 0xe8, 0x5d, 0x24, 0x5b, 0xcb, 0x4b, 0x11e, 0x162, 0xeb, 
            14, 320, 220, 220, 0x177, 0x3e, 0x150, 0x15d, 0x99, 0x162, 90, 0x132, 0x3f, 0x5c, 200, 0xd4, 
            0x5c, 0xf1, 0xbd, 11, 0x111, 0x61, 0x16b, 0x119, 0x36, 0x159, 0x88, 0x126, 0x15b, 0x159, 250, 0xee, 
            0x66, 0x99, 15, 0x16b, 0x62, 0x161, 0x1b, 0x15c, 0x146, 0x83, 0x94, 0x66, 0x8b, 0x9c, 0x5c, 0x159, 
            0x143, 150, 0xea, 0x88, 0x7f, 0x7b, 0x15c, 0x13a, 0x144, 0x39, 0x42, 370, 0xa1, 0x10c, 0x15c, 0xc6, 
            0x102, 0x162, 0xe8, 0x158, 0x141, 0x149, 0x20, 0x19, 0x8d, 0x17a, 0xd6, 0x8a, 0x161, 0x15c, 0x60
         }, { 
            0x4d, 0x17a, 0x11c, 14, 0x182, 0x4d, 0x66, 0xe9, 0x4e, 0xb5, 0x133, 0x11b, 0x98, 0x54, 0x138, 0x15c, 
            0x25, 0xb8, 110, 0x52, 0xaf, 170, 0x79, 0x57, 0xe9, 0x182, 0x7c, 340, 0x16c, 0x80, 0x57, 0x169, 
            0x7d, 350, 0x157, 0x175, 0x119, 0x12, 0x12, 0xf9, 0x119, 0x2a, 0x169, 0x179, 0x9d, 360, 0x2f, 0x23, 
            0x117, 310, 0xe5, 0x5e, 0x14c, 0xb5, 0x7d, 0x12b, 0x54, 0x130, 0x30, 0x30, 0x177, 0x5c, 370, 0, 
            70, 130, 0x152, 0x2d, 0x165, 10, 0x167, 0x9d, 0x53, 0x19, 0x5c, 0x11b, 0x15c, 390, 0x54, 0x60, 
            0x10d, 0x16b, 0xa8, 0x15c, 7, 0x23, 0x143, 0x177, 0x17f, 0x10, 0x165, 0x16e, 0x39, 360, 0x159, 240, 
            0x116, 0x13a, 320, 0xd0, 0x56, 0x5c, 0x4d, 0x161, 0x95, 140, 0x17a, 0x15c, 0x137, 30, 0x80, 0xd8, 
            0xc5, 0x27, 0x159, 0xa4, 0xf9, 0xa4, 0x162, 0xed, 0x160, 0x126, 0x53, 0xf3, 0x10b, 0xe1, 0x181, 0x11e, 
            0xb3, 0x148, 14, 0x135, 100, 0x92, 0x86, 0x52, 0x159, 0x14f, 0x5c, 0x145, 0x183, 0x194, 0x131, 0x12, 
            0xdd, 0x25, 330, 0x83, 0x7d, 0x80, 0x85, 0x13a, 0x155, 0x39, 0x13a, 0x13f, 0x119, 0xf3, 0x185, 0x164, 
            0x33, 0x3e, 330, 0x157, 0x72, 0x68, 0x1f, 0x99, 10, 240, 0x72, 0x54, 0x54, 0x129, 0x126, 0x146, 
            0x159, 20, 0x67, 0xb8, 0x14f, 0xb0, 0xef, 0x13, 350, 0xb3, 0xa2, 0xa7, 0x74, 0xa9, 0x14c
         }, { 
            0x143, 350, 130, 0x17e, 0x14c, 0x169, 14, 70, 0x11e, 0x159, 0, 0x155, 0xad, 0x17e, 0x169, 0x165, 
            14, 0x179, 0x53, 0x165, 330, 0x152, 330, 0x24, 0x24, 0x14b, 0x131, 0x184, 0xa4, 0x116, 0xf8, 0x15d, 
            0x14c, 0x182, 0x88, 0xf6, 0x3e, 0x2f, 0x175, 0x13c, 0x3e, 330, 0x171, 0x88, 0x81, 250, 40, 0x7b, 
            0x156, 0x137, 0x4a, 0x58, 0x12d, 50, 330, 0x173, 0x129, 0x15d, 250, 0x7d, 0xfc, 0x181, 0x145, 0, 
            0xaf, 0x3a, 0xf9, 0x182, 0x135, 250, 0x25, 120, 0x7f, 0x7f, 0x80, 0x16a, 0x164, 0x4d, 0x185, 0x149, 
            0x8f, 0x88, 0x23, 0xe3, 0x164, 0xe0, 0xf1, 320, 0x15c, 0xd1, 0xab, 0xba, 0x94, 0x182, 0xf2, 0x17a, 
            250, 0x127, 0xed, 0x178, 0xc2, 0x159, 0x81, 0x72, 0x116, 0xdf, 0x86, 0xcc, 0x61, 110, 0x3e, 0x173, 
            250, 0x15c, 0x98, 0xa2, 0x62, 0x81, 0x79, 0x11a, 0x60, 0xfb, 0x176, 0x7a, 340, 0x7f, 90, 0x98, 
            0x18b, 0x184, 0x181, 0x145, 0x162, 0x11a, 0x1f, 0x12b, 0x23, 0x7d, 0x156, 0x15b, 0x4b, 0x162, 0x155, 3, 
            0x3e, 0x182, 0xe9, 0xc4, 0x3a, 0x129, 0x11c, 0xbd, 0x174, 0x7d, 0x16d, 0x7f, 0x88, 0x159, 0x171, 0x23, 
            0x39, 130, 0x189, 0x149, 0xf3, 0x83, 8, 0x3f, 0x189, 11, 0x151, 0x57, 0x177, 0xd4, 0x184, 0x2c, 
            0xe8, 0x145, 120, 0x145, 330, 0x6b, 0xf8, 0x98, 0xb7, 0x149, 80, 0x13, 0xe8, 11, 0x15b
         }, { 
            0x171, 0xe2, 0x17a, 0xd0, 0x15c, 0x5c, 0x4a, 0x4a, 0x17a, 0x188, 380, 0x14d, 0x41, 0xe9, 0x177, 0x81, 
            0x17, 0x37, 250, 0x11e, 0x13c, 50, 0x91, 0xd4, 0x14e, 0x15, 0x188, 0xc6, 0x11e, 0x80, 0x7f, 0, 
            0x7d, 0xf1, 0x148, 0x145, 0x81, 0xfc, 0xd4, 0x86, 0xd4, 0xb2, 0xaf, 0xa3, 0x148, 0xfb, 0x185, 0xf5, 
            0x15c, 0x3e, 0x183, 0xe7, 0x176, 0x162, 0x49, 0x2d, 0x160, 0x177, 0x16f, 0x23, 320, 0x131, 0x54, 0, 
            0x185, 0x101, 0x16f, 0x13e, 0xf4, 0x171, 0x3f, 0x135, 0x5c, 0xac, 360, 14, 0x26, 0xaf, 0xa8, 0x131, 
            0x177, 0x129, 330, 0x99, 0x5c, 0x181, 0xf4, 0x177, 0xe2, 0x183, 0xa6, 0x16a, 0xfe, 0x13e, 0x86, 0x14c, 
            0x178, 0x3e, 0x12f, 0x7c, 0x177, 0x17a, 150, 0xf5, 0x157, 0x165, 0xa4, 350, 90, 330, 0x54, 0xe8, 
            0x130, 0x159, 0x87, 0x159, 0x15d, 370, 0xee, 0x116, 0x184, 0xab, 0x53, 40, 0x77, 0xb5, 250, 280, 
            110, 0x5b, 0xbc, 340, 0x14f, 0x128, 0x14f, 0x88, 0x7d, 0x116, 0x3a, 0x20, 0x126, 15, 12, 0xf9, 
            12, 0x4b, 0x4e, 0x11e, 0x5c, 0x160, 110, 340, 0x149, 0x5b, 0x175, 0x98, 0xe8, 0x15c, 0xa4, 0xf1, 
            8, 0x58, 0xad, 0x3f, 0xaf, 0x22, 0x3e, 320, 0xd0, 0xc6, 5, 0x158, 0x41, 0x44, 0x8b, 0x116, 
            0x117, 0xcb, 0x57, 0x15d, 0x24, 0x11c, 0x68, 0x157, 0xa9, 0x163, 0x177, 3, 0x15c, 0xe8, 0xd1
         }, { 
            20, 50, 0x88, 170, 0x12e, 0x7f, 0x7f, 0xa8, 0x49, 100, 0x37, 14, 14, 0x86, 0x7f, 0x49, 
            0x27, 0x5c, 0x149, 0x164, 0xd1, 0x177, 0x164, 0x177, 40, 0x47, 0x145, 0xad, 170, 0x14c, 0x145, 0x9e, 
            0xff, 0x14f, 0xd4, 0x12e, 250, 0xfc, 0x33, 390, 330, 0x99, 0xf1, 170, 0x39, 0x52, 0x135, 0x4a, 
            0x5f, 0x9f, 0x102, 0xb3, 2, 0x5c, 0x86, 0x92, 0, 0x159, 0xba, 0x8d, 250, 0x194, 160, 0, 
            320, 0x177, 0x159, 0x135, 0x3b, 350, 0x162, 0x22, 0x16f, 0x66, 0x89, 0x164, 0x150, 0x38, 0x155, 0x4f, 
            0x102, 0x116, 0x98, 0x11e, 0x13f, 0xf1, 0x12f, 0x4b, 0xc7, 0xf1, 0xb8, 0x108, 0x98, 0xf3, 0x17d, 0x72, 
            0x74, 0xe7, 0x13c, 0x110, 0x38, 0x94, 0x41, 0x15d, 0xa3, 0x73, 0x5b, 0x163, 0xb6, 0x160, 0xa7, 0x25, 
            0x150, 0xe8, 0x15c, 0x1a, 0x80, 200, 70, 0xf3, 0x5c, 0x143, 0x152, 0xf1, 0x14d, 0x54, 0x163, 0x165, 
            0x51, 0x5c, 0xa4, 0x4b, 0x86, 0xe8, 0x177, 0x109, 0x14c, 0x20, 0x30, 0xf6, 0x149, 0xf3, 0xf1, 0x116, 
            15, 0x17a, 0x93, 0x15c, 0xc4, 0x58, 0xeb, 0xad, 6, 0xc6, 0x86, 0xfe, 0xf7, 0x25, 0x54, 0xab, 
            0xd3, 0x15d, 0xb8, 350, 0xf8, 0xc1, 0x137, 0xf3, 0x15c, 0x100, 14, 0x2f, 0x86, 0x13a, 0x79, 0x17a, 
            0x139, 0x7f, 0x54, 0x102, 0x151, 0xfb, 0x79, 0x157, 0xc2, 0xf1, 0x80, 0x26, 0x7e, 0xb3, 350
         }, { 
            250, 0x98, 0x3e, 0xab, 0x38, 5, 0x175, 0x4f, 0x98, 0x15a, 0xe7, 11, 0x61, 0x61, 0xe4, 0x17a, 
            0x105, 0x4b, 6, 0x179, 0x177, 220, 0x8f, 0x174, 0x177, 0x11c, 0xed, 0x4d, 0x5f, 0x86, 0x14e, 0x65, 
            0x158, 0x8b, 0xfb, 0x179, 0x182, 0x177, 0x119, 0xa7, 0x162, 280, 0x161, 0x163, 0x15d, 0x174, 0x143, 0x54, 
            0xf7, 0x179, 0x15c, 0xab, 0x174, 0x171, 0xa7, 0x182, 0x79, 0x144, 0x2e, 0x79, 140, 0x15c, 0xe7, 0, 
            0xf3, 0x67, 0xd1, 0xed, 100, 11, 0xb2, 0xe1, 0xa7, 0x108, 0x106, 0x5c, 0x15a, 0x14c, 0x2a, 0x31, 
            0x124, 0x158, 0x161, 0x72, 0x11e, 0x54, 0x182, 0x54, 0x165, 12, 0x171, 0x162, 0x165, 0x132, 0x61, 0x175, 
            0x14b, 0x157, 0x5d, 130, 0xb5, 300, 0x72, 0x179, 140, 14, 0x11c, 0x148, 0x161, 0x4b, 0xba, 0x161, 
            0xa4, 0x13c, 0x14c, 0x54, 0x12b, 0x161, 0x3e, 0x11a, 100, 0xa7, 350, 0x2d, 0x83, 0xf1, 330, 0x127, 
            130, 200, 0xf1, 6, 0x11e, 0x20, 0x138, 0x162, 0x77, 14, 0x54, 0x13c, 0x39, 0x34, 0x159, 0x185, 
            0x3a, 0x7d, 0x143, 350, 0x61, 0x6b, 0xf2, 0x53, 0x11a, 0x14d, 0x145, 0x1f, 0x8b, 0xf1, 0x99, 330, 
            0x4b, 10, 0xe0, 0x139, 0xae, 0xe1, 0x155, 0x7c, 0x175, 0x11c, 0x107, 0xc4, 0x4c, 11, 0x147, 0x6d, 
            0x5c, 0xa4, 9, 0x7d, 0x125, 0x9f, 350, 0x162, 0x129, 0xbc, 0x45, 330, 0xa6, 50, 170
         }, { 
            0x163, 0xaf, 0x14e, 0x21, 0x17d, 0x145, 0x155, 0x156, 0x174, 0x80, 0x171, 0x15, 0xa8, 0x52, 0x4f, 170, 
            0x5b, 0x111, 140, 0x77, 0x15c, 0x5c, 0x17f, 0x4d, 0x162, 0x7d, 0x72, 0xa2, 0xe5, 0xa4, 0xa4, 0xaf, 
            170, 0x38, 0x179, 0xa7, 0x165, 0x2f, 0x187, 15, 0x9c, 0x2f, 0x15c, 15, 15, 0, 8, 0x2f, 
            15, 0xe9, 0xd8, 0xd8, 0x175, 0x2e, 0x15c, 0x103, 0x4f, 0x11c, 0x107, 0x1f, 0x58, 0x162, 0x15c, 0, 
            0xf1, 0x16f, 0x144, 0x13c, 0x180, 0x135, 0x14d, 0x135, 0x4b, 0x178, 0x22, 0xd0, 0x177, 0x175, 0x17a, 0x132, 
            0x15c, 250, 0x79, 0x44, 0x161, 200, 0x15c, 0x81, 0xa9, 0x157, 0x49, 0x84, 0x161, 0xf9, 0x3e, 0x83, 
            0x15c, 250, 0x93, 340, 0xa8, 0x79, 0x157, 0x88, 0x109, 0x187, 0x5c, 0xbc, 0x4f, 0xf1, 0x72, 0x14f, 
            0x72, 0x145, 0x15c, 0x147, 0x128, 14, 0x6d, 0x12f, 0x107, 0x157, 0x14c, 90, 0xa4, 0x7b, 250, 0x71, 
            0x4f, 0xd4, 0xbd, 0xd8, 0x15c, 0x98, 0xa6, 0x37, 0x15c, 330, 0x169, 0xe4, 0x161, 0xa8, 0x56, 0x58, 
            0x135, 0xbb, 0x13d, 0x23, 0x54, 0xec, 0xd7, 0x81, 0x80, 0x166, 0x15c, 0x194, 0x89, 310, 0x15b, 2, 
            0xc7, 0x5c, 0x68, 7, 0x86, 0xef, 0xa9, 0xf3, 100, 0x41, 0x16f, 0x158, 0xf6, 0x162, 3, 0x155, 
            0x13, 0x99, 0x163, 0x11e, 0x4c, 0x29, 0x7d, 0x125, 0x171, 0xdd, 0x10f, 0xb3, 350, 0x177, 0x6b
         }, { 
            0, 0x149, 0xa6, 0x12d, 0x79, 0x61, 0x9d, 12, 0x36, 0x17a, 0xe7, 0x161, 0x179, 130, 0x162, 0x2e, 
            0x135, 0x12e, 0x163, 0xdd, 0x131, 0x12b, 0x159, 0x25, 0x135, 0x11c, 0x175, 0x161, 0x165, 0x4b, 0x7b, 0x12e, 
            0x145, 0xc9, 220, 0x27, 0x157, 0x12e, 0x11c, 0x177, 0x163, 0x129, 180, 100, 370, 0x174, 0x16, 0x25, 
            0x129, 0x49, 0x11c, 0xae, 0x177, 0x36, 0x100, 0xf3, 0x155, 0x162, 0x15c, 0x4b, 0xa8, 0x11c, 0xb5, 0, 
            0x155, 0x171, 0x134, 0x4d, 15, 15, 0xa4, 0x163, 0x161, 0xb3, 0xa4, 0x139, 0xf1, 0x116, 0x162, 0x107, 
            0x143, 0x54, 0x8d, 0x12, 0x150, 0x11a, 0x163, 0x35, 0x7b, 9, 0x86, 15, 0x141, 0x98, 0x66, 0x11c, 
            0x94, 0x174, 0x14f, 0xaf, 0x188, 0x33, 0x58, 0x77, 0xe8, 0x151, 0x181, 0x7b, 390, 0xca, 0x15c, 0x13e, 
            0x38, 0x11c, 0x15, 0x25, 0x5c, 0x93, 0x3b, 0xa1, 0x16f, 1, 220, 0x54, 0xc6, 0x15c, 0x12f, 0xa4, 
            0x4b, 14, 11, 0x68, 0xf6, 0x15d, 0x166, 0x8a, 0x56, 0x62, 0xab, 0x44, 0xd6, 0x4a, 0xcb, 0x161, 
            0x126, 0x98, 0x5c, 0x11a, 0x79, 0x37, 0xa9, 0x15c, 0x14e, 14, 0x2f, 0x65, 0x79, 0x153, 0x15c, 0xe1, 
            150, 0x4a, 0x5c, 0xc0, 0xbd, 0x16f, 0xd8, 0x5d, 0xc5, 0xb5, 0x25, 160, 0x5e, 0x4c, 0x16f, 0x12d, 
            0x16a, 330, 0x189, 0x5c, 0x53, 0x16b, 0xdd, 0xbf, 170, 0x17d, 0x179, 0x132, 0x74, 0x34, 0x114
         }, { 
            0x6a, 0x14b, 0x5c, 0x73, 0x151, 330, 0x66, 0xdd, 0x9f, 0x159, 0x24, 0x45, 0x194, 0x54, 0x162, 0x9f, 
            0x7c, 0x5e, 20, 330, 250, 0x14e, 0xf1, 0xf7, 0x179, 0x184, 0xed, 0xa2, 0xd0, 0x161, 0xef, 0x14d, 
            0x86, 0x160, 0x7f, 0x15c, 0xba, 0x10b, 11, 0x11e, 0x162, 0x165, 0x73, 0x99, 0x14d, 0x14d, 0x128, 0x131, 
            0xc2, 330, 0x107, 40, 0x182, 0x184, 0x15b, 0x149, 0x14d, 0x165, 0x7f, 0x160, 0xb8, 0x21, 0xaf, 0, 
            0xa8, 0x17d, 0x74, 0x7f, 0x143, 0x7f, 340, 0x3d, 14, 0x157, 14, 0x16e, 0x145, 0x176, 0xb8, 170, 
            0x4a, 0xbc, 0x15b, 0x110, 150, 0x53, 0xbc, 0x9b, 0xa6, 360, 0x1f, 0x161, 0xf1, 0x159, 0x1f, 360, 
            0xfb, 0x15f, 0x39, 20, 0x42, 0x9f, 0xa4, 0x11f, 0x2e, 0x16f, 0x37, 0xc9, 0xa4, 0x99, 0x81, 0x160, 
            0x99, 0x85, 0x128, 0x15d, 0x25, 0x81, 0xae, 0x94, 0x148, 0x79, 0xf6, 5, 0x129, 70, 0x8f, 0xd4, 
            110, 0x23, 0x12d, 0x5b, 1, 0x4c, 0x6d, 0x18e, 2, 2, 0x12d, 0x6f, 0x13a, 0x25, 0xe5, 0xa2, 
            0x1a, 0xea, 0xf1, 350, 13, 0x128, 0x3e, 0xbd, 0xe7, 0x88, 0xa8, 240, 0x29, 0x80, 0xde, 0xf6, 
            0xaf, 0x1c, 0x3d, 0x6d, 130, 0x156, 0x15c, 0x10d, 0xe8, 0x107, 0x1d, 0x7b, 0xca, 0x145, 0x7d, 0xc9, 
            0xb2, 0x74, 0xab, 0x161, 0x162, 0xf7, 0x162, 0x77, 0x145, 0x177, 0xe5, 0x131, 0x27, 0x16b, 0x68
         }, 
        { 
            330, 360, 0x177, 0x162, 0x15d, 0x187, 0xb8, 0x175, 0x45, 0x175, 0x163, 0x54, 310, 0xf2, 0xee, 0x27, 
            0x187, 0x2e, 0x161, 0x15d, 240, 0x187, 0x6a, 0x17f, 0xaf, 0x9e, 0x159, 0x132, 0x171, 0x130, 0x17f, 0x14c, 
            70, 0x130, 0xf9, 0x2d, 0x165, 0x4e, 0x8f, 0x128, 0x27, 0x36, 0x165, 0x160, 4, 0x16f, 0x7e, 0xea, 
            0x23, 0x162, 0xa4, 0x16a, 0x15c, 0x7e, 0x130, 0xee, 0xd8, 0x15c, 0x159, 0x15c, 210, 0x107, 0x11d, 0, 
            0x159, 0xab, 0xbd, 0xbd, 210, 0x150, 0x80, 0x11c, 0xbd, 0x159, 15, 0x11c, 0x15c, 330, 130, 0xf9, 
            0x15c, 0xa8, 0x3b, 0x173, 0xab, 0xee, 0xf9, 6, 0x175, 0x177, 6, 0xb0, 0x54, 200, 0x40, 0x14c, 
            0x7f, 0x145, 0x148, 0xb6, 370, 0x54, 0x4f, 0x5c, 0xf1, 0xf3, 0xf1, 250, 0x158, 0x14c, 5, 0x18f, 
            0x9e, 6, 0x74, 0x8f, 0x44, 0x7c, 0x153, 0x38, 0x60, 0xb8, 0xc1, 0x15c, 0x44, 0x7f, 0x157, 0x176, 
            160, 0x9d, 0x127, 0x159, 0x61, 0x14e, 0x68, 0x92, 0x88, 0x105, 220, 0x142, 0x167, 0x145, 0x162, 0x36, 
            0xae, 0x182, 0xba, 0x11b, 0x127, 0x5c, 370, 170, 0x3d, 0x12, 0x15c, 0x3f, 0x25, 0xe3, 50, 0x157, 
            0x15a, 0x73, 0x9d, 330, 0x20, 120, 220, 0x177, 0x80, 250, 270, 0x4f, 0xf9, 3, 0x65, 180, 
            0xd7, 0x165, 0x14b, 0xe4, 0x51, 0x105, 150, 0x11d, 300, 14, 0x87, 0xa4, 0x162, 0x14c, 0x15d
         }, { 
            0x93, 0x2a, 0x182, 0x4f, 0x162, 0x149, 0x6b, 0x59, 0xf1, 0xb7, 260, 0x3e, 0x126, 330, 0x15c, 30, 
            0x15c, 0x13c, 330, 0x195, 0xf3, 0xf9, 0x7d, 0x173, 0x15b, 0x15d, 0xe0, 80, 0x175, 0x151, 0x45, 0x164, 
            0x178, 0x54, 0xe8, 0x109, 0x150, 0x4b, 0x88, 0x49, 0x60, 0x15d, 0xf3, 8, 330, 0x102, 0x21, 0xd7, 
            0x52, 0x165, 0x15c, 0xf6, 0xe8, 0x68, 0x72, 0x15d, 0x89, 0x40, 0x15c, 0x178, 330, 0x57, 260, 0, 
            0x7b, 0x12f, 0x8d, 0x163, 0xaf, 0, 0x146, 0x4a, 0x182, 0xd0, 0x13c, 0x11c, 0xc1, 0xe8, 0x8f, 0xab, 
            0x13, 0x12f, 0x74, 20, 0xe8, 0x162, 0x126, 0x189, 0x15, 0x179, 310, 0x7c, 0x175, 0x11c, 0x185, 0x177, 
            0x86, 0x12a, 0x15c, 0x68, 0xb3, 0xd0, 0x119, 50, 0xbd, 0x74, 0x1d, 0x145, 0x145, 0xba, 0xcb, 370, 
            0x83, 0x88, 0xa8, 0x14f, 0x157, 0x77, 0x2a, 0x7b, 300, 0x15d, 0x44, 0x11c, 0x131, 0x13f, 330, 0x102, 
            0x162, 0x25, 0x15c, 0x14d, 20, 0x162, 0x7a, 0x1d, 0x128, 0xc4, 0x153, 130, 270, 0x17d, 0xca, 0xe8, 
            0x149, 0x66, 0xe4, 0x153, 0x14d, 320, 3, 0x162, 14, 0x5e, 5, 130, 0x1f, 0x14f, 170, 350, 
            0x11e, 0x3b, 0x35, 0x1f, 0x149, 0x177, 0xdf, 0x26, 0x149, 0x8b, 0x20, 0x2b, 0x127, 15, 0xd7, 0x74, 
            40, 0xe7, 0x37, 0x15a, 0x189, 0xd0, 0x54, 0x21, 0x15c, 0x15c, 0x13a, 0x159, 0x1b, 0x8b, 0x157
         }, { 
            0x138, 0x15c, 0x15c, 0x155, 0x173, 0xe4, 110, 0x111, 0x11b, 0x185, 0x185, 20, 0x17a, 0x25, 0x166, 0xee, 
            0x13a, 0xf3, 0x54, 0x170, 0xb8, 0x159, 0x54, 0xa4, 0x164, 0xe8, 0x15a, 8, 20, 0x81, 250, 340, 
            0x176, 0xc6, 330, 330, 0x3e, 0x7c, 0xc6, 0x130, 0x11a, 0x15c, 0x126, 0x98, 0x8a, 11, 0x181, 0x151, 
            0x72, 0x80, 0x25, 0x91, 0xb3, 0xed, 0x11c, 0xc5, 0x8f, 0x15d, 0x89, 0x179, 0x26, 0x14d, 0x13a, 0, 
            0xc4, 0xa2, 0x5c, 0x162, 340, 0x102, 0x188, 0x177, 0x125, 0xa4, 0x14c, 0x151, 0xfb, 0xe8, 0x15c, 0x17a, 
            0x14d, 0xc2, 0x95, 220, 0x14c, 0x14c, 0x153, 0x89, 0x1d, 160, 0x5c, 0xe8, 0x107, 0xbd, 0x15c, 0x15d, 
            0x65, 0x8f, 0x165, 11, 0x127, 0xf3, 0x99, 0x9a, 0x15c, 0x135, 0xfb, 0xf5, 0x151, 0x51, 0x20, 0x144, 
            0x27, 0x74, 0x34, 0x165, 0x99, 0x4b, 0xa3, 0x17f, 0x7f, 14, 0x129, 0xf3, 0x160, 0x83, 0x7f, 0x26, 
            40, 170, 0xbc, 310, 0x79, 0x121, 0x159, 0x145, 0x72, 0xc1, 0x8d, 0x12e, 0x194, 0x9a, 0x85, 0x9f, 
            0x162, 0x20, 330, 0x146, 0x7a, 0x4b, 250, 0xfc, 110, 310, 0xfc, 140, 0x17e, 0xe2, 0xf4, 270, 
            0xf1, 0x126, 0x1d, 0x53, 0x163, 0xc6, 190, 0x49, 0xbd, 0x61, 15, 0x146, 0x6c, 0x145, 0xa1, 0x58, 
            0x11e, 0xad, 0xaf, 0x15a, 0x126, 0x4a, 0xab, 0xb8, 0xb3, 0x155, 0xe2, 320, 0x72, 0xc1, 0x83
         }, { 
            3, 0x43, 0x161, 0x111, 0x8e, 0xf3, 0x126, 0, 0x40, 0x6b, 0x164, 0x177, 0x91, 0xf9, 0x14e, 0x174, 
            0x161, 0x169, 0x135, 0x36, 0x62, 0x72, 0x178, 0x13c, 0x194, 0xbc, 0x9f, 0x143, 0x182, 0x165, 11, 0x129, 
            0x162, 0x1f, 0x139, 20, 0x6b, 0x7c, 0x72, 0x87, 0x53, 0x1f, 0x143, 0x177, 320, 0x155, 0x149, 0x162, 
            0x137, 0x98, 0x181, 0xb1, 0x151, 0xf6, 0x11a, 0x6b, 0xb1, 0x15b, 0x86, 0x16e, 0x86, 0x14c, 0x138, 0, 
            0xb7, 240, 0xa4, 0xe2, 0x164, 0x24, 90, 0xa4, 0x133, 0x13, 0x17a, 0x175, 0x13c, 0xac, 0x187, 0x86, 
            0x20, 0x163, 0x7d, 0x59, 0x40, 0x132, 0x20, 0xb2, 0x95, 0xab, 0xe8, 0xaf, 0xa4, 0xf4, 0xef, 0x87, 
            0xc1, 0x77, 0x145, 0xa9, 0x7c, 0x175, 0x15d, 0x79, 0x17a, 0x5c, 340, 0x79, 0x132, 0x157, 0x7e, 0xac, 
            0x74, 0x157, 0x107, 0x129, 0x149, 0x9d, 0x145, 0x181, 0x87, 0x18f, 9, 330, 0xba, 0x77, 0x17a, 0xf1, 
            330, 0x127, 70, 0x181, 0xe8, 190, 0x58, 0x51, 0x30, 0x11a, 100, 0xaf, 0x121, 0x14f, 0x159, 190, 
            0xf9, 0x128, 120, 340, 230, 0x7d, 0x155, 0x148, 0xba, 0x159, 0xf6, 0x8f, 0x119, 0xb7, 350, 240, 
            0xa4, 0x107, 0x12e, 0x7a, 14, 0x153, 0x54, 0x131, 0xe3, 0xc2, 120, 350, 0x14e, 0x9e, 0x1a, 0x74, 
            0xb3, 0x77, 0xa6, 0x17a, 0x15c, 0xaf, 0x155, 0x58, 0x11e, 0x126, 0x116, 280, 0x13a, 0x1f, 0x9d
         }, { 
            0x187, 0xe7, 3, 0xe8, 0x14c, 0x158, 0x17f, 0xa4, 0x8f, 0x92, 0x12e, 0x9a, 70, 0x17f, 0x2c, 0x182, 
            0x176, 12, 0xd4, 0x183, 0x4a, 0x159, 0x42, 0x15c, 0xf3, 0x17f, 0x5c, 0x162, 130, 100, 0xb8, 0x20, 
            0x13f, 330, 0xa6, 0x132, 0x61, 330, 0x11e, 0x175, 0x194, 0xbc, 0xaf, 0x75, 0x10, 0x56, 0x9d, 0x90, 
            80, 0x149, 200, 0x143, 0x74, 60, 0x14c, 0, 0x7b, 0xa7, 0x4e, 0xbb, 0x8b, 0x15a, 0x11c, 0, 
            0xa6, 0x68, 0x14c, 70, 0x13c, 0x145, 0x143, 0x54, 0x106, 0x5c, 0x4b, 0x89, 0x175, 0x135, 0x16f, 0x74, 
            0x15a, 0x47, 0x14b, 0x162, 0x91, 0x11b, 120, 0x145, 0x54, 0x173, 0x1d, 0xf5, 0x11c, 0x72, 0x99, 310, 
            0x7f, 0x12b, 0xa4, 0x39, 0x1f, 0xa6, 0x107, 240, 14, 0x6d, 0x181, 0x6b, 0x14f, 350, 0x164, 0x52, 
            0x6d, 6, 10, 0x66, 0x3a, 0xbd, 0x161, 0x23, 0xd6, 0xf3, 0xf3, 0x149, 0xa8, 0xf3, 0x77, 0x7d, 
            0x7d, 0x184, 0x158, 0x149, 0x84, 0x16b, 0x15c, 0x4d, 0x7c, 0x83, 0x38, 0x73, 0xe3, 0x15, 0xa4, 0xf9, 
            0x14e, 0x135, 0xfd, 0x99, 0x145, 0x77, 0xaf, 0x2a, 120, 0xf9, 0x14b, 5, 0x60, 0x12e, 0xac, 0x14c, 
            170, 0x86, 0x14f, 0xbf, 0x12b, 0x9c, 0x157, 0x79, 0x13d, 0x177, 0x8e, 0x177, 0x5c, 0x4b, 0x1f, 330, 
            0x86, 0x1f, 0x83, 0xd9, 0xbd, 0x54, 14, 0x162, 40, 0x125, 0x51, 0x159, 0x149, 0x162, 14
         }, { 
            0x7f, 0x73, 0x13b, 0x183, 0x77, 0x15b, 0xc1, 0x7d, 0x47, 0x7d, 0x127, 0x99, 0x74, 0x155, 0x174, 0x81, 
            0x175, 15, 0x178, 0x182, 0x153, 0x15b, 0xba, 0xe1, 2, 0x57, 0xf3, 0xba, 0x12d, 0x12e, 0xe3, 0x14b, 
            0xa6, 0x12d, 0x8b, 0x185, 0x15b, 400, 0x147, 0x105, 0x131, 0x12d, 0xf4, 0xa4, 0x125, 0x17f, 20, 0xe2, 
            0x10c, 0xe8, 0x10f, 0x59, 0x182, 0x149, 350, 120, 0x137, 0xac, 0x8b, 300, 0x11c, 0x128, 0x143, 0, 
            0x6d, 0x175, 0x175, 0xb3, 0x15c, 0x163, 0x131, 0xd4, 330, 0x7c, 0x5b, 180, 0x87, 0x127, 0x185, 0x12d, 
            0, 0x53, 0x146, 0xc7, 0xaf, 0x12d, 0xdf, 0x185, 0x13d, 0x153, 100, 0x155, 0xa6, 0x128, 0xb6, 0xc4, 
            0xb3, 130, 0x182, 0x66, 0xd7, 0x162, 0x126, 0x37, 0x179, 0x116, 0xf5, 0x158, 0x100, 0x11e, 0xb0, 0x80, 
            0xec, 0x1d, 0xa4, 0xed, 0x141, 0x14c, 0x12d, 0x3e, 0x145, 0x4b, 0x83, 0x10, 0x81, 0x20, 14, 0x1f, 
            0xd9, 5, 0x163, 0x139, 0x149, 0x60, 0xc4, 0xe8, 2, 0xec, 0x25, 0xa4, 0x159, 0xf4, 0xea, 0x20, 
            0xa2, 370, 330, 0x116, 14, 0xd3, 0xc4, 290, 0x56, 0x56, 0x54, 0xd9, 0x182, 0x81, 0x88, 10, 
            0x169, 0x126, 0x54, 0x184, 0x15c, 0xd9, 0x12f, 0x14e, 0x75, 0xe9, 0xa4, 0xf1, 0x8f, 0x17f, 0x18, 0x177, 
            0x149, 5, 0xac, 0x116, 0x10, 0x30, 0x1f, 0x5c, 0x14d, 0x80, 0x162, 0x179, 0x5b, 0x143, 0x98
         }, { 
            14, 0x145, 0xac, 0x3e, 270, 0x183, 0x15c, 0xaf, 0x91, 0xf4, 0x34, 0xf1, 0x20, 0x131, 0xb6, 0x160, 
            0x1f, 0x53, 0x83, 0x10, 0x11e, 0x194, 0x153, 0x30, 0xad, 360, 360, 0x1a, 0xa4, 0x14b, 330, 0x8d, 
            290, 13, 370, 0xf3, 0x24, 0xaf, 0x75, 0x5c, 240, 0x12b, 0xf4, 0xee, 170, 0x111, 0x153, 0x14c, 
            0x24, 0x99, 0x126, 0xac, 0xcb, 120, 0xeb, 0x12b, 0x4f, 0x7f, 0xfb, 0x15a, 0x131, 0x14d, 0x162, 0, 
            0x80, 0x188, 0xa8, 0xf5, 160, 0x49, 0x150, 360, 0xf1, 0x7d, 0x178, 0x3d, 0x158, 350, 0x49, 0x88, 
            400, 360, 240, 0x138, 0, 370, 0x42, 0x116, 0x8b, 0x7d, 0x51, 0x12b, 0xaf, 0x87, 0x79, 0x162, 
            0xa6, 0x165, 0xe8, 0x11e, 0x58, 0x14f, 0x54, 0x179, 0x54, 40, 0x38, 0x94, 0x6c, 0x7e, 0x5e, 0x14e, 
            0x135, 0xab, 0xf1, 0x51, 0x117, 0x67, 0x4a, 0x11d, 0xac, 0xfb, 0x143, 0x182, 0x8f, 0x14d, 0x135, 0xbf, 
            0x79, 0x126, 15, 0x60, 0x17f, 0xc1, 130, 0x175, 0x107, 90, 0xa4, 0x15c, 0x7d, 0x12, 0xea, 0xb6, 
            0xa2, 0xc3, 0x110, 0x14f, 0xa8, 0x16e, 0x7e, 0xf3, 0x7f, 0x77, 390, 220, 0x5c, 0x2a, 0x167, 0x160, 
            0x42, 0x5c, 0x145, 0x12, 0xc1, 0x88, 0x8f, 0xad, 0x3f, 0x38, 0xee, 0xc1, 0x7c, 0x4d, 0x5f, 340, 
            0x158, 0x71, 220, 0xb3, 330, 0x79, 0xa6, 0xf1, 350, 0xf1, 0x74, 0x9a, 0x159, 0x30, 0x143
         }, { 
            0x181, 0x110, 0xf3, 0x181, 0xa2, 14, 0x138, 0x155, 0x15b, 0x4a, 0x68, 0x131, 250, 0x52, 0x37, 0x15c, 
            2, 0x183, 0x157, 0x40, 0x17a, 0x71, 0x17f, 0x5c, 0xd4, 110, 0x7b, 0xf7, 0x12, 350, 0x99, 0xd6, 
            340, 0x7d, 0x7d, 0xf3, 0x1d, 0x177, 0xc0, 0xa4, 0xa2, 0x5c, 390, 0x98, 0x117, 0xe7, 0x9c, 70, 
            0x164, 0x2e, 0x194, 0x10, 10, 0xaf, 0x14c, 0x97, 0xad, 0x4b, 0xaf, 0x7d, 0x9e, 20, 0xf3, 0, 
            220, 0x1f, 0x14d, 0x7d, 330, 100, 0x19, 0xd4, 0xa2, 0x33, 250, 0xe2, 0xb3, 390, 0xb0, 0x189, 
            0x15c, 0x88, 0x131, 0x17a, 0x9e, 330, 0x15a, 0x151, 0xe4, 0x151, 0xb7, 0x158, 0x177, 0x14c, 0x162, 0x15c, 
            0x20, 0x23, 0x86, 0xb8, 0x162, 0x163, 0x14b, 0xcb, 2, 0x131, 130, 120, 350, 0x34, 0x30, 0x155, 
            370, 240, 0x18, 250, 0xaf, 14, 360, 0x146, 0x145, 0x165, 0x132, 0x149, 280, 0xf1, 0x1d, 180, 
            0xa4, 0xe8, 0xbf, 220, 0x109, 0x7d, 40, 0x24, 0x30, 0x14e, 80, 0xe0, 0x17a, 200, 0x177, 0x174, 
            0xad, 0x85, 0xed, 0xaf, 0x14b, 0x14e, 0x161, 0x177, 320, 0x177, 0xab, 0x60, 0x3e, 0xa4, 320, 0x24, 
            0x8e, 160, 0x158, 0x100, 0x177, 0x175, 0x65, 0xf1, 0x139, 0x9b, 0x85, 0x75, 0x71, 0x66, 0x81, 0xb0, 
            0x87, 3, 340, 0x4f, 0x61, 0x54, 0x88, 0x182, 0x12d, 0xab, 40, 0x52, 70, 0xf3, 0x173
         }, { 
            0x177, 350, 120, 0x182, 20, 0x131, 0x105, 13, 0xac, 0x155, 0x9c, 0x1f, 370, 370, 0x85, 5, 
            0x41, 0x88, 0xa8, 0xd0, 0xbb, 180, 0x121, 0x116, 0x116, 0xbb, 0x159, 14, 0x6b, 14, 0x116, 0xf3, 
            0x8d, 13, 0x72, 0x10a, 270, 0x14c, 0x14c, 0x7d, 0xc1, 0x14b, 0x123, 0x45, 0x16f, 0xcb, 0x171, 0xe7, 
            0x14b, 0xab, 100, 14, 0x10a, 110, 0x143, 0x5b, 0x5b, 0x4e, 40, 0x14d, 0x66, 0xc1, 0, 0, 
            0x9a, 0xa7, 0x194, 0x139, 0x114, 0x86, 0x164, 0x164, 0x1f, 250, 170, 0x131, 0x115, 0x9a, 0x159, 0x146, 
            0x159, 0x162, 0x7a, 0x162, 0x146, 0x14d, 10, 0x14d, 250, 220, 0x146, 0xe2, 0x15d, 0x145, 0x15d, 0x9b, 
            0xfc, 0xb3, 0x2c, 0xa7, 0x68, 0x7d, 0x3e, 0x86, 0x31, 0x11a, 0xc9, 0x16f, 0xa6, 0x9e, 0x5c, 0xec, 
            0x86, 0xf9, 0x47, 0x2c, 0x23, 0x194, 0x1d, 0x86, 0x155, 0xba, 350, 0x175, 0x51, 0x12e, 300, 0x14f, 
            90, 0x34, 90, 0x125, 0x12, 0x105, 0x17a, 0x14f, 130, 0xf4, 0xf1, 40, 0x131, 0x17a, 0x74, 0x58, 
            0x164, 0xf7, 320, 0x88, 0x7f, 0xf6, 0xaf, 0x188, 330, 0x86, 0x163, 0xa2, 0x159, 170, 20, 0x1d, 
            0x161, 5, 0xc4, 50, 0x117, 310, 0x165, 0xa6, 0xea, 0x39, 0x5c, 0x12, 0x15c, 0x102, 0x4b, 0x61, 
            0x8f, 0xaf, 0x177, 0x15c, 0x175, 0x74, 0xa4, 220, 0x11c, 0x177, 0xfb, 0xaf, 0x174, 0xd1, 0x144
         }, { 
            0x9e, 0x119, 0xfb, 0, 310, 0xd4, 0x12e, 0x8b, 110, 0xfc, 0x2b, 0x143, 0x45, 0xf1, 0x99, 0x131, 
            0x143, 0xea, 0x14c, 330, 0x79, 0x1f, 0xe8, 0x131, 0x77, 0x12e, 0x146, 0, 0x6b, 0x8b, 0x119, 0x79, 
            0x12e, 0x77, 0xa1, 0x150, 0x15c, 0x177, 0x15d, 0x15a, 0x45, 0x4b, 0x11b, 0xe5, 0x91, 0x165, 0x177, 0xe8, 
            0x24, 0x4b, 250, 0x3e, 0xab, 0x177, 0x13, 0x4a, 0x11e, 0x12b, 0x4d, 0x66, 0x162, 0x89, 0x7f, 0, 
            0x151, 0x2d, 0x149, 0x14b, 0x116, 0x11b, 240, 0x175, 0x14c, 0x3b, 0xe5, 0x15c, 0x48, 0xb2, 0x15d, 0x86, 
            0x175, 0xaf, 0x11b, 0x14c, 0x15d, 0x17a, 0x15a, 0x103, 0x14b, 0x26, 0x159, 0x15d, 0x162, 0x3e, 0x145, 0xd4, 
            0x17f, 0x2e, 0x182, 0x31, 0xaf, 170, 0x145, 0x7d, 0xf4, 0x7c, 0x5c, 0x5c, 140, 0x3d, 0x57, 0x7d, 
            0x169, 0xdf, 0xab, 0x15, 13, 0x16e, 0xe8, 0xee, 0x56, 0x9c, 0x58, 0x6d, 0x130, 90, 0x16b, 0x150, 
            0x165, 0x66, 110, 360, 0xb8, 0x162, 0x20, 0xd0, 0xf1, 0x11b, 0x15b, 0x21, 0x159, 0x79, 0x15, 0x6b, 
            0x66, 0x155, 0x99, 2, 0xc2, 0x13f, 0x157, 220, 330, 0xca, 12, 0x11c, 0x98, 0x15c, 0x177, 0x182, 
            0x57, 130, 0x175, 0x9d, 0xf9, 0x5c, 0x39, 0x54, 0x1f, 0x5c, 330, 0x3e, 0x162, 0x60, 130, 250, 
            0x7d, 0x7e, 0xec, 0xb8, 0x61, 0x149, 0x61, 0x5c, 0x86, 0x7d, 0xe9, 0x8e, 0xf5, 0x12d, 7
         }, { 
            3, 0x81, 0xf1, 0x159, 0x79, 0x165, 0x149, 0x131, 0x5c, 0x3b, 5, 330, 0x15d, 0x10c, 0x100, 170, 
            0x13e, 0x3d, 0xe8, 0x12b, 0x162, 0x159, 0x52, 0xd0, 0x4d, 0x5c, 0x3b, 0x15d, 0x177, 0xad, 330, 0xa4, 
            0xa4, 0xfc, 0x177, 0x15c, 0xf6, 0xf3, 0x77, 0x60, 0x187, 0x74, 0x166, 0x162, 0x27, 0x12b, 0x6b, 0x148, 
            290, 0x77, 0x86, 0x166, 0x160, 0x5c, 330, 0xac, 0xa4, 0xdd, 0x156, 0x166, 0x5c, 0x5c, 0xc7, 0, 
            0x55, 330, 0xc6, 0x52, 0xe3, 0x165, 0x25, 0x15a, 3, 0x149, 0x3f, 0x3a, 0x74, 0x40, 0xc6, 0x23, 
            0x16f, 0xab, 0xf1, 0x179, 0x72, 0x171, 0x15d, 0x17a, 0x13f, 0xab, 0x44, 350, 0x149, 0xab, 0xab, 0x72, 
            0x15d, 0x5b, 20, 0xb8, 0xc6, 0x34, 0x7d, 270, 0x11e, 0x20, 0xaf, 240, 250, 0xeb, 0x3b, 0x14c, 
            0x2a, 0x44, 0x158, 0x15d, 0x8f, 0x165, 0x4f, 0x25, 0x80, 70, 0x41, 0x161, 0x163, 0x68, 0x164, 0x148, 
            0x105, 120, 0x83, 0x108, 0x12f, 0x5f, 0x180, 0xc7, 220, 0xf3, 0xad, 0x44, 0x8a, 0xaf, 0x7c, 0x11a, 
            0x179, 0x189, 0x62, 0x175, 250, 0x177, 0x83, 0x65, 0x44, 0x159, 150, 0x10c, 0x6a, 0xe9, 0x175, 0xbd, 
            0x13f, 0xb3, 0x36, 0xe4, 0x143, 0xd3, 0x83, 0x159, 0x51, 0x162, 0x183, 0x42, 0x7d, 0x31, 0xc9, 190, 
            0x141, 0x4b, 0x11e, 0x24, 350, 0x5b, 0x194, 0x12, 0x134, 0x177, 0x29, 0x61, 0xbc, 0x110, 0x116
         }, { 
            0xb5, 0xb5, 0x165, 0xac, 0xbc, 0x12, 0x149, 0x145, 0x9b, 330, 0x15c, 0x39, 0x134, 0x162, 0xad, 0x38, 
            0x5c, 0xe3, 0x15a, 0x145, 0, 330, 0x5c, 0x149, 0xbc, 0xa2, 0xa4, 0x12d, 2, 0x51, 0x38, 0xad, 
            0xab, 0x15c, 0x53, 0xa4, 10, 110, 110, 110, 0x13, 0xf7, 310, 0x175, 0x24, 0xf7, 0xa7, 0x83, 
            310, 0x51, 190, 10, 310, 0x79, 0x15b, 0x42, 0x1d, 0xf3, 0x102, 0x3e, 70, 0x149, 0x102, 0, 
            0xf6, 0xd7, 0x15d, 0x10c, 0xc7, 0x141, 0x185, 8, 0x15c, 220, 0x132, 14, 0x81, 0x72, 0xe4, 0x13, 
            0x15d, 0x12e, 0x132, 0x81, 3, 0x70, 0x5f, 0xf2, 0x139, 350, 0x12b, 0x137, 0x155, 0x92, 13, 0x12e, 
            370, 0xa6, 170, 0x162, 330, 0x15c, 0x114, 0x150, 330, 0x10, 0x10c, 0x86, 0x128, 0x10, 0x10, 0x11e, 
            0x60, 0x61, 0x74, 0x51, 0x5c, 0x9e, 0x162, 0xe5, 0xb8, 0x171, 0x83, 0xd0, 0xac, 0x15c, 0x15a, 0x145, 
            0x49, 0xf4, 0x11c, 0x74, 0x17a, 0x155, 0x12f, 0x15b, 0x15a, 0x149, 0x6b, 0xbb, 0x21, 0x159, 0x74, 0x162, 
            0x145, 0x47, 10, 0x155, 15, 0x13e, 0xac, 0xb6, 0x117, 0x165, 0x15c, 0x162, 0x4f, 0x12b, 0x14c, 0x88, 
            0x33, 0x126, 0x132, 340, 330, 0xa4, 0x74, 0x84, 0x74, 0x51, 0x11c, 0x126, 0x14c, 0x177, 250, 0x74, 
            0x54, 0x189, 0xbd, 0x177, 0x2f, 0x175, 0x137, 0xf1, 0x1f, 330, 0x181, 330, 0xff, 0x133, 0x130
         }, { 
            0xe8, 0x9b, 0x9c, 0x16f, 9, 0, 0xf9, 0xf9, 0x119, 280, 0xc6, 0x7d, 0x3e, 0, 0x132, 0x12e, 
            0x14f, 0xe2, 0x5b, 0x13, 0x9b, 0x131, 0xae, 0x79, 0x7f, 0x156, 0x5c, 0x7d, 0x7e, 0x1f, 0x12e, 0x74, 
            0x14c, 0xf3, 70, 0x141, 0x7d, 0x9e, 0x145, 0x102, 0x54, 0x141, 0xfb, 0x5b, 0x145, 280, 0x6b, 0x20, 
            0x9b, 0x106, 0x165, 0x119, 0x145, 0x5b, 0x54, 0x132, 0x60, 0x165, 90, 14, 0x156, 0x12b, 70, 0, 
            0x141, 70, 0x54, 0x85, 0x14c, 0x14f, 0x14c, 0x5c, 0x166, 0xa1, 0xe7, 350, 350, 0x165, 0xe7, 3, 
            0x15d, 0x14d, 0x74, 0x15b, 0x42, 0xf7, 0x99, 0x14d, 0x124, 0x6b, 340, 0x15c, 340, 0x61, 0x127, 0x99, 
            0xf1, 0x48, 0x7c, 0x79, 0x195, 0xd5, 0x15a, 0x182, 0xfc, 0xf3, 0xc1, 0x133, 0xf1, 0x48, 0xb8, 0xbb, 
            0x59, 0x162, 0x162, 0x12e, 0x156, 0xbf, 0x5c, 0x58, 0x3a, 0x75, 0x22, 0x49, 0x158, 0x181, 15, 0x53, 
            0x4e, 2, 0xa4, 0xad, 0x16f, 0x13a, 0x3e, 0x9c, 320, 0x54, 0x151, 0xb7, 0x14b, 0x7f, 0x170, 0x44, 
            0xcb, 0x5b, 0x148, 0xf1, 0x48, 11, 0x42, 0x23, 0x179, 0x81, 0x3e, 0x155, 15, 0x174, 0x67, 0x10f, 
            0xf7, 250, 0x49, 0x3d, 0x7e, 0x16, 0xbc, 20, 140, 0x177, 0x54, 0x54, 340, 190, 0x93, 0x49, 
            0xbf, 0x39, 0x11b, 0x163, 0x15c, 0x12b, 0x182, 0x25, 0xc5, 0x9d, 0x7d, 0x3e, 0x12d, 0x158, 0xd0
         }, { 
            0x6c, 0x162, 0x143, 0x52, 0x49, 0x3e, 0x3f, 0xe2, 0xee, 0xab, 0x22, 0x83, 0xa2, 0xf6, 0x7f, 0x4b, 
            0x4b, 0x145, 0x14f, 0x9b, 0x11a, 0x15c, 0x15c, 0x8f, 0x48, 0x162, 0xed, 0xa2, 0x137, 0x7c, 0x13b, 0x79, 
            0x99, 0x7c, 0xb3, 0x139, 0x24, 350, 0x165, 0x74, 0x6b, 0x83, 0x13e, 0x13e, 0xec, 0x9d, 0x13e, 0x182, 
            0x182, 0x2c, 0x42, 0x9d, 0x130, 0x6b, 0xf3, 0x97, 0x185, 0x14c, 0xf6, 0x15c, 0x10d, 0x135, 0x4b, 0, 
            0x4b, 0x159, 0x146, 0x159, 0x162, 0x17d, 0x159, 0x14c, 0x150, 0x15c, 0x163, 0x10f, 310, 310, 0x7e, 0x99, 
            0xa2, 160, 0xea, 380, 0xb6, 50, 220, 0x6d, 0x7f, 0x61, 0x157, 0x159, 0x79, 0x116, 0x107, 0xbc, 
            0x12, 0x12b, 0xe8, 0x109, 0x128, 0x99, 0xb8, 0x8f, 0xc2, 0xea, 0x24, 140, 170, 0x61, 0x42, 14, 
            0xfb, 310, 0x4f, 0x175, 0x119, 0x143, 0x13d, 0x54, 0x59, 0x61, 0xa4, 0x159, 0xe8, 0x9e, 0xa4, 0x5c, 
            0x16e, 110, 100, 0x87, 130, 0x56, 0x15c, 0xee, 0x173, 0xa8, 0x13c, 0x2a, 0x116, 0xbb, 30, 0x195, 
            0x15, 0x12f, 0x86, 8, 0xf3, 80, 0x8d, 0x13b, 0x7b, 0xe0, 0x162, 0x176, 0x61, 0x8f, 0xee, 0x15, 
            20, 0x164, 0xc6, 0x130, 0x3f, 0x125, 0x11c, 0x155, 0x12e, 14, 0xd0, 0xe8, 0x4a, 0x8e, 160, 0x4d, 
            0x161, 0x24, 0x7c, 0xcb, 0x15b, 0x24, 0x40, 0x15d, 0x8b, 0x17a, 0x42, 0x43, 0x75, 0xfb, 0x69
         }, { 
            0x14c, 0xec, 0xaf, 170, 0xd4, 0xfb, 0x139, 0x84, 0xef, 350, 0x162, 0xa2, 0x53, 0x43, 0x62, 0x54, 
            0x14b, 0x171, 0xe4, 0x10c, 0x54, 0x12f, 0xa9, 0x5c, 0x155, 0x14e, 0x86, 0x10, 0x126, 0x145, 0x15a, 220, 
            0x128, 0x8b, 0x128, 0x4f, 0xac, 330, 0xac, 0xea, 0xea, 0xac, 0x10, 0x10, 0x10, 0xa8, 0x10, 0x111, 
            0x53, 0x153, 0x15a, 0x171, 0x126, 220, 0xac, 0x51, 0x4f, 0x51, 0x11c, 0x18, 0x5c, 0x42, 0x126, 0, 
            320, 0x171, 0x180, 0x102, 0x162, 0x15a, 0x11c, 0x15d, 0x4f, 0x4f, 300, 0x15d, 0x17a, 0x15c, 0x189, 14, 
            0x81, 0x132, 10, 0x2f, 0x138, 0x126, 10, 0x11c, 0x4a, 0x6a, 0x102, 310, 0x80, 0x7c, 0x13, 220, 
            0x13a, 0x114, 0x40, 0x176, 0x111, 0x26, 0x131, 3, 0x107, 160, 0x9d, 0x133, 0x91, 0x16e, 0xa4, 90, 
            0x4b, 0x36, 0xb1, 0xac, 0x8b, 0x7d, 0x9f, 0xf6, 0x86, 1, 0xf4, 0xdd, 12, 60, 0x8f, 0x9a, 
            0x61, 0x7b, 0xe5, 0x87, 0x130, 0x182, 0xf5, 0x8b, 0x126, 0x4b, 0x1d, 0x128, 0x77, 2, 0xae, 0xf4, 
            0x51, 0xba, 0xc4, 0x5b, 0x87, 0xc7, 0xac, 0x15c, 0x7c, 0x12, 0x10, 0x131, 0xb6, 0xb3, 0x160, 0x185, 
            0x155, 0x3e, 0x1f, 0x88, 240, 0xaf, 0x49, 0x9e, 240, 0x33, 0xf4, 0x3d, 0x7b, 0x181, 0x15c, 0x1d, 
            0x10, 0x178, 0x11a, 0x36, 0x177, 14, 0x182, 0xc4, 0x11e, 0x194, 0x5c, 0x54, 0x9f, 0x8f, 0x102
         }, { 
            0x2f, 0x14d, 0x15a, 0x87, 0x4d, 0xa1, 330, 20, 0xcd, 0x4b, 0x15, 0x89, 0x45, 0x129, 0x162, 330, 
            220, 0x9a, 0x68, 0x11c, 0x7d, 0x17f, 0x13, 0x14c, 0x15, 0x15b, 0x130, 0x51, 370, 0x145, 100, 0x4b, 
            0xda, 0x165, 0x74, 120, 0x79, 0x171, 0x73, 110, 0x151, 0x52, 0x145, 0x61, 0x1d, 0x127, 0x131, 20, 
            90, 330, 0x99, 0xac, 0x128, 0x14c, 0x15b, 0x146, 0xc4, 0x131, 0xb6, 14, 0x162, 0x153, 130, 0, 
            270, 0x13e, 0x17d, 0x116, 0x25, 0x39, 0x15c, 0xf1, 0x100, 0x24, 0x145, 0x14d, 0x171, 0x52, 0x6a, 0xbc, 
            0x159, 0xc4, 0x1f, 0x14d, 0xb3, 360, 0xca, 0x42, 320, 0x4a, 0x7c, 0xa1, 330, 0x45, 0x89, 0x68, 
            0x61, 0x175, 0x5c, 0x111, 0xd1, 0x54, 0xff, 0x66, 0x80, 0x6d, 330, 0xee, 0x41, 0x74, 0x160, 0x85, 
            0x163, 10, 0x175, 0x61, 0x44, 0xaf, 250, 0x25, 0x126, 0x4d, 0x177, 0x62, 0x153, 0xb0, 20, 0xa4, 
            0x74, 0x162, 0x14c, 0x135, 0x149, 0xbf, 3, 11, 0x2d, 0x74, 0x4b, 0x2f, 0xba, 0x149, 220, 0x7d, 
            350, 0x174, 0xac, 0xa8, 0x80, 0x85, 0x162, 0x74, 0xaf, 100, 0x13, 0x42, 0x81, 0xa4, 0x116, 0xa4, 
            0x161, 0x58, 0x8f, 0x39, 0x16f, 0xe4, 0x17a, 0x155, 0x7c, 0x158, 0x15c, 0x177, 160, 0x149, 0x36, 0x14c, 
            0x114, 0x17a, 0x51, 0x61, 0x145, 0x162, 0x162, 0x39, 0x9c, 0x15c, 0x73, 0x36, 0xae, 0x7c, 0x110
         }, 
        { 
            0x15b, 20, 0x52, 20, 0xd0, 14, 0xee, 0x13c, 0x6b, 0x51, 0x7d, 3, 2, 0x14c, 0x165, 0x52, 
            0xec, 0x150, 180, 0x162, 0xed, 0xf3, 0x3e, 320, 0x174, 0x25, 0x157, 0x17a, 0x177, 0xe5, 0x150, 260, 
            0x10c, 0x165, 0x146, 0x177, 0x39, 0x194, 0x161, 20, 10, 150, 320, 0x15c, 250, 240, 250, 0x84, 
            0xee, 0x173, 0x163, 0xe7, 0x179, 0x86, 0x17a, 0xd9, 0x86, 0xe8, 0x185, 0x7c, 0xab, 0x175, 0x170, 0, 
            0x54, 0x15a, 0x11c, 14, 320, 320, 0x126, 0xac, 180, 0xe9, 0x132, 0x177, 0x105, 0x134, 0x44, 0x157, 
            0xfb, 0x11a, 0x84, 0x4d, 0x6a, 20, 0x17a, 0x15d, 0xb3, 0x179, 0x39, 0x6a, 0xac, 0x86, 0x127, 0xf6, 
            0xb7, 0x25, 0xc4, 8, 0x5c, 120, 0x10, 0xb3, 350, 0x170, 0xad, 0x15d, 0x27, 8, 0x9d, 0x15c, 
            0x3f, 0xe8, 0x3f, 250, 0x15c, 0x127, 330, 0xf8, 0x180, 15, 220, 0x137, 0x45, 0x8f, 0x162, 0x157, 
            0x86, 0x162, 0x15c, 0x1d, 0xc7, 0x102, 130, 0xba, 0xe2, 0x3a, 0xf2, 0x5b, 0x90, 0xa6, 0x24, 0xa6, 
            0x7d, 0x10, 40, 0x135, 14, 0x86, 0x4a, 0x37, 11, 10, 0x194, 15, 0x9e, 0x25, 0x174, 0xf4, 
            0x107, 0xe2, 0x11e, 340, 0x89, 0x35, 130, 0xa2, 0x182, 0x21, 0x126, 0x7b, 160, 0x131, 0xdf, 0xae, 
            0x7e, 400, 0xc4, 0x41, 0x42, 0x39, 0xab, 0xd6, 0x68, 0x99, 5, 0x130, 0x6b, 0xf1, 0x6c
         }, { 
            0xa7, 0x6b, 0x13c, 0x155, 0x13e, 0x89, 0x4b, 0x24, 0x151, 0x126, 0xaf, 0x17f, 0x179, 0x119, 0xe9, 0x9a, 
            0x132, 0x9d, 0x183, 0x8f, 0xf1, 0xf1, 0x159, 0x51, 0x110, 0x159, 0x5b, 220, 0x149, 0xe9, 0x30, 0xe9, 
            0xf3, 0x51, 120, 0xf3, 0x7b, 0x162, 0x135, 0xfb, 0x14b, 0x183, 0x99, 0x106, 0x126, 0x62, 320, 0x13e, 
            0x128, 0xf3, 0x24, 0x177, 0xac, 0xe7, 0x134, 330, 0x1a, 70, 0x159, 0x163, 0x184, 0x14e, 0x116, 0, 
            0xf1, 0x177, 290, 0xaf, 330, 0xb3, 370, 0xc4, 220, 0x18, 0xea, 0x30, 250, 14, 0x177, 0x162, 
            340, 0x75, 20, 0x129, 0x14e, 170, 0x171, 0x49, 0xac, 320, 0x1c, 0x3f, 0x14e, 0x138, 0x159, 0xb3, 
            0x171, 0x81, 110, 350, 0x8f, 0x6b, 0x4b, 0x17d, 0xd4, 0xb6, 0x10f, 0x6d, 0x107, 0xec, 0x74, 0xf3, 
            0xf9, 0x5c, 30, 0x79, 0x5b, 0xbc, 0x54, 0xe8, 0x109, 0x14c, 0x6d, 0x81, 0x5f, 0x45, 0x15d, 0x25, 
            0x6b, 0x61, 0x8f, 0xa4, 0x161, 0xfe, 0x16f, 0xf9, 0xab, 0x24, 0x161, 0xf8, 0x7c, 0xcb, 0x177, 0x126, 
            250, 0x139, 0x9b, 0xf1, 0x80, 0x15a, 0xc5, 0x11a, 0x174, 280, 0x149, 0xa4, 40, 0x54, 0xf4, 0xf7, 
            0xf1, 330, 0x162, 0x51, 0x68, 0x68, 0x15c, 0xe8, 0x137, 0xfb, 0x143, 0x9f, 0xbc, 0x2d, 0x105, 0xc9, 
            0x54, 0x99, 0x8f, 0x54, 0x128, 0x162, 0x161, 0xae, 0xf9, 15, 0xc5, 0xf6, 5, 0xb6, 0xb7
         }, { 
            0x83, 0x15c, 0x15b, 0x174, 0xec, 0x179, 0x159, 0x169, 0x194, 0x134, 0x14d, 0x5c, 290, 0x86, 330, 0x77, 
            0xa4, 0xea, 260, 0x15d, 0xea, 0x151, 0xf6, 0x183, 0x129, 0x99, 290, 0x145, 0x145, 0x145, 0x162, 0x58, 
            0x15c, 0x8d, 10, 11, 0x170, 0x135, 0x14e, 0x95, 0x13e, 0x5e, 0xe9, 0x162, 0x12b, 0xee, 0x14e, 0xe3, 
            0x88, 0x36, 0xc4, 0xa8, 0xae, 0x14e, 0x169, 0x135, 0x12, 0x97, 0xaf, 90, 0x7f, 0x8e, 0x7f, 0, 
            160, 0x110, 0x9a, 0x135, 80, 0x153, 0xfe, 0x39, 0x9a, 0x12, 0x4e, 0xe8, 0x4e, 0x135, 10, 14, 
            0x106, 0x54, 0x4d, 0x105, 250, 0x5f, 0x164, 0xe7, 0x17b, 280, 0x12d, 0x135, 0xa4, 0x12, 0x135, 0xe7, 
            0x127, 180, 0x163, 330, 0x25, 0x131, 0xe3, 0x11c, 120, 0x1a, 0xea, 0x131, 330, 0x14d, 0x178, 370, 
            0x120, 0xb8, 0xe7, 0x79, 0xe2, 0x116, 0x7b, 0xbc, 0x1f, 0xa6, 0xc0, 0xa4, 70, 250, 0x55, 350, 
            0xf7, 0x14b, 0x11c, 0x17a, 0x162, 0x5c, 70, 0x5c, 0x7d, 0x173, 0x182, 0x74, 0xf8, 0xee, 0x37, 0x11b, 
            0x16b, 0x60, 0xa4, 0x126, 0x137, 0x7c, 15, 0x25, 0x93, 14, 0x14c, 0x159, 0xfb, 0x176, 0x89, 0x11c, 
            0x59, 0xe0, 280, 0x14e, 0xf7, 0x16b, 0xf5, 0x17a, 0x10b, 0xf3, 320, 14, 0x39, 0x92, 0x163, 0x14e, 
            0x175, 0x99, 120, 0x73, 0x60, 0x51, 0xa4, 14, 0x25, 0x129, 0xc0, 0x45, 0xaf, 0x47, 0x66
         }, { 
            0x176, 0x183, 0x124, 0x7d, 0x4a, 0x74, 0x9c, 0xf1, 0xa6, 0x175, 0xe7, 180, 270, 0xb6, 0xb6, 0x113, 
            340, 0xa9, 0xf3, 0xf3, 0xca, 0x9b, 0xd6, 0x12, 0xff, 0x45, 0x45, 0xcb, 0x14d, 330, 0x45, 0x6b, 
            0x45, 0x45, 0x85, 0x162, 0x162, 0x159, 0xa4, 0x150, 0x66, 0x183, 0xac, 0x14f, 0x117, 0xba, 0xf1, 0xf1, 
            0x56, 340, 0x162, 0x13e, 0xf1, 0xa7, 0x58, 0xea, 14, 0xf1, 340, 0x27, 0x159, 0x171, 0x162, 0, 
            0x3b, 0x102, 0x81, 6, 0x72, 320, 0x40, 0x5c, 0x162, 0x75, 0xf5, 0x12d, 0x6c, 0x13f, 0xc4, 0x81, 
            0x11a, 8, 0x163, 0xe8, 0x194, 0x146, 0x74, 0xaf, 0x166, 80, 0x52, 0xc7, 0x161, 0xe9, 0xc4, 110, 
            0x14b, 0x3f, 360, 0x3d, 20, 0x9d, 0x179, 0x162, 0x162, 0x26, 330, 0xd4, 0x195, 0x2a, 0x116, 0x15c, 
            14, 0x178, 8, 80, 0x5b, 0xaf, 0x17a, 0x16b, 330, 280, 0x145, 0xbc, 0x11d, 0x1a, 0x26, 0xbc, 
            0xf6, 0xd3, 0x7c, 0xf9, 0x114, 14, 0x3e, 0xf4, 0x12d, 0x81, 0x131, 330, 0x14c, 0xbd, 6, 0xa4, 
            0x137, 330, 0x2f, 0x18, 170, 0x183, 270, 0x73, 360, 0x2f, 340, 0x106, 0xf9, 0x7e, 0x5d, 0x5c, 
            0x15c, 0xab, 330, 0x17a, 0x51, 0x7d, 0xe9, 110, 0x15c, 0xbd, 0x177, 0xf1, 0xf1, 220, 0x3b, 0x54, 
            250, 0x85, 0xf5, 0xa9, 0x182, 360, 0xc9, 0x174, 0x7e, 0x25, 0x42, 0x58, 0x179, 0x15c, 0x61
         }, { 
            0x14f, 0x6b, 0xe8, 0xab, 320, 20, 0xf9, 0xed, 0x54, 14, 0x5c, 0x145, 250, 0x40, 20, 0x161, 
            0x67, 0xe8, 0xd1, 0x176, 0x12f, 0xe4, 0x54, 0x16f, 0x86, 0x61, 0x11c, 0x44, 0x38, 0x12e, 0xf2, 0x11e, 
            0x73, 0x175, 0x4d, 3, 0x145, 0x173, 0x17a, 0x15d, 0xa9, 0xb3, 0x13a, 0x15c, 0x15c, 0x13, 0x145, 0x80, 
            0x94, 0x14f, 0x14c, 0x5b, 0x79, 160, 0x54, 0x8e, 0x153, 0x4a, 0x89, 0x135, 190, 280, 0x16f, 0, 
            0x12d, 0xf6, 0x162, 0xcd, 0x174, 0x67, 0x5e, 0x129, 0x149, 0xf9, 0x11a, 240, 0x77, 0x137, 0xa4, 0x114, 
            0x114, 0x8e, 0xbc, 0x24, 0xa4, 0x184, 330, 0x160, 0x11a, 0x182, 0xf1, 0x176, 0x14d, 0xcd, 0x2d, 0x5c, 
            0x40, 0x189, 320, 0x14c, 0xc2, 0x177, 0x159, 0x115, 0x24, 0x13c, 0xa2, 0x9a, 0xe5, 0x74, 0x135, 340, 
            0x6a, 0x131, 160, 0x15, 0x80, 330, 0x86, 0xa4, 0x157, 0x11c, 0x36, 0x49, 0xf8, 0x156, 50, 0x11, 
            10, 0x12e, 0x7d, 0x54, 0xf4, 0x177, 0x54, 0x116, 0xa4, 320, 0x7c, 20, 0x12f, 0x99, 0x7f, 14, 
            0x14c, 0x14c, 0x5c, 0x80, 0xa7, 0x5c, 0x2e, 0x76, 0x25, 0x177, 0x3f, 20, 0x177, 0x7d, 0x41, 0x29, 
            0x178, 0x86, 0x4a, 0x36, 0xe9, 0x106, 0xd4, 0xe2, 0xf1, 40, 0x88, 240, 0x4f, 50, 0x17a, 170, 
            0x1f, 0xa9, 390, 0x14f, 0x177, 0x40, 0xc4, 0x153, 0xc4, 0xe8, 0x74, 0x88, 0x117, 0x61, 0x187
         }, { 
            0xf5, 0x61, 0x179, 0x44, 0x9d, 0x51, 0xd0, 0x15c, 0x9a, 0xaf, 0x85, 0x20, 0x83, 0xb2, 0xab, 0x184, 
            0xa4, 0xbc, 0x183, 0x177, 0xd1, 0x74, 0x162, 0x3e, 0x11c, 0x11a, 0x77, 0x135, 0x73, 0x176, 0x17a, 0x9c, 
            0x183, 0x16c, 15, 15, 0x77, 0xfb, 0x16c, 0x145, 0x145, 0x162, 0x2d, 0x106, 0x16f, 120, 0xa6, 0x159, 
            0xf9, 0xf9, 0x7d, 14, 0x4b, 0x15a, 0x54, 330, 0x14c, 0x14b, 0x145, 0x74, 0x11c, 0x10b, 0x155, 0, 
            0x146, 0xf3, 0x6d, 0x149, 0xe3, 0x110, 0xac, 180, 0x11c, 0x11c, 0x9a, 0x182, 0x134, 0x12e, 220, 0x5b, 
            0x160, 0xf3, 0xf1, 0x146, 0x10b, 0x11a, 0xa6, 5, 0xa1, 0x79, 0xc1, 0x5c, 0x137, 250, 0x7d, 0x11a, 
            0xb6, 0x5f, 0x129, 0x177, 0x182, 0xf7, 0xa7, 0x162, 0xa4, 0x146, 0x139, 0x5c, 0xe5, 0x51, 0x114, 0x15d, 
            2, 0x14c, 0xb5, 0x23, 0x86, 10, 0x137, 0x182, 0x15d, 0x162, 0x2e, 0x148, 0xc1, 0x163, 320, 0x17f, 
            300, 0x89, 0x86, 0xb3, 250, 0x27, 0xf8, 0xb0, 0x149, 360, 0xc5, 5, 0xac, 11, 0x150, 0x161, 
            80, 6, 0xed, 0xd1, 0xaf, 0x129, 0x54, 0x73, 0x12f, 0x66, 0x81, 0x145, 0x4d, 0x5c, 0x80, 0x14d, 
            0x157, 0x5e, 0xa4, 0xa6, 0x7d, 0x11c, 0x137, 0x67, 0x114, 0x77, 0x5c, 0xf7, 0xab, 0x184, 0x51, 0x9a, 
            0x20, 0x61, 0xd0, 0xd1, 0x40, 0x11c, 0x182, 0x52, 0x41, 0x4b, 0xf9, 0x54, 120, 15, 0x110
         }, { 
            330, 0xf9, 0x10, 0x5c, 0x5c, 0x17a, 0x7e, 0x153, 0x17d, 0x160, 370, 0x8d, 0x156, 0x11, 0x162, 250, 
            0x14d, 20, 0x80, 0x157, 0x129, 120, 0x188, 320, 0x116, 0x4f, 0x88, 170, 0x157, 0xbf, 330, 0x16e, 
            0x14d, 0x52, 100, 0x73, 150, 0x16c, 0x110, 0x171, 0x58, 0x66, 350, 0xa4, 0x20, 0xa2, 0x11e, 2, 
            0x107, 0x5c, 0x162, 0x74, 0x11e, 0xa4, 0xa9, 0xb3, 0xc0, 0x175, 0x14d, 0x4b, 0xaf, 100, 0xa4, 0, 
            0x14c, 0x3b, 0x5c, 0x13f, 6, 110, 0x161, 0x16f, 20, 0xe8, 0x8e, 0x13a, 0x16c, 0x73, 150, 0x16f, 
            0x89, 0x160, 0xf1, 0x11a, 14, 0x20, 0x135, 0x146, 0x145, 0xfb, 0x7e, 0xe3, 0xf3, 0x145, 330, 0x74, 
            0x58, 5, 0xf1, 0x12e, 100, 220, 0xa1, 0x10, 0x156, 0xb6, 0xc1, 0x160, 0x66, 0x116, 0x188, 0xa4, 
            0x37, 0x15a, 0x37, 0x7f, 0xb6, 0x7d, 0x86, 0x106, 0x60, 11, 0x81, 0x13b, 0x94, 0x61, 0x3e, 0x73, 
            0x5b, 0x8f, 14, 0xae, 0xf2, 0x97, 0x12, 70, 0xba, 6, 0x159, 0xa7, 0x14e, 0x144, 0x25, 0x14d, 
            0x159, 0x138, 0x132, 0x160, 0, 0x9a, 0xb8, 0xfe, 0x137, 0x5c, 0x182, 0x153, 0xfb, 0x85, 0x12, 0x77, 
            0xa9, 0xb9, 0x79, 0xbd, 0x5c, 0x89, 0x17a, 0xbd, 0xf1, 5, 0x119, 170, 0x38, 40, 0x161, 0x14b, 
            0x15c, 250, 70, 0xa4, 0xf7, 0x18, 3, 0x52, 0x161, 0x149, 0x159, 330, 0xf9, 0x6b, 0x16f
         }, { 
            0x171, 100, 0xfc, 0x15c, 0x54, 0xa4, 0x177, 0x15, 0x159, 0x54, 0x173, 0x5c, 0x53, 0x107, 0x159, 0x11c, 
            0x53, 0xc2, 10, 0x163, 0x177, 0x74, 0xf6, 0x66, 0x52, 0x146, 0x171, 0x11c, 0x162, 0x55, 220, 0x88, 
            0x88, 0xe8, 0x77, 0x175, 10, 0x159, 0x158, 0x176, 80, 0x53, 0x146, 0xdf, 0x38, 0x5b, 0x107, 0xab, 
            0xc0, 0x54, 320, 0x146, 0xa4, 15, 0x177, 0x5b, 0x163, 0x2f, 250, 0x14e, 0x25, 0x39, 0x86, 0, 
            220, 0x61, 0x178, 0x162, 0x15a, 0x162, 0x158, 0x138, 0x162, 310, 350, 0x48, 0x149, 0x4d, 0x62, 2, 
            0x177, 0x159, 0x71, 0x14e, 0x7c, 0xa9, 0x17a, 0x15a, 0x15c, 0x72, 0xaf, 0x107, 0xc5, 0x5b, 0x102, 0x14e, 
            0x153, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0x179, 0x25, 0xb3, 0x71, 0xd1, 0x4b, 0xb0, 0x7c, 0x5c, 0x13c, 0x87, 320, 240, 0x149, 0x87, 0x162, 
            20, 0x89, 0x89, 14, 330, 0x89, 0x86, 0x13c, 0x83, 0x135, 0x4b, 0x4b, 0x98, 0x74, 0x149, 0x11a, 
            0x9d, 0x80, 0xe2, 0xaf, 0xe8, 0x11e, 0x54, 0x158, 0x181, 0xe7, 0xf9, 0xf3, 11, 0x40, 0xaf, 0xfc, 
            0x7d, 0x86, 0x13c, 0x158, 0x163, 0xf1, 0xa4, 0x15b, 0x17f, 0x92, 0x4a, 0x9a, 0x11b, 0xf1, 0x83, 0, 
            0x15c, 0x15c, 0xf7, 0x182, 0x9d, 0x44, 0xf1, 0x13d, 0x5e, 0x86, 250, 0x15c, 0x188, 0x5c, 0x11e, 0, 
            0x25, 0xbf, 0x106, 0x158, 0xf9, 0x135, 0x74, 0x135, 0x4b, 0x81, 0xb8, 0x54, 0x2d, 0x13c, 0x159, 110, 
            0x163, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0xe9, 0x9a, 0xba, 0x74, 350, 0x177, 0x149, 0x86, 0x44, 0xf4, 80, 0x74, 350, 0x163, 0x14c, 0x147, 
            0x11c, 110, 40, 0x131, 0x14b, 0x10b, 0xac, 0x5c, 0x74, 0xf3, 0x157, 0x6b, 0x2f, 0x2f, 0x15c, 220, 
            0x159, 0x5c, 0xa4, 310, 0x93, 0x135, 0x135, 0x15c, 0x13c, 180, 0x14e, 90, 310, 0x23, 0x5c, 0x13d, 
            0x174, 5, 220, 0x15c, 0xdf, 0x25, 0x177, 0xac, 0x160, 0x194, 14, 290, 0x181, 0x162, 0x149, 0, 
            0x88, 0x15d, 0x135, 0x126, 0x80, 0x15c, 0x75, 14, 350, 0x129, 120, 0x4f, 0x80, 0xa8, 0x159, 90, 
            0x85, 0x14c, 0x14c, 0x13c, 0xb5, 0x188, 0x162, 350, 0xaf, 0x13d, 0x14c, 0x156, 0x15c, 0xe8, 0x17a, 0xb3, 
            330, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0x15c, 0x5c, 0x16b, 0x162, 0x171, 0x15b, 0x15a, 0xe8, 0xd6, 0x74, 0xbd, 350, 0xbc, 0x3e, 0x164, 0x162, 
            0xa2, 0x15, 0xaf, 110, 0xad, 290, 0x164, 350, 0xfb, 250, 0xa4, 0xb0, 0x11c, 0xf4, 0x14e, 0xab, 
            0x156, 0x71, 0x179, 0x149, 0x9a, 0xf3, 0x5e, 0x163, 0x129, 110, 0xf9, 0x15c, 0x147, 0xac, 0x5c, 0x15c, 
            0x15c, 0x77, 0x171, 0xbc, 290, 0xaf, 130, 0xab, 0x7d, 0x14c, 0x36, 0x7d, 0x7d, 0x159, 0x161, 0, 
            50, 0xe4, 50, 0xe4, 0x17a, 0x7d, 0xbd, 0x162, 0xac, 0x23, 0xfd, 170, 0xd0, 0x85, 0xfd, 0x83, 
            0x126, 0x14d, 0x159, 0x7c, 0xbd, 0xa4, 370, 0x83, 0xf1, 0xab, 0x159, 50, 0xb5, 110, 0x21, 0x54, 
            190, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            190, 0x54, 0xe4, 250, 250, 0xc5, 0x54, 0x159, 0x9d, 190, 0x25, 0x53, 250, 190, 0xc4, 0xc4, 
            0x184, 0, 0x52, 120, 130, 0x65, 310, 0x13b, 0x75, 0x98, 0x72, 0x25, 0x6f, 0x15c, 0x39, 330, 
            0x13f, 0xc4, 0xf3, 0x171, 0x159, 0xba, 0x159, 0x164, 0x131, 0x159, 0x159, 0x159, 0x175, 0x175, 0x180, 0x18, 
            0x15c, 0xba, 0x171, 0x159, 70, 0xaf, 0x52, 0xc1, 0x163, 50, 250, 0x173, 0x141, 0x17a, 0x177, 0, 
            0xbc, 5, 0x11, 320, 14, 0x173, 0xbd, 0x175, 0x182, 0x61, 0x44, 0x52, 0x163, 0x20, 90, 0xf1, 
            0x163, 0x131, 0x134, 0x11e, 0x51, 0x146, 0x51, 0x40, 320, 0x178, 250, 0x11b, 0x11c, 0x11c, 0x139, 330, 
            0x83, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0x7a, 330, 0x159, 0x13c, 0x126, 0x14c, 0xa2, 220, 0x149, 0x149, 0x94, 0x14f, 110, 0x153, 0x147, 0x16f, 
            0xd8, 0xca, 0x182, 0x170, 0x5c, 0x182, 0x5c, 0x5c, 0x25, 0x23, 0x23, 110, 0x158, 0x15d, 0x14f, 10, 
            0x16b, 0x14f, 0x182, 0x25, 0x159, 0x16f, 0x137, 0xab, 0xab, 40, 0xfb, 0x14f, 0x15d, 0xd4, 0x85, 220, 
            0x2e, 0x165, 0x162, 40, 0x15c, 0xd0, 0x16f, 0x184, 250, 0x165, 0x159, 0x162, 0x4b, 0x148, 0x15c, 0, 
            0x36, 0x184, 0x3f, 40, 130, 0x158, 110, 0x15d, 0xb7, 0xe3, 0x148, 0xe3, 0x159, 0xb7, 0xad, 0x5f, 
            0x8f, 0x37, 0xab, 0x37, 0xf9, 0xf9, 0x11, 0x2c, 110, 0x88, 0x14f, 0x164, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }, { 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 
            0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
         }
     };
        private static readonly string[] _spellMusicCode = new string[] { 
        "a", "ai", "an", "ang", "ao", "ba", "bai", "ban", "bang", "bao", "bei", "ben", "beng", "bi", "bian", "biao", 
        "bie", "bin", "bing", "bo", "bu", "ca", "cai", "can", "cang", "cao", "ce", "ceng", "cha", "chai", "chan", "chang", 
        "chao", "che", "chen", "cheng", "chi", "chong", "chou", "chu", "chuai", "chuan", "chuang", "chui", "chun", "chuo", "ci", "cong", 
        "cou", "cu", "cuan", "cui", "cun", "cuo", "da", "dai", "dan", "dang", "dao", "de", "deng", "di", "dian", "diao", 
        "die", "ding", "diu", "dong", "dou", "du", "duan", "dui", "dun", "duo", "e", "en", "er", "fa", "fan", "fang", 
        "fei", "fen", "feng", "fu", "fou", "ga", "gai", "gan", "gang", "gao", "ge", "ji", "gen", "geng", "gong", "gou", 
        "gu", "gua", "guai", "guan", "guang", "gui", "gun", "guo", "ha", "hai", "han", "hang", "hao", "he", "hei", "hen", 
        "heng", "hong", "hou", "hu", "hua", "huai", "huan", "huang", "hui", "hun", "huo", "jia", "jian", "jiang", "qiao", "jiao", 
        "jie", "jin", "jing", "jiong", "jiu", "ju", "juan", "jue", "jun", "ka", "kai", "kan", "kang", "kao", "ke", "ken", 
        "keng", "kong", "kou", "ku", "kua", "kuai", "kuan", "kuang", "kui", "kun", "kuo", "la", "lai", "lan", "lang", "lao", 
        "le", "lei", "leng", "li", "lia", "lian", "liang", "liao", "lie", "lin", "ling", "liu", "long", "lou", "lu", "luan", 
        "lue", "lun", "luo", "ma", "mai", "man", "mang", "mao", "me", "mei", "men", "meng", "mi", "mian", "miao", "mie", 
        "min", "ming", "miu", "mo", "mou", "mu", "na", "nai", "nan", "nang", "nao", "ne", "nei", "nen", "neng", "ni", 
        "nian", "niang", "niao", "nie", "nin", "ning", "niu", "nong", "nu", "nuan", "nue", "yao", "nuo", "o", "ou", "pa", 
        "pai", "pan", "pang", "pao", "pei", "pen", "peng", "pi", "pian", "piao", "pie", "pin", "ping", "po", "pou", "pu", 
        "qi", "qia", "qian", "qiang", "qie", "qin", "qing", "qiong", "qiu", "qu", "quan", "que", "qun", "ran", "rang", "rao", 
        "re", "ren", "reng", "ri", "rong", "rou", "ru", "ruan", "rui", "run", "ruo", "sa", "sai", "san", "sang", "sao", 
        "se", "sen", "seng", "sha", "shai", "shan", "shang", "shao", "she", "shen", "sheng", "shi", "shou", "shu", "shua", "shuai", 
        "shuan", "shuang", "shui", "shun", "shuo", "si", "song", "sou", "su", "suan", "sui", "sun", "suo", "ta", "tai", "tan", 
        "tang", "tao", "te", "teng", "ti", "tian", "tiao", "tie", "ting", "tong", "tou", "tu", "tuan", "tui", "tun", "tuo", 
        "wa", "wai", "wan", "wang", "wei", "wen", "weng", "wo", "wu", "xi", "xia", "xian", "xiang", "xiao", "xie", "xin", 
        "xing", "xiong", "xiu", "xu", "xuan", "xue", "xun", "ya", "yan", "yang", "ye", "yi", "yin", "ying", "yo", "yong", 
        "you", "yu", "yuan", "yue", "yun", "za", "zai", "zan", "zang", "zao", "ze", "zei", "zen", "zeng", "zha", "zhai", 
        "zhan", "zhang", "zhao", "zhe", "zhen", "zheng", "zhi", "zhong", "zhou", "zhu", "zhua", "zhuai", "zhuan", "zhuang", "zhui", "zhun", 
        "zhuo", "zi", "zong", "zou", "zu", "zuan", "zui", "zun", "zuo", "", "ei", "m", "n", "dia", "cen", "nou", 
        "jv", "qv", "xv", "lv", "nv"
     };

        /// <summary>
        /// 将中文转化为拼音
        /// </summary>
        /// <param name="strChinese">中文</param>
        /// <param name="options">选项</param>
        /// <returns></returns>
        public static string MakeSpellCode(string strChinese, string splitChar, SpellOptions options)
        {
            byte[] bytes = Encoding.GetEncoding("GB2312").GetBytes(strChinese);
            int index = 0;
            StringBuilder sb = new StringBuilder();
            string append = "";
            int length = bytes.Length;
            while (index < length)
            {
                char ch2;
                if ((bytes[index] < 0x81) || (bytes[index + 1] < 0x40))
                {
                    goto Label_0187;
                }
                switch (bytes[index])
                {
                    case 0xa2:
                        if (bytes[index + 1] <= 160)
                        {
                            break;
                        }
                        append = _charIndex[bytes[index + 1] - 160];
                        goto Label_016A;

                    case 0xa3:
                        append = ((char)(bytes[index + 1] - 0x80)).ToString();
                        if (((((options & SpellOptions.EnableUnicodeLetter) == SpellOptions.EnableUnicodeLetter) && ((append[0] < 'a') || (append[0] > 'z'))) && ((append[0] < 'A') || (append[0] > 'Z'))) && ((append[0] < '0') || (append[0] > '9')))
                        {
                            append = "";
                        }
                        goto Label_016A;

                    case 0xa6:
                        append = "";
                        goto Label_016A;

                    default:
                        {
                            int num2 = _spellCodeIndex[bytes[index] - 0x81, bytes[index + 1] - 0x40] - 1;
                            if (num2 == -1)
                            {
                                append = "";
                            }
                            else if ((options & SpellOptions.FirstLetterOnly) == SpellOptions.FirstLetterOnly)
                            {
                                append = _spellMusicCode[num2].Substring(0, 1);
                            }
                            else
                            {
                                append = _spellMusicCode[num2];
                            }
                            goto Label_016A;
                        }
                }
                append = "";
            Label_016A:
                if (!string.IsNullOrEmpty(append))
                {
                    AppendString(sb, append, splitChar);
                    //AppendString(sb, append.Substring(0, 1).ToUpper(), splitChar);
                }
                index += 2;
                continue;
            Label_0187:
                ch2 = (char)bytes[index];
                AppendString(sb, ch2.ToString(), splitChar);
                index++;
            }
            return sb.ToString();
        }

        /// <summary>
        /// 字符串连接
        /// </summary>
        /// <param name="sb">原字符串</param>
        /// <param name="append">要添加的字符串</param>
        /// <param name="split">分隔符</param>
        public static void AppendString(StringBuilder sb, string append, string split)
        {
            if (sb.Length == 0)
            {
                sb.Append(append);
            }
            else
            {
                sb.Append(split);
                sb.Append(append);
            }
        }
    }

    public enum SpellOptions
    {
        //完整拼音
        EnableUnicodeLetter = 4,
        //头字母
        FirstLetterOnly = 1,
        //不识别的字用?号代替
        TranslateUnknowWordToInterrogation = 2
    }
}
