﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="UpFiles.aspx.cs" Inherits="QiCms.Web.Admin.UpFiles" %>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title>奇布思CMS网站管理系统</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="renderer" content="webkit">
    <meta http-equiv="Cache-Control" content="no-siteapp" />
    <link rel="icon" type="image/png" href="/template/admin/i/favicon.png">
    <link rel="apple-touch-icon-precomposed" href="/template/admin/i/app-icon72x72@2x.png">
    <meta name="apple-mobile-web-app-title" content="Amaze UI" />
    <link rel="stylesheet" href="/template/admin/css/amazeui.min.css" />
    <link rel="stylesheet" href="/template/admin/css/admin.css">
    <link rel="stylesheet" href="/template/admin/css/app.css">
    <script src="/template/admin/js/clipboard.min.js"></script>
</head>
<body>
    <form id="UpFileForm" runat="server">
        <div class="tpl-content-wrapper">
            <div class="tpl-portlet-components">
                <div class="portlet-title">
                    <div class="caption font-green bold">
                        <span class="am-icon-cloud-upload"></span>上传文件
                    </div>
                </div>

                <div class="am-tabs-bd am-g tpl-amazeui-form">

                    <div class="am-form am-form-horizontal">
                        <div class="am-u-sm-9" style="font-size:14px;margin-top: 10px; width: 100%; text-align: center">
				        <small>支持文件类型：JPG,JPEG,GIF,PNG,SWF,RAR,ZIP。</small>
			            </div>

                        <div class="am-form-group">
                            <label for="user-name" class="am-u-sm-3 am-form-label" style="color:darkred;">选择文件：
                            <asp:RequiredFieldValidator ID="UploadFieldValR" runat="server" ErrorMessage="*" Display="Dynamic"></asp:RequiredFieldValidator>
                            </label>
                            <div class="am-u-sm-9">
                                <asp:FileUpload ID="FileUpld" runat="server" Width="320" CssClass="am-btn " />
                            </div>
                        </div>
                        <div class="am-form-group">
                            <label for="user-name" class="am-u-sm-3 am-form-label" style="color:darkred;">注意：</label>
                            <div class="am-u-sm-9" style="font-size:14px;margin-top:8px;">
                                <asp:CheckBox ID="SmallImageChk" runat="server" Text="生成缩略图(选择此项不能生成水印)" ForeColor="Red" /><br />
                                <asp:RegularExpressionValidator ID="UploadValRE" runat="server" ErrorMessage="文件格式不正确" Display="Dynamic"></asp:RegularExpressionValidator>
                            </div>
                        </div>

                        <div class="am-form-group">
                            <div class="am-u-sm-9 am-u-sm-push-3">
                                <asp:Button ID="UploadBtn" CssClass="am-btn am-btn-primary tpl-btn-bg-color-success" runat="server" Text="上传" onclick="UploadBtn_Click"/>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </form>

    <div class="tpl-content-wrapper" id="UploadedTbl" runat="server">
            <div class="tpl-portlet-components">
                <div class="portlet-title">
                    <div class="caption font-green bold">
                        <span class="am-icon-cloud-upload"></span>上传文件
                    </div>
                </div>

                <div class="am-tabs-bd am-g tpl-amazeui-form">

                    <div class="am-form am-form-horizontal">
                        <div class="am-text-danger" style="font-size:16px;margin-top: 10px; width: 100%; text-align: center">
				        文件上传成功。
			            </div>

                        <div class="am-form-group">
                            <label for="user-name" class="am-u-sm-3 am-form-label" style="text-align:left;color:darkred;">文件地址：</label>
                            <div class="am-u-sm-9">
                                <input id="CopyTxt" runat="server" readonly="readonly" size="50" type="text" />
                            </div>
                        </div>
                        <div class="am-form-group">
                            <label for="user-name" class="am-u-sm-3 am-form-label" style="text-align:left;color:darkred;">注意：</label>
                            <div class="am-u-sm-9">
                                <button class="am-btn am-btn-primary tpl-btn-bg-color-success" data-clipboard-text="<%=CopyTxt.Value %>">复制到剪贴板</button>&nbsp;
                                <input class="am-btn am-btn-primary tpl-btn-bg-color-success" onclick="window.open('../' + CopyTxt.value,'Preview')" type="button" value="预览图片" />
                            </div>
                        </div>
                            <script>
                                var btns = document.querySelectorAll('button');
                                var clipboard = new Clipboard(btns);

                                clipboard.on('success', function (e) {
                                    console.log(e);
                                });

                                clipboard.on('error', function (e) {
                                    console.log(e);
                                });
                            </script>

                    </div>
                </div>
            </div>
        </div>

</body>
</html>

