﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="List.aspx.cs" Inherits="QiCms.Web.Config.List" %>
<%@ Import namespace="QiCms.WebPage" %>
<!DOCTYPE html>
<html>
<head>
<title><%=keystr %></title>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=1">
<meta name="apple-mobile-web-app-title" content="<%=ShowContent.TitleName %>">
<meta name="author" content="<%=ShowContent.Author %>" />
<meta name="description" content="<%=ClassSummary %>" />
<meta name="keywords" content="<%=ShowContent.KeyWords %>" />
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/font-awesome.min.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/ewen-icons.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/animate.min.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/cubeportfolio.min.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/owl.carousel.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/owl.transitions.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/settings.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/bootsnav.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/jquery.fancybox.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/loader.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/style.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/orange.css">
<link rel="icon" href="<%=ShowContent.DefaultTemplatePath %>images/favicon.png"> 
<script src="<%=ShowContent.DefaultTemplatePath %>js/js.js"></script>
<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->
</head>
<body>

<!--#include file="Header.html"-->

<!-- Page Header -->
<section class="padding page_header" style="background:url(<%=ClassPic %>) no-repeat;background-attachment:fixed;background-size:cover;">
  <div class="container">
    <div class="row">
      <div class="col-sm-12 text-center">
        <h1 class="text-capitalize top40"><%=ClassName %></h1>
        <p class="bottom30"><%=ClassSummary %></p>
        <ul class="breadcrumb_link">
          <li><a href="<%=ShowContent.Url %>">Home</a></li>
          <li class="active"><%=ClassName %></li>
        </ul>
      </div>
    </div>
  </div>
</section>
<!-- Page Header ends -->

<!-- Blog & News -->
<section id="ewn_news" class="light shadow padding_bottom_half padding_top">
  <div class="container">
    <div class="row">
      <div class="col-sm-8">
        <%=ShowContent.ArticleList(40,200) %>
       
        <ul class="pager heading_space">
          <%=ShowContent.Pagination%><%=ShowContent.NextPrev%>
        </ul>
      </div>
      <div class="col-sm-4">
        <div class="widget heading_space">
          <form class="widget_search border-radius" method="get" action="Search.aspx">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="input-group">
                            <input type="search" class="form-control" name="s" placeholder="Search for...">
                            <span class="input-group-btn">
                                <button class="btn btn-success btn-lg icon-icons185" type="submit"></button>
                            </span>
                        </div><!-- /input-group -->
                    </div><!-- /.col-lg-6 -->
                </div>
            </form>
        </div>
      
        <div class="widget heading_space">
          <h4 class="bottom15">Categories</h4>
          <ul class="category">
            <%=ClassNavigate%>
          </ul>

        </div>
        <div class="widget heading_space">
          <h4 class="bottom15">Tags</h4>
          <ul class="tags">
            <li><a href="#.">web design</a></li>
            <li><a href="#.">network</a></li>
            <li><a href="#.">marketing</a></li>
            <li><a href="#.">posts</a></li>
            <li><a href="#.">event</a></li>
            <li><a href="#.">website</a></li>
            <li><a href="#.">social</a></li>
            <li><a href="#.">themeforest</a></li>
            <li><a href="#.">creative</a></li>
            <li><a href="#.">best solutions</a></li>
          </ul>
        </div>
        <div class="widget heading_space">
          <h4 class="bottom15">Pic News</h4>
          <div class="row">
            <%=ShowContent.ListPic(0,0,69,69) %>
          </div>
        </div>
        <div class="widget heading_space">
          <div class="image bottom30"><img src="<%=ShowContent.DefaultTemplatePath %>images/about-sidebar.jpg" alt="About Us"></div>
          <h3 class="bottom15">About Us</h3>
          <p class="bottom0"><%=ShowContent.AboutList("About") %></p>
        </div>
        
      </div>
    </div>
  </div>
</section>
<!-- News ends -->

<!--#include file="Footer.html"-->
        
</body>
</html>
