﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Show.aspx.cs" Inherits="QiCms.Web.Config.Show" %>
<%@ Import namespace="QiCms.WebPage" %>
<!DOCTYPE html>
<html>
<head>
<title><%=keystr %></title>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1, user-scalable=1">
<meta name="apple-mobile-web-app-title" content="<%=ShowContent.TitleName %>">
<meta name="author" content="<%=Author %>" />
<meta name="description" content="<%=Description %>" />
<meta name="keywords" content="<%=KeyWords %>" />
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/bootstrap.min.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/font-awesome.min.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/ewen-icons.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/animate.min.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/cubeportfolio.min.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/owl.carousel.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/owl.transitions.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/settings.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/bootsnav.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/jquery.fancybox.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/loader.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/style.css">
<link rel="stylesheet" type="text/css" href="<%=ShowContent.DefaultTemplatePath %>css/orange.css">
<link rel="icon" href="<%=ShowContent.DefaultTemplatePath %>images/favicon.png"> 
<script src="<%=ShowContent.DefaultTemplatePath %>js/js.js"></script>
<!--[if lt IE 9]>
<script src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
<script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->
</head>
<body>

<!--#include file="Header.html"-->


<!-- Page Header -->
<section class="padding page_header" style="background:url(<%=ClassPic %>) no-repeat;background-attachment:fixed;background-size:cover;">
  <div class="container">
    <div class="row">
      <div class="col-sm-12 text-center">
        <h1 class="text-capitalize top40"><%=ClassName %></h1>
        <p class="bottom30"><%=ClassSummary %></p>
        <ul class="breadcrumb_link">
          <li><a href="<%=ShowContent.Url %>">Home</a></li>
          <li class="active"><%=ClassName %></li>
        </ul>
      </div>
    </div>
  </div>
</section>
<!-- Page Header ends -->



<!-- Blog & News -->
<section id="ewn_news" class="light shadow padding_bottom_half padding_top">
  <div class="container">
    <div class="row">
      <div class="col-sm-8">
        <div class="news_item heading_space">
          <%=PageImg %>
          <div class="news_desc">
            <h3 class="text-capitalize"><%=PageTitle %></h3>
            <ul class="ewn_meta top20 bottom20">
              <li><a href="#"><i class="icon-calendar2"></i><%=AddTime %></a></li>
              <li><a href="#" > <i class="icon-profile-male"></i> By <%=Author %></a></li>
              <li><a href="#"><i class="icon-comment"></i><%=RemarkNum %> Comments</a></li>
            </ul>
             <blockquote><%=Summary %></blockquote>
             <div class="row">
                <%=PageContent %>
             </div>
             
             
             <ul class="tags">
             <li><a href="#.">预留位</a></li>
             <li><a href="#.">work place</a></li>
             <li><a href="#.">creative</a></li>
             </ul>

          </div>
        </div>
 <!--     评论预留位  
        <div class="widget profile dark heading_space">
          <div class="photo">
            <img src="<%=ShowContent.DefaultTemplatePath %>images/profile.png" alt="Latest News">
          </div>
          <div class="profile_body">
            <h4 class="text-capitalize"><a href="news_detail.html" class="green_t">Alison Johnson</a> <small>January 26, 2016</small></h4>
            <p class="top20 bottom15 white_t">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry's standard dummy.</p>
            <ul class="social">
              <li><a href="#" class="facebook"><i class="fa fa-facebook"></i></a></li>
              <li><a href="#" class="twitter"><i class="icon-twitter4"></i></a></li>
              <li><a href="#" class="dribbble"><i class="icon-dribbble4"></i></a></li>
              <li><a href="#" class="instagram"><i class="icon-instagram"></i></a></li>
            </ul>
          </div>
        </div>
        <h3>Comments</h3>
        <div class="widget profile top20">
          <div class="photo">
            <img src="<%=ShowContent.DefaultTemplatePath %>images/commenter1.png" alt="Latest News">
          </div>
          <div class="profile_body">
            <a href="#." class="btn_reply">Reply</a>
            <h4 class="text-capitalize"><a href="news_detail.html"><strong>Claire Gibson</strong></a></h4>
            <p class="top20 bottom0">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Ipsum has been the industry's standard dummy. printing and 
            typesetting industry. Ipsum has been standard dummy.</p>
          </div>
        </div>
        <div class="widget profile top20 col-md-offset-2 col-sm-offset-2">
          <div class="photo">
            <img src="<%=ShowContent.DefaultTemplatePath %>images/commenter2.png" alt="Latest News">
          </div>
          <div class="profile_body">
            <a href="#." class="btn_reply">Reply</a>
            <h4 class="text-capitalize"><a href="news_detail.html"><strong>Claire Gibson</strong></a></h4>
            <p class="top20 bottom0">Lorem Ipsum is simply dummy text of the printing and typesetting that industry. been the industry's standard dummy. .</p>
          </div>
        </div>
        <div class="widget profile top20">
          <div class="photo">
            <img src="<%=ShowContent.DefaultTemplatePath %>images/commenter3.png" alt="Latest News">
          </div>
          <div class="profile_body">
            <a href="#." class="btn_reply">Reply</a>
            <h4 class="text-capitalize"><a href="news_detail.html"><strong>Claire Gibson</strong></a></h4>
            <p class="top20 bottom0">Lorem Ipsum is simply dummy text of the printing and typesetting industry. Ipsum has been the industry's standard dummy. </p>
          </div>
        </div>
        
        <div class="widget top40 heading_space">
        <h3 class="bottom20">Leave a Comment</h3>
        <form class="callus">
          <div class="row">
            <div class="col-sm-6">
              <div class="form-group">
                <input type="text" class="form-control" placeholder="Your Name">
              </div>
            </div>
            <div class="col-sm-6">
              <div class="form-group">
                <input type="email" class="form-control" placeholder="Email Address">
              </div>
            </div>
            <div class="col-sm-12">
              <div class="form-group">
                <textarea class="form-control" placeholder="Your Message"></textarea>
              </div>
              <a href="#." class="btn_border btn_default active">submit</a>
            </div>
          </div>
        </form>
        </div>
        -->

      </div>


      <div class="col-sm-4">
        <div class="widget heading_space">
          <form class="widget_search border-radius" method="get" action="Search.aspx">
                <div class="row">
                    <div class="col-lg-12">
                        <div class="input-group">
                            <input type="search" class="form-control" name="s" placeholder="Search for...">
                            <span class="input-group-btn">
                                <button class="btn btn-success btn-lg icon-icons185" type="submit"></button>
                            </span>
                        </div><!-- /input-group -->
                    </div><!-- /.col-lg-6 -->
                </div>
            </form>
        </div>

        <div class="widget heading_space">
          <h4 class="bottom15">Week News</h4>
          <ul class="category">
            <%=ShowContent.WeekHitsList(28,"icon-star-full") %>
          </ul>
        </div>
        <div class="widget heading_space">
          <h4 class="bottom15">Tags</h4>
          <ul class="tags">
            <li><a href="#.">预留</a></li>
            <li><a href="#.">network</a></li>
            <li><a href="#.">marketing</a></li>
            <li><a href="#.">posts</a></li>
            <li><a href="#.">event</a></li>
            <li><a href="#.">website</a></li>
            <li><a href="#.">social</a></li>
            <li><a href="#.">themeforest</a></li>
            <li><a href="#.">creative</a></li>
            <li><a href="#.">best solutions</a></li>
          </ul>
        </div>
        <div class="widget heading_space">
          <h4 class="bottom15">Pic News</h4>
          <div class="row">
            <%=ShowContent.ListPic(0,0,69,69) %>
          </div>
        </div>
        <div class="widget heading_space">
          <div class="image bottom30"><img src="<%=ShowContent.DefaultTemplatePath %>images/about-sidebar.jpg" alt="About Us"></div>
          <h3 class="bottom15">About Us</h3>
          <p class="bottom0"><%=ShowContent.AboutList("About") %></p>
        </div>
        
      </div>
    </div>
  </div>
</section>
<!-- News ends -->


<!--#include file="Footer.html"-->
        
</body>
</html>