﻿<%@ Page Title="" Language="C#" MasterPageFile="~/admin/adminmaster.master" AutoEventWireup="true"
    CodeBehind="admin_articleclass.aspx.cs" Inherits="V5_CMS.admin.article.admin_articleclass" %>
<%@ Import Namespace="V5_CMS._Class.Common"  %>
<%@ Register Namespace="Wuqi.Webdiyer" TagPrefix="webdiyer" Assembly="V5_Utility" %>
<asp:Content ID="Content1" ContentPlaceHolderID="TitleConent" runat="server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="HeaderConent" runat="server">
</asp:Content>
<asp:Content ID="Content3" ContentPlaceHolderID="BodyerContent" runat="server">
    <table cellpadding="0" cellspacing="0" class="tablelist">
        <tr>
            <td class="headertext">位置导航：<a class="list_link" href="<%=this.ResolveUrl("~/") %>admin/index/main"
                target="main">首页</a> >> 文章分类管理
            </td>
        </tr>
        <tr>
            <td>
                <span class="back"><a href="?">管理首页</a></span> | <span class="add"><a href="?action=edit">添加文章分类</a></span>
            </td>
        </tr>
    </table>
    <asp:MultiView ID="MultiViewList" runat="server">
        <asp:View ID="View1" runat="server">
            <asp:GridView ID="gvList" runat="server" OnRowCommand="gvList_RowCommand" CssClass="tablelist overlist rowlist tableheader"
                AutoGenerateColumns="False" GridLines="None">
                <HeaderStyle CssClass="headertext" />
                <Columns>
                    <asp:BoundField DataField="ClassiD" HeaderText="ID">
                        <HeaderStyle HorizontalAlign="Center" Width="30px" />
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:BoundField>
                    <asp:TemplateField HeaderText="分类名称">
                        <ItemTemplate>
                            <%# ClassHelper.Instance.GetColumnListName(Eval("classname", "{0}"), Eval("ClassCode", "{0}"))%>(<%#Eval("Num") %>)
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField>
                        <HeaderStyle HorizontalAlign="Center" Width="150px" />
                        <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:LinkButton ID="LinkButton6" runat="server" CommandArgument='<%#Eval("ClassID") %>'
                                CommandName="up">升</asp:LinkButton>
                            <asp:LinkButton ID="LinkButton7" runat="server" CommandArgument='<%#Eval("ClassID") %>'
                                CommandName="down">降</asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="扩展字段">
                        <ItemTemplate>
                            <%#Eval("parentid").ToString()=="0"?"<a href='../ext/admin_extfield.aspx?type=article&classid="+Eval("classid")+"'>配置</a>" :""%>
                        </ItemTemplate>
                        <HeaderStyle HorizontalAlign="Center" Width="50px" />
                        <ItemStyle HorizontalAlign="Center" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="操作">
                        <HeaderStyle HorizontalAlign="Center" Width="150px" />
                        <ItemStyle HorizontalAlign="Center" />
                        <ItemTemplate>
                            <asp:LinkButton ID="LinkButton5" runat="server" CommandArgument='<%#Eval("ClassID") %>'
                                CommandName="addsubclass">添加子类</asp:LinkButton>
                            <asp:LinkButton ID="LinkButton1" runat="server" CommandArgument='<%#Eval("ClassID") %>'
                                CommandName="go">修改</asp:LinkButton>
                            <asp:LinkButton ID="LinkButton2" runat="server" CommandArgument='<%#Eval("ClassID") %>'
                                CommandName="del" OnClientClick="return confirm('你确定要删除吗?');">删除</asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <table border="0" cellpadding="0" cellspacing="0" class="tablelist">
                <tr>
                    <td>
                        <webdiyer:AspNetPager ID="Pager" runat="server" CustomInfoHTML="共%PageCount%页，当前为第%CurrentPageIndex%页，每页%PageSize%条"
                            FirstPageText="首页" HorizontalAlign="Right" LastPageText="尾页" NextPageText="下一页"
                            OnPageChanged="Pager_PageChanged" PageIndexBoxType="DropDownList" PageSize="20"
                            PrevPageText="上一页" ShowCustomInfoSection="Left" ShowPageIndexBox="Always" SubmitButtonText="Go"
                            TextAfterPageIndexBox="页" TextBeforePageIndexBox="转到" AlwaysShow="True" CssClass="pager-list">
                        </webdiyer:AspNetPager>
                    </td>
                </tr>
            </table>
        </asp:View>
        <asp:View ID="View2" runat="server">
            <table border="0" cellpadding="0" cellspacing="0" class="tablelist rowlist">
                <tr>
                    <td colspan="2" class="headertext">
                        <asp:Label ID="lblTitle" runat="server" Text="添加分类"></asp:Label>
                    </td>
                </tr>
                <tr>
                    <td style="width: 15%;">分类名称<span class="font-red">*</span>
                    </td>
                    <td>
                        <asp:TextBox ID="txtClassName" runat="server" HintInfo="控制在100个字数内，分类名称文本尽量不要太长。"
                            HintTitle="信息标题" MaxLength="200" Width="220px"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>所属分类
                    </td>
                    <td>
                        <asp:DropDownList ID="ddlClassID" runat="server">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>网站关键词
                    </td>
                    <td>
                        <asp:TextBox ID="txtClassKeyWord" Width="200px" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>网站说明
                    </td>
                    <td>
                        <asp:TextBox ID="txtClassDescription" TextMode="MultiLine" Width="300px" Height="100px" runat="server"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>分类简介
                    </td>
                    <td>
                        <asp:TextBox ID="txtInfo" runat="server" Height="95px" MaxLength="200" TextMode="MultiLine"
                            Width="300px"></asp:TextBox>
                    </td>
                </tr>
                <tr >
                    <td>列表模板
                    </td>
                    <td>
                        <asp:TextBox ID="txtTemplateList" Width="300px" runat="server"></asp:TextBox>
                        <asp:DropDownList ID="ddlTemplateListFile" runat="server" onchange="setTemplate1()"></asp:DropDownList>
                        <script>
                            function setTemplate1() {
                                $("#<%=this.txtTemplateList.ClientID%>").val($("#<%=this.ddlTemplateListFile.ClientID%>").val());
                            }
                        </script>
                        为空读取默认模板
                    </td>
                </tr>
                <tr>
                    <td>详细模板
                    </td>
                    <td>
                        <asp:TextBox ID="txtTemplateView" Width="300px" runat="server"></asp:TextBox>
                        <asp:DropDownList ID="ddlTemplateViewFile" runat="server" onchange="setTemplate2()"></asp:DropDownList>
                        <script>
                            function setTemplate2() {
                                $("#<%=this.txtTemplateView.ClientID%>").val($("#<%=this.ddlTemplateViewFile.ClientID%>").val());
                            }
                        </script>
                        为空读取默认模板
                    </td>
                </tr>
                <tr>
                    <td colspan="2" align="center">
                        <asp:HiddenField ID="hfParentID" runat="server" Value="0" />
                        <asp:HiddenField ID="hfClassID" runat="server" />
                        <asp:Button ID="btnSave" runat="server" Text="保存添加" OnClick="btnSave_Click" CssClass="ds-btn ds-btn-ok" />
                    </td>
                </tr>
            </table>
            <script type="text/javascript">
                $(function(){
                    $("#<%=this.ddlClassID.ClientID%>").click(function(){
                        load_ExtShow(this);
                    });

                    load_ExtShow("#<%=this.ddlClassID.ClientID%>");
                    //Load_ShowTemplate("#<%=this.hfParentID.ClientID%>");
                });

                function Load_ShowTemplate($parentId) {
                    var parentId = $($parentId).val();
                    if (parentId == "0") {
                        $(".template-show").css("display", "block");
                    } else {
                        $(".template-show").css("display", "none");
                    }
                }

                function load_ExtShow(thisObj){
                    me = $(thisObj);
                    if(me.val()=="0"||me.val()==""){
                        $(".ext_show").css("display","");
                    }else{
                        $(".ext_show").css("display","none");
                    }
                }
            </script>
            <script type="text/javascript">
                $(function() {
                    $("#<%=this.Form.ClientID %>").validate({
                        rules: {
                            <%=txtClassName.UniqueID %>:
                        {
                            required: true
                        }
                        },
                        messages:{
                            <%=txtClassName.UniqueID %>:
                        {
                            required: "分类名称不能为空!"
                        }
                        }
                    });
                });
            </script>
        </asp:View>
    </asp:MultiView>
</asp:Content>