﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="uploadfiles.ascx.cs" Inherits="V5_CMS.admin.controls.uploadfiles" %>

<%@ Import Namespace="System.IO" %>
<%
    string fileIconPath = this.ResolveUrl("~/") + "includes/files/";
%>
<div id="content">
    <div class="right">
        <h4>上传附件</h4>
        <p>
            文件目录:<%=DateTime.Now.ToString("yyyyMM") %>
        </p>
        <p>
            <asp:FileUpload ID="FileUpload1" runat="server" Width="180px" />
        </p>
        <p>
            自动命名:
        </p>
        <p>
            <asp:RadioButtonList ID="rblistAutoReName" runat="server" RepeatLayout="Flow">
                <asp:ListItem Text="不自动命名" Value="0" Selected="True"></asp:ListItem>
                <asp:ListItem Text="&quot; 副件&quot;+文件名" Value="1"></asp:ListItem>
                <asp:ListItem Text="20111101122333" Value="2"></asp:ListItem>
            </asp:RadioButtonList>
        </p>
        <p>
            <asp:CheckBox ID="chkWatermark" runat="server" Text="加水印(图片)" Checked="true" />
            <a href="" class="small">水印详细设置</a>
        </p>
        <p>
            存在同名文件时:
        </p>
        <p>
            <asp:RadioButtonList ID="rblistType" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                <asp:ListItem Value="1" Text="跳过" Selected="True"></asp:ListItem>
                <asp:ListItem Value="2" Text="重命名"></asp:ListItem>
                <asp:ListItem Value="3" Text="覆盖"></asp:ListItem>
            </asp:RadioButtonList>
        </p>
        <p>
            直接插入:<asp:CheckBox ID="chkIsInsert" runat="server" Text="是" Checked="true" />
        </p>
        <p>
            <asp:Button ID="btnUpload" runat="server" Text="上传" CssClass="button" OnClick="btnUpload_Click" />
        </p>
        <p class="notice" style="word-wrap: break-word; word-break: break-all; overflow: auto;"
            title="<%=AllowFileExtension%>">
            允许格式:<br />
            <%=AllowFileExtension%>
        </p>
    </div>
    <div class="left">
        <h4>导航:
            <%=GetPathUrl()%>地址:<input id="txtUploadUrl" name="txtUploadUrl" type="text" size="30" /><input
                id="Button1" type="button" value="复制" onclick="setTxt();" /></h4>
        <ul class="upfile">
            <%

                foreach (FileSystemInfo d in currentDirectory.GetFileSystemInfos()) {
            %>
            <li>
                <%if (d is DirectoryInfo) {%>
                <a href="<%=FileName %>?path=<%=path %><%=d.Name %>/" title="点击打开此文件夹">

                    <img src="<%=fileIconPath %>folder.png" lt="点击打开此文件夹" width="48" height="48" />
                </a>
                <p class="small">
                    <span title="文件夹:<%=d.Name%>">
                        <%=d.Name%>
                    </span>
                    <br />
                    <span class="gray">
                        <%=((DirectoryInfo)d).GetFileSystemInfos().Length %>
                        个对象</span>
                </p>
                <%
                    }
                    else {
                %>
                <img src="<%=fileIconPath %><%=GetFileImage(d.Extension) %>.gif" width="48"
                    height="48" alt="" class="file" filepath="<%=this.ResolveUrl("~/") %>uploadfiles/<%=path %><%=d.Name %>"
                    title="双击进行选择" />
                <p class="small">
                    <span title="<%=d.Name %>">
                        <%=d.Name %>
                    </span>
                    <br />
                    <span class="gray">
                        <%=ConvertUnit(((FileInfo)d).Length)%></span>
                </p>
                <%
                    } %>
                <a class="delete" href="<%=FileName %>?action=delete&category=<%= d.Attributes%>&deletepath=<%=path %><%=d.Name %>"
                    title="删除" onclick=" return confirm('确定要删除<%=d.Name %> 吗?');">X</a> </li>
            <%
                } %>
        </ul>
    </div>
</div>