﻿/// <reference path="../../scripts/jquery-vsdoc.js" />
String.prototype.Trim = function () {
    return this.replace(/(^\s*)|(\s*$)/g, "");
}
String.prototype.LTrim = function () {
    return this.replace(/(^\s*)/g, "");
}
String.prototype.RTrim = function () {
    return this.replace(/(\s*$)/g, "");
}
jQuery.fn.FieldContent = function (options) {
    var me = this;
    //初始化
    var p = {
        button: "#btnSubmit",//提交按钮
        type: "field",//content字段类型
        classID: "0",//读取字段分类类型
        render: "#render",//加载到标签上
        ajaxUrl: "ext/admin_extfield_ajax.php",//字段库地址
    };
    p = $.extend(p, options);
    //绑定事件
    jQuery(p.button).bind("click", function () {
        me.FieldMerge();
    });
    //初始化
    var LoadFieldListRender = function () {
        $(me).html("");
        var action = "";
        if (p.type == "field") {
            action = "getclassfields";
        } else if (p.type == "content") {
            action = "getclassfieldscontent";
        }
        var ClassID = p.classID;
        if (ClassID == 0 || ClassID == "0") {
            return;
        }
        var data = jQuery.param({
            action: action,
            classid: ClassID
        });
        $.ajax({
            type: "POST",
            url: p.ajaxUrl,
            data: data,
            cache: false,
            success: function (a) {
                try {
                    var result = a;
                    var json = $.parseJSON(result);
                    if (p.type == "field") {
                        FieldRender(json);
                    } else if (p.type == "content") {
                        FieldContentRender(json);
                    }
                } catch (e) {
                    alert(e);
                }
            },
            error: function (a, b, c) {
                alert(a.responseText);
            }
        });
    }
    //渲染
    var FieldRender = function (json1) {
        var str = "";
        var str1 = ""
        var json = json1.data;
        for (var j in json) {
            var js = json[j];
            if (js.ischoice == "" || js.ischoice == "0") {
                str += '<span class="filedlistsetting" title="text" style="">';
                str += '<span class="fieldname">' + js.fieldname + '</span>:';
                str += '<span ><input class="fieldvalue" id="txtField' + j + '" type="text" class="textfield" style="width:80px;" /></span>';
                //添加下拉列表
                var fieldvalues = js.fieldvalues;
                if (fieldvalues.indexOf(',') > -1) {
                    var pList = fieldvalues.split(',');
                    str += '<span class="selectspan1">';
                    str += '<select id="SelectField' + j + '" class="selectspan2" onchange="txtField' + j + '.value=this.options[this.selectedIndex].value;">';
                    str += '<option value="">请选择</option>';
                    for (var ii in pList) {
                        var vText = pList[ii];
                        var vValue = pList[ii];
                        str += '<option value="' + vValue + '">' + vText + '</option>';
                    }
                    str += '</select>';
                    str += '</span>';
                }
                str += "</span>";
            } else if (js.ischoice == "1") {
                str1 += '<span class="filedlistsetting" title="checkbox" style="">';
                str1 += '<span class="fieldname">' + js.fieldname + '</span>:';
                var fieldvalues = js.fieldvalues;
                var pList = fieldvalues.split(',');
                for (var jj = 0; jj < pList.length; jj++) {
                    var pShowName = pList[jj];
                    var pShowImg = "";
                    if (pList[jj].indexOf('|') > -1) {
                        pShowName = pList[jj].split('|')[0];
                        pShowImg = pList[jj].split('|')[1];
                    }
                    str1 += '<span class="fieldchecklist"><input class="fieldvalue" id="Checkbox' + jj + '" type="checkbox" value="' + pList[jj] + '" />';
                    if (pList[jj].indexOf('|') > -1) {
                        str1 += '<img src="' + pShowImg + '" style="width:15px;height:15px;border:0px;"/>';
                    }
                    str1 += '<span class="fieldcheckname">' + pShowName + '</span></span>';
                }
                str1 += "</span><br/>";
            }
        }
        $(me).html(str + "<Br/>" + str1);
        RenderFieldValues();
    }
    //合并结果
    this.FieldMerge = function () {
        if (p.type == "content") {
            me.FieldContentMerge();
            return;
        }
        var str = [];
        $(".filedlistsetting").each(function () {
            var $fieldName = $(this).find(".fieldname");
            var $fieldvalues = $(this).find(".fieldvalue");
            var type = $fieldvalues.attr("type");
            var valuesList = '';
            if (type == "text") {
                valuesList = $fieldvalues.val();
            } else {
                var ss = [];
                $(this).find(".fieldchecklist").each(function () {
                    var $fieldvalues = $(this).find(".fieldvalue");
                    var $fieldCheckName = $(this).find(".fieldcheckname");
                    if ($fieldvalues.attr("checked")) {
                        ss.push($fieldvalues.val().Trim());
                    }
                });
                valuesList = ss.join(",");
            }
            str.push($fieldName.text() + ":" + valuesList);
        });
        $(p.render).val(str.join("||"));
    }
    //初始化
    var RenderFieldValues = function () {
        var extFields = $(p.render).val();
        if (extFields != '') {
            extFieldsArr = extFields.split('||');
            $(".filedlistsetting").each(function () {
                meme = this;
                var type = $(this).attr("title");
                var $fieldName = $(meme).find(".fieldname");
                if (type == "text") {
                    var $fieldvalues = $(meme).find(".fieldvalue");
                    for (var i in extFieldsArr) {
                        var list = extFieldsArr[i];
                        var listArr = extFieldsArr[i].split(':');
                        if ($fieldName.text() == listArr[0]) {
                            $fieldvalues.val(listArr[1]);
                        }
                    }
                } else {
                    $(meme).find(".fieldchecklist").each(function () {
                        var $fieldCheckName = $(this).find(".fieldcheckname");
                        var $fieldvalues = $(this).find(".fieldvalue");
                        for (var i in extFieldsArr) {
                            var list = extFieldsArr[i];
                            var listArr = list.split(':');
                            if ($fieldName.text() == listArr[0]) {
                                var listlist = listArr[1];
                                var listlistArr = listlist.split(',');
                                for (var jj in listlistArr) {
                                    if (listlistArr[jj].Trim() == $fieldvalues.val().Trim()) {
                                        $fieldvalues.attr("checked", true);
                                    }
                                }
                            }
                        }
                    });
                }
            });
        }
    }
    //内容渲染
    var FieldContentRender = function (json1) {
        var str = '';
        var json = json1.data;
        for (var i in json) {
            if (json[i].fieldname != undefined && json[i].fieldname != null) {
                str += '<fieldset class="fieldcontentlistsetting" style="border:#06c dashed 1px; overflow:hidden;width:auto;display:block;float:left;">';
                str += '<legend class="fieldcontenttitle">' + json[i].fieldname + '</legend>';
                str += '<textarea class="fieldcontentvalues" id="txtFieldContent' + i + '" name="fieldcontent' + i + '" rows="5" cols="50" style="width:500px;height:150px;" ></textarea>';
                //这里增加编辑器
                str += '</fieldset>';
            }
        }
        $(me).html(str);
        FieldContentRenderShow();
    }
    //内容合并
    this.FieldContentMerge = function () {
        var str = [];
        $(".fieldcontentlistsetting").each(function () {
            var $fieldcontenttitle = $(this).find(".fieldcontenttitle");
            var $fieldcontentvalues = $(this).find(".fieldcontentvalues");
            str.push($fieldcontenttitle.text() + ":" + $fieldcontentvalues.val());
        });
        $(p.render).val(str.join("||"));
    }
    //绑定数据
    var FieldContentRenderShow = function () {
        var extFields = $(p.render).val();
        if (extFields != '') {
            extFieldsArr = extFields.split('||');
            $(".fieldcontentlistsetting").each(function () {
                meme = this;
                var $fieldName = $(meme).find(".fieldcontenttitle");
                var $fieldValues = $(meme).find(".fieldcontentvalues");
                for (var i in extFieldsArr) {
                    var list = extFieldsArr[i];
                    var listArr = extFieldsArr[i].split(':');
                    if ($fieldName.text() == listArr[0]) {
                        $fieldValues.val(listArr[1]);
                    }
                }
            });
        }
    }

    var init = function () {
        LoadFieldListRender();
    };

    return this.each(function () {
        var _init = init();
    });
};