﻿/// <reference path="../../jquery-vsdoc.js" />
jQuery.fn.moreField = function (options) {
    //初始化
    var p = {
        data: [
                    {
                        id: 1,
                        fieldname: "名称1",
                        choicetype: 0,
                        values: "默认"
                    },
                    {
                        id: 2,
                        fieldname: "名称2",
                        choicetype: 1,
                        values: "1,2,3,4"
                    },
                    {
                        id: 3,
                        fieldname: "名称3",
                        choicetype: 2,
                        values: "1,2,3,4"
                    },
                    {
                        id: 4,
                        fieldname: "名称4",
                        choicetype: 2,
                        values: "1|1.jpg,2|2.jpg,3|3.jpg,4|4.jpg"
                    }
        ]
    };
    p = $.extend(p, options);

    var me = this;
    me.main = me.selector.replace("#", "");

    me.render = function () {

    };

    me.init = function () {
        var html = '';
        for (var d in p.data) {
            var data = p.data[d];
            html += '<span class="fielditem" title="' + data.id + '">';
            html += '<label> ' + data.fieldname + '</label>:';
            if (data.choicetype == 0) {
                html += '<input class="item" type="text" id="" name="" value="' + data.values + '" style="width:80px;"/>';
            } else if (data.choicetype == 1) {
                html += '<select class="item">';
                var arr = data.values.split(",");
                for (var val in arr) {
                    html += '<option value="' + arr[val] + '">' + arr[val] + '</option>';
                }
                html += '</select>';
            } else if (data.choicetype == 2) {
                html += '<span class="item">';
                var arr = data.values.split(",");
                for (var val in arr) {
                    var valImg = arr[val].split('|');
                    html += '<input type="checkbox" value="' + arr[val] + '">';
                    if (valImg.length == 2) {
                        html += '<img src="' + valImg[1] + '" border="0" style="width:15px;height:15px;border:0px;"/>';
                    }
                    html += valImg[0];
                }
                html += '</span>';
            }
            html += '</span>';
        }
        $(me).append(html);

        $(".item").each(function () {
            var me = this;
            console.log($(me));
        });
    };

    return this.each(function () {
        me.init();
    });
};