﻿/// <reference path="../../scripts/jquery-vsdoc.js" />
jQuery.fn.multiFiled = function (options) {
    var me = this;
    //初始化
    var p = {
        selectPhoto: "#0",
        selectButton: "#1",
        fieldName: "#2",
        fieldImgSrc: "#3",
        renderHidden: "#4",
        submitButton: "#5"
    };
    p = $.extend(p, options);

    $(p.selectButton).bind("click", function () {
        me.addFiledControl();
    });

    $(p.submitButton).bind("click", function () {
        me.MergeFileds();
    });

    $(p.selectPhoto).bind("click", function () {
        if (BrowseServer == null || BrowseServer == undefined) {
            alert("BrowseServer函数没有定义!");
            return;
        }
        BrowseServer(function (url, data) {
            if (url != "") {
                $(p.fieldImgSrc).val(url);
            }
        });
    });

    this.addFiledControl = function () {
        /// <summary>
        /// 添加字段
        /// </summary>
        var val = $(p.fieldName).val();
        var picval = $(p.fieldImgSrc).val();
        if (val == "" || picval == "") {
            alert("请输入预设值和图片地址!");
            return;
        }
        me.addField(val, picval);
        $(p.fieldName).val("");
        $(p.fieldImgSrc).val("");
    }

    this.pid = 1;
    this.addField = function (fileTag, fileSrc) {
        /// <summary>
        /// 添加字段
        /// </summary>
        /// <param name="fileTag"></param>
        /// <param name="fileSrc"></param>
        var insertValue = fileTag + '|' + fileSrc;
        var str = '<div id="addfield' + me.pid + '">';
        str += '<span>预设值：</span> ';
        str += '<span><input name="txtFieldValue" style="width: 50px;" type="text" value="' + fileTag + '" /></span> ';
        str += '<span>图片地址：</span> ';
        str += '<span><input type="text" value="' + fileSrc + '" style="width:350px;"/></span> ';
        str += '<input class="filed" id="file' + me.pid + '" type="hidden" value="' + insertValue + '" /> ';
        str += '<span><a title="' + me.pid + '" style="cursor:pointer;" class="delfield">删除</a></span> ';
        str += '</div>';
        $(me).append(str);
        me.pid++;
        $(".delfield").bind("click", function () {
            var pid = $(this).attr("title");
            me.delFiled(pid);
        });
    }

    this.delFiled = function (pid) {
        /// <summary>
        /// 删除字段
        /// </summary>
        /// <param name="pid"></param>
        $("#addfield" + pid).remove();
    }

    this.MergeFileds = function () {
        /// <summary>
        /// 合并字段
        /// </summary>
        var picSrcs = [];
        $(me).find(".filed").each(function () {
            picSrcs.push($(this).val());
        });
        $(p.renderHidden).val(picSrcs.join());
    }

    this.initFileds = function () {
        /// <summary>
        /// 初始化
        /// </summary>
        if ($(p.renderHidden).length > 0 && $(p.renderHidden) != null && $(p.renderHidden) != undefined) {
            var Fileds = $(p.renderHidden).val();
            var PicUrlArr = null;
            if (Fileds != '') {
                PicUrlArr = Fileds.split(',');
                for (var i = 1; i < PicUrlArr.length + 1; i++) {
                    arrFileds = PicUrlArr[i - 1].split('|');
                    me.addField(arrFileds[0], arrFileds[1]);
                }
            }
        }
    }

    return this.each(function () {
        me.initFileds();
    });
}