﻿/// <reference path="../../wwwroot/jquery-vsdoc.js" />
/*!
<input type="text" id="uploadFile"/>
<script>
$(function(){
    $("#uploadFile").uploadImage({
          title: "上传图片",
          file: "upload.html",
          width: 500,
          height: 200,
          callback: null
    });
});
</script>
 */
jQuery.fn.uploadImage = function (options) {
    /// <summary>
    /// 上传图片
    /// </summary>
    var p = {
        title: "上传图片",
        file: "upload.html",
        width: 500,
        height: 200,
        callback: null
    };
    p = $.extend(p, options);
    var me = this;
    me.main = me.selector.replace("#", "");
    me.openUploadWindow = function () {
        /// <summary>
        /// 打开上传窗体
        /// </summary>
        if (me.uploadjQueryDialog == null) {
            var htmlDialog = '<div style="display:none;font-size:12px;" title="' + p.title + '">';
            htmlDialog += '<iframe src="' + p.file + '?v=' + new Date().getTime() + '" scrolling="auto" frameborder="0" border="0" allowtransparency="yes" width="100%" height="' + (p.height - 70) + 'px"></iframe>';
            htmlDialog += '</div>';
            me.uploadjQueryDialog = $(htmlDialog).dialog({
                width: p.width,
                height: p.height,
                draggable: true,
                resizable: false,
                modal: true
            });
        } else {
            me.uploadjQueryDialog.dialog("open");
        }
        window.closeUploadWindow = me.closeUploadWindow;
    };

    me.closeUploadWindow = function (bigurl, smallurl) {
        /// <summary>
        /// 关闭上传窗体
        /// </summary>
        $("#" + me.main).val(smallurl);
        if (p.callback != null) {
            p.callback(smallurl);
        }
        me.uploadjQueryDialog.dialog("close");
        me.uploadjQueryDialog=null;
    };

    $(me).after(' <button id="' + me.main + '_uploadImage" type="button">' + p.title + '</button>');
    me.init = function () {
        /// <summary>
        /// 初始化
        /// </summary>
        $('#' + me.main + '_uploadImage').click(function () {
            me.openUploadWindow();
        });
    };

    return this.each(function () {
        me.init();
    });
};
/*!
<div id="uploadMore"></div>
<script>
$(function(){
    $("#uploadMore").uploadMore({
        title:"",
        widht:200,
        upload:{
            title: "上传图片",
            file: "upload.html",
            width: 500,
            height: 200,
            callback: null
        }
    });
});
</script>
 */
jQuery.fn.uploadMore = function (options) {
    /// <summary>
    /// 多文件上传
    /// </summary>
    var p = {
        title: "",
        width: 400,
        upload: {
            title: "上传图片",
            file: "upload.html",
            width: 500,
            height: 200,
            callback: null
        }
    };
    p = $.extend(p, options);
    var me = this;
    me.main = me.selector.replace("#", "");
    me.main = me.main.replace(".", "");
    me.pid = 0;
    me.addImage = function (bigsrc, smallsrc, text) {
        /// <summary>
        /// 添加上传图片
        /// </summary>
        var htmlStr = '';
        htmlStr += '<div class="thumb-pics" id="thumbshow' + me.pid + '" style="border:#06c dashed 1px;display:block;margin:2px;float:left;">';
        htmlStr += '<img src="' + smallsrc + '" style="width:100px;height:100px"/>';
        htmlStr += '<br/>';
        htmlStr += '<a style="cursor:pointer;" id="picsdel' + me.pid + '" class="thumb-pics-del" title=' + me.pid + ' >删除</a>';
        htmlStr += '<br/>';
        htmlStr += '<span><input class="' + me.main + '_pics" id="pics' + me.pid + '" type="hidden" value="' + bigsrc + '|' + smallsrc + '" />说明:<input id="picinfo' + me.pid + '" type="text" size="10" value="' + text + '" /></span>';
        htmlStr += '</div>';
        $(me).before(htmlStr);
        me.pid++;
        $(".thumb-pics-del").click(function () {
            var ss = $(this).attr("title");
            me.delUpImage(ss);
        });
        me.mergeImages();
    };
    me.delUpImage = function (pid) {
        /// <summary>
        /// 删除已经上传的图片
        /// </summary>
        $("#thumbshow" + pid).remove();
        me.mergeImages();
    };
    me.initImages = function () {
        /// <summary>
        /// 编辑初始化图片
        /// </summary>
        //说明|小图|大图|||说明|小图|大图
        if ($("#" + me.main).val() != "") {
            var PicUrls = $("#" + me.main).val();
            var PicUrlArr = null;
            if (PicUrls != '') {
                PicUrlArr = PicUrls.split('|||');
                for (var i = 1; i < PicUrlArr.length + 1; i++) {
                    var picArr = PicUrlArr[i - 1].split('|');
                    me.addImage(picArr[1], picArr[2], picArr[0]);
                }
                me.mergeImages();
            }
        }
    };
    me.mergeImages = function () {
        /// <summary>
        /// 合并图片信息 提交的时候用到
        /// </summary>
        var picSrcs = '';
        var src = '';
        $('.' + me.main + '_pics').each(function () {
            src = $(this).next().val().replace('|||', '').replace('|', '') + '|' + $(this).val();
            if (picSrcs == '') {
                picSrcs = src;
            } else {
                picSrcs += '|||' + src;
            }
        });
        $("#" + me.main).val(picSrcs);
    };
    me.insertImage = function () {
        /// <summary>
        /// 对话框插入图片
        /// </summary>
        var smallPics = '', bigPics = '', Text = '';
        smallPics = $('#' + me.main + '_SmallPic').val();
        bigPics = $('#' + me.main + '_BigPic').val();
        Text = $('#' + me.main + '_Text').val();
        if (smallPics == '') {
            if (bigPics == '') {
                alert("大图|小图至少有不能为空!");
                return;
            } else {
                smallPics = bigPics;
            }
        } else {
            if (bigPics == '') {
                bigPics = smallPics;
            }
        }
        me.addImage(bigPics, smallPics, Text);
        me.jQueryDialog.dialog("close");
        $('#' + me.main + '_SmallPic').val("");
        $('#' + me.main + '_BigPic').val("");
        $('#' + me.main + '_Text').val("");
    };

    me.openImageWindow = function () {
        /// <summary>
        /// 打开对话框
        /// </summary>
        if (me.jQueryDialog == null) {
            var htmlDialog = '<div style="display: none;font-size:12px;" title="添加图片" class="jquery-dialog-mul">';
            htmlDialog += '小图:<input id="' + me.main + '_SmallPic" type="text" style="width:250px;" />';
            htmlDialog += '<br />';
            htmlDialog += '大图:<input id="' + me.main + '_BigPic" type="text" style="width:250px;" />';
            htmlDialog += '<br />';
            htmlDialog += '说明:<input id="' + me.main + '_Text" type="text" />';
            htmlDialog += '<br/>';
            htmlDialog += '默认:<input id="' + me.main + '_Default" type="checkbox" value="1" />是';
            htmlDialog += '<br/>';
            htmlDialog += '<input id="btnImageInsert" type="button" value="插入" />';
            htmlDialog += '</div>';

            me.jQueryDialog = $(htmlDialog).dialog({
                width: p.width,
                draggable: true,
                resizable: false,
                modal: true
            });

            $('#' + me.main + '_SmallPic').uploadImage({
                file: p.upload.file,
                height: p.upload.height,
                width: p.upload.width,
                callback: function (a) {
                    var ext = a.substring(a.lastIndexOf("."));
                    var ss = a.replace(ext, "")
                    $('#' + me.main + '_SmallPic').val(ss + "_thum" + ext);
                    $('#' + me.main + '_BigPic').val(a);
                }
            });
            $('#' + me.main + '_BigPic').uploadImage({
                file: p.upload.file,
                height: p.upload.height,
                width:p.upload.width,
                callback: function (a) {
                    var ext = a.substring(a.lastIndexOf("."));
                    var ss = a.replace(ext, "")
                    //$('#' + me.main + '_SmallPic').val(ss + "_thum" + ext);
                    $('#' + me.main + '_SmallPic').val(a);
                    $('#' + me.main + '_BigPic').val(a);
                }
            });

            $("#btnImageInsert").click(function () {
                me.insertImage();
            });

        } else {
            me.jQueryDialog.dialog("open");
        }
    };

    $(me).before('<span><button id="' + me.main + '_upload" type="button">添加图片</button></span><br/>');

    $("#" + me.main + "_upload").click(function () {
        me.openImageWindow();
    });

    return this.each(function () {
        me.initImages();
    });
};