﻿/// <reference path="jquery-vsdoc.js" />
/*1.清除缓存
<meta http-equiv="Pragma" c>
<meta http-equiv="Cache-Control" c>
<meta http-equiv="Expires" c>
*/
/**************
replaceAll：
替换字符串中的字符。
用法：
yourstring.replaceAll("要替换的字符", "替换成什么");
例子:
"cssrain".replaceAll("s", "a");
"   cs   sr   ai   n".replaceAll(" ", "");
**************/
String.prototype.replaceAll = function (AFindText, ARepText) {
    raRegExp = new RegExp(AFindText, "g");
    return this.replace(raRegExp, ARepText);
}
//字符串增加trim方法 过滤前后空格
String.prototype.trim = function () { return this.replace(/(^\s*)|(\s*$)/g, ""); }
/**************
* 计算字符串的真正长度
//String有个属性length，但是它不能区分英文字符，
//计算中文字符和全角字符。但是在数据存储的时候中文和全角都是用两个字节来存储的，
//所有需要额外处理一下。自己写了个函数，返回String正真的长度.
用法：
<input type="text" name="rain" id="rain" />
<input type="button" id="test" value="test" onclick="alert(  document.getElementById('rain').value.codeLength()  )"/>
**************/
String.prototype.codeLength = function () {
    var len = 0;
    if (this == null || this.length == 0)
        return 0;
    var str = this.replace(/(^\s*)|(\s*$)/g, ""); //去掉空格
    for (i = 0; i < str.length; i++)
        if (str.charCodeAt(i) > 0 && str.charCodeAt(i) < 128)
            len++;
        else
            len += 2;
    return len;
}
String.prototype.realLength = function () {
    return this.replace(/[^\x00-\xff]/g, "**").length;
}
String.prototype.length = function () {
    return this.replace(/[\u4e00-\u9fa5]+/g, "**").length;
}
String.prototype.filterHtml = function () {
    return this.replace(/&/g, "&amp;").replace(/</g, "&lt;").replace(/>/g, "&gt").replace(/"/g, "&#34;").replace(/'/g, "&#39;");
}
Date.prototype.format = function (format) {
    var o = {
        "M+": this.getMonth() + 1, //month   
        "d+": this.getDate(),    //day   
        "h+": this.getHours(),   //hour   
        "m+": this.getMinutes(), //minute   
        "s+": this.getSeconds(), //second   
        "q+": Math.floor((this.getMonth() + 3) / 3), //quarter   
        "S": this.getMilliseconds() //millisecond   
    }
    if (/(y+)/.test(format)) format = format.replace(RegExp.$1,
        (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o) if (new RegExp("(" + k + ")").test(format))
        format = format.replace(RegExp.$1,
            RegExp.$1.length == 1 ? o[k] :
                ("00" + o[k]).substr(("" + o[k]).length));
    return format;
}
//浏览器地址请求操作
var request = {
    QueryString: function (val) {
        ///	<summary>
        ///	请求参数变量的值
        ///	</summary>
        var uri = window.location.search;
        var re = new RegExp("" + val + "\=([^\&\?]*)", "ig");
        return ((uri.match(re)) ? (uri.match(re)[0].substr(val.length + 1)) : null);
    },
    QueryStrings: function () {
        ///	<summary>
        ///	所有请求参数变量的值
        ///	</summary>
        var uri = window.location.search;
        var re = /\w*\=([^\&\?]*)/ig;
        var retval = [];
        while ((arr = re.exec(uri)) != null)
            retval.push(arr[0]);
        return retval;
    },
    setQuery: function (val1, val2) {
        ///	<summary>
        ///	更改请求参数变量
        ///	</summary>
        var a = this.QueryStrings();
        var retval = "";
        var seted = false;
        var re = new RegExp("^" + val1 + "\=([^\&\?]*)$", "ig");
        for (var i = 0; i < a.length; i++) {
            if (re.test(a[i])) {
                seted = true;
                a[i] = val1 + "=" + val2;
            }
        }
        retval = a.join("&");
        return "?" + retval + (seted ? "" : (retval ? "&" : "") + val1 + "=" + val2);
    }
};
//收藏夹操作
var VV = {
    addFavorite: function (title, link) {
        ///	<summary>
        ///	加入收藏夹 title标题 link地址链接 http://www.xxx.com
        ///	</summary>
        if (document.all) {
            window.external.addFavorite(link, title);
        }
        else if (window.sidebar) {
            window.sidebar.addPanel(title, link, "");
        }
    },
    addFavoriteThisLink: function () {
        ///	<summary>
        ///	将本页面加入收藏夹
        ///	</summary>
        this.addFavorite(document.title, document.location.href);
    },
    setHomePage: function () {
        ///	<summary>
        ///	设置首页
        ///	</summary>
        console.log("1231");
        var temp = window.location.href;
        if (window.ActiveXObject) {
            this.style.behavior = 'url(#default#homepage)'; this.setHomePage(temp);
        }
        else if (window.sidebar) {
            if (window.netscape) {
                try {
                    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
                }
                catch (e) {
                    alert("此操作被浏览器拒绝！请在浏览器地址栏输入“about:config”并回车然后将[signed.applets.codebase_principal_support]设置为'true'");
                }
            }
            var prefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);
            prefs.setCharPref('browser.startup.homepage', temp);
        }
    }
};
//公共类库入库
var JS = {
    include: function (rFile) {
        ///	<summary>
        ///	静态文件包含
        ///	</summary>
        var cc = $.get(rFile, function (result) {
            document.writeln(result);
        });
    },
    addFavorite: function (title, link) {
        ///	<summary>
        ///	加入收藏夹 title标题 link地址链接 http://www.xxx.com
        ///	</summary>
        if (document.all) {
            window.external.addFavorite(link, title);
        }
        else if (window.sidebar) {
            window.sidebar.addPanel(title, link, "");
        }
    },
    addFavoriteThisLink: function () {
        ///	<summary>
        ///	将本页面加入收藏夹
        ///	</summary>
        this.addFavorite(document.title, document.location.href);
    },
    setHomePage: function () {
        ///	<summary>
        ///	设置首页
        ///	</summary>
        var temp = window.location.href;
        if (window.ActiveXObject) {
            this.style.behavior = 'url(#default#homepage)'; this.setHomePage(temp);
        }
        else if (window.sidebar) {
            if (window.netscape) {
                try {
                    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
                }
                catch (e) {
                    alert("此操作被浏览器拒绝！请在浏览器地址栏输入“about:config”并回车然后将[signed.applets.codebase_principal_support]设置为'true'");
                }
            }
            var prefs = Components.classes['@mozilla.org/preferences-service;1'].getService(Components.interfaces.nsIPrefBranch);
            prefs.setCharPref('browser.startup.homepage', temp);
        }
    },
    /********************************** mask ***************************************/
    /**
    *校验字符串是否符合自定义正则表达式
    *str 要校验的字串  pat 自定义的正则表达式
    *返回值：
    *如果为空，定义校验通过，           返回true
    *如果字串符合，校验通过，           返回true
    *如果字串不符合，                   返回false    参考提示信息：必须满足***模式
    */
    $checkMask: function (str, pat) {
        //如果值为空，通过校验
        if (str == "")
            return true;
        var pattern = new RegExp(pat, "gi")
        if (pattern.test(str))
            return true;
        else
            return false;
    },
    /********************************** chinese ***************************************/
    /**
    *校验字符串是否为中文
    *返回值：
    *如果为空，定义校验通过，           返回true
    *如果字串为中文，校验通过，         返回true
    *如果字串为非中文，             返回false    参考提示信息：必须为中文！
    */
    checkIsChinese: function (str) {
        //如果值为空，通过校验
        if (str == "")
            return true;
        var pattern = /^([\u4E00-\u9FA5]|[\uFE30-\uFFA0])*$/gi;
        if (pattern.test(str))
            return true;
        else
            return false;
    },
    /********************************** email *****************************************/
    /**
    *校验字符串是否为email型
    *返回值：
    *如果为空，定义校验通过，           返回true
    *如果字串为email型，校验通过，      返回true
    *如果email不合法，                  返回false    参考提示信息：Email的格式不正確！
    */
    checkEmail: function (str) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        if (str.charAt(0) == "." || str.charAt(0) == "@" || str.indexOf('@', 0) == -1
            || str.indexOf('.', 0) == -1 || str.lastIndexOf("@") == str.length - 1 || str.lastIndexOf(".") == str.length - 1)
            return false;
        else
            return true;
    },
    /**
    *校验两个日期的先后
    *返回值：
    *如果其中有一个日期为空，校验通过,          返回true
    *如果起始日期早于等于终止日期，校验通过，   返回true
    *如果起始日期晚于终止日期，                 返回false    参考提示信息： 起始日期不能晚于结束日期。
    */
    checkDateEarlier: function (strStart, strEnd) {
        if (checkIsValidDate(strStart) == false || checkIsValidDate(strEnd) == false)
            return false;
        //如果有一个输入为空，则通过检验
        if ((strStart == "") || (strEnd == ""))
            return true;
        var arr1 = strStart.split("-");
        var arr2 = strEnd.split("-");
        var date1 = new Date(arr1[0], parseInt(arr1[1].replace(/^0/, ""), 10) - 1, arr1[2]);
        var date2 = new Date(arr2[0], parseInt(arr2[1].replace(/^0/, ""), 10) - 1, arr2[2]);
        if (arr1[1].length == 1)
            arr1[1] = "0" + arr1[1];
        if (arr1[2].length == 1)
            arr1[2] = "0" + arr1[2];
        if (arr2[1].length == 1)
            arr2[1] = "0" + arr2[1];
        if (arr2[2].length == 1)
            arr2[2] = "0" + arr2[2];
        var d1 = arr1[0] + arr1[1] + arr1[2];
        var d2 = arr2[0] + arr2[1] + arr2[2];
        if (parseInt(d1, 10) > parseInt(d2, 10))
            return false;
        else
            return true;
    },
    /*--------------------------------- Double ---------------------------------------*/
    /********************************** date ******************************************/
    /**
    *校验字符串是否为日期型
    *返回值：
    *如果为空，定义校验通过，           返回true
    *如果字串为日期型，校验通过，       返回true
    *如果日期不合法，                   返回false    参考提示信息：输入域的时间不合法！（yyyy-MM-dd）
    */
    checkIsValidDate: function (str) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        var pattern = /^((\d{4})|(\d{2}))-(\d{1,2})-(\d{1,2})$/g;
        if (!pattern.test(str))
            return false;
        var arrDate = str.split("-");
        if (parseInt(arrDate[0], 10) < 100)
            arrDate[0] = 2000 + parseInt(arrDate[0], 10) + "";
        var date = new Date(arrDate[0], (parseInt(arrDate[1], 10) - 1) + "", arrDate[2]);
        if (date.getYear() == arrDate[0]
            && date.getMonth() == (parseInt(arrDate[1], 10) - 1) + ""
            && date.getDate() == arrDate[2])
            return true;
        else
            return false;
    },
    /**
    *校验浮点型是否为非负数
    *str：要校验的串。
    *
    *返回值：
    *如果为空，定义校验通过，返回true
    *如果非负数，            返回true
    *如果是负数，            返回false               参考提示信息：输入值不能是负数！
    */
    isNotNegativeDouble: function (str) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        if (checkIsDouble(str) == true) {
            if (parseFloat(str) < 0)
                return false;
            else
                return true;
        }
        else
            return false;
    },
    /*
    js编码解码
    1编码
    0解码
    encoding("ssss",0);
    */
    encoding: function (str, flagvale) {
        if (flagvale == 1) {
            return encodeURI(str);
        }
        if (flagvale == 0) {
            return decodeURI(str);
        }
    },

    /********************************** Empty **************************************/
    /**
    *校验字符串是否为空
    *返回值：
    *如果不为空，定义校验通过，返回true
    *如果为空，校验不通过，返回false               参考提示信息：输入域不能为空！
    */
    checkIsNotEmpty: function (str) {
        if (str.trim() == "")
            return false;
        else
            return true;
    },
    /*--------------------------------- Empty --------------------------------------*/
    /********************************** Integer *************************************/
    /**
    *校验字符串是否为整型
    *返回值：
    *如果为空，定义校验通过，      返回true
    *如果字串全部为数字，校验通过，返回true
    *如果校验不通过，              返回false     参考提示信息：输入域必须为数字！
    */
    checkIsInteger: function (str) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        if (/^(\-?)(\d+)$/.test(str))
            return true;
        else
            return false;
    },
    /**
    *校验整型最小值
    *str：要校验的串。  val：比较的值
    *
    *返回值：
    *如果为空，定义校验通过，                返回true
    *如果满足条件，大于等于给定值，校验通过，返回true
    *如果小于给定值，                        返回false              参考提示信息：输入域不能小于给定值！
    */
    checkIntegerMinValue: function (str, val) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        if (typeof (val) != "string")
            val = val + "";
        if (checkIsInteger(str) == true) {
            if (parseInt(str, 10) >= parseInt(val, 10))
                return true;
            else
                return false;
        }
        else
            return false;
    },
    /**
    *校验整型最大值
    *str：要校验的串。  val：比较的值
    *
    *返回值：
    *如果为空，定义校验通过，                返回true
    *如果满足条件，小于等于给定值，校验通过，返回true
    *如果大于给定值，                        返回false       参考提示信息：输入值不能大于给定值！
    */
    checkIntegerMaxValue: function (str, val) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        if (typeof (val) != "string")
            val = val + "";
        if (checkIsInteger(str) == true) {
            if (parseInt(str, 10) <= parseInt(val, 10))
                return true;
            else
                return false;
        }
        else
            return false;
    },
    /**
    *校验整型是否为非负数
    *str：要校验的串。
    *
    *返回值：
    *如果为空，定义校验通过，返回true
    *如果非负数，            返回true
    *如果是负数，            返回false               参考提示信息：输入值不能是负数！
    */
    isNotNegativeInteger: function (str) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        if (checkIsInteger(str) == true) {
            if (parseInt(str, 10) < 0)
                return false;
            else
                return true;
        }
        else
            return false;
    },
    /*--------------------------------- Integer --------------------------------------*/
    /********************************** Double ****************************************/
    /**
    *校验字符串是否为浮点型
    *返回值：
    *如果为空，定义校验通过，      返回true
    *如果字串为浮点型，校验通过，  返回true
    *如果校验不通过，              返回false     参考提示信息：输入域不是合法的浮点数！
    */
    checkIsDouble: function (str) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        //如果是整数，则校验整数的有效性
        if (str.indexOf(".") == -1) {
            if (checkIsInteger(str) == true)
                return true;
            else
                return false;
        }
        else {
            if (/^(\-?)(\d+)(.{1})(\d+)$/g.test(str))
                return true;
            else
                return false;
        }
    },
    /**
    *校验浮点型最小值
    *str：要校验的串。  val：比较的值
    *
    *返回值：
    *如果为空，定义校验通过，                返回true
    *如果满足条件，大于等于给定值，校验通过，返回true
    *如果小于给定值，                        返回false              参考提示信息：输入域不能小于给定值！
    */
    checkDoubleMinValue: function (str, val) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        if (typeof (val) != "string")
            val = val + "";
        if (checkIsDouble(str) == true) {
            if (parseFloat(str) >= parseFloat(val))
                return true;
            else
                return false;
        }
        else
            return false;
    },
    /**
    *校验浮点型最大值
    *str：要校验的串。  val：比较的值
    *
    *返回值：
    *如果为空，定义校验通过，                返回true
    *如果满足条件，小于等于给定值，校验通过，返回true
    *如果大于给定值，                        返回false       参考提示信息：输入值不能大于给定值！
    */
    checkDoubleMaxValue: function (str, val) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        if (typeof (val) != "string")
            val = val + "";
        if (checkIsDouble(str) == true) {
            if (parseFloat(str) <= parseFloat(val))
                return true;
            else
                return false;
        }
        else
            return false;
    },
    /**************
    format：
    格式化数字.
    例子:
    var n = format_number( 123456.45656 , 2 ); // .toFixed(2)也可以实现，不过不兼容FF.
    alert(n); 
    **************/
    format_number: function (str, digit) {
        if (isNaN(str)) {
            alert("您传入的值不是数字！");
            return 0;
        }
        else if (Math.round(digit) != digit) {
            alert("您输入的小数位数不是整数！");
            return 0;
        }
        else
            return Math.round(parseFloat(str) * Math.pow(10, digit)) / Math.pow(10, digit);
    },

    /**************
    * 得到单选框选中的值。
    * 用法：
    *<input type="radio"  value="1" name="cssrain"/>
    *<input type="radio"  value="2" name="cssrain" checked/>
    *<input type="radio"  value="3" name="cssrain"/>
    *<input type="button" onclick="alert(getRadioValue('cssrain'))" value="test"/>
    **************/
    getRadioValue: function (radioName) {
        var obj = document.getElementsByName(radioName);
        for (var i = 0; i < obj.length; i++) {
            if (obj[i].checked) {
                return obj[i].value;
            }
        }
    },
    /**************
    * 复选框全选/不选/反选
    * 用法：
    <form id="form_a">
    <input type="checkbox"  value="1" name="a"/>
    <input type="checkbox"  value="2" name="a" checked/>
    <input type="checkbox"  value="3" name="a"/>
    <input type="button" value="全选" onclick="checkAll(document.getElementById('form_a'),'all')"/>
    <input type="button" value="不选" onclick="checkAll(document.getElementById('form_a'),'none')"/>
    <input type="button" value="反选" onclick="checkAll(document.getElementById('form_a'),'')"/>
    </form>
    **************/
    checkAll: function (form, sel) {
        for (i = 0, n = form.elements.length; i < n; i++) {
            if (form.elements[i].type == "checkbox") {
                if (form.elements[i].checked == true) {
                    form.elements[i].checked = (sel == "all" ? true : false);
                } else {
                    form.elements[i].checked = (sel == "none" ? false : true);
                }
            }
        }
    },

    /**************
    * 复选框检查是否选中。
    * 如果没一个选中，会返回false.
    * 用法：
    <form id="form_a" name="form_a">
    <input type="checkbox"  value="1" name="a"/>
    <input type="checkbox"  value="2" name="a" checked/>
    <input type="checkbox"  value="3" name="a"/>
    <input type="button" value="全选" onclick="alert( SCheckBox('form_a','a') )"/>
    </form>
    **************/
    SCheckBox: function (_formName, _checkboxName) {
        var selflag = { 'checked': 0, 'cvalues': [] };
        _scheckbox = eval('document.' + _formName + '.' + _checkboxName);
        if (_scheckbox) {
            if (eval(_scheckbox.length)) {
                for (i = 0; i < _scheckbox.length; i++) {
                    if (_scheckbox[i].checked) {
                        selflag.checked++;
                        selflag.cvalues.push(_scheckbox[i].value);
                    }
                };
            } else if (_scheckbox.checked) {
                selflag.checked++;
                selflag.cvalues.push(_scheckbox.value);
            }
            if (selflag.checked) {
                return selflag;
            }
        }
        return false;
    },
    /*
    得到单选框选中的值
    */
    checkAll: function (form, sel) {
        for (i = 0, n = form.elements.length; i < n; i++) {
            if (form.elements[i].type == "checkbox") {
                if (form.elements[i].checked == true) {
                    form.elements[i].checked = (sel == "all" ? true : false);
                } else {
                    form.elements[i].checked = (sel == "none" ? false : true);
                }
            }
        }
    },
    /*
    复选框检查是否选中
    */
    SCheckBox: function (_formName, _checkboxName) {
        var selflag = { 'checked': 0, 'cvalues': [] };
        _scheckbox = eval('document.' + _formName + '.' + _checkboxName);
        if (_scheckbox) {
            if (eval(_scheckbox.length)) {
                for (i = 0; i < _scheckbox.length; i++) {
                    if (_scheckbox[i].checked) {
                        selflag.checked++; selflag.cvalues.push(_scheckbox[i].value);
                    }
                };
            } else if (_scheckbox.checked) {
                selflag.checked++; selflag.cvalues.push(_scheckbox.value);
            } if (selflag.checked) {
                return selflag;
            }
        }
        return false;
    },
    /************** 收藏到书签.(兼容IE和FF)。*/
    addBookmark: function (title, url) {
        if (window.sidebar) {
            window.sidebar.addPanel(title, url, "");
        } else if (document.all) {
            window.external.AddFavorite(url, title);
        } else if (window.opera && window.print) {
            return true;
        }
    },
    /**************
    函数 ： 文本框得到与失去焦点 操作。
    这个方法经常在文本框搜索的时候出现。
    文本里显示 “ 搜索 ”，然后当用户鼠标点击此文本，
    文本框内容清空。如果用户没填写内容，那么文本的值又复原。
    如果填写了，就显示用户填写的。
    用法:
    <input type="" value="关键字搜索" name="a" onfocus="clearTxt('a','关键字搜索')" onblur="fillTxt('a','关键字搜索')"/>
    <input type="text" value="test" name="test" />
    **************/
    clearTxt: function (id, txt) {
        if (document.getElementById(id).value == txt)
            document.getElementById(id).value = "";
        return;
    },
    fillTxt: function (id, txt) {
        if (document.getElementById(id).value == "")
            document.getElementById(id).value = txt;
        return;
    },
    /**************
    函数 ： 用来判断鼠标按的是左键还是右键。(兼容IE和ff)
    用法:
    onmousedown="mouse_keycode(event)"
    **************/
    mouse_keycode: function (event) {
        var event = event || window.event;
        var nav = window.navigator.userAgent;
        if (nav.indexOf("MSIE") >= 1) //如果浏览器为IE.解释：因为 document.all 是 IE 的特有属性，所以通常用这个方法来判断客户端是否是IE浏览器 ,document.all?1:0; 
        {
            if (event.button == 1) { alert("左键") }
            else if (event.button == 2) { alert("右键") }
        }
        else if (nav.indexOf("Firefox") >= 1) ////如果浏览器为Firefox 
        {
            if (event.button == 0) { alert("左键"); }
            else if (event.button == 2) { alert("右键"); }
        }
        else { //如果浏览器为其他 
            alert("other");
        }
    },
    /**************
    函数 ：触发某个对象的onclick事件。（兼容IE和FF）
    用法: 
    <input type="button" value="aaa" id="a" onclick=" alert('cssrain') " />
    <input type="button" value="触发ID为a的onclick事件" onclick=" handerToClick('a') " />
    **************/
    handerToClick: function (objid) {
        var obj = document.getElementById(objid);
        if (document.all) {
            obj.fireEvent("onclick");
        } else {
            var e = document.createEvent('MouseEvent');
            e.initEvent('click', false, false);
            obj.dispatchEvent(e);
        }
    },
    /**************
    回车提交。
    用法:
    <input   type=text   onkeydown="keysubmit()">   
    **************/
    keysubmit: function () {
        if (event.keyCode == 13) {
            form.submit();
        }
    },
    /**************
    实现Ctrl+Enter 提交的效果.(兼容IE和FF)
    在做这个效果时，发现一个问题，
    当表单中如果只有一个文本框时，
    回车会默认提交。(没有提交按钮也一样。)
    用法:
    <form action="#"  name="a">
    <input   type="text" />   
    <input   type="text"   onkeydown="QuickPost( event , document.a )" />   
    </form>
    **************/
    QuickPost: function (event, form) {
        var event = event || window.event;
    },
    /*********
    验证是否是数字
    **********/
    checkIsInteger: function (str) {
        //如果为空，则通过校验
        if (str == "")
            return true;
        if (/^(\-?)(\d+)$/.test(str))
            return true;
        else
            return false;
    }
}

jQuery(function () {
    $(".img-refresh").bind("click", function () {
        var src = $(this).prop("src");

        $(this).prop("src", src + "?time=" + new Date().getTime());
    });
});