﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.UI;
using Models;
using Newtonsoft.Json;

public partial class List : AdminBase
{

    Entities db = new Entities();
    protected override void OnUnload(EventArgs e)
    {
        db.Dispose();
        base.OnUnload(e);
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            bindTypes();
        }
    }

    private void bindTypes()
    {
        jsTreeJson.Text = this.getTree("Newlist.aspx?Classddl={0}&cid={0}");
    }

    protected string getTree(string url)
    {
        JsTreeData JsTree = new JsTreeData();
        JsTree.data = new List<JsTreeNode>();

        JsTree.data.Add(new JsTreeNode()
        {
            id = "node_" + 0,
            parent = "#",
            text = "全部",
            state = new JsTreeState()
            {
                opened = false,
                selected = false
            },
            a_attr = new JsTreeAttr()
            {
                link = string.Format(url, "")
            }
        });

        var m = from n in db.L_Classs.Where(x => x.CpareID == 0) select n;
        foreach (var n in m)
        {
            if (!chkpow(n.CID))
            {
                continue;
            }
            JsTree.data.Add(new JsTreeNode()
            {
                id = "node_" + n.CID,
                parent = "#",
                text = n.CNmae,
                state = new JsTreeState()
                {
                    opened = true,
                    selected = false
                },
                a_attr = new JsTreeAttr()
                {
                    link = string.Format(url, n.CID)
                }
            });

            getChildrenNodes(JsTree.data, n.CID, url);
        }
        return JsonConvert.SerializeObject(JsTree);
    }

    protected bool chkpow(long claid)
    {
        if (sysset.NewsRule)
        { return true; }
        else
        {
            string admin_power = "";
            int _Id = int.Parse(Session["AdminID"].ToString());
           admin_power = db.Manages.SingleOrDefault(p => p.MID == _Id).MRole;

            if (admin_power.IndexOf("," + claid + ",") > -1)
                return true;
            else
                return false;
        }
    }

    protected void getChildrenNodes(List<JsTreeNode> nodes, long cID, string url)
    {
        var mm = from n in db.L_Classs.Where(x => x.CpareID == cID) select n;
        string parent = "node_" + cID;
        foreach (var n in mm)
        {
            if (!chkpow(n.CID))
            {
                continue;
            }
            nodes.Add(new JsTreeNode()
            {
                id = "node_" + n.CID,
                parent = parent,
                text = n.CNmae,
                state = new JsTreeState()
                {
                    opened = false,
                    selected = false
                },
                a_attr = new JsTreeAttr()
                {
                    link = string.Format(url, n.CID)
                }
            });
            getChildrenNodes(nodes, n.CID, url);
        }
    }
}

public class JsTreeData
{
    public List<JsTreeNode> data;
}

public class JsTreeNode
{
    public string id;
    public string parent;
    public string text;
    public JsTreeState state;
    public JsTreeAttr a_attr;
}

public class JsTreeState
{
    public bool opened;
    public bool selected;
}

public class JsTreeAttr
{
    public string link;
}
