﻿using System;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using Models;

public partial class NewList : AdminBase
{
    public int classId;

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            ClassTreeBind("请选择栏目...", this.Classddl);

            if (!string.IsNullOrEmpty(Request.Params["CID"]))
            {
                string _CId = HttpContext.Current.Request.QueryString["CID"];
                Classddl.SelectedValue = _CId;
            }

            myDatabind();

        }
    }


    private void myDatabind()
    {

        if (!int.TryParse(this.Classddl.SelectedValue as string, out this.classId))
        {
            this.classId = 0;
        }

        //if (classId != 0)
        //{
        using (Entities bll = new Entities())
        {

            var Bpl = bll.L_Newss.Select(s => new
            {
                NId = s.NID,
                ClassId = s.ClassId,
                Title = s.Title,
                Time = s.Time,
                IsTop = s.IsTop,
                IsRed = s.IsRed,
                IsHot = s.IsHot,
                IsSlide = s.IsSlide,
                IsLock = s.IsLock,

            });



            if (txtkey.Text.Trim() != "")
            {
                Bpl = Bpl.Where(p => p.Title.Contains(txtkey.Text));
            }


            if (this.ddlProperty.SelectedValue != null)
            {
                switch (this.ddlProperty.SelectedValue)
                {
                    case "IsTop":
                        Bpl = Bpl.Where(p => p.IsTop == true);
                        break;
                    case "IsRed":
                        Bpl = Bpl.Where(p => p.IsRed == true);
                        break;
                    case "IsHot":
                        Bpl = Bpl.Where(p => p.IsHot == true);
                        break;
                    case "IsSlide":
                        Bpl = Bpl.Where(p => p.IsSlide == true);
                        break;

                }
            }


            if (this.classId > 0)
            {
                Bpl = Bpl.Where(p => p.ClassId == classId);
            }
            else
            {
                string admin_power = "";
                int _Id = int.Parse(Session["AdminID"].ToString());
                admin_power = bll.Manages.SingleOrDefault(p => p.MID == _Id).MRole;
                try
                {
                    admin_power = admin_power.Substring(1, admin_power.Length - 2);
                }
                catch (Exception e)
                { }
                finally
                {
                    string[] aa = admin_power.Split(',');
                    int[] ids = new int[aa.Length];
                    for (int i = 0; i < aa.Length; i++)
                    {
                        int.TryParse(aa[i], out ids[i]);
                    }
                    Bpl = Bpl.Where(p => ids.Contains(p.ClassId.Value));
                }

     
          
            }

            Bpl = Bpl.OrderByDescending(p => p.Time);


            PagedDataSource pds = new PagedDataSource();
            pds.DataSource = Bpl.ToList();  //这里好像一定要Tolist();不然会有点错误；
            pds.AllowPaging = true;
            AspNetPager1.RecordCount = Bpl.Count(); //记录总数；
            pds.CurrentPageIndex = AspNetPager1.CurrentPageIndex - 1;
            pds.PageSize = AspNetPager1.PageSize;

            this.rptList.DataSource = pds;
            this.rptList.DataBind();
        }
        //}

    }


  




    protected void AspNetPager1_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {   //当页面页数改变时，执行这个方法；
        AspNetPager1.CurrentPageIndex = e.NewPageIndex;
        myDatabind();
    }
    protected void rptList_ItemCommand(object source, RepeaterCommandEventArgs e)
    {
        int id = Convert.ToInt32(e.CommandArgument);


        Entities bll = new Entities();
        L_Newss model = bll.L_Newss.First(p => p.NID == id);

        switch (e.CommandName.ToLower())
        {
            case "ibtntop":
                if (model.IsTop == true)
                    model.IsTop = false;
                else
                    model.IsTop = true;
                break;
            case "ibtnred":
                if (model.IsRed == true)
                    model.IsRed = false;
                else
                    model.IsRed = true;
                break;
            case "ibtnhot":
                if (model.IsHot == true)
                    model.IsHot = false;
                else
                    model.IsHot = true;
                break;
            case "ibtnslide":
                if (model.IsSlide == true)
                    model.IsSlide = false;
                else
                    model.IsSlide = true;
                break;
            case "ibtnlock":
                if (model.IsLock == true)
                    model.IsLock = false;
                else
                    model.IsLock = true;
                break;


            case "del":

                bll.L_Newss.Remove(model);
                bll.SaveChanges();
                break;

        }

        bll.SaveChanges();
        myDatabind();
        //RptBind("Id>0" + CombSqlTxt(this.kindId, this.classId, this.keywords, this.property), "AddTime desc");
    }

    public string ToClassName(int ClassId)
    {
        string result = "";
        Entities db = new Entities();
        var LClass = db.L_Classs.SingleOrDefault(p => p.CID == ClassId);
        result = LClass.CNmae;
        return result;
    }

    protected void DropDownList1_SelectedIndexChanged(object sender, EventArgs e)
    {
        myDatabind();
    }

    protected void ddlProperty_SelectedIndexChanged(object sender, EventArgs e)
    {
        myDatabind();
    }
    protected void LinkButton2_Click(object sender, EventArgs e)
    {
        myDatabind();
    }


  
}

