﻿<%@ WebHandler Language="C#" Class="Hup_ajax" %>

using System;
using System.Collections;
using System.IO;
using System.Collections.Generic;
using System.Web.SessionState;
using System.Web;
using System.Text.RegularExpressions;
using LitJson;





    /// <summary>
    /// 文件上传处理页
    /// </summary>
    public class Hup_ajax : IHttpHandler, IRequiresSessionState
    {

        public void ProcessRequest(HttpContext context)
        {

            //检查是否登录后上传操作
            if (!new AdminBase().IsAdminLogin())
            {
                context.Response.Write("{msg: 0, msbox: \"请登录后再进行上传文件！\"}");
                return;
            }
            
            
            //取得处事类型
            string action = context.Request.QueryString["action"];
          
            switch (action)
            {
          
                case "MultipleFile": //多文件
                    MultipleFile(context);
                    break;
        
            }

        }

      

        #region 上传多文件处理===================================
        private void MultipleFile(HttpContext context)
        {
            string forid = context.Request.QueryString["forid"]; 
            
            string _upfilepath = context.Request.QueryString["UpFilePath"]; //取得上传的对象名称
            HttpPostedFile _upfile = context.Request.Files[_upfilepath];
            int _iswater = 0; //默认不打水印
            bool _isthumbnail = false; //默认不生成缩略图

            if (context.Request.QueryString["IsWater"] == "1")
                _iswater = 1;
            if (context.Request.QueryString["IsThumbnail"] == "1")
                _isthumbnail = true;

            if (_upfile == null)
            {
                context.Response.Write("{msg: 0, msbox: \"请选择要上传文件！\"}");
                return;
            }
            
            UpLoad upFiles = new UpLoad();
            string msg = upFiles.fileSaveAs(_upfile,_iswater);
           //string msg = upFiles.fileSaveAs(_upfile, _iswater, forid);
            //返回成功信息
            context.Response.Write(msg);
            context.Response.End();
        }
        #endregion


        public bool IsReusable
        {
            get
            {
                return false;
            }
        }
    }