using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;

namespace DAL
{
	/// <summary>
	/// DataProvider ժҪ˵
	/// </summary>
	public sealed class DataProvider
	{
		public static readonly string db = ConfigurationManager.ConnectionStrings["db"].ConnectionString;
		private DataProvider()
		{}

		public static DataTable GetList(out int RecordCount, bool ReturnCount, string QueryStr, int PageSize, int PageCurrent
			,string FdShow, string IdentityStr, string WhereStr, string FdOrder)
		{
			RecordCount = 0;
			SqlParameter[] p =
				{
					SqlHelper.MakeOutParam("@RecordCount", SqlDbType.Int, 4),
					SqlHelper.MakeInParam("@ReturnCount", SqlDbType.Bit, 1, ReturnCount),
					SqlHelper.MakeInParam("@QueryStr", SqlDbType.NVarChar, 1000, QueryStr),
					SqlHelper.MakeInParam("@PageSize", SqlDbType.Int, 4, PageSize),
					SqlHelper.MakeInParam("@PageCurrent", SqlDbType.Int, 4, PageCurrent),
					SqlHelper.MakeInParam("@FdShow", SqlDbType.NVarChar, 2000, FdShow),
					SqlHelper.MakeInParam("@IdentityStr", SqlDbType.NVarChar, 100, IdentityStr),
					SqlHelper.MakeInParam("@WhereStr", SqlDbType.NVarChar, 2000, WhereStr),
					SqlHelper.MakeInParam("@FdOrder", SqlDbType.NVarChar, 100, FdOrder)
				};

			DataTable dt = SqlHelper.ExecuteDataTable(db, CommandType.StoredProcedure, "page", p);
			if (ReturnCount)
			{
				RecordCount = (int)p[0].Value;
			}

			return dt;
		}

        public static void FlashManage(int id, string title, string content, int class1, int status)
        {
			SqlParameter[] p =
				{
					SqlHelper.MakeInParam("@id", SqlDbType.Int, 4, id),
					SqlHelper.MakeInParam("@title", SqlDbType.NVarChar, 200, title),
					SqlHelper.MakeInParam("@content", SqlDbType.NVarChar, 4000, content),
					SqlHelper.MakeInParam("@class", SqlDbType.Int, 4, class1),
					SqlHelper.MakeInParam("@status", SqlDbType.Int, 4, status)
				};

            SqlHelper.ExecuteNonQuery(db, CommandType.StoredProcedure, "FlashManage", p);
        }

		public static DataTable ExecuteSql(string sql)
		{
			return SqlHelper.ExecuteDataTable(db, CommandType.Text, sql);
		}

		public static int GetCount(int id)
		{
			SqlParameter[] p =
				{
					SqlHelper.MakeInParam("@id", SqlDbType.Int, 4, id)
				};

			return (int)SqlHelper.ExecuteScalar(db, CommandType.StoredProcedure, "GetFlashCountByID", p);
		}
	}
}
