using System;
using System.Web;
using System.Text.RegularExpressions;
using System.Configuration;
using System.Collections;
using System.Web.Security;
using System.Security.Principal;

using System.IO;


namespace flash
{
	/// <summary>
	/// MyHttpModule ժҪ˵
	/// </summary>
	public class MyHttpModule : IHttpModule
	{
		public void Init(HttpApplication app)
		{
			app.AuthorizeRequest += new EventHandler(app_AuthorizeRequest);
		}

		public void Dispose() {}

		public static bool Rewrite(string url, ArrayList urls, System.Web.HttpApplication app)
		{
			URLRewrite urlRewrite = SiteUrls.GetSiteUrls().Match(url, urls);

			if (urlRewrite != null)
			{
				string query = Regex.Replace(url, urlRewrite.Pattern, urlRewrite.QueryString, RegexOptions.Compiled|RegexOptions.IgnoreCase);

				if (TryCache(urlRewrite, query, app))
				{
					return true;
				}
				app.Context.RewritePath(urlRewrite.Page, string.Empty, query);
				return true;
			}
			return false;
		}

		public static bool TryCache(URLRewrite url, string query, System.Web.HttpApplication app)
		{
			//洦
			if (app.Request.RequestType.ToLower() == "get" && app.Request.RawUrl.IndexOf("?")<0)
			{
				string key = url.Page + (query.Length>0? "?":"") + query;

				string CachePath = FileCache.CacheList[key.ToLower()] as string;
				if (CachePath != null && File.Exists(CachePath))
				{
					app.Context.RewritePath(CachePath);
					return true;
				}
			}
			return false;
		}

		private void app_AuthorizeRequest(object sender, EventArgs e)
		{
			HttpApplication app = (HttpApplication) sender;
			if (app.Request.Url.ToString().IndexOf("?")>0)
			{
				return;
			}

			Rewrite(app.Request.Path, SiteUrls.GetSiteUrls().Urls, app);

			if (System.Configuration.ConfigurationSettings.AppSettings["ip"] == "1")
			{
				using (StreamWriter sw = new StreamWriter(app.Server.MapPath("~/iplog.txt"), true))
				{
					sw.WriteLine("time:{3}\r\nip:{0}\r\nurl:{1}\r\nmeth:{2}\r\n----------\r\n", app.Request.UserHostAddress, app.Request.RawUrl, app.Request.RequestType, DateTime.Now.ToString("yyyyMMddhhmmss"));
					sw.Flush();
					sw.Close();
				}
			}
		}

		private void app_AuthenticateRequest(object sender, EventArgs e)
		{
			// ȡ֤ cookie
			string cookieName = FormsAuthentication.FormsCookieName;
			HttpCookie authCookie = HttpContext.Current.Request.Cookies[cookieName];

			if(null == authCookie)
			{
				// û֤ cookie
				return;
			}

			FormsAuthenticationTicket authTicket = null;
			authTicket = FormsAuthentication.Decrypt(authCookie.Value);

			if (null == authTicket)
			{
				// ޷ Cookie
				return; 
			}
			// Ʊ֤Ϊ UserData ָһ
			// ԹָܵĽɫַ
			string[] roles = authTicket.UserData.Split(new char[]{'|'});


			// һʶ
			FormsIdentity id = new FormsIdentity( authTicket ); 

			// 彫ͨ
			GenericPrincipal principal = new GenericPrincipal(id, roles);
			// µ󸽼ӵǰ HttpContext 
			HttpContext.Current.User = principal;


		}
	}
}
