/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterator;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractEndToEndTupleList;
import mondrian.calc.impl.AbstractTupleList;
import mondrian.olap.Evaluator;
import mondrian.olap.Member;
import mondrian.olap.Util;

public class ArrayTupleList
extends AbstractEndToEndTupleList {
    private transient Member[] objectData;
    private int size;

    public ArrayTupleList(int arity) {
        this(arity, 10 * arity);
        assert (arity > 1) : "Probably better to use a UnaryTupleList";
    }

    public ArrayTupleList(int arity, int initialCapacity) {
        this(arity, new Member[initialCapacity * arity], 0);
    }

    private ArrayTupleList(int arity, Member[] members, int size) {
        super(arity);
        assert (members.length % arity == 0);
        this.objectData = members;
        this.size = size;
    }

    @Override
    protected List<Member> backingList() {
        return new AbstractList<Member>(){

            @Override
            public Member get(int index) {
                return ArrayTupleList.this.objectData[index];
            }

            @Override
            public int size() {
                return ArrayTupleList.this.size * ArrayTupleList.this.arity;
            }
        };
    }

    @Override
    public Member get(int slice, int index) {
        return this.objectData[index * this.arity + slice];
    }

    @Override
    public List<Member> get(int index) {
        final int startIndex = index * this.arity;
        AbstractList<Member> list = new AbstractList<Member>(){

            @Override
            public Member get(int index) {
                return ArrayTupleList.this.objectData[startIndex + index];
            }

            @Override
            public int size() {
                return ArrayTupleList.this.arity;
            }
        };
        if (this.mutable) {
            return Util.flatList(list);
        }
        return list;
    }

    @Override
    public List<Member> set(int index, List<Member> element) {
        assert (this.mutable);
        int i = 0;
        int startIndex = index * this.arity;
        while (i < this.arity) {
            this.objectData[startIndex + i] = element.get(i);
            ++i;
        }
        return null;
    }

    @Override
    public void addCurrent(TupleCursor tupleIter) {
        assert (this.mutable);
        int n = this.size * this.arity;
        this.ensureCapacity(n + this.arity);
        tupleIter.currentToArray(this.objectData, n);
        ++this.size;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(List<Member> members) {
        assert (this.mutable);
        if (members.size() != this.arity) {
            throw new IllegalArgumentException("Tuple length does not match arity");
        }
        int n = this.size * this.arity;
        this.ensureCapacity(n + this.arity);
        int i = 0;
        while (i < members.size()) {
            this.objectData[n++] = members.get(i);
            ++i;
        }
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, List<Member> members) {
        assert (this.mutable);
        if (members.size() != this.arity) {
            throw new IllegalArgumentException("Tuple length does not match arity");
        }
        int n = index * this.arity;
        this.ensureCapacity(this.size + 1 + this.arity);
        System.arraycopy(this.objectData, n, this.objectData, n + this.arity, this.arity);
        for (Member member : members) {
            this.objectData[n++] = member;
        }
        ++this.size;
    }

    @Override
    public boolean addAll(int index, Collection<? extends List<Member>> c) {
        assert (this.mutable);
        int size1 = c.size();
        this.ensureCapacity(this.size * this.arity + size1 * this.arity);
        int n = index * this.arity;
        System.arraycopy(this.objectData, n, this.objectData, n + size1 * this.arity, this.size * this.arity - n);
        for (List<Member> list : c) {
            for (Member member : list) {
                this.objectData[n++] = member;
            }
        }
        this.size += size1;
        return size1 > 0;
    }

    @Override
    public void addTuple(Member ... members) {
        assert (this.mutable);
        if (members.length != this.arity) {
            throw new IllegalArgumentException("Tuple length does not match arity");
        }
        this.ensureCapacity(this.size * this.arity + this.arity);
        System.arraycopy(members, 0, this.objectData, this.size * this.arity, this.arity);
        ++this.size;
    }

    @Override
    public List<Member> remove(int index) {
        assert (this.mutable);
        int n = index * this.arity;
        System.arraycopy(this.objectData, n + this.arity, this.objectData, n, this.arity);
        --this.size;
        return null;
    }

    @Override
    public List<Member> slice(final int column) {
        if (column < 0 || column >= this.arity) {
            throw new IllegalArgumentException();
        }
        return new AbstractList<Member>(){

            @Override
            public Member get(int index) {
                return ArrayTupleList.this.objectData[index * ArrayTupleList.this.arity + column];
            }

            @Override
            public int size() {
                return ArrayTupleList.this.size;
            }
        };
    }

    @Override
    public TupleList cloneList(int capacity) {
        if (capacity < 0) {
            return new ArrayTupleList(this.arity, (Member[])this.objectData.clone(), this.size());
        }
        return new ArrayTupleList(this.arity, capacity);
    }

    @Override
    public TupleIterator tupleIteratorInternal() {
        return new AbstractTupleList.AbstractTupleListIterator(this){

            @Override
            public void setContext(Evaluator evaluator) {
                int i = 0;
                int x = this.lastRet * ArrayTupleList.this.arity;
                while (i < ArrayTupleList.this.arity) {
                    evaluator.setContext(ArrayTupleList.this.objectData[x + i]);
                    ++i;
                }
            }

            @Override
            public Member member(int column) {
                return ArrayTupleList.this.objectData[this.lastRet * ArrayTupleList.this.arity + column];
            }

            @Override
            public void currentToArray(Member[] members, int offset) {
                System.arraycopy(ArrayTupleList.this.objectData, this.lastRet * ArrayTupleList.this.arity, members, offset, ArrayTupleList.this.arity);
            }
        };
    }

    private void ensureCapacity(int minCapacity) {
        int oldCapacity = this.objectData.length;
        if (minCapacity > oldCapacity) {
            int newCapacity = oldCapacity * 3 / 2 + 1;
            if (newCapacity < minCapacity) {
                newCapacity = minCapacity;
            }
            int rem = newCapacity % this.arity;
            this.objectData = Util.copyOf(this.objectData, newCapacity += this.arity - rem);
        }
    }
}

