/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import mondrian.calc.Calc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.Type;

public class MemberArrayValueCalc
extends GenericCalc {
    private final MemberCalc[] memberCalcs;
    private final Member[] members;
    private final boolean nullCheck;

    MemberArrayValueCalc(Exp exp, MemberCalc[] memberCalcs, boolean nullCheck) {
        super(exp);
        this.nullCheck = nullCheck;
        Type type = exp.getType();
        assert (type instanceof ScalarType) : exp;
        this.memberCalcs = memberCalcs;
        this.members = new Member[memberCalcs.length];
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        int savepoint = evaluator.savepoint();
        try {
            Object result;
            int i = 0;
            while (i < this.memberCalcs.length) {
                MemberCalc memberCalc = this.memberCalcs[i];
                Member member = memberCalc.evaluateMember(evaluator);
                if (member == null || member.isNull()) {
                    return null;
                }
                evaluator.setContext(member);
                this.members[i] = member;
                ++i;
            }
            if (this.nullCheck && evaluator.needToReturnNullForUnrelatedDimension(this.members)) {
                return null;
            }
            Object object = result = evaluator.evaluateCurrent();
            return object;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    @Override
    public Calc[] getCalcs() {
        return this.memberCalcs;
    }

    @Override
    public boolean dependsOn(Hierarchy hierarchy) {
        if (super.dependsOn(hierarchy)) {
            return true;
        }
        MemberCalc[] memberCalcArray = this.memberCalcs;
        int n = this.memberCalcs.length;
        int n2 = 0;
        while (n2 < n) {
            MemberCalc memberCalc = memberCalcArray[n2];
            if (memberCalc.getType().usesHierarchy(hierarchy, true)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

