/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import mondrian.calc.Calc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.MemberArrayValueCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.type.ScalarType;
import mondrian.olap.type.Type;

public class MemberValueCalc
extends GenericCalc {
    private final MemberCalc memberCalc;
    private final boolean nullCheck;

    public MemberValueCalc(Exp exp, MemberCalc memberCalc, boolean nullCheck) {
        super(exp);
        this.nullCheck = nullCheck;
        Type type = exp.getType();
        assert (type instanceof ScalarType) : exp;
        this.memberCalc = memberCalc;
    }

    public static GenericCalc create(Exp exp, MemberCalc[] memberCalcs, boolean nullCheck) {
        switch (memberCalcs.length) {
            case 0: {
                return new ValueCalc(exp);
            }
            case 1: {
                return new MemberValueCalc(exp, memberCalcs[0], nullCheck);
            }
        }
        return new MemberArrayValueCalc(exp, memberCalcs, nullCheck);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Evaluator evaluator) {
        int savepoint = evaluator.savepoint();
        try {
            Object result;
            Member member = this.memberCalc.evaluateMember(evaluator);
            if (member == null) return null;
            if (member.isNull()) {
                return null;
            }
            evaluator.setContext(member);
            if (this.nullCheck && evaluator.needToReturnNullForUnrelatedDimension(new Member[]{member})) {
                return null;
            }
            Object object = result = evaluator.evaluateCurrent();
            return object;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    @Override
    public Calc[] getCalcs() {
        return new MemberCalc[]{this.memberCalc};
    }

    @Override
    public boolean dependsOn(Hierarchy hierarchy) {
        if (super.dependsOn(hierarchy)) {
            return true;
        }
        return !this.memberCalc.getType().usesHierarchy(hierarchy, true);
    }
}

