/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.fun.TupleFunDef;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

public class TupleValueCalc
extends GenericCalc {
    private final TupleCalc tupleCalc;
    private final boolean nullCheck;

    public TupleValueCalc(Exp exp, TupleCalc tupleCalc, boolean nullCheck) {
        super(exp);
        this.tupleCalc = tupleCalc;
        this.nullCheck = nullCheck;
    }

    @Override
    public Object evaluate(Evaluator evaluator) {
        Member[] members = this.tupleCalc.evaluateTuple(evaluator);
        if (members == null) {
            return null;
        }
        if (this.nullCheck && evaluator.needToReturnNullForUnrelatedDimension(members)) {
            return null;
        }
        int savepoint = evaluator.savepoint();
        try {
            Object result;
            evaluator.setContext(members);
            Object object = result = evaluator.evaluateCurrent();
            return object;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    @Override
    public Calc[] getCalcs() {
        return new Calc[]{this.tupleCalc};
    }

    @Override
    public boolean dependsOn(Hierarchy hierarchy) {
        if (super.dependsOn(hierarchy)) {
            return true;
        }
        Type[] typeArray = ((TupleType)this.tupleCalc.getType()).elementTypes;
        int n = ((TupleType)this.tupleCalc.getType()).elementTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Type type = typeArray[n2];
            if (type.usesHierarchy(hierarchy, true)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public Calc optimize() {
        if (this.tupleCalc instanceof TupleFunDef.CalcImpl) {
            TupleFunDef.CalcImpl calc = (TupleFunDef.CalcImpl)this.tupleCalc;
            return MemberValueCalc.create(new DummyExp(this.type), calc.getMemberCalcs(), this.nullCheck);
        }
        return this;
    }
}

