/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import mondrian.gui.I18n;
import mondrian.gui.JdbcMetaData;
import mondrian.gui.PreferencesSchemasDialog;
import mondrian.gui.Workbench;

public class PreferencesDialog
extends JDialog {
    boolean accepted = false;
    private JTextField driverClassTextField;
    private JPanel jPanel1;
    private JTextField urlTextField;
    private JTextField usernameTextField;
    private JTextField passwordTextField;
    private JTextField schemaTextField;
    private JCheckBox requireSchemaButton;
    private JButton acceptButton;
    private JButton testButton;
    private JTabbedPane jTabbedPane1;
    private JButton cancelButton;
    private JButton selectSchemasButton;
    private JLabel jLabel6;
    private JLabel jLabel5;
    private JLabel jLabel4;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JLabel jLabel1;

    public PreferencesDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.pack();
        this.setLocationRelativeTo(parent);
    }

    public boolean accepted() {
        return this.accepted;
    }

    public void setJDBCConnectionUrl(String s) {
        this.urlTextField.setText(s);
    }

    public String getJdbcConnectionUrl() {
        return this.urlTextField.getText();
    }

    public void setJDBCUsername(String s) {
        this.usernameTextField.setText(s);
    }

    public String getJdbcUsername() {
        return this.usernameTextField.getText();
    }

    public void setJDBCPassword(String s) {
        this.passwordTextField.setText(s);
    }

    public String getJdbcPassword() {
        return this.passwordTextField.getText();
    }

    public void setJDBCDriverClassName(String s) {
        this.driverClassTextField.setText(s);
    }

    public String getJdbcDriverClassName() {
        return this.driverClassTextField.getText();
    }

    public void setDatabaseSchema(String schema) {
        this.schemaTextField.setText(schema);
    }

    public String getDatabaseSchema() {
        return this.schemaTextField.getText();
    }

    public void setRequireSchema(boolean requireSchema) {
        this.requireSchemaButton.setSelected(requireSchema);
    }

    public boolean getRequireSchema() {
        return this.requireSchemaButton.isSelected();
    }

    public I18n getResourceConverter() {
        if (this.getParent() == null && this.getParent().getClass() != Workbench.class) {
            return Workbench.getGlobalResourceConverter();
        }
        return ((Workbench)this.getParent()).getResourceConverter();
    }

    private void initComponents() {
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.urlTextField = new JTextField(50);
        this.usernameTextField = new JTextField();
        this.passwordTextField = new JTextField();
        this.driverClassTextField = new JTextField();
        this.schemaTextField = new JTextField();
        this.requireSchemaButton = new JCheckBox();
        this.testButton = new JButton();
        this.acceptButton = new JButton();
        this.cancelButton = new JButton();
        this.selectSchemasButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle(this.getResourceConverter().getString("preferences.pane.title", "Database Connection"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                PreferencesDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jLabel1.setText(this.getResourceConverter().getString("preferences.driverClassName.title", "Driver Class Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText(this.getResourceConverter().getString("preferences.connectionURL.title", "Connection URL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText(this.getResourceConverter().getString("preferences.userName.title", "User name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel4.setText(this.getResourceConverter().getString("preferences.password.title", "Password"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.urlTextField, gridBagConstraints);
        this.jLabel5.setText(this.getResourceConverter().getString("preferences.schema.title", "Schemas (Optional, comma separated)"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel5, gridBagConstraints);
        this.jLabel6.setText(this.getResourceConverter().getString("preferences.requireschema.title", "Require Schema Attributes"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.jLabel6, gridBagConstraints);
        this.usernameTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.usernameTextField, gridBagConstraints);
        this.passwordTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.passwordTextField, gridBagConstraints);
        this.schemaTextField.setText("");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.schemaTextField, gridBagConstraints);
        this.selectSchemasButton.setText(this.getResourceConverter().getString("preferences.selectSchemasButton.title", "Select Schemas"));
        this.selectSchemasButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.selectSchemasButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(4, 4, 4, 180);
        this.jPanel1.add((Component)this.selectSchemasButton, gridBagConstraints);
        this.selectSchemasButton.setVisible(false);
        this.requireSchemaButton.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.requireSchemaButton, gridBagConstraints);
        this.driverClassTextField.setText("org.gjt.mm.mysql.Driver");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.driverClassTextField, gridBagConstraints);
        this.jTabbedPane1.addTab(this.getResourceConverter().getString("preferences.jdbcPanel.title", "JDBC"), this.jPanel1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.jTabbedPane1, gridBagConstraints);
        this.testButton.setText(this.getResourceConverter().getString("preferences.testButton.title", "Test Connection"));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.testButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(4, 4, 4, 180);
        this.getContentPane().add((Component)this.testButton, gridBagConstraints);
        this.cancelButton.setText(this.getResourceConverter().getString("preferences.cancelButton.title", "Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancelButton, gridBagConstraints);
        this.acceptButton.setText(this.getResourceConverter().getString("preferences.acceptButton.title", "Accept"));
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PreferencesDialog.this.acceptButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(4, 4, 4, 80);
        this.getContentPane().add((Component)this.acceptButton, gridBagConstraints);
        this.pack();
    }

    private void selectSchemasButtonActionPerformed(ActionEvent evt) {
        JdbcMetaData jdbcMetaData = this.getTestingJdbcMetadata();
        if (jdbcMetaData.getErrMsg() != null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("preferences.unsuccessfulTestConnection.alert", "Database connection could not be done.\n{0}", jdbcMetaData.getErrMsg()), "", 2);
            return;
        }
        List<String> allSchemaNames = jdbcMetaData.listAllSchemas();
        if (allSchemaNames == null || allSchemaNames.size() == 0) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.noSchemas.cantSetSchemas.alert", "No schemas available for this database connection"), "", 2);
            return;
        }
        PreferencesSchemasDialog psd = new PreferencesSchemasDialog(this, jdbcMetaData);
        this.setVisible(false);
        this.setModal(false);
        psd.setVisible(true);
        psd.isAccepted();
        this.setModal(true);
        this.setVisible(true);
    }

    public JdbcMetaData getTestingJdbcMetadata() {
        return new JdbcMetaData(this.getJdbcDriverClassName(), this.getJdbcConnectionUrl(), this.getJdbcUsername(), this.getJdbcPassword());
    }

    private void testButtonActionPerformed(ActionEvent evt) {
        JdbcMetaData jdbcMetaData = this.getTestingJdbcMetadata();
        if (jdbcMetaData.getErrMsg() != null) {
            JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("preferences.unsuccessfulTestConnection.alert", "Database connection could not be done.\n{0}", jdbcMetaData.getErrMsg()), "", 2);
            this.accepted = false;
            return;
        }
        List<String> allSchemaNames = jdbcMetaData.listAllSchemas();
        String currentSchemas = this.schemaTextField.getText();
        if (allSchemaNames == null || allSchemaNames.size() == 0) {
            if (currentSchemas != null && currentSchemas.trim().length() > 0) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.noSchemas.butSchemasEntered.alert", "No schemas available for this database connection, but schemas entered"), "", 2);
                this.accepted = false;
                return;
            }
            if (this.requireSchemaButton.isSelected()) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.noSchemas.butSchemasRequired.alert", "No schemas available for this database connection, but schemas are required"), "", 2);
                this.accepted = false;
                return;
            }
        }
        if (currentSchemas != null && currentSchemas.trim().length() > 0) {
            String[] schemasArray = currentSchemas.trim().split("[,;]");
            TreeSet<String> validSchemas = new TreeSet<String>();
            StringBuffer schemasInError = new StringBuffer();
            int i = 0;
            while (i < schemasArray.length) {
                String enteredSchemaName = schemasArray[i].trim();
                if (enteredSchemaName.length() > 0) {
                    for (String actualSchemaName : allSchemaNames) {
                        if (!actualSchemaName.equalsIgnoreCase(enteredSchemaName)) continue;
                        validSchemas.add(enteredSchemaName);
                        break;
                    }
                }
                if (!validSchemas.contains(enteredSchemaName)) {
                    schemasInError.append(" ").append(enteredSchemaName);
                }
                ++i;
            }
            if (schemasInError.length() > 0) {
                JOptionPane.showMessageDialog(this, this.getResourceConverter().getFormattedString("preferences.invalidSchemas.alert", "The following entered schemas are invalid.\n{0}", schemasInError.toString()), "", 2);
                this.accepted = false;
                return;
            }
        }
        JOptionPane.showMessageDialog(this, this.getResourceConverter().getString("preferences.successfulTestConnection.alert", "Database connection successful"), "", 1);
        this.accepted = true;
    }

    private void acceptButtonActionPerformed(ActionEvent evt) {
        this.accepted = true;
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.accepted = false;
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.dispose();
    }
}

