/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.lang.reflect.Field;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.Workbench;
import org.apache.log4j.Logger;

public class PropertyTableModel
extends AbstractTableModel {
    private static final Logger LOGGER = Logger.getLogger(PropertyTableModel.class);
    private Object parentTarget;
    private String factTable;
    private String factTableSchema;
    private List<String> names;
    private String errorMsg = null;
    String[] propertyNames;
    Object target;
    Workbench workbench;

    public PropertyTableModel(Workbench wb, Object t, String[] pNames) {
        this.workbench = wb;
        this.propertyNames = pNames;
        this.target = t;
    }

    @Override
    public String getColumnName(int i) {
        if (i == 0) {
            return this.workbench.getResourceConverter().getString("propertyTableModel.attribute", "Attribute");
        }
        if (i == 1) {
            return this.workbench.getResourceConverter().getString("propertyTableModel.value", "Value");
        }
        return this.workbench.getResourceConverter().getString("propertyTableModel.unknown", "?");
    }

    public String getRowName(int i) {
        String pName = this.propertyNames[i];
        int j = -1;
        j = pName.indexOf(124);
        if (j != -1) {
            return pName.substring(0, j).trim();
        }
        return this.propertyNames[i];
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (col == 1) {
            Object cellObj = this.getValueAt(row, col);
            return !(cellObj instanceof MondrianGuiDef.Join);
        }
        return false;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public int getRowCount() {
        return this.propertyNames.length;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.propertyNames[rowIndex];
        }
        try {
            String pName = this.propertyNames[rowIndex];
            if (pName.indexOf(124) == -1) {
                Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
                return f.get(this.target);
            }
            Object obj = null;
            String[] pNames = pName.split("\\|", 0);
            int j = 0;
            while (true) {
                if (j >= pNames.length) {
                    return obj;
                }
                if (pNames[j].indexOf(46) != -1) {
                    String[] pNamesField = pNames[j].trim().split("\\.", 0);
                    if (pNamesField.length <= 1) return null;
                    Field f = this.target.getClass().getField(pNamesField[0].trim());
                    obj = f.get(this.target);
                    if (obj == null) return null;
                    Field f2 = obj.getClass().getField(pNamesField[1].trim());
                    return f2.get(obj);
                }
                Field f = this.target.getClass().getField(pNames[j].trim());
                obj = f.get(this.target);
                if (obj != null) {
                    return obj;
                }
                ++j;
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"getValueAt(row, index)", (Throwable)ex);
            return "#ERROR";
        }
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        this.setErrorMsg(null);
        try {
            String pName = this.propertyNames[rowIndex];
            int i = -1;
            i = pName.indexOf(124);
            if (i != -1) {
                Field f = this.target.getClass().getField(this.propertyNames[rowIndex].substring(0, i).trim());
                f.set(this.target, value);
                String[] pNames = pName.split("\\|", 0);
                int j = 1;
                while (j < pNames.length) {
                    String[] pNamesField = pNames[j].trim().split("\\.", 0);
                    Field f2 = this.target.getClass().getField(pNamesField[0].trim());
                    f2.set(this.target, null);
                    ++j;
                }
            } else if (this.target instanceof MondrianGuiDef.Level && pName.equals("ordinalExp")) {
                ((MondrianGuiDef.Level)((Object)this.target)).ordinalExp.expressions[0] = (MondrianGuiDef.SQL)((Object)value);
            } else if (this.target instanceof MondrianGuiDef.Level && pName.equals("captionExp")) {
                ((MondrianGuiDef.Level)((Object)this.target)).captionExp.expressions[0] = (MondrianGuiDef.SQL)((Object)value);
            } else if (this.target instanceof MondrianGuiDef.Table && pName.equals("name") || this.target instanceof MondrianGuiDef.Hierarchy && pName.equals("primaryKeyTable") || this.target instanceof MondrianGuiDef.Level && pName.equals("table")) {
                if (value != null) {
                    String[] aValues = ((String)value).split("->");
                    if (aValues.length == 2) {
                        if (this.target instanceof MondrianGuiDef.Table) {
                            ((MondrianGuiDef.Table)((Object)this.target)).name = aValues[1];
                            ((MondrianGuiDef.Table)((Object)this.target)).schema = aValues[0];
                            this.fireTableDataChanged();
                        } else {
                            Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
                            f.set(this.target, aValues[1]);
                        }
                    } else {
                        Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
                        this.setFieldValue(f, value);
                    }
                }
            } else if (this.target instanceof MondrianGuiDef.Dimension && pName.equals("foreignKey") || this.target instanceof MondrianGuiDef.DimensionUsage && pName.equals("foreignKey") || this.target instanceof MondrianGuiDef.Measure && pName.equals("column") || this.target instanceof MondrianGuiDef.Hierarchy && pName.equals("primaryKey") || this.target instanceof MondrianGuiDef.Level && pName.equals("column") || this.target instanceof MondrianGuiDef.Level && pName.equals("nameColumn") || this.target instanceof MondrianGuiDef.Level && pName.equals("ordinalColumn") || this.target instanceof MondrianGuiDef.Level && pName.equals("parentColumn") || this.target instanceof MondrianGuiDef.Level && pName.equals("captionColumn") || this.target instanceof MondrianGuiDef.Closure && pName.equals("parentColumn") || this.target instanceof MondrianGuiDef.Closure && pName.equals("childColumn") || this.target instanceof MondrianGuiDef.Property && pName.equals("column")) {
                if (value != null) {
                    String[] aValues = ((String)value).split("->");
                    Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
                    value = aValues[aValues.length - 1].split(" - ")[0];
                    this.setFieldValue(f, value);
                }
            } else if (this.propertyNames[rowIndex].equals("name") && !(this.target instanceof MondrianGuiDef.Table) && !value.equals(this.target.getClass().getField(this.propertyNames[rowIndex]).get(this.target)) && this.duplicateName(value)) {
                this.setErrorMsg(this.workbench.getResourceConverter().getFormattedString("propertyTableModel.duplicateValue.error", "Error setting name property. {0} already exists", value.toString()));
            } else {
                Field f = this.target.getClass().getField(this.propertyNames[rowIndex]);
                this.setFieldValue(f, value);
            }
        }
        catch (Exception ex) {
            LOGGER.error((Object)"setValueAt(aValue, row, index)", (Throwable)ex);
        }
    }

    private void setFieldValue(Field aField, Object aValue) throws IllegalAccessException {
        if (aValue != null && aValue.toString().trim().length() == 0) {
            aField.set(this.target, null);
        } else {
            aField.set(this.target, aValue);
        }
    }

    public Object getValue() {
        return this.target;
    }

    public Object getParentTarget() {
        return this.parentTarget;
    }

    public void setParentTarget(Object parentTarget) {
        this.parentTarget = parentTarget;
    }

    public String getFactTable() {
        return this.factTable;
    }

    public void setFactTable(String factTable) {
        this.factTable = factTable;
    }

    public String getFactTableSchema() {
        return this.factTableSchema;
    }

    public void setFactTableSchema(String factTableSchema) {
        this.factTableSchema = factTableSchema;
    }

    private boolean duplicateName(Object aValue) {
        return this.names != null && this.names.contains(aValue);
    }

    public List<String> getNames() {
        return this.names;
    }

    public void setNames(List<String> names) {
        this.names = names;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}

