/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import mondrian.gui.MondrianGuiDef;
import mondrian.util.CompositeList;

public class SchemaTreeModel
extends DefaultTreeModel {
    MondrianGuiDef.Schema schema;

    public SchemaTreeModel() {
        super(null);
    }

    public SchemaTreeModel(MondrianGuiDef.Schema s) {
        super(new DefaultMutableTreeNode(s.name));
        this.schema = s;
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.getChildList(parent).get(index);
    }

    private List<Object> getChildList(Object parent) {
        if (parent instanceof MondrianGuiDef.Cube) {
            MondrianGuiDef.Cube c = (MondrianGuiDef.Cube)((Object)parent);
            return new CompositeList<Object>(this.ifList(c.fact), Arrays.asList(c.dimensions), Arrays.asList(c.measures), Arrays.asList(c.calculatedMembers), Arrays.asList(c.namedSets), this.ifList(c.annotations));
        }
        if (parent instanceof MondrianGuiDef.Dimension) {
            MondrianGuiDef.Dimension d = (MondrianGuiDef.Dimension)((Object)parent);
            return new CompositeList<Object>(Arrays.asList(d.hierarchies), this.ifList(d.annotations));
        }
        if (parent instanceof MondrianGuiDef.UserDefinedFunction) {
            MondrianGuiDef.UserDefinedFunction udf = (MondrianGuiDef.UserDefinedFunction)((Object)parent);
            return new CompositeList<Object>(this.ifList(udf.script));
        }
        if (parent instanceof MondrianGuiDef.ExpressionView) {
            MondrianGuiDef.ExpressionView ev = (MondrianGuiDef.ExpressionView)parent;
            return Arrays.asList(ev.expressions);
        }
        if (parent instanceof MondrianGuiDef.Hierarchy) {
            MondrianGuiDef.Hierarchy h = (MondrianGuiDef.Hierarchy)((Object)parent);
            return new CompositeList<Object>(Arrays.asList(h.levels), Arrays.asList(h.memberReaderParameters), this.ifList(h.relation), this.ifList(h.annotations));
        }
        if (parent instanceof MondrianGuiDef.Join) {
            MondrianGuiDef.Join j = (MondrianGuiDef.Join)((Object)parent);
            return Arrays.asList(new Object[]{j.left, j.right});
        }
        if (parent instanceof MondrianGuiDef.Level) {
            MondrianGuiDef.Level level = (MondrianGuiDef.Level)((Object)parent);
            return new CompositeList<Object>(Arrays.asList(level.properties), this.ifList(level.keyExp), this.ifList(level.nameExp), this.ifList(level.ordinalExp), this.ifList(level.captionExp), this.ifList(level.parentExp), this.ifList(level.closure), this.ifList(level.memberFormatter), this.ifList(level.annotations));
        }
        if (parent instanceof MondrianGuiDef.CellFormatter) {
            MondrianGuiDef.CellFormatter f = (MondrianGuiDef.CellFormatter)((Object)parent);
            return new CompositeList<Object>(this.ifList(f.script));
        }
        if (parent instanceof MondrianGuiDef.MemberFormatter) {
            MondrianGuiDef.MemberFormatter f = (MondrianGuiDef.MemberFormatter)((Object)parent);
            return new CompositeList<Object>(this.ifList(f.script));
        }
        if (parent instanceof MondrianGuiDef.PropertyFormatter) {
            MondrianGuiDef.PropertyFormatter f = (MondrianGuiDef.PropertyFormatter)((Object)parent);
            return new CompositeList<Object>(this.ifList(f.script));
        }
        if (parent instanceof MondrianGuiDef.Property) {
            MondrianGuiDef.Property property = (MondrianGuiDef.Property)((Object)parent);
            return new CompositeList<Object>(this.ifList(property.propertyFormatter));
        }
        if (parent instanceof MondrianGuiDef.CalculatedMember) {
            MondrianGuiDef.CalculatedMember c = (MondrianGuiDef.CalculatedMember)((Object)parent);
            return new CompositeList<Object>(this.ifList(c.formulaElement), this.arrayList(c.memberProperties), this.ifList(c.annotations), this.ifList(c.cellFormatter));
        }
        if (parent instanceof MondrianGuiDef.Measure) {
            MondrianGuiDef.Measure m = (MondrianGuiDef.Measure)((Object)parent);
            return new CompositeList<Object>(this.ifList(m.measureExp), this.arrayList(m.memberProperties), this.ifList(m.annotations), this.ifList(m.cellFormatter));
        }
        if (parent instanceof MondrianGuiDef.NamedSet) {
            MondrianGuiDef.NamedSet m = (MondrianGuiDef.NamedSet)((Object)parent);
            return new CompositeList<Object>(this.ifList(m.formulaElement), this.ifList(m.annotations));
        }
        if (parent instanceof MondrianGuiDef.Schema) {
            MondrianGuiDef.Schema s = (MondrianGuiDef.Schema)((Object)parent);
            return new CompositeList<Object>(Arrays.asList(s.cubes), Arrays.asList(s.dimensions), Arrays.asList(s.namedSets), Arrays.asList(s.namedSets), Arrays.asList(s.userDefinedFunctions), Arrays.asList(s.virtualCubes), Arrays.asList(s.roles), Arrays.asList(s.parameters), this.ifList(s.annotations));
        }
        if (parent instanceof MondrianGuiDef.Table) {
            MondrianGuiDef.Table t = (MondrianGuiDef.Table)((Object)parent);
            return new CompositeList<Object>(this.arrayList(t.aggTables), this.arrayList(t.aggExcludes));
        }
        if (parent instanceof MondrianGuiDef.AggTable) {
            MondrianGuiDef.AggTable t = (MondrianGuiDef.AggTable)((Object)parent);
            return new CompositeList<Object>(this.ifList(t.factcount), Arrays.asList(t.ignoreColumns), Arrays.asList(t.foreignKeys), Arrays.asList(t.measures), Arrays.asList(t.levels), t instanceof MondrianGuiDef.AggPattern ? Arrays.asList(((MondrianGuiDef.AggPattern)t).excludes) : Collections.emptyList());
        }
        if (parent instanceof MondrianGuiDef.View) {
            MondrianGuiDef.View v = (MondrianGuiDef.View)((Object)parent);
            return Arrays.asList(v.selects);
        }
        if (parent instanceof MondrianGuiDef.VirtualCube) {
            MondrianGuiDef.VirtualCube c = (MondrianGuiDef.VirtualCube)((Object)parent);
            return new CompositeList<Object>(Arrays.asList(c.dimensions), Arrays.asList(c.measures), Arrays.asList(c.calculatedMembers), this.ifList(c.annotations));
        }
        if (parent instanceof MondrianGuiDef.VirtualCubeDimension) {
            MondrianGuiDef.VirtualCubeDimension d = (MondrianGuiDef.VirtualCubeDimension)((Object)parent);
            return this.ifList(d.annotations);
        }
        if (parent instanceof MondrianGuiDef.VirtualCubeMeasure) {
            MondrianGuiDef.VirtualCubeMeasure m = (MondrianGuiDef.VirtualCubeMeasure)((Object)parent);
            return this.ifList(m.annotations);
        }
        if (parent instanceof MondrianGuiDef.Role) {
            MondrianGuiDef.Role c = (MondrianGuiDef.Role)((Object)parent);
            return new CompositeList<Object>(Arrays.asList(c.schemaGrants), this.ifList(c.annotations));
        }
        if (parent instanceof MondrianGuiDef.SchemaGrant) {
            MondrianGuiDef.SchemaGrant c = (MondrianGuiDef.SchemaGrant)parent;
            return Arrays.asList(c.cubeGrants);
        }
        if (parent instanceof MondrianGuiDef.CubeGrant) {
            MondrianGuiDef.CubeGrant c = (MondrianGuiDef.CubeGrant)parent;
            return new CompositeList<Object>(Arrays.asList(c.dimensionGrants), Arrays.asList(c.hierarchyGrants));
        }
        if (parent instanceof MondrianGuiDef.HierarchyGrant) {
            MondrianGuiDef.HierarchyGrant c = (MondrianGuiDef.HierarchyGrant)parent;
            return Arrays.asList(c.memberGrants);
        }
        if (parent instanceof MondrianGuiDef.Closure) {
            MondrianGuiDef.Closure c = (MondrianGuiDef.Closure)((Object)parent);
            return this.ifList(c.table);
        }
        if (parent instanceof MondrianGuiDef.Annotations) {
            MondrianGuiDef.Annotations annotations = (MondrianGuiDef.Annotations)((Object)parent);
            return Arrays.asList(annotations.array);
        }
        return Collections.emptyList();
    }

    private <T> List<T> ifList(T e) {
        return e == null ? Collections.emptyList() : Collections.singletonList(e);
    }

    private <T> List<T> arrayList(T ... e) {
        return e == null || e.length == 0 ? Collections.emptyList() : (e.length == 1 ? Collections.singletonList(e[0]) : Arrays.asList(e));
    }

    @Override
    public int getChildCount(Object parent) {
        return this.getChildList(parent).size();
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        if (parent == null) {
            return -1;
        }
        List<Object> list = this.getChildList(parent);
        int i = 0;
        for (Object o : list) {
            if (this.equal(o, child)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private boolean equal(Object o1, Object o2) {
        if (o1 == null) {
            return o2 == null;
        }
        if (o1 instanceof MondrianGuiDef.Hierarchy || o1 instanceof MondrianGuiDef.SQL) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    @Override
    public Object getRoot() {
        return this.schema;
    }

    @Override
    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

