/*
 * Decompiled with CFR 0.152.
 */
package mondrian.gui.validate;

import java.util.TreeSet;
import mondrian.gui.MondrianGuiDef;
import mondrian.gui.SchemaExplorer;
import mondrian.gui.validate.JdbcValidator;
import mondrian.gui.validate.Messages;
import mondrian.gui.validate.TreeModel;
import mondrian.gui.validate.TreeModelPath;
import org.apache.log4j.Logger;

public class ValidationUtils {
    private static final Logger LOGGER = Logger.getLogger(ValidationUtils.class);
    static String[] DEF_LEVEL = new String[]{"column", "nameColumn", "parentColumn", "ordinalColumn", "captionColumn"};

    /*
     * Unable to fully structure code
     */
    public static String invalid(Messages messages, JdbcValidator jdbcValidator, TreeModel treeModel, TreeModelPath tpath, Object value, MondrianGuiDef.Cube cube, MondrianGuiDef.Dimension parentDimension, MondrianGuiDef.Hierarchy parentHierarchy, MondrianGuiDef.Level parentLevel, boolean isSchemaRequired) {
        block123: {
            block128: {
                block127: {
                    block126: {
                        block125: {
                            block124: {
                                block122: {
                                    nameMustBeSet = messages.getString("schemaTreeCellRenderer.nameMustBeSet.alert", "Name must be set");
                                    if (!tpath.isEmpty()) {
                                        pathcount = tpath.getPathCount();
                                        i = 0;
                                        while (i < pathcount && (cube == null || parentDimension == null || parentHierarchy == null || parentLevel == null)) {
                                            p = tpath.getPathComponent(i);
                                            if (p instanceof MondrianGuiDef.Cube && cube == null) {
                                                cube = (MondrianGuiDef.Cube)p;
                                            }
                                            if (p instanceof MondrianGuiDef.Dimension && parentDimension == null) {
                                                parentDimension = (MondrianGuiDef.Dimension)p;
                                            }
                                            if (p instanceof MondrianGuiDef.Hierarchy && parentHierarchy == null) {
                                                parentHierarchy = (MondrianGuiDef.Hierarchy)p;
                                            }
                                            if (p instanceof MondrianGuiDef.Level && parentLevel == null) {
                                                parentLevel = (MondrianGuiDef.Level)p;
                                            }
                                            ++i;
                                        }
                                    }
                                    if (!(value instanceof MondrianGuiDef.Schema)) break block122;
                                    if (ValidationUtils.isEmpty(((MondrianGuiDef.Schema)value).name)) {
                                        return nameMustBeSet;
                                    }
                                    break block123;
                                }
                                if (!(value instanceof MondrianGuiDef.VirtualCube)) break block124;
                                virtCube = (MondrianGuiDef.VirtualCube)value;
                                if (ValidationUtils.isEmpty(virtCube.name)) {
                                    return nameMustBeSet;
                                }
                                if (ValidationUtils.isEmpty((Object[])virtCube.dimensions)) {
                                    return messages.getString("schemaTreeCellRenderer.cubeMustHaveDimensions.alert", "Cube must contain dimensions");
                                }
                                if (ValidationUtils.isEmpty((Object[])virtCube.measures)) {
                                    return messages.getString("schemaTreeCellRenderer.cubeMustHaveMeasures.alert", "Cube must contain measures");
                                }
                                break block123;
                            }
                            if (!(value instanceof MondrianGuiDef.VirtualCubeDimension)) break block125;
                            if (ValidationUtils.isEmpty(((MondrianGuiDef.VirtualCubeDimension)value).name)) {
                                return nameMustBeSet;
                            }
                            break block123;
                        }
                        if (!(value instanceof MondrianGuiDef.VirtualCubeMeasure)) break block126;
                        if (ValidationUtils.isEmpty(((MondrianGuiDef.VirtualCubeMeasure)value).name)) {
                            return nameMustBeSet;
                        }
                        break block123;
                    }
                    if (!(value instanceof MondrianGuiDef.Cube)) break block127;
                    cubeVal = (MondrianGuiDef.Cube)value;
                    if (ValidationUtils.isEmpty(cubeVal.name)) {
                        return nameMustBeSet;
                    }
                    if (cubeVal.fact == null || cubeVal.fact instanceof MondrianGuiDef.Table && ValidationUtils.isEmpty(((MondrianGuiDef.Table)cubeVal.fact).name) || cubeVal.fact instanceof MondrianGuiDef.View && ValidationUtils.isEmpty(((MondrianGuiDef.View)cubeVal.fact).alias)) {
                        return messages.getString("schemaTreeCellRenderer.factNameMustBeSet.alert", "Fact name must be set");
                    }
                    if (ValidationUtils.isEmpty((Object[])cubeVal.dimensions)) {
                        return messages.getString("schemaTreeCellRenderer.cubeMustHaveDimensions.alert", "Cube must contain dimensions");
                    }
                    if (ValidationUtils.isEmpty((Object[])cubeVal.measures)) {
                        return messages.getString("schemaTreeCellRenderer.cubeMustHaveMeasures.alert", "Cube must contain measures");
                    }
                    if (jdbcValidator.isInitialized() && ((MondrianGuiDef.Cube)value).fact instanceof MondrianGuiDef.Table) {
                        table = (MondrianGuiDef.Table)cubeVal.fact;
                        schemaName = table.schema;
                        factTable = table.name;
                        if (!jdbcValidator.isTableExists(schemaName, factTable)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.factTableDoesNotExist.alert", "Fact table {0} does not exist in database {1}", new Object[]{factTable, schemaName == null || schemaName.equals("") != false ? "." : "schema " + schemaName});
                        }
                    }
                    break block123;
                }
                if (!(value instanceof MondrianGuiDef.CubeDimension)) break block128;
                if (ValidationUtils.isEmpty(((MondrianGuiDef.CubeDimension)value).name)) {
                    return nameMustBeSet;
                }
                if (value instanceof MondrianGuiDef.DimensionUsage) {
                    if (ValidationUtils.isEmpty(((MondrianGuiDef.DimensionUsage)value).source)) {
                        return messages.getString("schemaTreeCellRenderer.sourceMustBeSet.alert", "Source must be set");
                    }
                    s = (MondrianGuiDef.Schema)treeModel.getRoot();
                    ds = s.dimensions;
                    sourcename = ((MondrianGuiDef.DimensionUsage)value).source;
                    notfound = true;
                    j = 0;
                    while (j < ds.length) {
                        if (ds[j].name.equalsIgnoreCase(sourcename)) {
                            notfound = false;
                            break;
                        }
                        ++j;
                    }
                    if (notfound) {
                        return messages.getFormattedString("schemaTreeCellRenderer.sourceInSharedDimensionDoesNotExist.alert", "Source {0} does not exist as Shared Dimension of Schema", new Object[]{sourcename});
                    }
                }
                if (value instanceof MondrianGuiDef.Dimension && cube != null && !ValidationUtils.isEmpty(((MondrianGuiDef.Dimension)value).foreignKey) && jdbcValidator.isInitialized() && cube.fact instanceof MondrianGuiDef.Table) {
                    factTable = (MondrianGuiDef.Table)cube.fact;
                    foreignKey = ((MondrianGuiDef.Dimension)value).foreignKey;
                    if (!jdbcValidator.isColExists(factTable.schema, factTable.name, foreignKey)) {
                        return messages.getFormattedString("schemaTreeCellRenderer.foreignKeyDoesNotExist.alert", "foreignKey {0} does not exist in fact table", new Object[]{foreignKey});
                    }
                }
                break block123;
            }
            if (!(value instanceof MondrianGuiDef.Level)) ** GOTO lbl113
            level = (MondrianGuiDef.Level)value;
            if (!ValidationUtils.isEmpty(level.levelType) && parentDimension != null) {
                if ((ValidationUtils.isEmpty(parentDimension.type) || parentDimension.type.equals("StandardDimension")) && !ValidationUtils.isEmpty(level.levelType) && !level.levelType.equals(MondrianGuiDef.Level._levelType_values[0])) {
                    return messages.getFormattedString("schemaTreeCellRenderer.levelUsedOnlyInTimeDimension.alert", "levelType {0} can only be used with a TimeDimension", new Object[]{level.levelType});
                }
                if (!ValidationUtils.isEmpty(parentDimension.type) && parentDimension.type.equals("TimeDimension") && !ValidationUtils.isEmpty(level.levelType) && level.levelType.equals(MondrianGuiDef.Level._levelType_values[0])) {
                    return messages.getFormattedString("schemaTreeCellRenderer.levelUsedOnlyInStandardDimension.alert", "levelType {0} can only be used with a StandardDimension", new Object[]{level.levelType});
                }
            }
            if (ValidationUtils.isEmpty(column = level.column)) {
                if (level.properties == null || level.properties.length == 0) {
                    return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                }
            } else {
                theMessage = null;
                try {
                    i = 0;
                    while (i < ValidationUtils.DEF_LEVEL.length) {
                        theField = level.getClass().getDeclaredField(ValidationUtils.DEF_LEVEL[i]);
                        column = (String)theField.get((Object)level);
                        theMessage = ValidationUtils.validateColumn(column, ValidationUtils.DEF_LEVEL[i], messages, level, jdbcValidator, cube, parentHierarchy);
                        if (theMessage == null) {
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception ex) {
                    ValidationUtils.LOGGER.error((Object)"ValidationUtils", (Throwable)ex);
                }
                return theMessage;
lbl113:
                // 1 sources

                if (value instanceof MondrianGuiDef.Property) {
                    p = (MondrianGuiDef.Property)value;
                    column = p.column;
                    if (ValidationUtils.isEmpty(column)) {
                        return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                    }
                    if (jdbcValidator.isInitialized()) {
                        table = null;
                        if (parentLevel != null) {
                            table = parentLevel.table;
                        }
                        if (ValidationUtils.isEmpty(table)) {
                            if (parentHierarchy != null) {
                                if (parentHierarchy.relation == null && cube != null) {
                                    factTable = (MondrianGuiDef.Table)cube.fact;
                                    if (!jdbcValidator.isColExists(factTable.schema, factTable.name, column)) {
                                        return messages.getFormattedString("schemaTreeCellRenderer.degenDimensionColumnDoesNotExist.alert", "Degenerate dimension validation check - Column {0} does not exist in fact table", new Object[]{column});
                                    }
                                } else if (parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                                    parentTable = (MondrianGuiDef.Table)parentHierarchy.relation;
                                    if (!jdbcValidator.isColExists(parentTable.schema, parentTable.name, column)) {
                                        return messages.getFormattedString("schemaTreeCellRenderer.columnInDimensionDoesNotExist.alert", "Column {0} does not exist in Dimension table", new Object[]{parentTable.name});
                                    }
                                }
                            }
                        } else if (!jdbcValidator.isColExists(null, table, column)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.columnInDimensionDoesNotExist.alert", "Column {0} does not exist in Level table {1}", new Object[]{column, table});
                        }
                    }
                } else if (value instanceof MondrianGuiDef.Measure) {
                    measure = (MondrianGuiDef.Measure)value;
                    if (ValidationUtils.isEmpty(measure.name)) {
                        return nameMustBeSet;
                    }
                    if (ValidationUtils.isEmpty(measure.aggregator)) {
                        return messages.getString("schemaTreeCellRenderer.aggregatorMustBeSet.alert", "Aggregator must be set");
                    }
                    if (measure.measureExp == null) {
                        if (ValidationUtils.isEmpty(measure.column)) {
                            return messages.getString("schemaTreeCellRenderer.columnMustBeSet.alert", "Column must be set");
                        }
                        if (cube != null && cube.fact != null && cube.fact instanceof MondrianGuiDef.Table) {
                            factTable = (MondrianGuiDef.Table)cube.fact;
                            if (jdbcValidator.isInitialized() && jdbcValidator.isColExists(factTable.schema, factTable.name, column = measure.column)) {
                                colType = jdbcValidator.getColumnDataType(factTable.schema, factTable.name, measure.column);
                                agIndex = -1;
                                if ("sum".equals(measure.aggregator) || "avg".equals(measure.aggregator)) {
                                    agIndex = 0;
                                }
                                if (agIndex != -1 && (colType < 2 || colType > 8) && colType != -5 && colType != -6) {
                                    return messages.getFormattedString("schemaTreeCellRenderer.aggregatorNotValidForColumn.alert", "Aggregator {0} is not valid for the data type of the column {1}", new Object[]{measure.aggregator, measure.column});
                                }
                            }
                        }
                    }
                } else if (value instanceof MondrianGuiDef.Hierarchy) {
                    hierarchy = (MondrianGuiDef.Hierarchy)value;
                    if (hierarchy.relation instanceof MondrianGuiDef.Join) {
                        if (ValidationUtils.isEmpty(hierarchy.primaryKeyTable)) {
                            if (ValidationUtils.isEmpty(hierarchy.primaryKey)) {
                                return messages.getString("schemaTreeCellRenderer.primaryKeyTableAndPrimaryKeyMustBeSet.alert", "PrimaryKeyTable and PrimaryKey must be set for Join");
                            }
                            return messages.getString("schemaTreeCellRenderer.primaryKeyTableMustBeSet.alert", "PrimaryKeyTable must be set for Join");
                        }
                        if (ValidationUtils.isEmpty(hierarchy.primaryKey)) {
                            return messages.getString("schemaTreeCellRenderer.primaryKeyMustBeSet.alert", "PrimaryKey must be set for Join");
                        }
                    }
                    if ((levels = hierarchy.levels) == null || levels.length == 0) {
                        return messages.getString("schemaTreeCellRenderer.atLeastOneLevelForHierarchy.alert", "At least one Level must be set for Hierarchy");
                    }
                    schema = null;
                    pkTable = null;
                    if (hierarchy.relation instanceof MondrianGuiDef.Join) {
                        schemaAndTable = SchemaExplorer.getTableNameForAlias(hierarchy.relation, hierarchy.primaryKeyTable);
                        schema = schemaAndTable[0];
                        pkTable = schemaAndTable[1];
                    } else if (hierarchy.relation instanceof MondrianGuiDef.Table) {
                        table = (MondrianGuiDef.Table)hierarchy.relation;
                        pkTable = table.name;
                        schema = table.schema;
                    }
                    if (pkTable != null && !jdbcValidator.isColExists(schema, pkTable, hierarchy.primaryKey)) {
                        return messages.getFormattedString("schemaTreeCellRenderer.columnInTableDoesNotExist.alert", "Column {0} defined in field {1} does not exist in table {2}", new Object[]{ValidationUtils.isEmpty(hierarchy.primaryKey.trim()) != false ? "' '" : hierarchy.primaryKey, "primaryKey", pkTable});
                    }
                    if (hierarchy.relation instanceof MondrianGuiDef.Table && !ValidationUtils.isEmpty(hierarchy.primaryKeyTable)) {
                        return messages.getString("schemaTreeCellRenderer.fieldMustBeEmpty", "Table field must be empty");
                    }
                    primaryKeyTable = hierarchy.primaryKeyTable;
                    if (!ValidationUtils.isEmpty(primaryKeyTable) && hierarchy.relation instanceof MondrianGuiDef.Join) {
                        joinTables = new TreeSet<String>();
                        SchemaExplorer.getTableNamesForJoin(hierarchy.relation, joinTables);
                        if (!joinTables.contains(primaryKeyTable)) {
                            return messages.getString("schemaTreeCellRenderer.wrongTableValue", "Table value does not correspond to any join");
                        }
                    }
                    if (!ValidationUtils.isEmpty(primaryKeyTable) && hierarchy.relation instanceof MondrianGuiDef.Table) {
                        theTable = (MondrianGuiDef.Table)hierarchy.relation;
                        v0 = compareTo = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                        if (!primaryKeyTable.equals(compareTo)) {
                            return messages.getString("schemaTreeCellRenderer.tableDoesNotMatch", "Table value does not correspond to Hierarchy Relation");
                        }
                    }
                } else if (value instanceof MondrianGuiDef.NamedSet) {
                    namedSet = (MondrianGuiDef.NamedSet)value;
                    if (ValidationUtils.isEmpty(namedSet.name)) {
                        return nameMustBeSet;
                    }
                    if (ValidationUtils.isEmpty(namedSet.formula) && namedSet.formulaElement == null) {
                        return messages.getString("schemaTreeCellRenderer.formulaMustBeSet.alert", "Formula must be set");
                    }
                } else if (value instanceof MondrianGuiDef.Formula) {
                    formula = (MondrianGuiDef.Formula)value;
                    if (ValidationUtils.isEmpty(formula.cdata)) {
                        return messages.getString("schemaTreeCellRenderer.formulaMustBeSet.alert", "Formula must be set");
                    }
                } else if (value instanceof MondrianGuiDef.UserDefinedFunction) {
                    udf = (MondrianGuiDef.UserDefinedFunction)value;
                    if (ValidationUtils.isEmpty(udf.name)) {
                        return nameMustBeSet;
                    }
                    if (ValidationUtils.isEmpty(udf.className) && udf.script == null) {
                        return messages.getString("Either a Class Name or a Script are required", "Class name must be set");
                    }
                } else if (value instanceof MondrianGuiDef.MemberFormatter) {
                    f = (MondrianGuiDef.MemberFormatter)value;
                    if (ValidationUtils.isEmpty(f.className) && f.script == null) {
                        return messages.getString("schemaTreeCellRenderer.classNameOrScriptRequired.alert", "Either a Class Name or a Script are required");
                    }
                } else if (value instanceof MondrianGuiDef.CellFormatter) {
                    f = (MondrianGuiDef.CellFormatter)value;
                    if (ValidationUtils.isEmpty(f.className) && f.script == null) {
                        return messages.getString("schemaTreeCellRenderer.classNameOrScriptRequired.alert", "Either a Class Name or a Script are required");
                    }
                } else if (value instanceof MondrianGuiDef.PropertyFormatter) {
                    f = (MondrianGuiDef.PropertyFormatter)value;
                    if (ValidationUtils.isEmpty(f.className) && f.script == null) {
                        return messages.getString("schemaTreeCellRenderer.classNameOrScriptRequired.alert", "Either a Class Name or a Script are required");
                    }
                } else if (value instanceof MondrianGuiDef.CalculatedMember) {
                    calculatedMember = (MondrianGuiDef.CalculatedMember)value;
                    if (ValidationUtils.isEmpty(calculatedMember.name)) {
                        return nameMustBeSet;
                    }
                    if (ValidationUtils.isEmpty(calculatedMember.dimension)) {
                        return messages.getString("schemaTreeCellRenderer.dimensionMustBeSet.alert", "Dimension must be set");
                    }
                    if (ValidationUtils.isEmpty(calculatedMember.formula) && calculatedMember.formulaElement == null) {
                        return messages.getString("schemaTreeCellRenderer.formulaMustBeSet.alert", "Formula must be set");
                    }
                } else if (value instanceof MondrianGuiDef.Join) {
                    join = (MondrianGuiDef.Join)value;
                    if (ValidationUtils.isEmpty(join.leftKey)) {
                        return messages.getString("schemaTreeCellRenderer.leftKeyMustBeSet.alert", "Left key must be set");
                    }
                    if (ValidationUtils.isEmpty(join.rightKey)) {
                        return messages.getString("schemaTreeCellRenderer.rightKeyMustBeSet.alert", "Right key must be set");
                    }
                } else if (value instanceof MondrianGuiDef.Table) {
                    table = (MondrianGuiDef.Table)value;
                    tableName = table.name;
                    if (!jdbcValidator.isTableExists(null, tableName)) {
                        return messages.getFormattedString("schemaTreeCellRenderer.tableDoesNotExist.alert", "Table {0} does not exist in database", new Object[]{tableName});
                    }
                    theSchema = table.schema;
                    if (!ValidationUtils.isEmpty(theSchema) && !jdbcValidator.isSchemaExists(theSchema)) {
                        return messages.getFormattedString("schemaTreeCellRenderer.schemaDoesNotExist.alert", "Schema {0} does not exist", new Object[]{theSchema});
                    }
                    if (ValidationUtils.isEmpty(theSchema) && isSchemaRequired) {
                        return messages.getString("schemaTreeCellRenderer.schemaMustBeSet.alert", "Schema must be set");
                    }
                }
            }
        }
        childCnt = treeModel.getChildCount(value);
        i = 0;
        while (i < childCnt) {
            child = treeModel.getChild(value, i);
            if (child instanceof MondrianGuiDef.Cube) {
                childErrMsg = ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, (MondrianGuiDef.Cube)child, parentDimension, parentHierarchy, parentLevel, isSchemaRequired);
            } else if (child instanceof MondrianGuiDef.Dimension) {
                childErrMsg = ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, cube, (MondrianGuiDef.Dimension)child, parentHierarchy, parentLevel, isSchemaRequired);
            } else if (child instanceof MondrianGuiDef.Hierarchy) {
                if (value instanceof MondrianGuiDef.Dimension && cube != null && ((MondrianGuiDef.Hierarchy)child).relation != null && ValidationUtils.isEmpty(((MondrianGuiDef.Dimension)value).foreignKey)) {
                    return messages.getString("schemaTreeCellRenderer.foreignKeyMustBeSet.alert", "Foreign key must be set");
                }
                childErrMsg = ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, cube, parentDimension, (MondrianGuiDef.Hierarchy)child, parentLevel, isSchemaRequired);
            } else {
                childErrMsg = child instanceof MondrianGuiDef.Level != false ? ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, cube, parentDimension, parentHierarchy, (MondrianGuiDef.Level)child, isSchemaRequired) : ValidationUtils.invalid(messages, jdbcValidator, treeModel, tpath, child, cube, parentDimension, parentHierarchy, parentLevel, isSchemaRequired);
            }
            if (childErrMsg != null) {
                childClassName = child.getClass().getName();
                simpleName = childClassName.split("[$.]", 0);
                try {
                    f = child.getClass().getField("name");
                    childName = (String)f.get(child);
                    if (childName == null) {
                        childName = "";
                    }
                    childErrMsg = messages.getFormattedString("schemaTreeCellRenderer.childErrorMessageWithName.alert", "{0} {1} is invalid", new Object[]{simpleName[simpleName.length - 1], childName});
                }
                catch (Exception ex) {
                    childErrMsg = messages.getFormattedString("schemaTreeCellRenderer.childErrorExceptionMessage.alert", "{0} is invalid", new Object[]{simpleName[simpleName.length - 1]});
                }
                return childErrMsg;
            }
            ++i;
        }
        return null;
    }

    public static boolean isEmpty(String v) {
        return v == null || v.equals("");
    }

    public static boolean isEmpty(Object[] arr) {
        return arr == null || arr.length == 0;
    }

    private static String validateColumn(String column, String fieldName, Messages messages, MondrianGuiDef.Level level, JdbcValidator jdbcValidator, MondrianGuiDef.Cube cube, MondrianGuiDef.Hierarchy parentHierarchy) {
        if (!ValidationUtils.isEmpty(column) && jdbcValidator.isInitialized()) {
            MondrianGuiDef.Table parentTable;
            String table = level.table;
            if (!ValidationUtils.isEmpty(table) && parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                TreeSet<String> joinTables = new TreeSet<String>();
                SchemaExplorer.getTableNamesForJoin(parentHierarchy.relation, joinTables);
                if (!joinTables.contains(table)) {
                    return messages.getString("schemaTreeCellRenderer.wrongTableValue", "Table value does not correspond to any join");
                }
            }
            if (!ValidationUtils.isEmpty(table) && parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                String compareTo;
                MondrianGuiDef.Table theTable = parentTable = (MondrianGuiDef.Table)parentHierarchy.relation;
                String string = compareTo = theTable.alias != null && theTable.alias.trim().length() > 0 ? theTable.alias : theTable.name;
                if (!table.equals(compareTo)) {
                    return messages.getString("schemaTreeCellRenderer.tableDoesNotMatch", "Table value does not correspond to Hierarchy Relation");
                }
            }
            if (!ValidationUtils.isEmpty(table) && parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.View) {
                return messages.getString("schemaTreeCellRenderer.noTableForView", "Table for column cannot be set in View");
            }
            if (ValidationUtils.isEmpty(table)) {
                if (parentHierarchy != null) {
                    if (parentHierarchy.relation == null && cube != null) {
                        if (!jdbcValidator.isColExists(((MondrianGuiDef.Table)cube.fact).schema, ((MondrianGuiDef.Table)cube.fact).name, column)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.degenDimensionColumnDoesNotExist.alert", "Degenerate dimension validation check - Column {0} does not exist in fact table", column);
                        }
                    } else if (parentHierarchy.relation instanceof MondrianGuiDef.Table) {
                        parentTable = (MondrianGuiDef.Table)parentHierarchy.relation;
                        if (!jdbcValidator.isColExists(parentTable.schema, parentTable.name, column)) {
                            return messages.getFormattedString("schemaTreeCellRenderer.columnInTableDoesNotExist.alert", "Column {0} defined in field {1} does not exist in table {2}", ValidationUtils.isEmpty(column.trim()) ? "' '" : column, fieldName, parentTable.name);
                        }
                    } else if (parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                        return messages.getString("schemaTreeCellRenderer.tableMustBeSet.alert", "Table must be set");
                    }
                }
            } else {
                String schema = null;
                if (parentHierarchy != null && parentHierarchy.relation instanceof MondrianGuiDef.Join) {
                    String[] schemaAndTable = SchemaExplorer.getTableNameForAlias(parentHierarchy.relation, table);
                    schema = schemaAndTable[0];
                    table = schemaAndTable[1];
                }
                if (!jdbcValidator.isColExists(schema, table, column)) {
                    return messages.getFormattedString("schemaTreeCellRenderer.columnInTableDoesNotExist.alert", "Column {0} defined in field {1} does not exist in table {2}", ValidationUtils.isEmpty(column.trim()) ? "' '" : column, fieldName, table);
                }
            }
        }
        return null;
    }
}

