/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.type.Type;

public final class ResolvedFunCall
extends ExpBase
implements FunCall {
    private final Exp[] args;
    private final Type returnType;
    private final FunDef funDef;

    public ResolvedFunCall(FunDef funDef, Exp[] args, Type returnType) {
        assert (funDef != null);
        assert (args != null);
        assert (returnType != null);
        this.funDef = funDef;
        this.args = args;
        this.returnType = returnType;
    }

    public String toString() {
        return Util.unparse(this);
    }

    @Override
    public ResolvedFunCall clone() {
        return new ResolvedFunCall(this.funDef, ExpBase.cloneArray(this.args), this.returnType);
    }

    @Override
    public Exp getArg(int index) {
        return this.args[index];
    }

    @Override
    public Exp[] getArgs() {
        return this.args;
    }

    @Override
    public final int getArgCount() {
        return this.args.length;
    }

    @Override
    public String getFunName() {
        return this.funDef.getName();
    }

    @Override
    public Syntax getSyntax() {
        return this.funDef.getSyntax();
    }

    @Override
    public Object[] getChildren() {
        return this.args;
    }

    public FunDef getFunDef() {
        return this.funDef;
    }

    @Override
    public final int getCategory() {
        return this.funDef.getReturnCategory();
    }

    @Override
    public final Type getType() {
        return this.returnType;
    }

    @Override
    public Exp accept(Validator validator) {
        Exp[] newArgs = new Exp[this.args.length];
        FunUtil.resolveFunArgs(validator, this.funDef, this.args, newArgs, this.getFunName(), this.getSyntax());
        return this;
    }

    @Override
    public void unparse(PrintWriter pw) {
        this.funDef.unparse(this.args, pw);
    }

    @Override
    public Calc accept(ExpCompiler compiler) {
        return this.funDef.compileCall(this, compiler);
    }

    @Override
    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        if (visitor.shouldVisitChildren()) {
            Exp[] expArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                Exp arg = expArray[n2];
                arg.accept(visitor);
                ++n2;
            }
        }
        return o;
    }
}

