/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import java.io.PrintWriter;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.type.Type;

public class UnresolvedFunCall
extends ExpBase
implements FunCall {
    private final String name;
    private final Syntax syntax;
    private final Exp[] args;

    public UnresolvedFunCall(String name, Exp[] args) {
        this(name, Syntax.Function, args);
    }

    public UnresolvedFunCall(String name, Syntax syntax, Exp[] args) {
        assert (name != null);
        assert (syntax != null);
        assert (args != null);
        this.name = name;
        this.syntax = syntax;
        this.args = args;
        switch (syntax) {
            case Braces: {
                Util.assertTrue(name.equals("{}"));
                break;
            }
            case Parentheses: {
                Util.assertTrue(name.equals("()"));
                break;
            }
            case Internal: {
                Util.assertTrue(name.startsWith("$"));
                break;
            }
            case Empty: {
                Util.assertTrue(name.equals(""));
                break;
            }
            default: {
                Util.assertTrue(!name.startsWith("$") && !name.equals("{}") && !name.equals("()"));
            }
        }
    }

    @Override
    public UnresolvedFunCall clone() {
        return new UnresolvedFunCall(this.name, this.syntax, ExpBase.cloneArray(this.args));
    }

    @Override
    public int getCategory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unparse(PrintWriter pw) {
        this.syntax.unparse(this.name, this.args, pw);
    }

    @Override
    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        if (visitor.shouldVisitChildren()) {
            Exp[] expArray = this.args;
            int n = this.args.length;
            int n2 = 0;
            while (n2 < n) {
                Exp arg = expArray[n2];
                arg.accept(visitor);
                ++n2;
            }
        }
        return o;
    }

    @Override
    public Exp accept(Validator validator) {
        Exp[] newArgs = new Exp[this.args.length];
        FunDef funDef = FunUtil.resolveFunArgs(validator, null, this.args, newArgs, this.name, this.syntax);
        return funDef.createCall(validator, newArgs);
    }

    @Override
    public Calc accept(ExpCompiler compiler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFunName() {
        return this.name;
    }

    @Override
    public Syntax getSyntax() {
        return this.syntax;
    }

    @Override
    public Exp getArg(int index) {
        return this.args[index];
    }

    @Override
    public Exp[] getArgs() {
        return this.args;
    }

    @Override
    public final int getArgCount() {
        return this.args.length;
    }

    @Override
    public Object[] getChildren() {
        return this.args;
    }
}

