/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.List;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.LevelType;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class CubeBase
extends OlapElementBase
implements Cube {
    public static final int CATALOG_NAME = 0;
    public static final int SCHEMA_NAME = 1;
    public static final int CUBE_NAME = 2;
    public static final int DIMENSION_UNIQUE_NAME = 3;
    public static final int HIERARCHY_UNIQUE_NAME = 4;
    public static final int LEVEL_UNIQUE_NAME = 5;
    public static final int LEVEL_NUMBER = 6;
    public static final int MEMBER_NAME = 7;
    public static final int MEMBER_UNIQUE_NAME = 8;
    public static final int MEMBER_CAPTION = 9;
    public static final int MEMBER_TYPE = 10;
    public static final int Tree_Operator = 11;
    public static final int maxNofConstraintsForAdSchemaMember = 12;
    public static final int MDTREEOP_SELF = 0;
    public static final int MDTREEOP_CHILDREN = 1;
    public static final int MDPROP_USERDEFINED0 = 19;
    protected final String name;
    private final String uniqueName;
    private final String description;
    protected Dimension[] dimensions;

    protected CubeBase(String name, String caption, boolean visible, String description, Dimension[] dimensions) {
        this.name = name;
        this.caption = caption;
        this.visible = visible;
        this.description = description;
        this.dimensions = dimensions;
        this.uniqueName = Util.quoteMdxIdentifier(name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getQualifiedName() {
        return MondrianResource.instance().MdxCubeName.str(this.getName());
    }

    @Override
    public Dimension getDimension() {
        return null;
    }

    @Override
    public Hierarchy getHierarchy() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Dimension[] getDimensions() {
        return this.dimensions;
    }

    @Override
    public Hierarchy lookupHierarchy(Id.NameSegment s, boolean unique) {
        Dimension[] dimensionArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            Hierarchy[] hierarchies;
            Dimension dimension = dimensionArray[n2];
            Hierarchy[] hierarchyArray = hierarchies = dimension.getHierarchies();
            int n3 = hierarchies.length;
            int n4 = 0;
            while (n4 < n3) {
                String name;
                Hierarchy hierarchy = hierarchyArray[n4];
                String string = name = unique ? hierarchy.getUniqueName() : hierarchy.getName();
                if (name.equals(s.getName())) {
                    return hierarchy;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        Dimension mdxDimension = this.lookupDimension(s);
        if (mdxDimension != null) {
            return mdxDimension;
        }
        List<Dimension> dimensions = schemaReader.getCubeDimensions(this);
        if (MondrianProperties.instance().SsasCompatibleNaming.get() && s instanceof Id.NameSegment && ((Id.NameSegment)s).name.contains(".")) {
            for (Dimension dimension : dimensions) {
                if (!((Id.NameSegment)s).name.startsWith(dimension.getName())) continue;
                for (Hierarchy hierarchy : schemaReader.getDimensionHierarchies(dimension)) {
                    if (!Util.equalName(((Id.NameSegment)s).name, String.valueOf(dimension.getName()) + "." + hierarchy.getName())) continue;
                    return hierarchy;
                }
            }
        }
        for (Dimension dimension : dimensions) {
            OlapElement mdxElement = dimension.lookupChild(schemaReader, s, matchType);
            if (mdxElement == null || mdxElement instanceof Member && MondrianProperties.instance().NeedDimensionPrefix.get()) continue;
            return mdxElement;
        }
        return null;
    }

    public Dimension lookupDimension(Id.Segment s) {
        if (!(s instanceof Id.NameSegment)) {
            return null;
        }
        Id.NameSegment nameSegment = (Id.NameSegment)s;
        Dimension[] dimensionArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension dimension = dimensionArray[n2];
            if (Util.equalName(dimension.getName(), nameSegment.name)) {
                return dimension;
            }
            ++n2;
        }
        return null;
    }

    private Level getTimeLevel(LevelType levelType) {
        Dimension[] dimensionArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            Dimension dimension = dimensionArray[n2];
            if (dimension.getDimensionType() == DimensionType.TimeDimension) {
                Hierarchy[] hierarchies;
                Hierarchy[] hierarchyArray = hierarchies = dimension.getHierarchies();
                int n3 = hierarchies.length;
                int n4 = 0;
                while (n4 < n3) {
                    Level[] levels;
                    Hierarchy hierarchy = hierarchyArray[n4];
                    Level[] levelArray = levels = hierarchy.getLevels();
                    int n5 = levels.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        Level level = levelArray[n6];
                        if (level.getLevelType() == levelType) {
                            return level;
                        }
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Level getYearLevel() {
        return this.getTimeLevel(LevelType.TimeYears);
    }

    @Override
    public Level getQuarterLevel() {
        return this.getTimeLevel(LevelType.TimeQuarters);
    }

    @Override
    public Level getMonthLevel() {
        return this.getTimeLevel(LevelType.TimeMonths);
    }

    @Override
    public Level getWeekLevel() {
        return this.getTimeLevel(LevelType.TimeWeeks);
    }
}

