/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;

public class EnumeratedValues<V extends Value>
implements Cloneable {
    private Map<String, V> valuesByName = new LinkedHashMap<String, V>();
    private int min = Integer.MAX_VALUE;
    private int max = Integer.MIN_VALUE;
    private Value[] ordinalToValueMap;
    private static final String[] emptyStringArray = new String[0];

    public EnumeratedValues() {
    }

    public EnumeratedValues(V[] values) {
        V[] VArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            V value = VArray[n2];
            this.register(value);
            ++n2;
        }
        this.makeImmutable();
    }

    public EnumeratedValues(String[] names) {
        int i = 0;
        while (i < names.length) {
            this.register(new BasicValue(names[i], i, names[i]));
            ++i;
        }
        this.makeImmutable();
    }

    public EnumeratedValues(String[] names, int[] codes) {
        int i = 0;
        while (i < names.length) {
            this.register(new BasicValue(names[i], codes[i], names[i]));
            ++i;
        }
        this.makeImmutable();
    }

    public EnumeratedValues(String[] names, int[] codes, String[] descriptions) {
        int i = 0;
        while (i < names.length) {
            this.register(new BasicValue(names[i], codes[i], descriptions[i]));
            ++i;
        }
        this.makeImmutable();
    }

    public EnumeratedValues(Class<? extends Enum> clazz) {
        throw new UnsupportedOperationException();
    }

    public EnumeratedValues<V> clone() {
        EnumeratedValues clone;
        try {
            clone = (EnumeratedValues)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw Util.newInternal(ex, "error while cloning " + this);
        }
        clone.valuesByName = new HashMap<String, V>(this.valuesByName);
        clone.ordinalToValueMap = null;
        return clone;
    }

    public EnumeratedValues getMutableClone() {
        return this.clone();
    }

    public void register(V value) {
        assert (value != null) : "pre: value != null";
        Util.assertPrecondition(!this.isImmutable(), "isImmutable()");
        String name = value.getName();
        Util.assertPrecondition(name != null, "value.getName() != null");
        Value old = (Value)this.valuesByName.put(name, value);
        if (old != null) {
            throw Util.newInternal("Enumeration already contained a value '" + old.getName() + "'");
        }
        int ordinal = value.getOrdinal();
        this.min = Math.min(this.min, ordinal);
        this.max = Math.max(this.max, ordinal);
    }

    public void makeImmutable() {
        this.ordinalToValueMap = new Value[1 + this.max - this.min];
        for (Value value : this.valuesByName.values()) {
            int index = value.getOrdinal() - this.min;
            if (this.ordinalToValueMap[index] != null) {
                throw Util.newInternal("Enumeration has more than one value with ordinal " + value.getOrdinal());
            }
            this.ordinalToValueMap[index] = value;
        }
    }

    public final boolean isImmutable() {
        return this.ordinalToValueMap != null;
    }

    public final int getMin() {
        return this.min;
    }

    public final int getMax() {
        return this.max;
    }

    public final boolean isValid(int ordinal) {
        if (ordinal < this.min || ordinal > this.max) {
            return false;
        }
        return this.getName(ordinal) != null;
    }

    public final V getValue(int ordinal) {
        Util.assertPrecondition(this.isImmutable());
        return (V)this.ordinalToValueMap[ordinal - this.min];
    }

    public final String getName(int ordinal) {
        Util.assertPrecondition(this.isImmutable());
        Value value = this.ordinalToValueMap[ordinal - this.min];
        return value == null ? null : value.getName();
    }

    public final String getDescription(int ordinal) {
        Util.assertPrecondition(this.isImmutable());
        Value value = this.ordinalToValueMap[ordinal - this.min];
        return value == null ? null : value.getDescription();
    }

    public final int getOrdinal(String name) {
        return this.getValue(name, true).getOrdinal();
    }

    public V getValue(String name, boolean fail) {
        Value value = (Value)this.valuesByName.get(name);
        if (value == null && fail) {
            throw new Error("Unknown enum name:  " + name);
        }
        return (V)value;
    }

    public String[] getNames() {
        return this.valuesByName.keySet().toArray(emptyStringArray);
    }

    public List<V> getValuesSortedByName() {
        ArrayList<V> list = new ArrayList<V>();
        Object[] names = this.getNames();
        Arrays.sort(names);
        Object[] objectArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            Object name = objectArray[n2];
            list.add(this.getValue((String)name, true));
            ++n2;
        }
        return list;
    }

    public RuntimeException badValue(int ordinal) {
        return Util.newInternal("bad value " + ordinal + "(" + this.getName(ordinal) + ") for enumeration '" + this.getClass().getName() + "'");
    }

    public RuntimeException unexpected(V value) {
        return Util.newInternal("Was not expecting value '" + value + "' for enumeration '" + this.getClass().getName() + "' in this context");
    }

    public static class BasicValue
    implements Value {
        public final String name;
        public final int ordinal;
        public final String description;

        public BasicValue(String name, int ordinal, String description) {
            Util.assertPrecondition(name != null, "name != null");
            this.name = name;
            this.ordinal = ordinal;
            this.description = description;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getOrdinal() {
            return this.ordinal;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(String s) {
            return super.equals(s);
        }

        public RuntimeException unexpected() {
            return Util.newInternal("Value " + this.name + " of class " + this.getClass() + " unexpected here");
        }
    }

    public static interface Value {
        public String getName();

        public int getOrdinal();

        public String getDescription();
    }
}

