/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ResultStyle;
import mondrian.calc.impl.BetterExpCompiler;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;

public class ExpCacheDescriptor {
    private final Exp exp;
    private int[] dependentHierarchyOrdinals;
    private final Calc calc;

    public ExpCacheDescriptor(Exp exp, Calc calc, Evaluator evaluator) {
        this.calc = calc;
        this.exp = exp;
        this.computeDepends(calc, evaluator);
    }

    public ExpCacheDescriptor(Exp exp, Evaluator evaluator) {
        this(exp, new BetterExpCompiler(evaluator, null));
    }

    public ExpCacheDescriptor(Exp exp, ExpCompiler compiler) {
        this.exp = exp;
        Calc calc = compiler.compile(exp);
        if (calc == null) {
            calc = compiler.compileAs(exp, null, ResultStyle.ANY_ONLY);
        }
        this.calc = calc;
        this.computeDepends(calc, compiler.getEvaluator());
    }

    private void computeDepends(Calc calc, Evaluator evaluator) {
        ArrayList<Integer> ordinalList = new ArrayList<Integer>();
        Member[] members = evaluator.getMembers();
        int i = 0;
        while (i < members.length) {
            Hierarchy hierarchy = members[i].getHierarchy();
            if (calc.dependsOn(hierarchy)) {
                ordinalList.add(i);
            }
            ++i;
        }
        this.dependentHierarchyOrdinals = new int[ordinalList.size()];
        i = 0;
        while (i < this.dependentHierarchyOrdinals.length) {
            this.dependentHierarchyOrdinals[i] = (Integer)ordinalList.get(i);
            ++i;
        }
    }

    public Exp getExp() {
        return this.exp;
    }

    public Calc getCalc() {
        return this.calc;
    }

    public Object evaluate(Evaluator evaluator) {
        return this.calc.evaluate(evaluator);
    }

    public int[] getDependentHierarchyOrdinals() {
        return this.dependentHierarchyOrdinals;
    }
}

