/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mondrian.mdx.MdxVisitor;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Annotation;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.FunCall;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.MemberProperty;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.QueryPart;
import mondrian.olap.SchemaReader;
import mondrian.olap.SetBase;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.DecimalType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCalculatedMember;

public class Formula
extends QueryPart {
    private final Id id;
    private Exp exp;
    private final MemberProperty[] memberProperties;
    private final boolean isMember;
    private Member mdxMember;
    private NamedSet mdxSet;

    public Formula(Id id, Exp exp) {
        this(false, id, exp, new MemberProperty[0], null, null);
        this.createElement(null);
    }

    public Formula(Id id, Exp exp, MemberProperty[] memberProperties) {
        this(true, id, exp, memberProperties, null, null);
    }

    Formula(boolean isMember, Id id, Exp exp, MemberProperty[] memberProperties, Member mdxMember, NamedSet mdxSet) {
        this.isMember = isMember;
        this.id = id;
        this.exp = exp;
        this.memberProperties = memberProperties;
        this.mdxMember = mdxMember;
        this.mdxSet = mdxSet;
        assert (isMember || mdxMember == null);
        assert (!isMember || mdxSet == null);
    }

    public Object clone() {
        return new Formula(this.isMember, this.id, this.exp.clone(), MemberProperty.cloneArray(this.memberProperties), this.mdxMember, this.mdxSet);
    }

    static Formula[] cloneArray(Formula[] x) {
        Formula[] x2 = new Formula[x.length];
        int i = 0;
        while (i < x.length) {
            x2[i] = (Formula)x[i].clone();
            ++i;
        }
        return x2;
    }

    void accept(Validator validator) {
        boolean scalar = this.isMember;
        this.exp = validator.validate(this.exp, scalar);
        String id = this.id.toString();
        Type type = this.exp.getType();
        if (this.isMember) {
            if (!TypeUtil.canEvaluate(type)) {
                throw MondrianResource.instance().MdxMemberExpIsSet.ex(this.exp.toString());
            }
        } else if (!TypeUtil.isSet(type)) {
            throw MondrianResource.instance().MdxSetExpNotSet.ex(id);
        }
        MemberProperty[] memberPropertyArray = this.memberProperties;
        int n = this.memberProperties.length;
        int n2 = 0;
        while (n2 < n) {
            MemberProperty memberProperty = memberPropertyArray[n2];
            validator.validate(memberProperty);
            ++n2;
        }
        if (this.isMember) {
            Exp formatExp = this.getFormatExp(validator);
            if (formatExp != null) {
                this.mdxMember.setProperty(Property.FORMAT_EXP_PARSED.name, formatExp);
                this.mdxMember.setProperty(Property.FORMAT_EXP.name, Util.unparse(formatExp));
            }
            ArrayList<MemberProperty> memberPropertyList = new ArrayList<MemberProperty>(Arrays.asList(this.memberProperties));
            int i = 0;
            while (i < memberPropertyList.size()) {
                MemberProperty memberProperty = (MemberProperty)memberPropertyList.get(i);
                if (memberProperty.getName().equals(Property.CELL_FORMATTER_SCRIPT_LANGUAGE.name)) {
                    memberPropertyList.remove(i);
                    memberPropertyList.add(0, memberProperty);
                }
                ++i;
            }
            for (MemberProperty memberProperty : memberPropertyList) {
                Exp exp;
                if (Property.FORMAT_PROPERTIES.contains(memberProperty.getName()) || !((exp = memberProperty.getExp()) instanceof Literal)) continue;
                String value = String.valueOf(((Literal)exp).getValue());
                this.mdxMember.setProperty(memberProperty.getName(), value);
            }
        }
    }

    void createElement(Query q) {
        List<Id.Segment> segments = this.id.getSegments();
        if (this.isMember) {
            if (this.mdxMember != null) {
                return;
            }
            OlapElement mdxElement = q.getCube();
            SchemaReader schemaReader = q.getSchemaReader(false);
            int i = 0;
            while (i < segments.size()) {
                Id.Segment segment0 = segments.get(i);
                if (!(segment0 instanceof Id.NameSegment)) {
                    throw Util.newError("Calculated member name must not contain member keys");
                }
                Id.NameSegment segment = (Id.NameSegment)segment0;
                Cube parent = mdxElement;
                mdxElement = null;
                if (i != segments.size() - 1) {
                    mdxElement = schemaReader.getElementChild(parent, segment);
                }
                if (mdxElement == null || i == segments.size() - 1) {
                    Level level;
                    Member parentMember = null;
                    if (parent instanceof Member) {
                        parentMember = (Member)((Object)parent);
                        level = parentMember.getLevel().getChildLevel();
                        if (level == null) {
                            throw Util.newError("The '" + segment + "' calculated member cannot be created " + "because its parent is at the lowest level " + "in the " + parentMember.getHierarchy().getUniqueName() + " hierarchy.");
                        }
                    } else {
                        Dimension dimension;
                        Hierarchy hierarchy = parent instanceof Dimension && MondrianProperties.instance().SsasCompatibleNaming.get() ? ((dimension = (Dimension)((Object)parent)).getHierarchies().length == 1 ? dimension.getHierarchies()[0] : null) : parent.getHierarchy();
                        if (hierarchy == null) {
                            throw MondrianResource.instance().MdxCalculatedHierarchyError.ex(this.id.toString());
                        }
                        level = hierarchy.getLevels()[0];
                    }
                    if (parentMember != null && parentMember.isCalculated()) {
                        throw Util.newError("The '" + parent + "' calculated member cannot be used as a parent" + " of another calculated member.");
                    }
                    Member mdxMember = level.getHierarchy().createMember(parentMember, level, segment.getName(), this);
                    assert (mdxMember != null);
                    mdxElement = mdxMember;
                }
                ++i;
            }
            this.mdxMember = (Member)mdxElement;
        } else {
            Util.assertTrue(segments.size() == 1, "set names must not be compound");
            Id.Segment segment0 = segments.get(0);
            if (!(segment0 instanceof Id.NameSegment)) {
                throw Util.newError("Calculated member name must not contain member keys");
            }
            this.mdxSet = new SetBase(((Id.NameSegment)segment0).getName(), null, null, this.exp, false, Collections.<String, Annotation>emptyMap());
        }
    }

    @Override
    public Object[] getChildren() {
        Object[] children = new Object[1 + this.memberProperties.length];
        children[0] = this.exp;
        System.arraycopy(this.memberProperties, 0, children, 1, this.memberProperties.length);
        return children;
    }

    @Override
    public void unparse(PrintWriter pw) {
        if (this.isMember) {
            pw.print("member ");
            if (this.mdxMember != null) {
                pw.print(this.mdxMember.getUniqueName());
            } else {
                this.id.unparse(pw);
            }
        } else {
            pw.print("set ");
            this.id.unparse(pw);
        }
        pw.print(" as '");
        this.exp.unparse(pw);
        pw.print("'");
        if (this.memberProperties != null) {
            MemberProperty[] memberPropertyArray = this.memberProperties;
            int n = this.memberProperties.length;
            int n2 = 0;
            while (n2 < n) {
                MemberProperty memberProperty = memberPropertyArray[n2];
                pw.print(", ");
                memberProperty.unparse(pw);
                ++n2;
            }
        }
    }

    public boolean isMember() {
        return this.isMember;
    }

    public NamedSet getNamedSet() {
        return this.mdxSet;
    }

    public Id getIdentifier() {
        return this.id;
    }

    public String getName() {
        return this.isMember ? this.mdxMember.getName() : this.mdxSet.getName();
    }

    public String getCaption() {
        return this.isMember ? this.mdxMember.getCaption() : this.mdxSet.getName();
    }

    void rename(String newName) {
        String oldName = this.getElement().getName();
        List<Id.Segment> segments = this.id.getSegments();
        assert (Util.last(segments) instanceof Id.NameSegment);
        assert (((Id.NameSegment)Util.last(segments)).name.equalsIgnoreCase(oldName));
        segments.set(segments.size() - 1, new Id.NameSegment(newName));
        if (this.isMember) {
            this.mdxMember.setName(newName);
        } else {
            this.mdxSet.setName(newName);
        }
    }

    String getUniqueName() {
        return this.isMember ? this.mdxMember.getUniqueName() : this.mdxSet.getUniqueName();
    }

    OlapElement getElement() {
        return this.isMember ? this.mdxMember : this.mdxSet;
    }

    public Exp getExpression() {
        return this.exp;
    }

    private Exp getMemberProperty(String name) {
        return MemberProperty.get(this.memberProperties, name);
    }

    public Member getMdxMember() {
        return this.mdxMember;
    }

    public Number getSolveOrder() {
        return this.getIntegerMemberProperty(Property.SOLVE_ORDER.name);
    }

    private Number getIntegerMemberProperty(String name) {
        Exp exp = this.getMemberProperty(name);
        if (exp != null && exp.getType() instanceof NumericType) {
            return Formula.quickEval(exp);
        }
        return null;
    }

    private static Number quickEval(Exp exp) {
        FunCall call;
        if (exp instanceof Literal) {
            Literal literal = (Literal)exp;
            Object value = literal.getValue();
            if (value instanceof Number) {
                return (Number)value;
            }
            return null;
        }
        if (exp instanceof FunCall && (call = (FunCall)exp).getFunName().equals("-") && call.getSyntax() == Syntax.Prefix) {
            Number number = Formula.quickEval(call.getArg(0));
            if (number == null) {
                return null;
            }
            if (number instanceof Integer) {
                return -number.intValue();
            }
            return -number.doubleValue();
        }
        return null;
    }

    private Exp getFormatExp(Validator validator) {
        for (String prop : Property.FORMAT_PROPERTIES) {
            Exp formatExp = this.getMemberProperty(prop);
            if (formatExp == null) continue;
            return formatExp;
        }
        Type type = this.exp.getType();
        if (type instanceof DecimalType) {
            int scale = ((DecimalType)type).getScale();
            String formatString = "#,##0";
            if (scale > 0) {
                formatString = String.valueOf(formatString) + ".";
                while (scale-- > 0) {
                    formatString = String.valueOf(formatString) + "0";
                }
            }
            return Literal.createString(formatString);
        }
        if (!this.mdxMember.isMeasure()) {
            return null;
        }
        try {
            this.exp.accept(new FormatFinder(validator));
            return null;
        }
        catch (FoundOne foundOne) {
            return foundOne.exp;
        }
    }

    public void compile() {
    }

    public Object accept(MdxVisitor visitor) {
        Object o = visitor.visit(this);
        if (visitor.shouldVisitChildren()) {
            this.exp.accept(visitor);
        }
        return o;
    }

    private static class FormatFinder
    extends MdxVisitorImpl {
        private final Validator validator;

        public FormatFinder(Validator validator) {
            this.validator = validator;
        }

        @Override
        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            this.returnFormula(member);
            if (member.isCalculated() && member instanceof RolapCalculatedMember && !this.hasCyclicReference(memberExpr)) {
                Formula formula = ((RolapCalculatedMember)member).getFormula();
                formula.accept(this.validator);
                this.returnFormula(member);
            }
            return super.visit(memberExpr);
        }

        private boolean hasCyclicReference(Exp expr) {
            ArrayList<MemberExpr> expList = new ArrayList<MemberExpr>();
            return this.hasCyclicReference(expr, expList);
        }

        private boolean hasCyclicReference(Exp expr, List<MemberExpr> expList) {
            if (expr instanceof MemberExpr) {
                MemberExpr memberExpr = (MemberExpr)expr;
                if (expList.contains(expr)) {
                    return true;
                }
                expList.add(memberExpr);
                Member member = memberExpr.getMember();
                if (member instanceof RolapCalculatedMember) {
                    RolapCalculatedMember calculatedMember = (RolapCalculatedMember)member;
                    Exp exp1 = calculatedMember.getExpression().accept(this.validator);
                    return this.hasCyclicReference(exp1, expList);
                }
            }
            if (expr instanceof FunCall) {
                FunCall funCall = (FunCall)expr;
                Exp[] exps = funCall.getArgs();
                int i = 0;
                while (i < exps.length) {
                    if (this.hasCyclicReference(exps[i], this.cloneForEachBranch(expList))) {
                        return true;
                    }
                    ++i;
                }
            }
            return false;
        }

        private List<MemberExpr> cloneForEachBranch(List<MemberExpr> expList) {
            ArrayList<MemberExpr> list = new ArrayList<MemberExpr>();
            list.addAll(expList);
            return list;
        }

        private void returnFormula(Member member) {
            if (this.getFormula(member) != null) {
                throw new FoundOne(this.getFormula(member));
            }
        }

        private Exp getFormula(Member member) {
            return (Exp)member.getPropertyValue(Property.FORMAT_EXP_PARSED.name);
        }
    }

    private static class FoundOne
    extends RuntimeException {
        private final Exp exp;

        public FoundOne(Exp exp) {
            this.exp = exp;
        }
    }
}

