/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Literal;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.Type;
import org.olap4j.impl.UnmodifiableArrayList;

public class Id
extends ExpBase
implements Cloneable {
    private final List<Segment> segments;

    public Id(Segment segment) {
        this.segments = Collections.singletonList(segment);
    }

    public Id(List<Segment> segments) {
        this.segments = segments;
        if (segments.size() <= 0) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Id clone() {
        return this;
    }

    @Override
    public int getCategory() {
        return 0;
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        Util.quoteMdxIdentifier(this.segments, buf);
        return buf.toString();
    }

    public String[] toStringArray() {
        String[] names = new String[this.segments.size()];
        int k = 0;
        for (Segment segment : this.segments) {
            names[k++] = ((NameSegment)segment).getName();
        }
        return names;
    }

    public List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public Segment getElement(int i) {
        return this.segments.get(i);
    }

    public Id append(Segment segment) {
        ArrayList<Segment> newSegments = new ArrayList<Segment>(this.segments);
        newSegments.add(segment);
        return new Id(newSegments);
    }

    @Override
    public Exp accept(Validator validator) {
        Exp element;
        if (this.segments.size() == 1) {
            Segment s = this.segments.get(0);
            if (s.quoting == Quoting.UNQUOTED) {
                NameSegment nameSegment = (NameSegment)s;
                if (validator.getFunTable().isReserved(nameSegment.getName())) {
                    return Literal.createSymbol(nameSegment.getName().toUpperCase());
                }
            }
        }
        if ((element = Util.lookup(validator.getQuery(), validator.getSchemaReader().withLocus(), this.segments, true)) == null) {
            return null;
        }
        return element.accept(validator);
    }

    @Override
    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }

    @Override
    public void unparse(PrintWriter pw) {
        pw.print(this.toString());
    }

    public static class KeySegment
    extends Segment {
        public final List<NameSegment> subSegmentList;

        public KeySegment(NameSegment ... subSegments) {
            super(Quoting.KEY);
            if (subSegments.length < 1) {
                throw new IllegalArgumentException();
            }
            this.subSegmentList = UnmodifiableArrayList.asCopyOf((Object[])subSegments);
        }

        public KeySegment(List<NameSegment> subSegmentList) {
            super(Quoting.KEY);
            if (subSegmentList.size() < 1) {
                throw new IllegalArgumentException();
            }
            this.subSegmentList = new UnmodifiableArrayList((Object[])subSegmentList.toArray(new NameSegment[subSegmentList.size()]));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof KeySegment)) {
                return false;
            }
            KeySegment that = (KeySegment)o;
            return this.subSegmentList.equals(that.subSegmentList);
        }

        public int hashCode() {
            return this.subSegmentList.hashCode();
        }

        @Override
        public void toString(StringBuilder buf) {
            for (NameSegment segment : this.subSegmentList) {
                buf.append('&');
                segment.toString(buf);
            }
        }

        @Override
        public List<NameSegment> getKeyParts() {
            return this.subSegmentList;
        }

        @Override
        public boolean matches(String name) {
            return false;
        }
    }

    public static class NameSegment
    extends Segment {
        public final String name;

        public NameSegment(String name, Quoting quoting) {
            super(quoting);
            this.name = name;
            if (name == null) {
                throw new NullPointerException();
            }
            if (quoting != Quoting.QUOTED && quoting != Quoting.UNQUOTED) {
                throw new IllegalArgumentException();
            }
        }

        public NameSegment(String name) {
            this(name, Quoting.QUOTED);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NameSegment)) {
                return false;
            }
            NameSegment that = (NameSegment)o;
            return that.name.equals(this.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String getName() {
            return this.name;
        }

        @Override
        public List<NameSegment> getKeyParts() {
            return null;
        }

        @Override
        public void toString(StringBuilder buf) {
            switch (this.quoting) {
                case UNQUOTED: {
                    buf.append(this.name);
                    return;
                }
                case QUOTED: {
                    Util.quoteMdxIdentifier(this.name, buf);
                    return;
                }
            }
            throw Util.unexpected(this.quoting);
        }

        @Override
        public boolean matches(String name) {
            switch (this.quoting) {
                case UNQUOTED: {
                    return Util.equalName(this.name, name);
                }
                case QUOTED: {
                    return Util.equalName(this.name, name);
                }
            }
            return false;
        }
    }

    public static enum Quoting {
        UNQUOTED,
        QUOTED,
        KEY;

    }

    public static abstract class Segment {
        public final Quoting quoting;

        protected Segment(Quoting quoting) {
            this.quoting = quoting;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toString(buf);
            return buf.toString();
        }

        public Quoting getQuoting() {
            return this.quoting;
        }

        public abstract List<NameSegment> getKeyParts();

        public static List<Segment> toList(String ... nameParts) {
            ArrayList<Segment> segments = new ArrayList<Segment>(nameParts.length);
            String[] stringArray = nameParts;
            int n = nameParts.length;
            int n2 = 0;
            while (n2 < n) {
                String namePart = stringArray[n2];
                segments.add(new NameSegment(namePart));
                ++n2;
            }
            return segments;
        }

        public abstract boolean matches(String var1);

        public abstract void toString(StringBuilder var1);
    }
}

