/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.TriggerableProperties;

public abstract class MondrianPropertiesBase
extends TriggerableProperties {
    private final PropertySource propertySource;
    private int populateCount;
    private static final Logger LOGGER = Logger.getLogger(MondrianProperties.class);
    protected static final String mondrianDotProperties = "mondrian.properties";

    protected MondrianPropertiesBase(PropertySource propertySource) {
        this.propertySource = propertySource;
    }

    public boolean triggersAreEnabled() {
        return ((MondrianProperties)this).EnableTriggers.get();
    }

    public void populate() {
        this.loadIfStale(this.propertySource);
        URL url = null;
        File file = new File(mondrianDotProperties);
        if (file.exists() && file.isFile()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOGGER.warn((Object)("Mondrian: file '" + file.getAbsolutePath() + "' could not be loaded"), (Throwable)e);
            }
        } else {
            url = MondrianPropertiesBase.class.getClassLoader().getResource(mondrianDotProperties);
        }
        if (url != null) {
            this.load(new UrlPropertySource(url));
        } else {
            LOGGER.warn((Object)("mondrian.properties can't be found under '" + new File(".").getAbsolutePath() + "' or classloader"));
        }
        int count = 0;
        Enumeration<Object> keys = System.getProperties().keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String value = System.getProperty(key);
            if (!key.startsWith("mondrian.")) continue;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("populate: key=" + key + ", value=" + value));
            }
            super.setProperty(key, value);
            ++count;
        }
        if (this.populateCount++ == 0) {
            LOGGER.info((Object)("Mondrian: loaded " + count + " system properties"));
        }
    }

    private void loadIfStale(PropertySource source) {
        if (source.isStale()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Mondrian: loading " + source.getDescription()));
            }
            this.load(source);
        }
    }

    private void load(PropertySource source) {
        try {
            this.load(source.openStream());
            if (this.populateCount == 0) {
                LOGGER.info((Object)("Mondrian: properties loaded from '" + source.getDescription() + "'"));
            }
        }
        catch (IOException e) {
            LOGGER.error((Object)("Mondrian: error while loading properties from '" + source.getDescription() + "' (" + e + ")"));
        }
    }

    static class FilePropertySource
    implements PropertySource {
        private final File file;
        private long lastModified;

        FilePropertySource(File file) {
            this.file = file;
            this.lastModified = 0L;
        }

        @Override
        public InputStream openStream() {
            try {
                this.lastModified = this.file.lastModified();
                return new FileInputStream(this.file);
            }
            catch (FileNotFoundException e) {
                throw Util.newInternal(e, "Error while opening properties file '" + this.file + "'");
            }
        }

        @Override
        public boolean isStale() {
            return this.file.exists() && this.file.lastModified() > this.lastModified;
        }

        @Override
        public String getDescription() {
            return "file=" + this.file.getAbsolutePath() + " (exists=" + this.file.exists() + ")";
        }
    }

    public static interface PropertySource {
        public InputStream openStream();

        public boolean isStale();

        public String getDescription();
    }

    static class UrlPropertySource
    implements PropertySource {
        private final URL url;
        private long lastModified;

        UrlPropertySource(URL url) {
            this.url = url;
        }

        private URLConnection getConnection() {
            try {
                return this.url.openConnection();
            }
            catch (IOException e) {
                throw Util.newInternal(e, "Error while opening properties file '" + this.url + "'");
            }
        }

        @Override
        public InputStream openStream() {
            try {
                URLConnection connection = this.getConnection();
                this.lastModified = connection.getLastModified();
                return connection.getInputStream();
            }
            catch (IOException e) {
                throw Util.newInternal(e, "Error while opening properties file '" + this.url + "'");
            }
        }

        @Override
        public boolean isStale() {
            long lastModified = this.getConnection().getLastModified();
            return lastModified > this.lastModified;
        }

        @Override
        public String getDescription() {
            return this.url.toExternalForm();
        }
    }
}

