/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.Map;
import mondrian.olap.Annotation;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.MatchType;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.SchemaReader;
import mondrian.olap.Validator;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import org.apache.log4j.Logger;

public class SetBase
extends OlapElementBase
implements NamedSet {
    private static final Logger LOGGER = Logger.getLogger(SetBase.class);
    private String name;
    private Map<String, Annotation> annotationMap;
    private String description;
    private final String uniqueName;
    private Exp exp;
    private boolean validated;

    SetBase(String name, String caption, String description, Exp exp, boolean validated, Map<String, Annotation> annotationMap) {
        this.name = name;
        this.annotationMap = annotationMap;
        this.caption = caption;
        this.description = description;
        this.exp = exp;
        this.validated = validated;
        this.uniqueName = "[" + name + "]";
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return this.annotationMap;
    }

    @Override
    public String getNameUniqueWithinQuery() {
        return String.valueOf(System.identityHashCode(this));
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public Object clone() {
        return new SetBase(this.name, this.caption, this.description, this.exp.clone(), this.validated, this.annotationMap);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.exp.getType().getHierarchy();
    }

    @Override
    public Dimension getDimension() {
        return this.getHierarchy().getDimension();
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        return null;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAnnotationMap(Map<String, Annotation> annotationMap) {
        this.annotationMap = annotationMap;
    }

    @Override
    public Exp getExp() {
        return this.exp;
    }

    @Override
    public NamedSet validate(Validator validator) {
        if (!this.validated) {
            this.exp = validator.validate(this.exp, false);
            this.validated = true;
        }
        return this;
    }

    @Override
    public Type getType() {
        Type type = this.exp.getType();
        if (type instanceof MemberType || type instanceof TupleType) {
            type = new SetType(type);
        }
        return type;
    }
}

