/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import mondrian.olap.Category;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunCall;
import mondrian.olap.Util;

public class Syntax
extends Enum<Syntax> {
    public static final /* enum */ Syntax Function = new Syntax(){

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            ExpBase.unparseList(pw, args, String.valueOf(fun) + "(", ", ", ")");
        }
    };
    public static final /* enum */ Syntax Property = new Syntax(){

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(pw);
            pw.print(".");
            pw.print(fun);
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return String.valueOf(Syntax.getTypeDescription(argTypes[0])) + "." + name;
        }
    };
    public static final /* enum */ Syntax Method = new Syntax(){

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            Util.assertTrue(args.length >= 1);
            args[0].unparse(pw);
            pw.print(".");
            pw.print(fun);
            pw.print("(");
            int i = 1;
            while (i < args.length) {
                if (i > 1) {
                    pw.print(", ");
                }
                args[i].unparse(pw);
                ++i;
            }
            pw.print(")");
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return String.valueOf(returnType == 0 ? "" : String.valueOf(Syntax.getTypeDescription(returnType)) + " ") + Syntax.getTypeDescription(argTypes[0]) + "." + name + "(" + Syntax.getTypeDescriptionCommaList(argTypes, 1) + ")";
        }
    };
    public static final /* enum */ Syntax Infix = new Syntax(){

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(pw, args, "(", " " + fun + " ", ")");
            } else {
                ExpBase.unparseList(pw, args, "", " " + fun + " ", "");
            }
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return String.valueOf(Syntax.getTypeDescription(argTypes[0])) + " " + name + " " + Syntax.getTypeDescription(argTypes[1]);
        }
    };
    public static final /* enum */ Syntax Prefix = new Syntax(){

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(pw, args, "(" + fun + " ", null, ")");
            } else {
                ExpBase.unparseList(pw, args, String.valueOf(fun) + " ", null, "");
            }
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return String.valueOf(name) + " " + Syntax.getTypeDescription(argTypes[0]);
        }
    };
    public static final /* enum */ Syntax Postfix = new Syntax(){

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (Syntax.needParen(args)) {
                ExpBase.unparseList(pw, args, "(", null, " " + fun + ")");
            } else {
                ExpBase.unparseList(pw, args, "", null, " " + fun);
            }
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return String.valueOf(Syntax.getTypeDescription(argTypes[0])) + " " + name;
        }
    };
    public static final /* enum */ Syntax Braces = new Syntax(){

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return "{" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + "}";
        }

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            ExpBase.unparseList(pw, args, "{", ", ", "}");
        }
    };
    public static final /* enum */ Syntax Parentheses = new Syntax(){

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return "(" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + ")";
        }

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            ExpBase.unparseList(pw, args, "(", ", ", ")");
        }
    };
    public static final /* enum */ Syntax Case = new Syntax(){

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (fun.equals("_CaseTest")) {
                pw.print("CASE");
                int j = 0;
                int clauseCount = (args.length - j) / 2;
                int i = 0;
                while (i < clauseCount) {
                    pw.print(" WHEN ");
                    args[j++].unparse(pw);
                    pw.print(" THEN ");
                    args[j++].unparse(pw);
                    ++i;
                }
                if (j < args.length) {
                    pw.print(" ELSE ");
                    args[j++].unparse(pw);
                }
                Util.assertTrue(j == args.length);
                pw.print(" END");
            } else {
                Util.assertTrue(fun.equals("_CaseMatch"));
                pw.print("CASE ");
                int j = 0;
                args[j++].unparse(pw);
                int clauseCount = (args.length - j) / 2;
                int i = 0;
                while (i < clauseCount) {
                    pw.print(" WHEN ");
                    args[j++].unparse(pw);
                    pw.print(" THEN ");
                    args[j++].unparse(pw);
                    ++i;
                }
                if (j < args.length) {
                    pw.print(" ELSE ");
                    args[j++].unparse(pw);
                }
                Util.assertTrue(j == args.length);
                pw.print(" END");
            }
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            String s = Syntax.getTypeDescription(argTypes[0]);
            if (argTypes[0] == 5) {
                return "CASE WHEN " + s + " THEN <Expression> ... END";
            }
            return "CASE " + s + " WHEN " + s + " THEN <Expression> ... END";
        }
    };
    public static final /* enum */ Syntax Internal = new Syntax();
    public static final /* enum */ Syntax Cast = new Syntax(){

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            pw.print("CAST(");
            args[0].unparse(pw);
            pw.print(" AS ");
            args[1].unparse(pw);
            pw.print(")");
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return "CAST(<Expression> AS <Type>)";
        }
    };
    public static final /* enum */ Syntax QuotedProperty = new Syntax();
    public static final /* enum */ Syntax AmpersandQuotedProperty = new Syntax();
    public static final /* enum */ Syntax Empty = new Syntax(){

        @Override
        public void unparse(String fun, Exp[] args, PrintWriter pw) {
            if (!$assertionsDisabled && args.length != 0) {
                throw new AssertionError();
            }
        }

        @Override
        public String getSignature(String name, int returnType, int[] argTypes) {
            return "";
        }
    };
    private static final /* synthetic */ Syntax[] ENUM$VALUES;

    static {
        ENUM$VALUES = new Syntax[]{Function, Property, Method, Infix, Prefix, Postfix, Braces, Parentheses, Case, Internal, Cast, QuotedProperty, AmpersandQuotedProperty, Empty};
    }

    private Syntax() {
    }

    public void unparse(String fun, Exp[] args, PrintWriter pw) {
        throw new UnsupportedOperationException();
    }

    public String getSignature(String name, int returnType, int[] argTypes) {
        return String.valueOf(returnType == 0 ? "" : String.valueOf(Syntax.getTypeDescription(returnType)) + " ") + name + "(" + Syntax.getTypeDescriptionCommaList(argTypes, 0) + ")";
    }

    private static boolean needParen(Exp[] args) {
        return args.length != 1 || !(args[0] instanceof FunCall) || ((FunCall)args[0]).getSyntax() != Parentheses;
    }

    private static String getTypeDescription(int type) {
        return "<" + Category.instance.getDescription(type & 0x1F) + ">";
    }

    private static String getTypeDescriptionCommaList(int[] types, int start) {
        int initialSize = (types.length - start) * 16;
        StringBuilder sb = new StringBuilder(initialSize > 0 ? initialSize : 16);
        int i = start;
        while (i < types.length) {
            if (i > start) {
                sb.append(", ");
            }
            sb.append("<").append(Category.instance.getDescription(types[i] & 0x1F)).append(">");
            ++i;
        }
        return sb.toString();
    }

    public static Syntax[] values() {
        Syntax[] syntaxArray = ENUM$VALUES;
        int n = syntaxArray.length;
        Syntax[] syntaxArray2 = new Syntax[n];
        System.arraycopy(ENUM$VALUES, 0, syntaxArray2, 0, n);
        return syntaxArray2;
    }

    public static Syntax valueOf(String string) {
        return Enum.valueOf(Syntax.class, string);
    }

    /* synthetic */ Syntax(String string, int n, Syntax syntax) {
        this();
    }
}

