/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.DelegatingTupleList;
import mondrian.mdx.UnresolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapMember;

public class AbstractAggregateFunDef
extends FunDefBase {
    public AbstractAggregateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    protected Exp validateArg(Validator validator, Exp[] args, int i, int category) {
        Exp arg;
        if (i == 0 && MondrianProperties.instance().EnableExpCache.get() && FunUtil.worthCaching(arg = args[0])) {
            UnresolvedFunCall cacheCall = new UnresolvedFunCall("Cache", Syntax.Function, new Exp[]{arg});
            return validator.validate(cacheCall, false);
        }
        return super.validateArg(validator, args, i, category);
    }

    protected static TupleList evaluateCurrentList(ListCalc listCalc, Evaluator evaluator) {
        TupleList dims;
        TupleList tuples;
        int savepoint = evaluator.savepoint();
        try {
            evaluator.setNonEmpty(false);
            tuples = listCalc.evaluateList(evaluator);
        }
        finally {
            evaluator.restore(savepoint);
        }
        int currLen = tuples.size();
        try {
            dims = AbstractAggregateFunDef.processUnrelatedDimensions(tuples, evaluator);
        }
        finally {
            evaluator.restore(savepoint);
        }
        AbstractAggregateFunDef.crossProd(evaluator, currLen);
        return dims;
    }

    protected TupleIterable evaluateCurrentIterable(IterCalc iterCalc, Evaluator evaluator) {
        TupleIterable iterable;
        int savepoint = evaluator.savepoint();
        int currLen = 0;
        try {
            evaluator.setNonEmpty(false);
            iterable = iterCalc.evaluateIterable(evaluator);
        }
        finally {
            evaluator.restore(savepoint);
        }
        AbstractAggregateFunDef.crossProd(evaluator, currLen);
        return iterable;
    }

    private static void crossProd(Evaluator evaluator, int currLen) {
        long iterationLimit = MondrianProperties.instance().IterationLimit.get();
        int productLen = currLen * evaluator.getIterationLength();
        if (iterationLimit > 0L && (long)productLen > iterationLimit) {
            throw MondrianResource.instance().IterationLimitExceeded.ex(iterationLimit);
        }
        evaluator.setIterationLength(currLen);
    }

    private static TupleList processUnrelatedDimensions(TupleList tuplesForAggregation, Evaluator evaluator) {
        if (tuplesForAggregation.size() == 0) {
            return tuplesForAggregation;
        }
        RolapMember measure = (RolapMember)evaluator.getMembers()[0];
        if (measure.isCalculated()) {
            return tuplesForAggregation;
        }
        RolapCube virtualCube = (RolapCube)evaluator.getCube();
        RolapCube baseCube = (RolapCube)evaluator.getMeasureCube();
        if (virtualCube.isVirtual() && baseCube != null) {
            if (virtualCube.shouldIgnoreUnrelatedDimensions(baseCube.getName())) {
                return AbstractAggregateFunDef.ignoreUnrelatedDimensions(tuplesForAggregation, baseCube);
            }
            if (MondrianProperties.instance().IgnoreMeasureForNonJoiningDimension.get()) {
                return AbstractAggregateFunDef.ignoreMeasureForNonJoiningDimension(tuplesForAggregation, baseCube);
            }
        }
        return tuplesForAggregation;
    }

    private static TupleList ignoreMeasureForNonJoiningDimension(TupleList tuplesForAggregation, RolapCube baseCube) {
        Set<Dimension> nonJoiningDimensions = AbstractAggregateFunDef.nonJoiningDimensions(baseCube, tuplesForAggregation);
        if (nonJoiningDimensions.size() > 0) {
            return TupleCollections.emptyList(tuplesForAggregation.getArity());
        }
        return tuplesForAggregation;
    }

    private static TupleList ignoreUnrelatedDimensions(TupleList tuplesForAggregation, RolapCube baseCube) {
        Set<Dimension> nonJoiningDimensions = AbstractAggregateFunDef.nonJoiningDimensions(baseCube, tuplesForAggregation);
        LinkedHashSet processedTuples = new LinkedHashSet(tuplesForAggregation.size());
        Iterator iterator = tuplesForAggregation.iterator();
        while (iterator.hasNext()) {
            ArrayList<Member> tuple;
            ArrayList<Member> tupleCopy = tuple = (ArrayList<Member>)iterator.next();
            int j = 0;
            while (j < tuple.size()) {
                Member member = (Member)tuple.get(j);
                if (nonJoiningDimensions.contains(member.getDimension())) {
                    Hierarchy hierarchy;
                    if (tupleCopy == tuple) {
                        tupleCopy = new ArrayList<Member>(tuple);
                    }
                    if ((hierarchy = member.getDimension().getHierarchy()).hasAll()) {
                        tupleCopy.set(j, hierarchy.getAllMember());
                    } else {
                        tupleCopy.set(j, hierarchy.getDefaultMember());
                    }
                }
                ++j;
            }
            processedTuples.add(tupleCopy);
        }
        return new DelegatingTupleList(tuplesForAggregation.getArity(), new ArrayList<List<Member>>(processedTuples));
    }

    private static Set<Dimension> nonJoiningDimensions(RolapCube baseCube, TupleList tuplesForAggregation) {
        List tuple = (List)tuplesForAggregation.get(0);
        return baseCube.nonJoiningDimensions(tuple.toArray(new Member[tuple.size()]));
    }
}

