/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCursor;
import mondrian.calc.TupleIterator;
import mondrian.calc.TupleList;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Aggregator;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Property;
import mondrian.olap.Role;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapEvaluator;
import org.eigenbase.util.property.IntegerProperty;

public class AggregateFunDef
extends AbstractAggregateFunDef {
    private static final String TIMING_NAME = AggregateFunDef.class.getSimpleName();
    static final ReflectiveMultiResolver resolver = new ReflectiveMultiResolver("Aggregate", "Aggregate(<Set>[, <Numeric Expression>])", "Returns a calculated value using the appropriate aggregate function, based on the context of the query.", new String[]{"fnx", "fnxn"}, AggregateFunDef.class);

    public AggregateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc = compiler.compileList(call.getArg(0));
        ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        return new AggregateCalc(call, listCalc, calc);
    }

    public static class AggregateCalc
    extends GenericCalc {
        private final ListCalc listCalc;
        private final Calc calc;

        public AggregateCalc(Exp exp, ListCalc listCalc, Calc calc) {
            super(exp, new Calc[]{listCalc, calc});
            this.listCalc = listCalc;
            this.calc = calc;
        }

        @Override
        public Object evaluate(Evaluator evaluator) {
            evaluator.getTiming().markStart(TIMING_NAME);
            try {
                TupleList list = AggregateFunDef.evaluateCurrentList(this.listCalc, evaluator);
                Object object = AggregateCalc.aggregate(this.calc, evaluator, list);
                return object;
            }
            finally {
                evaluator.getTiming().markEnd(TIMING_NAME);
            }
        }

        public static Object aggregate(Calc calc, Evaluator evaluator, TupleList tupleList) {
            Object ob = evaluator.getProperty(Property.AGGREGATION_TYPE.name, null);
            Aggregator aggregator = (Aggregator)ob;
            if (aggregator == null) {
                throw AggregateFunDef.newEvalException(null, "Could not find an aggregator in the current evaluation context");
            }
            Aggregator rollup = aggregator.getRollup();
            if (rollup == null) {
                throw AggregateFunDef.newEvalException(null, "Don't know how to rollup aggregator '" + aggregator + "'");
            }
            if (aggregator != RolapAggregator.DistinctCount) {
                int savepoint = evaluator.savepoint();
                try {
                    Object o;
                    evaluator.setNonEmpty(false);
                    Object object = o = rollup.aggregate(evaluator, tupleList, calc);
                    return object;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }
            if (tupleList.size() == 0) {
                return 1.2345E-8;
            }
            if (!(evaluator instanceof RolapEvaluator) || !((RolapEvaluator)evaluator).getDialect().supportsUnlimitedValueList()) {
                tupleList = AggregateCalc.optimizeTupleList(evaluator, tupleList, true);
            }
            Evaluator evaluator2 = evaluator.pushAggregation(tupleList);
            evaluator2.setNonEmpty(false);
            return evaluator2.evaluateCurrent();
        }

        private static boolean canOptimize(Evaluator evaluator, TupleList tupleList) {
            for (List tupleMembers : tupleList) {
                for (Member member : tupleMembers) {
                    Role.RollupPolicy policy = evaluator.getSchemaReader().getRole().getAccessDetails(member.getHierarchy()).getRollupPolicy();
                    if (policy != Role.RollupPolicy.PARTIAL) continue;
                    return false;
                }
            }
            return true;
        }

        public static TupleList optimizeTupleList(Evaluator evaluator, TupleList tupleList, boolean checkSize) {
            if (!AggregateCalc.canOptimize(evaluator, tupleList)) {
                return tupleList;
            }
            tupleList = AggregateCalc.optimizeChildren(tupleList, evaluator.getSchemaReader(), evaluator.getMeasureCube());
            if (checkSize) {
                AggregateCalc.checkIfAggregationSizeIsTooLarge(tupleList);
            }
            return tupleList;
        }

        public static TupleList removeOverlappingTupleEntries(TupleList list) {
            TupleList trimmedList = list.cloneList(list.size());
            Member[] tuple1 = new Member[list.getArity()];
            Member[] tuple2 = new Member[list.getArity()];
            TupleCursor cursor1 = list.tupleCursor();
            while (cursor1.forward()) {
                cursor1.currentToArray(tuple1, 0);
                if (trimmedList.isEmpty()) {
                    trimmedList.addTuple(tuple1);
                    continue;
                }
                boolean ignore = false;
                TupleIterator iterator = trimmedList.tupleIterator();
                while (iterator.forward()) {
                    iterator.currentToArray(tuple2, 0);
                    if (AggregateCalc.isSuperSet(tuple1, tuple2)) {
                        iterator.remove();
                        continue;
                    }
                    if (!AggregateCalc.isSuperSet(tuple2, tuple1) && !AggregateCalc.isEqual(tuple1, tuple2)) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
                trimmedList.addTuple(tuple1);
            }
            return trimmedList;
        }

        public static boolean isSuperSet(Member[] tuple1, Member[] tuple2) {
            int parentLevelCount = 0;
            int i = 0;
            while (i < tuple1.length) {
                Member member2 = tuple2[i];
                Member member1 = tuple1[i];
                if (!member2.isChildOrEqualTo(member1)) {
                    return false;
                }
                if (member1.getLevel().getDepth() < member2.getLevel().getDepth()) {
                    ++parentLevelCount;
                }
                ++i;
            }
            return parentLevelCount > 0;
        }

        private static void checkIfAggregationSizeIsTooLarge(List list) {
            IntegerProperty property = MondrianProperties.instance().MaxConstraints;
            int maxConstraints = property.get();
            if (list.size() > maxConstraints) {
                throw AggregateFunDef.newEvalException(null, "Aggregation is not supported over a list with more than " + maxConstraints + " predicates" + " (see property " + property.getPath() + ")");
            }
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            if (hierarchy.getDimension().isMeasures()) {
                return true;
            }
            return AggregateCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }

        public static TupleList optimizeChildren(TupleList tuples, SchemaReader reader, Cube baseCubeForMeasure) {
            Map<Member, Integer>[] membersOccurencesInTuple = AggregateCalc.membersVersusOccurencesInTuple(tuples);
            int tupleLength = tuples.getArity();
            Set[] sets = new Set[tupleLength];
            boolean optimized = false;
            int i = 0;
            while (i < tupleLength) {
                if (AggregateFunDef.areOccurencesEqual(membersOccurencesInTuple[i].values())) {
                    Set<Member> members = membersOccurencesInTuple[i].keySet();
                    int originalSize = members.size();
                    sets[i] = AggregateCalc.optimizeMemberSet(new LinkedHashSet<Member>(members), reader, baseCubeForMeasure);
                    if (sets[i].size() != originalSize) {
                        optimized = true;
                    }
                } else {
                    sets[i] = new LinkedHashSet<Member>(membersOccurencesInTuple[i].keySet());
                }
                ++i;
            }
            if (optimized) {
                return AggregateCalc.crossProd(sets);
            }
            return tuples;
        }

        public static Map<Member, Integer>[] membersVersusOccurencesInTuple(TupleList tupleList) {
            int tupleLength = tupleList.getArity();
            Map[] counters = new Map[tupleLength];
            int i = 0;
            while (i < counters.length) {
                counters[i] = new LinkedHashMap();
                ++i;
            }
            for (List tuple : tupleList) {
                int i2 = 0;
                while (i2 < tuple.size()) {
                    Map map = counters[i2];
                    Member member = (Member)tuple.get(i2);
                    if (map.containsKey(member)) {
                        Integer count = (Integer)map.get(member);
                        count = count + 1;
                        map.put(member, count);
                    } else {
                        map.put(member, 1);
                    }
                    ++i2;
                }
            }
            return counters;
        }

        private static Set<Member> optimizeMemberSet(Set<Member> members, SchemaReader reader, Cube baseCubeForMeasure) {
            LinkedHashSet<Member> membersToBeOptimized = new LinkedHashSet<Member>();
            Set<Member> optimizedMembers = new LinkedHashSet<Member>();
            while (members.size() > 0) {
                boolean didOptimize;
                Iterator<Member> iterator = members.iterator();
                Member first = iterator.next();
                if (first.isAll()) {
                    optimizedMembers.clear();
                    optimizedMembers.add(first);
                    return optimizedMembers;
                }
                membersToBeOptimized.add(first);
                iterator.remove();
                Member firstParentMember = first.getParentMember();
                while (iterator.hasNext()) {
                    Member current = iterator.next();
                    if (current.isAll()) {
                        optimizedMembers.clear();
                        optimizedMembers.add(current);
                        return optimizedMembers;
                    }
                    Member currentParentMember = current.getParentMember();
                    if ((firstParentMember != null || currentParentMember != null) && (firstParentMember == null || !firstParentMember.equals(currentParentMember))) continue;
                    membersToBeOptimized.add(current);
                    iterator.remove();
                }
                int childCountOfParent = -1;
                if (firstParentMember != null) {
                    childCountOfParent = AggregateCalc.getChildCount(firstParentMember, reader);
                }
                if (childCountOfParent != -1 && membersToBeOptimized.size() == childCountOfParent && AggregateCalc.canOptimize(firstParentMember, baseCubeForMeasure)) {
                    optimizedMembers.add(firstParentMember);
                    didOptimize = true;
                } else {
                    optimizedMembers.addAll(membersToBeOptimized);
                    didOptimize = false;
                }
                membersToBeOptimized.clear();
                if (members.size() != 0 || !didOptimize) continue;
                Set<Member> temp = members;
                members = optimizedMembers;
                optimizedMembers = temp;
            }
            return optimizedMembers;
        }

        private static boolean isEqual(Member[] tuple1, Member[] tuple2) {
            int i = 0;
            while (i < tuple1.length) {
                if (!tuple1[i].getUniqueName().equals(tuple2[i].getUniqueName())) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        private static boolean canOptimize(Member parentMember, Cube baseCube) {
            return AggregateCalc.dimensionJoinsToBaseCube(parentMember.getDimension(), baseCube) || !parentMember.isAll();
        }

        private static TupleList crossProd(Set<Member>[] sets) {
            ArrayList<TupleList> tupleLists = new ArrayList<TupleList>();
            Set<Member>[] setArray = sets;
            int n = sets.length;
            int n2 = 0;
            while (n2 < n) {
                Set<Member> set = setArray[n2];
                tupleLists.add(new UnaryTupleList(new ArrayList<Member>(set)));
                ++n2;
            }
            if (tupleLists.size() == 1) {
                return (TupleList)tupleLists.get(0);
            }
            return CrossJoinFunDef.mutableCrossJoin(tupleLists);
        }

        private static boolean dimensionJoinsToBaseCube(Dimension dimension, Cube baseCube) {
            HashSet<Dimension> dimensions = new HashSet<Dimension>();
            dimensions.add(dimension);
            return baseCube.nonJoiningDimensions(dimensions).size() == 0;
        }

        private static int getChildCount(Member parentMember, SchemaReader reader) {
            int childrenCountFromCache = reader.getChildrenCountFromCache(parentMember);
            if (childrenCountFromCache != -1) {
                return childrenCountFromCache;
            }
            return reader.getMemberChildren(parentMember).size();
        }
    }
}

