/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.Type;

class AncestorFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Ancestor", "Ancestor(<Member>, {<Level>|<Numeric Expression>})", "Returns the ancestor of a member at a specified level.", new String[]{"fmml", "fmmn"}, AncestorFunDef.class);

    public AncestorFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
        Type type1 = call.getArg(1).getType();
        if (type1 instanceof LevelType) {
            final LevelCalc levelCalc = compiler.compileLevel(call.getArg(1));
            return new AbstractMemberCalc(call, new Calc[]{memberCalc, levelCalc}){

                @Override
                public Member evaluateMember(Evaluator evaluator) {
                    Level level = levelCalc.evaluateLevel(evaluator);
                    Member member = memberCalc.evaluateMember(evaluator);
                    int distance = member.getLevel().getDepth() - level.getDepth();
                    return AncestorFunDef.ancestor(evaluator, member, distance, level);
                }
            };
        }
        final IntegerCalc distanceCalc = compiler.compileInteger(call.getArg(1));
        return new AbstractMemberCalc(call, new Calc[]{memberCalc, distanceCalc}){

            @Override
            public Member evaluateMember(Evaluator evaluator) {
                int distance = distanceCalc.evaluateInteger(evaluator);
                Member member = memberCalc.evaluateMember(evaluator);
                return AncestorFunDef.ancestor(evaluator, member, distance, null);
            }
        };
    }
}

