/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.DimensionCalc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.HierarchyCalc;
import mondrian.calc.IntegerCalc;
import mondrian.calc.LevelCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractBooleanCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.calc.impl.AbstractLevelCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Aggregator;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.AddCalculatedMembersFunDef;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.AncestorFunDef;
import mondrian.olap.fun.AsFunDef;
import mondrian.olap.fun.AvgFunDef;
import mondrian.olap.fun.CacheFunDef;
import mondrian.olap.fun.CaseMatchFunDef;
import mondrian.olap.fun.CaseTestFunDef;
import mondrian.olap.fun.CastFunDef;
import mondrian.olap.fun.CoalesceEmptyFunDef;
import mondrian.olap.fun.CorrelationFunDef;
import mondrian.olap.fun.CountFunDef;
import mondrian.olap.fun.CovarianceFunDef;
import mondrian.olap.fun.CrossJoinFunDef;
import mondrian.olap.fun.DescendantsFunDef;
import mondrian.olap.fun.DimensionDimensionFunDef;
import mondrian.olap.fun.DimensionsNumericFunDef;
import mondrian.olap.fun.DimensionsStringFunDef;
import mondrian.olap.fun.DistinctFunDef;
import mondrian.olap.fun.DrilldownLevelFunDef;
import mondrian.olap.fun.DrilldownLevelTopBottomFunDef;
import mondrian.olap.fun.DrilldownMemberFunDef;
import mondrian.olap.fun.ExceptFunDef;
import mondrian.olap.fun.ExistsFunDef;
import mondrian.olap.fun.ExtractFunDef;
import mondrian.olap.fun.FilterFunDef;
import mondrian.olap.fun.FormatFunDef;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunInfo;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.GenerateFunDef;
import mondrian.olap.fun.HeadTailFunDef;
import mondrian.olap.fun.HierarchizeFunDef;
import mondrian.olap.fun.HierarchyCurrentMemberFunDef;
import mondrian.olap.fun.HierarchyDimensionFunDef;
import mondrian.olap.fun.IifFunDef;
import mondrian.olap.fun.IntersectFunDef;
import mondrian.olap.fun.IsEmptyFunDef;
import mondrian.olap.fun.IsFunDef;
import mondrian.olap.fun.IsNullFunDef;
import mondrian.olap.fun.JavaFunDef;
import mondrian.olap.fun.LastPeriodsFunDef;
import mondrian.olap.fun.LeadLagFunDef;
import mondrian.olap.fun.LevelDimensionFunDef;
import mondrian.olap.fun.LevelHierarchyFunDef;
import mondrian.olap.fun.LevelMembersFunDef;
import mondrian.olap.fun.LinReg;
import mondrian.olap.fun.MedianFunDef;
import mondrian.olap.fun.MemberDimensionFunDef;
import mondrian.olap.fun.MemberHierarchyFunDef;
import mondrian.olap.fun.MemberLevelFunDef;
import mondrian.olap.fun.MemberOrderKeyFunDef;
import mondrian.olap.fun.MinMaxFunDef;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.NamedSetCurrentFunDef;
import mondrian.olap.fun.NamedSetCurrentOrdinalFunDef;
import mondrian.olap.fun.NativizeSetFunDef;
import mondrian.olap.fun.NonEmptyCrossJoinFunDef;
import mondrian.olap.fun.OpeningClosingPeriodFunDef;
import mondrian.olap.fun.OrderFunDef;
import mondrian.olap.fun.ParallelPeriodFunDef;
import mondrian.olap.fun.ParameterFunDef;
import mondrian.olap.fun.PercentileFunDef;
import mondrian.olap.fun.PeriodsToDateFunDef;
import mondrian.olap.fun.PropertiesFunDef;
import mondrian.olap.fun.RangeFunDef;
import mondrian.olap.fun.RankFunDef;
import mondrian.olap.fun.SetFunDef;
import mondrian.olap.fun.SetItemFunDef;
import mondrian.olap.fun.SetToStrFunDef;
import mondrian.olap.fun.StdevFunDef;
import mondrian.olap.fun.StdevPFunDef;
import mondrian.olap.fun.StrToMemberFunDef;
import mondrian.olap.fun.StrToSetFunDef;
import mondrian.olap.fun.StrToTupleFunDef;
import mondrian.olap.fun.SubsetFunDef;
import mondrian.olap.fun.SumFunDef;
import mondrian.olap.fun.ToggleDrillStateFunDef;
import mondrian.olap.fun.TopBottomCountFunDef;
import mondrian.olap.fun.TopBottomPercentSumFunDef;
import mondrian.olap.fun.TupleFunDef;
import mondrian.olap.fun.TupleItemFunDef;
import mondrian.olap.fun.TupleToStrFunDef;
import mondrian.olap.fun.UnionFunDef;
import mondrian.olap.fun.UnorderFunDef;
import mondrian.olap.fun.ValidMeasureFunDef;
import mondrian.olap.fun.VarFunDef;
import mondrian.olap.fun.VarPFunDef;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.olap.fun.XtdFunDef;
import mondrian.olap.fun.extra.CalculatedChildFunDef;
import mondrian.olap.fun.extra.NthQuartileFunDef;
import mondrian.olap.fun.vba.Excel;
import mondrian.olap.fun.vba.Vba;
import mondrian.olap.type.LevelType;
import mondrian.olap.type.Type;

public class BuiltinFunTable
extends FunTableImpl {
    private static BuiltinFunTable instance;

    protected BuiltinFunTable() {
    }

    @Override
    public void defineFunctions(FunTable.Builder builder) {
        builder.defineReserved("NULL");
        builder.define(new FunDefBase("", "", "Dummy function representing the empty expression", Syntax.Empty, 17, new int[0]){});
        builder.define(HierarchyDimensionFunDef.instance);
        builder.define(DimensionDimensionFunDef.INSTANCE);
        builder.define(LevelDimensionFunDef.INSTANCE);
        builder.define(MemberDimensionFunDef.INSTANCE);
        builder.define(DimensionsNumericFunDef.INSTANCE);
        builder.define(DimensionsStringFunDef.INSTANCE);
        builder.define(LevelHierarchyFunDef.instance);
        builder.define(MemberHierarchyFunDef.instance);
        builder.define(MemberLevelFunDef.instance);
        builder.define(new FunDefBase("Levels", "Returns the level whose position in a hierarchy is specified by a numeric expression.", "mlhn"){

            @Override
            public Type getResultType(Validator validator, Exp[] args) {
                Type argType = args[0].getType();
                return LevelType.forType(argType);
            }

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                final IntegerCalc ordinalCalc = compiler.compileInteger(call.getArg(1));
                return new AbstractLevelCalc(call, new Calc[]{hierarchyCalc, ordinalCalc}){

                    @Override
                    public Level evaluateLevel(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        int ordinal = ordinalCalc.evaluateInteger(evaluator);
                        return this.nthLevel(hierarchy, ordinal);
                    }
                };
            }

            Level nthLevel(Hierarchy hierarchy, int n) {
                Level[] levels = hierarchy.getLevels();
                if (n >= levels.length || n < 0) {
                    throw 2.newEvalException(this, "Index '" + n + "' out of bounds");
                }
                return levels[n];
            }
        });
        builder.define(new FunDefBase("Levels", "Returns the level whose name is specified by a string expression.", "mlhS"){

            @Override
            public Type getResultType(Validator validator, Exp[] args) {
                Type argType = args[0].getType();
                return LevelType.forType(argType);
            }

            @Override
            public Calc compileCall(final ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                final StringCalc nameCalc = compiler.compileString(call.getArg(1));
                return new AbstractLevelCalc(call, new Calc[]{hierarchyCalc, nameCalc}){

                    @Override
                    public Level evaluateLevel(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        String name = nameCalc.evaluateString(evaluator);
                        Level[] levelArray = hierarchy.getLevels();
                        int n = levelArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Level level = levelArray[n2];
                            if (level.getName().equals(name)) {
                                return level;
                            }
                            ++n2;
                        }
                        throw 3.newEvalException(call.getFunDef(), "Level '" + name + "' not found in hierarchy '" + hierarchy + "'");
                    }
                };
            }
        });
        builder.define(new FunDefBase("Levels", "Returns the level whose name is specified by a string expression.", "flS"){

            @Override
            public Type getResultType(Validator validator, Exp[] args) {
                Type argType = args[0].getType();
                return LevelType.forType(argType);
            }

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc stringCalc = compiler.compileString(call.getArg(0));
                return new AbstractLevelCalc(call, new Calc[]{stringCalc}){

                    @Override
                    public Level evaluateLevel(Evaluator evaluator) {
                        String levelName = stringCalc.evaluateString(evaluator);
                        return this.findLevel(evaluator, levelName);
                    }
                };
            }

            Level findLevel(Evaluator evaluator, String s) {
                OlapElement o;
                Cube cube = evaluator.getCube();
                OlapElement olapElement = o = s.startsWith("[") ? evaluator.getSchemaReader().lookupCompound(cube, 4.parseIdentifier(s), false, 4) : null;
                if (o instanceof Level) {
                    return (Level)o;
                }
                if (o == null) {
                    throw 4.newEvalException(this, "Level '" + s + "' not found");
                }
                throw 4.newEvalException(this, "Levels('" + s + "') found " + o);
            }
        });
        builder.define(IsEmptyFunDef.FunctionResolver);
        builder.define(IsEmptyFunDef.PostfixResolver);
        builder.define(IsNullFunDef.Resolver);
        builder.define(IsFunDef.Resolver);
        builder.define(AsFunDef.RESOLVER);
        builder.define(AncestorFunDef.Resolver);
        builder.define(new FunDefBase("Cousin", "<Member> Cousin(<Member>, <Ancestor Member>)", "Returns the member with the same relative position under <ancestor member> as the member specified.", "fmmm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                final MemberCalc ancestorMemberCalc = compiler.compileMember(call.getArg(1));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc, ancestorMemberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        Member ancestorMember = ancestorMemberCalc.evaluateMember(evaluator);
                        return 5.cousin(evaluator.getSchemaReader(), member, ancestorMember);
                    }
                };
            }
        });
        builder.define(HierarchyCurrentMemberFunDef.instance);
        builder.define(NamedSetCurrentFunDef.instance);
        builder.define(NamedSetCurrentOrdinalFunDef.instance);
        builder.define(new FunDefBase("DataMember", "Returns the system-generated data member that is associated with a nonleaf member of a dimension.", "pmm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getDataMember();
                    }
                };
            }
        });
        builder.define(new FunInfo("DefaultMember", "Returns the default member of a dimension.", "pmd"));
        builder.define(new FunDefBase("DefaultMember", "Returns the default member of a hierarchy.", "pmh"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{hierarchyCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return evaluator.getSchemaReader().getHierarchyDefaultMember(hierarchy);
                    }
                };
            }
        });
        builder.define(new FunDefBase("FirstChild", "Returns the first child of a member.", "pmm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.firstChild(evaluator, member);
                    }
                };
            }

            Member firstChild(Evaluator evaluator, Member member) {
                List<Member> children = evaluator.getSchemaReader().getMemberChildren(member);
                return children.size() == 0 ? member.getHierarchy().getNullMember() : children.get(0);
            }
        });
        builder.define(new FunDefBase("FirstSibling", "Returns the first child of the parent of a member.", "pmm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.firstSibling(member, evaluator);
                    }
                };
            }

            Member firstSibling(Member member, Evaluator evaluator) {
                List<Member> children;
                Member parent = member.getParentMember();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                if (parent == null) {
                    if (member.isNull()) {
                        return member;
                    }
                    children = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                } else {
                    children = schemaReader.getMemberChildren(parent);
                }
                return children.get(0);
            }
        });
        builder.define(LeadLagFunDef.LagResolver);
        builder.define(new FunDefBase("LastChild", "Returns the last child of a member.", "pmm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.lastChild(evaluator, member);
                    }
                };
            }

            Member lastChild(Evaluator evaluator, Member member) {
                List<Member> children = evaluator.getSchemaReader().getMemberChildren(member);
                return children.size() == 0 ? member.getHierarchy().getNullMember() : children.get(children.size() - 1);
            }
        });
        builder.define(new FunDefBase("LastSibling", "Returns the last child of the parent of a member.", "pmm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.firstSibling(member, evaluator);
                    }
                };
            }

            Member firstSibling(Member member, Evaluator evaluator) {
                List<Member> children;
                Member parent = member.getParentMember();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                if (parent == null) {
                    if (member.isNull()) {
                        return member;
                    }
                    children = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                } else {
                    children = schemaReader.getMemberChildren(parent);
                }
                return children.get(children.size() - 1);
            }
        });
        builder.define(LeadLagFunDef.LeadResolver);
        builder.define(new FunDefBase("Members", "Returns the member whose name is specified by a string expression.", "fmS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                throw new UnsupportedOperationException();
            }
        });
        builder.define(new FunDefBase("NextMember", "Returns the next member in the level that contains a specified member.", "pmm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, 1);
                    }
                };
            }
        });
        builder.define(OpeningClosingPeriodFunDef.OpeningPeriodResolver);
        builder.define(OpeningClosingPeriodFunDef.ClosingPeriodResolver);
        builder.define(MemberOrderKeyFunDef.instance);
        builder.define(ParallelPeriodFunDef.Resolver);
        builder.define(new FunDefBase("Parent", "Returns the parent of a member.", "pmm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return this.memberParent(evaluator, member);
                    }
                };
            }

            Member memberParent(Evaluator evaluator, Member member) {
                Member parent = evaluator.getSchemaReader().getMemberParent(member);
                if (parent == null) {
                    parent = member.getHierarchy().getNullMember();
                }
                return parent;
            }
        });
        builder.define(new FunDefBase("PrevMember", "Returns the previous member in the level that contains a specified member.", "pmm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractMemberCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public Member evaluateMember(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return evaluator.getSchemaReader().getLeadMember(member, -1);
                    }
                };
            }
        });
        builder.define(StrToMemberFunDef.INSTANCE);
        builder.define(ValidMeasureFunDef.instance);
        builder.define(AggregateFunDef.resolver);
        builder.define(new MultiResolver("$AggregateChildren", "$AggregateChildren(<Hierarchy>)", "Equivalent to 'Aggregate(<Hierarchy>.CurrentMember.Children); for internal use.", new String[]{"Inh"}){

            @Override
            protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
                return new FunDefBase(dummyFunDef){

                    @Override
                    public void unparse(Exp[] args, PrintWriter pw) {
                        pw.print(this.getName());
                        pw.print("(");
                        args[0].unparse(pw);
                        pw.print(")");
                    }

                    @Override
                    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                        final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                        final ValueCalc valueCalc = new ValueCalc(call);
                        return new GenericCalc(call){

                            @Override
                            public Object evaluate(Evaluator evaluator) {
                                Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                                return this.aggregateChildren(evaluator, hierarchy, valueCalc);
                            }

                            @Override
                            public Calc[] getCalcs() {
                                return new Calc[]{hierarchyCalc, valueCalc};
                            }
                        };
                    }

                    Object aggregateChildren(Evaluator evaluator, Hierarchy hierarchy, Calc valueFunCall) {
                        Member member = evaluator.getPreviousContext(hierarchy);
                        ArrayList<Member> members = new ArrayList<Member>();
                        evaluator.getSchemaReader().getParentChildContributingChildren(member.getDataMember(), hierarchy, members);
                        Aggregator aggregator = (Aggregator)evaluator.getProperty(Property.AGGREGATION_TYPE.name, null);
                        if (aggregator == null) {
                            throw FunUtil.newEvalException(null, "Could not find an aggregator in the current evaluation context");
                        }
                        Aggregator rollup = aggregator.getRollup();
                        if (rollup == null) {
                            throw FunUtil.newEvalException(null, "Don't know how to rollup aggregator '" + aggregator + "'");
                        }
                        int savepoint = evaluator.savepoint();
                        try {
                            Object o;
                            Object object = o = rollup.aggregate(evaluator, new UnaryTupleList(members), valueFunCall);
                            return object;
                        }
                        finally {
                            evaluator.restore(savepoint);
                        }
                    }
                };
            }
        });
        builder.define(AvgFunDef.Resolver);
        builder.define(CorrelationFunDef.Resolver);
        builder.define(CountFunDef.Resolver);
        builder.define(new FunDefBase("Count", "Returns the number of tuples in a set including empty cells.", "pnx"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final ListCalc listCalc = compiler.compileList(call.getArg(0));
                return new AbstractIntegerCalc(call, new Calc[]{listCalc}){

                    @Override
                    public int evaluateInteger(Evaluator evaluator) {
                        TupleList list = listCalc.evaluateList(evaluator);
                        return 17.count(evaluator, list, true);
                    }
                };
            }
        });
        builder.define(CovarianceFunDef.CovarianceResolver);
        builder.define(CovarianceFunDef.CovarianceNResolver);
        builder.define(IifFunDef.STRING_INSTANCE);
        builder.define(IifFunDef.NUMERIC_INSTANCE);
        builder.define(IifFunDef.TUPLE_INSTANCE);
        builder.define(IifFunDef.BOOLEAN_INSTANCE);
        builder.define(IifFunDef.MEMBER_INSTANCE);
        builder.define(IifFunDef.LEVEL_INSTANCE);
        builder.define(IifFunDef.HIERARCHY_INSTANCE);
        builder.define(IifFunDef.DIMENSION_INSTANCE);
        builder.define(IifFunDef.SET_INSTANCE);
        builder.define(LinReg.InterceptResolver);
        builder.define(LinReg.PointResolver);
        builder.define(LinReg.R2Resolver);
        builder.define(LinReg.SlopeResolver);
        builder.define(LinReg.VarianceResolver);
        builder.define(MinMaxFunDef.MaxResolver);
        builder.define(MinMaxFunDef.MinResolver);
        builder.define(MedianFunDef.Resolver);
        builder.define(PercentileFunDef.Resolver);
        builder.define(new FunDefBase("Ordinal", "Returns the zero-based ordinal value associated with a level.", "pnl"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractIntegerCalc(call, new Calc[]{levelCalc}){

                    @Override
                    public int evaluateInteger(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getDepth();
                    }
                };
            }
        });
        builder.define(RankFunDef.Resolver);
        builder.define(CacheFunDef.Resolver);
        builder.define(StdevFunDef.StdevResolver);
        builder.define(StdevFunDef.StddevResolver);
        builder.define(StdevPFunDef.StdevpResolver);
        builder.define(StdevPFunDef.StddevpResolver);
        builder.define(SumFunDef.Resolver);
        builder.define(new FunDefBase("Value", "Returns the value of a measure.", "pnm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new GenericCalc(call){

                    @Override
                    public Object evaluate(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        int savepoint = evaluator.savepoint();
                        evaluator.setContext(member);
                        try {
                            Object value;
                            Object object = value = evaluator.evaluateCurrent();
                            return object;
                        }
                        finally {
                            evaluator.restore(savepoint);
                        }
                    }

                    @Override
                    public boolean dependsOn(Hierarchy hierarchy) {
                        if (super.dependsOn(hierarchy)) {
                            return true;
                        }
                        return !memberCalc.getType().usesHierarchy(hierarchy, true);
                    }

                    @Override
                    public Calc[] getCalcs() {
                        return new Calc[]{memberCalc};
                    }
                };
            }
        });
        builder.define(VarFunDef.VarResolver);
        builder.define(VarFunDef.VarianceResolver);
        builder.define(VarPFunDef.VariancePResolver);
        builder.define(VarPFunDef.VarPResolver);
        builder.define(AddCalculatedMembersFunDef.resolver);
        builder.define(new FunDefBase("Ascendants", "Returns the set of the ascendants of a specified member.", "fxm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public TupleList evaluateList(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return new UnaryTupleList(this.ascendants(evaluator.getSchemaReader(), member));
                    }
                };
            }

            List<Member> ascendants(SchemaReader schemaReader, Member member) {
                if (member.isNull()) {
                    return Collections.emptyList();
                }
                ArrayList<Member> result = new ArrayList<Member>();
                result.add(member);
                schemaReader.getMemberAncestors(member, result);
                return result;
            }
        });
        builder.define(TopBottomCountFunDef.BottomCountResolver);
        builder.define(TopBottomPercentSumFunDef.BottomPercentResolver);
        builder.define(TopBottomPercentSumFunDef.BottomSumResolver);
        builder.define(TopBottomCountFunDef.TopCountResolver);
        builder.define(TopBottomPercentSumFunDef.TopPercentResolver);
        builder.define(TopBottomPercentSumFunDef.TopSumResolver);
        builder.define(new FunDefBase("Children", "Returns the children of a member.", "pxm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{memberCalc}, false){

                    @Override
                    public TupleList evaluateList(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return new UnaryTupleList(21.getNonEmptyMemberChildren(evaluator, member));
                    }
                };
            }
        });
        builder.define(CrossJoinFunDef.Resolver);
        builder.define(NonEmptyCrossJoinFunDef.Resolver);
        builder.define(CrossJoinFunDef.StarResolver);
        builder.define(DescendantsFunDef.Resolver);
        builder.define(DescendantsFunDef.Resolver2);
        builder.define(DistinctFunDef.instance);
        builder.define(DrilldownLevelFunDef.Resolver);
        builder.define(DrilldownLevelTopBottomFunDef.DrilldownLevelTopResolver);
        builder.define(DrilldownLevelTopBottomFunDef.DrilldownLevelBottomResolver);
        builder.define(DrilldownMemberFunDef.Resolver);
        builder.define(ExceptFunDef.Resolver);
        builder.define(ExistsFunDef.resolver);
        builder.define(ExtractFunDef.Resolver);
        builder.define(FilterFunDef.instance);
        builder.define(GenerateFunDef.ListResolver);
        builder.define(GenerateFunDef.StringResolver);
        builder.define(HeadTailFunDef.HeadResolver);
        builder.define(HierarchizeFunDef.Resolver);
        builder.define(IntersectFunDef.resolver);
        builder.define(LastPeriodsFunDef.Resolver);
        builder.define(new FunInfo("Members", "Returns the set of members in a dimension.", "pxd"));
        builder.define(new FunDefBase("Members", "Returns the set of members in a hierarchy.", "pxh"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{hierarchyCalc}){

                    @Override
                    public TupleList evaluateList(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return 22.hierarchyMembers(hierarchy, evaluator, false);
                    }
                };
            }
        });
        builder.define(new FunDefBase("AllMembers", "Returns a set that contains all members, including calculated members, of the specified hierarchy.", "pxh"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{hierarchyCalc}){

                    @Override
                    public TupleList evaluateList(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return 23.hierarchyMembers(hierarchy, evaluator, true);
                    }
                };
            }
        });
        builder.define(LevelMembersFunDef.INSTANCE);
        builder.define(new FunDefBase("AllMembers", "Returns a set that contains all members, including calculated members, of the specified level.", "pxl"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{levelCalc}){

                    @Override
                    public TupleList evaluateList(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return 24.levelMembers(level, evaluator, true);
                    }
                };
            }
        });
        builder.define(XtdFunDef.MtdResolver);
        builder.define(OrderFunDef.Resolver);
        builder.define(UnorderFunDef.Resolver);
        builder.define(PeriodsToDateFunDef.Resolver);
        builder.define(XtdFunDef.QtdResolver);
        builder.define(new FunDefBase("StripCalculatedMembers", "Removes calculated members from a set.", "fxx"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final ListCalc listCalc = compiler.compileList(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{listCalc}){

                    @Override
                    public TupleList evaluateList(Evaluator evaluator) {
                        TupleList list = listCalc.evaluateList(evaluator);
                        return 25.removeCalculatedMembers(list);
                    }
                };
            }
        });
        builder.define(new FunDefBase("Siblings", "Returns the siblings of a specified member, including the member itself.", "pxm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractListCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public TupleList evaluateList(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return new UnaryTupleList(this.memberSiblings(member, evaluator));
                    }
                };
            }

            List<Member> memberSiblings(Member member, Evaluator evaluator) {
                if (member.isNull()) {
                    return Collections.emptyList();
                }
                Member parent = member.getParentMember();
                SchemaReader schemaReader = evaluator.getSchemaReader();
                if (parent == null) {
                    return schemaReader.getHierarchyRootMembers(member.getHierarchy());
                }
                return schemaReader.getMemberChildren(parent);
            }
        });
        builder.define(StrToSetFunDef.Resolver);
        builder.define(SubsetFunDef.Resolver);
        builder.define(HeadTailFunDef.TailResolver);
        builder.define(ToggleDrillStateFunDef.Resolver);
        builder.define(UnionFunDef.Resolver);
        builder.define(VisualTotalsFunDef.Resolver);
        builder.define(XtdFunDef.WtdResolver);
        builder.define(XtdFunDef.YtdResolver);
        builder.define(RangeFunDef.instance);
        builder.define(SetFunDef.Resolver);
        builder.define(NativizeSetFunDef.Resolver);
        builder.define(FormatFunDef.Resolver);
        builder.define(new FunDefBase("Caption", "Returns the caption of a dimension.", "pSd"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{dimensionCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return dimension.getCaption();
                    }
                };
            }
        });
        builder.define(new FunDefBase("Caption", "Returns the caption of a hierarchy.", "pSh"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{hierarchyCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return hierarchy.getCaption();
                    }
                };
            }
        });
        builder.define(new FunDefBase("Caption", "Returns the caption of a level.", "pSl"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{levelCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getCaption();
                    }
                };
            }
        });
        builder.define(new FunDefBase("Caption", "Returns the caption of a member.", "pSm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getCaption();
                    }
                };
            }
        });
        builder.define(new FunDefBase("Name", "Returns the name of a dimension.", "pSd"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{dimensionCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return dimension.getName();
                    }
                };
            }
        });
        builder.define(new FunDefBase("Name", "Returns the name of a hierarchy.", "pSh"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{hierarchyCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return hierarchy.getName();
                    }
                };
            }
        });
        builder.define(new FunDefBase("Name", "Returns the name of a level.", "pSl"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{levelCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getName();
                    }
                };
            }
        });
        builder.define(new FunDefBase("Name", "Returns the name of a member.", "pSm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getName();
                    }
                };
            }
        });
        builder.define(SetToStrFunDef.instance);
        builder.define(TupleToStrFunDef.instance);
        builder.define(new FunDefBase("UniqueName", "Returns the unique name of a dimension.", "pSd"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DimensionCalc dimensionCalc = compiler.compileDimension(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{dimensionCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Dimension dimension = dimensionCalc.evaluateDimension(evaluator);
                        return dimension.getUniqueName();
                    }
                };
            }
        });
        builder.define(new FunDefBase("UniqueName", "Returns the unique name of a hierarchy.", "pSh"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final HierarchyCalc hierarchyCalc = compiler.compileHierarchy(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{hierarchyCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Hierarchy hierarchy = hierarchyCalc.evaluateHierarchy(evaluator);
                        return hierarchy.getUniqueName();
                    }
                };
            }
        });
        builder.define(new FunDefBase("UniqueName", "Returns the unique name of a level.", "pSl"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final LevelCalc levelCalc = compiler.compileLevel(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{levelCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Level level = levelCalc.evaluateLevel(evaluator);
                        return level.getUniqueName();
                    }
                };
            }
        });
        builder.define(new FunDefBase("UniqueName", "Returns the unique name of a member.", "pSm"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final MemberCalc memberCalc = compiler.compileMember(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{memberCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        Member member = memberCalc.evaluateMember(evaluator);
                        return member.getUniqueName();
                    }
                };
            }
        });
        builder.define(SetItemFunDef.intResolver);
        builder.define(SetItemFunDef.stringResolver);
        builder.define(TupleItemFunDef.instance);
        builder.define(StrToTupleFunDef.Resolver);
        builder.define(TupleFunDef.Resolver);
        builder.define(CoalesceEmptyFunDef.Resolver);
        builder.define(CaseTestFunDef.Resolver);
        builder.define(CaseMatchFunDef.Resolver);
        builder.define(PropertiesFunDef.Resolver);
        builder.define(new ParameterFunDef.ParameterResolver());
        builder.define(new ParameterFunDef.ParamRefResolver());
        builder.define(new FunDefBase("+", "Adds two numbers.", "innn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public double evaluateDouble(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (v0 == 1.2345E-8) {
                            if (v1 == 1.2345E-8) {
                                return 1.2345E-8;
                            }
                            return v1;
                        }
                        if (v1 == 1.2345E-8) {
                            return v0;
                        }
                        return v0 + v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("-", "Subtracts two numbers.", "innn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public double evaluateDouble(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (v0 == 1.2345E-8) {
                            if (v1 == 1.2345E-8) {
                                return 1.2345E-8;
                            }
                            return -v1;
                        }
                        if (v1 == 1.2345E-8) {
                            return v0;
                        }
                        return v0 - v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("*", "Multiplies two numbers.", "innn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public double evaluateDouble(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return 1.2345E-8;
                        }
                        return v0 * v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("/", "Divides two numbers.", "innn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                boolean isNullDenominatorProducesNull = MondrianProperties.instance().NullDenominatorProducesNull.get();
                if (!isNullDenominatorProducesNull) {
                    return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                        @Override
                        public double evaluateDouble(Evaluator evaluator) {
                            double v0 = calc0.evaluateDouble(evaluator);
                            double v1 = calc1.evaluateDouble(evaluator);
                            if (v0 == 1.2345E-8) {
                                return 1.2345E-8;
                            }
                            if (v1 == 1.2345E-8) {
                                return Double.POSITIVE_INFINITY;
                            }
                            return v0 / v1;
                        }
                    };
                }
                return new AbstractDoubleCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public double evaluateDouble(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return 1.2345E-8;
                        }
                        return v0 / v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("-", "Returns the negative of a number.", "Pnn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc = compiler.compileDouble(call.getArg(0));
                return new AbstractDoubleCalc(call, new Calc[]{calc}){

                    @Override
                    public double evaluateDouble(Evaluator evaluator) {
                        double v = calc.evaluateDouble(evaluator);
                        if (v == 1.2345E-8) {
                            return 1.2345E-8;
                        }
                        return -v;
                    }
                };
            }
        });
        builder.define(new FunDefBase("||", "Concatenates two strings.", "iSSS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractStringCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        String s0 = calc0.evaluateString(evaluator);
                        String s1 = calc1.evaluateString(evaluator);
                        return String.valueOf(s0) + s1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("AND", "Returns the conjunction of two conditions.", "ibbb"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        boolean b0 = calc0.evaluateBoolean(evaluator);
                        if (!evaluator.isEvalAxes() && !b0) {
                            return false;
                        }
                        boolean b1 = calc1.evaluateBoolean(evaluator);
                        return b0 && b1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("OR", "Returns the disjunction of two conditions.", "ibbb"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        boolean b0 = calc0.evaluateBoolean(evaluator);
                        if (!evaluator.isEvalAxes() && b0) {
                            return true;
                        }
                        boolean b1 = calc1.evaluateBoolean(evaluator);
                        return b0 || b1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("XOR", "Returns whether two conditions are mutually exclusive.", "ibbb"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final BooleanCalc calc0 = compiler.compileBoolean(call.getArg(0));
                final BooleanCalc calc1 = compiler.compileBoolean(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        boolean b0 = calc0.evaluateBoolean(evaluator);
                        boolean b1 = calc1.evaluateBoolean(evaluator);
                        return b0 ^ b1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("NOT", "Returns the negation of a condition.", "Pbb"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final BooleanCalc calc = compiler.compileBoolean(call.getArg(0));
                return new AbstractBooleanCalc(call, new Calc[]{calc}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        return !calc.evaluateBoolean(evaluator);
                    }
                };
            }
        });
        builder.define(new FunDefBase("=", "Returns whether two expressions are equal.", "ibSS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.equals(b1);
                    }
                };
            }
        });
        builder.define(new FunDefBase("=", "Returns whether two expressions are equal.", "ibnn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 == v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("<>", "Returns whether two expressions are not equal.", "ibSS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return !b0.equals(b1);
                    }
                };
            }
        });
        builder.define(new FunDefBase("<>", "Returns whether two expressions are not equal.", "ibnn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 != v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("<", "Returns whether an expression is less than another.", "ibnn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 < v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("<", "Returns whether an expression is less than another.", "ibSS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.compareTo(b1) < 0;
                    }
                };
            }
        });
        builder.define(new FunDefBase("<=", "Returns whether an expression is less than or equal to another.", "ibnn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 <= v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase("<=", "Returns whether an expression is less than or equal to another.", "ibSS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.compareTo(b1) <= 0;
                    }
                };
            }
        });
        builder.define(new FunDefBase(">", "Returns whether an expression is greater than another.", "ibnn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 > v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase(">", "Returns whether an expression is greater than another.", "ibSS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.compareTo(b1) > 0;
                    }
                };
            }
        });
        builder.define(new FunDefBase(">=", "Returns whether an expression is greater than or equal to another.", "ibnn"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final DoubleCalc calc0 = compiler.compileDouble(call.getArg(0));
                final DoubleCalc calc1 = compiler.compileDouble(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        double v0 = calc0.evaluateDouble(evaluator);
                        double v1 = calc1.evaluateDouble(evaluator);
                        if (Double.isNaN(v0) || Double.isNaN(v1) || v0 == 1.2345E-8 || v1 == 1.2345E-8) {
                            return false;
                        }
                        return v0 >= v1;
                    }
                };
            }
        });
        builder.define(new FunDefBase(">=", "Returns whether an expression is greater than or equal to another.", "ibSS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc calc0 = compiler.compileString(call.getArg(0));
                final StringCalc calc1 = compiler.compileString(call.getArg(1));
                return new AbstractBooleanCalc(call, new Calc[]{calc0, calc1}){

                    @Override
                    public boolean evaluateBoolean(Evaluator evaluator) {
                        String b0 = calc0.evaluateString(evaluator);
                        String b1 = calc1.evaluateString(evaluator);
                        if (b0 == null || b1 == null) {
                            return false;
                        }
                        return b0.compareTo(b1) >= 0;
                    }
                };
            }
        });
        builder.define(NthQuartileFunDef.FirstQResolver);
        builder.define(NthQuartileFunDef.ThirdQResolver);
        builder.define(CalculatedChildFunDef.instance);
        builder.define(CastFunDef.Resolver);
        builder.define(new FunDefBase("UCase", "Returns a string that has been converted to uppercase", "fSS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final Locale locale = compiler.getEvaluator().getConnectionLocale();
                final StringCalc stringCalc = compiler.compileString(call.getArg(0));
                return new AbstractStringCalc(call, new Calc[]{stringCalc}){

                    @Override
                    public String evaluateString(Evaluator evaluator) {
                        String value = stringCalc.evaluateString(evaluator);
                        return value.toUpperCase(locale);
                    }
                };
            }
        });
        builder.define(new FunDefBase("Len", "Returns the number of characters in a string", "fnS"){

            @Override
            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                final StringCalc stringCalc = compiler.compileString(call.getArg(0));
                return new AbstractIntegerCalc(call, new Calc[]{stringCalc}){

                    @Override
                    public int evaluateInteger(Evaluator evaluator) {
                        String value = stringCalc.evaluateString(evaluator);
                        if (value == null) {
                            return 0;
                        }
                        return value.length();
                    }
                };
            }
        });
        for (FunDef funDef : JavaFunDef.scan(Vba.class)) {
            builder.define(funDef);
        }
        for (FunDef funDef : JavaFunDef.scan(Excel.class)) {
            builder.define(funDef);
        }
    }

    public static BuiltinFunTable instance() {
        if (instance == null) {
            instance = new BuiltinFunTable();
            instance.init();
        }
        return instance;
    }
}

