/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;

class CaseTestFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    public CaseTestFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        final BooleanCalc[] conditionCalcs = new BooleanCalc[args.length / 2];
        final Calc[] exprCalcs = new Calc[args.length / 2];
        ArrayList<Calc> calcList = new ArrayList<Calc>();
        int i = 0;
        int j = 0;
        while (i < exprCalcs.length) {
            conditionCalcs[i] = compiler.compileBoolean(args[j++]);
            calcList.add(conditionCalcs[i]);
            exprCalcs[i] = compiler.compile(args[j++]);
            calcList.add(exprCalcs[i]);
            ++i;
        }
        final ConstantCalc defaultCalc = args.length % 2 == 1 ? compiler.compileScalar(args[args.length - 1], true) : ConstantCalc.constantNull(call.getType());
        calcList.add(defaultCalc);
        final Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
        return new GenericCalc(call){

            @Override
            public Object evaluate(Evaluator evaluator) {
                int i = 0;
                while (i < conditionCalcs.length) {
                    if (conditionCalcs[i].evaluateBoolean(evaluator)) {
                        return exprCalcs[i].evaluate(evaluator);
                    }
                    ++i;
                }
                return defaultCalc.evaluate(evaluator);
            }

            @Override
            public Calc[] getCalcs() {
                return calcs;
            }
        };
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("_CaseTest", "Case When <Logical Expression> Then <Expression> [...] [Else <Expression>] End", "Evaluates various conditions, and returns the corresponding expression for the first which evaluates to true.", Syntax.Case);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (args.length < 1) {
                return null;
            }
            int j = 0;
            int clauseCount = args.length / 2;
            int mismatchingArgs = 0;
            int returnType = args[1].getCategory();
            int i = 0;
            while (i < clauseCount) {
                if (!validator.canConvert(j, args[j++], 5, conversions)) {
                    ++mismatchingArgs;
                }
                if (!validator.canConvert(j, args[j++], returnType, conversions)) {
                    ++mismatchingArgs;
                }
                ++i;
            }
            if (j < args.length && !validator.canConvert(j, args[j++], returnType, conversions)) {
                ++mismatchingArgs;
            }
            Util.assertTrue(j == args.length);
            if (mismatchingArgs != 0) {
                return null;
            }
            FunDef dummy = ResolverImpl.createDummyFunDef(this, returnType, args);
            return new CaseTestFunDef(dummy);
        }

        @Override
        public boolean requiresExpression(int k) {
            return true;
        }
    }
}

