/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;

public class CoalesceEmptyFunDef
extends FunDefBase {
    static final ResolverBase Resolver = new ResolverImpl();

    public CoalesceEmptyFunDef(ResolverBase resolverBase, int type, int[] types) {
        super(resolverBase, type, types);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        final Calc[] calcs = new Calc[args.length];
        int i = 0;
        while (i < args.length) {
            calcs[i] = compiler.compileScalar(args[i], true);
            ++i;
        }
        return new GenericCalc(call){

            @Override
            public Object evaluate(Evaluator evaluator) {
                Calc[] calcArray = calcs;
                int n = calcs.length;
                int n2 = 0;
                while (n2 < n) {
                    Calc calc = calcArray[n2];
                    Object o = calc.evaluate(evaluator);
                    if (o != null) {
                        return o;
                    }
                    ++n2;
                }
                return null;
            }

            @Override
            public Calc[] getCalcs() {
                return calcs;
            }
        };
    }

    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("CoalesceEmpty", "CoalesceEmpty(<Value Expression>[, <Value Expression>...])", "Coalesces an empty cell value to a different value. All of the expressions must be of the same type (number or string).", Syntax.Function);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (args.length < 1) {
                return null;
            }
            int[] types = new int[]{7, 9};
            int[] argTypes = new int[args.length];
            int[] nArray = types;
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                int type = nArray[n2];
                int matchingArgs = 0;
                conversions.clear();
                int i = 0;
                while (i < args.length) {
                    if (validator.canConvert(i, args[i], type, conversions)) {
                        ++matchingArgs;
                    }
                    argTypes[i] = type;
                    ++i;
                }
                if (matchingArgs == args.length) {
                    return new CoalesceEmptyFunDef(this, type, argTypes);
                }
                ++n2;
            }
            return null;
        }

        @Override
        public boolean requiresExpression(int k) {
            return true;
        }
    }
}

