/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.ReflectiveMultiResolver;

class CorrelationFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Correlation", "Correlation(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Returns the correlation of two series evaluated over a set.", new String[]{"fnxn", "fnxnn"}, CorrelationFunDef.class);

    public CorrelationFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final Calc calc1 = compiler.compileScalar(call.getArg(1), true);
        final ValueCalc calc2 = call.getArgCount() > 2 ? compiler.compileScalar(call.getArg(2), true) : new ValueCalc(call);
        return new AbstractDoubleCalc(call, new Calc[]{listCalc, calc1, calc2}){

            @Override
            public double evaluateDouble(Evaluator evaluator) {
                int savepoint = evaluator.savepoint();
                try {
                    double correlation;
                    evaluator.setNonEmpty(false);
                    TupleList list = CorrelationFunDef.evaluateCurrentList(listCalc, evaluator);
                    double d = correlation = CorrelationFunDef.correlation(evaluator, list, calc1, calc2);
                    return d;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }

            @Override
            public boolean dependsOn(Hierarchy hierarchy) {
                return 1.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

