/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleIterable;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractIntegerCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Literal;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.ReflectiveMultiResolver;

class CountFunDef
extends AbstractAggregateFunDef {
    static final String[] ReservedWords = new String[]{"INCLUDEEMPTY", "EXCLUDEEMPTY"};
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Count", "Count(<Set>[, EXCLUDEEMPTY | INCLUDEEMPTY])", "Returns the number of tuples in a set, empty cells included unless the optional EXCLUDEEMPTY flag is used.", new String[]{"fnx", "fnxy"}, CountFunDef.class, ReservedWords);

    public CountFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final Calc calc = compiler.compileAs(call.getArg(0), null, ResultStyle.ITERABLE_ANY);
        final boolean includeEmpty = call.getArgCount() < 2 || ((Literal)call.getArg(1)).getValue().equals("INCLUDEEMPTY");
        return new AbstractIntegerCalc(call, new Calc[]{calc}){

            @Override
            public int evaluateInteger(Evaluator evaluator) {
                int savepoint = evaluator.savepoint();
                try {
                    int count;
                    evaluator.setNonEmpty(false);
                    if (calc instanceof IterCalc) {
                        IterCalc iterCalc = (IterCalc)calc;
                        TupleIterable iterable = CountFunDef.this.evaluateCurrentIterable(iterCalc, evaluator);
                        count = CountFunDef.count(evaluator, iterable, includeEmpty);
                    } else {
                        ListCalc listCalc = (ListCalc)calc;
                        TupleList list = CountFunDef.evaluateCurrentList(listCalc, evaluator);
                        count = CountFunDef.count(evaluator, list, includeEmpty);
                    }
                    int n = count;
                    return n;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }

            @Override
            public boolean dependsOn(Hierarchy hierarchy) {
                if (super.dependsOn(hierarchy)) {
                    return true;
                }
                if (includeEmpty) {
                    return false;
                }
                return !calc.getType().usesHierarchy(hierarchy, true);
            }
        };
    }
}

