/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.ReflectiveMultiResolver;

class CovarianceFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver CovarianceResolver = new ReflectiveMultiResolver("Covariance", "Covariance(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Returns the covariance of two series evaluated over a set (biased).", new String[]{"fnxn", "fnxnn"}, CovarianceFunDef.class);
    static final MultiResolver CovarianceNResolver = new ReflectiveMultiResolver("CovarianceN", "CovarianceN(<Set>, <Numeric Expression>[, <Numeric Expression>])", "Returns the covariance of two series evaluated over a set (unbiased).", new String[]{"fnxn", "fnxnn"}, CovarianceFunDef.class);
    private final boolean biased;

    public CovarianceFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
        this.biased = dummyFunDef.getName().equals("Covariance");
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final Calc calc1 = compiler.compileScalar(call.getArg(1), true);
        final ValueCalc calc2 = call.getArgCount() > 2 ? compiler.compileScalar(call.getArg(2), true) : new ValueCalc(call);
        return new AbstractDoubleCalc(call, new Calc[]{listCalc, calc1, calc2}){

            @Override
            public double evaluateDouble(Evaluator evaluator) {
                TupleList memberList = listCalc.evaluateList(evaluator);
                int savepoint = evaluator.savepoint();
                try {
                    double covariance;
                    evaluator.setNonEmpty(false);
                    double d = covariance = ((Double)CovarianceFunDef.covariance(evaluator, memberList, calc1, calc2, CovarianceFunDef.this.biased)).doubleValue();
                    return d;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }

            @Override
            public boolean dependsOn(Hierarchy hierarchy) {
                return 1.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

