/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;

class ExistsFunDef
extends FunDefBase {
    static final Resolver resolver = new ReflectiveMultiResolver("Exists", "Exists(<Set1>, <Set2>])", "Returns the the set of tuples of the first set that exist with one or more tuples of the second set.", new String[]{"fxxx"}, ExistsFunDef.class);

    public ExistsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}){

            @Override
            public TupleList evaluateList(Evaluator evaluator) {
                TupleList leftTuples = listCalc1.evaluateList(evaluator);
                if (leftTuples.isEmpty()) {
                    return TupleCollections.emptyList(leftTuples.getArity());
                }
                TupleList rightTuples = listCalc2.evaluateList(evaluator);
                if (rightTuples.isEmpty()) {
                    return TupleCollections.emptyList(leftTuples.getArity());
                }
                TupleList result = TupleCollections.createList(leftTuples.getArity());
                List leftDims = ExistsFunDef.getDimensions((List)leftTuples.get(0));
                List rightDims = ExistsFunDef.getDimensions((List)rightTuples.get(0));
                int rightSize = rightDims.size();
                int[] idxmap = new int[rightSize];
                int i = 0;
                while (i < rightSize) {
                    Dimension d = (Dimension)rightDims.get(i);
                    if (!leftDims.contains(d)) {
                        return TupleCollections.emptyList(leftTuples.getArity());
                    }
                    idxmap[i] = leftDims.indexOf(d);
                    ++i;
                }
                block1: for (List leftTuple : leftTuples) {
                    block2: for (List rightTuple : rightTuples) {
                        int i2 = 0;
                        while (i2 < rightSize) {
                            Member rightMem;
                            Member leftMem = (Member)leftTuple.get(idxmap[i2]);
                            if (!ExistsFunDef.isOnSameHierarchyChain(leftMem, rightMem = (Member)rightTuple.get(i2))) continue block2;
                            ++i2;
                        }
                        result.add(leftTuple);
                        continue block1;
                    }
                }
                return result;
            }
        };
    }

    private static boolean isOnSameHierarchyChain(Member mA, Member mB) {
        return FunUtil.isAncestorOf(mA, mB, false) || FunUtil.isAncestorOf(mB, mA, false);
    }

    private static List<Dimension> getDimensions(List<Member> members) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        for (Member member : members) {
            dimensions.add(member.getDimension());
        }
        return dimensions;
    }
}

